/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-03 at 02:09:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an event update failure resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventRecordFailure extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the event that was not updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventId;

  /**
   * The cause for the update failure. Possible values are:   - "NOT_FOUND" - An attempt was made to
   * set an event that was not defined.  - "INVALID_UPDATE_VALUE" - An attempt was made to increment
   * an event by a non-positive value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String failureCause;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordFailure.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the event that was not updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventId() {
    return eventId;
  }

  /**
   * The ID of the event that was not updated.
   * @param eventId eventId or {@code null} for none
   */
  public EventRecordFailure setEventId(java.lang.String eventId) {
    this.eventId = eventId;
    return this;
  }

  /**
   * The cause for the update failure. Possible values are:   - "NOT_FOUND" - An attempt was made to
   * set an event that was not defined.  - "INVALID_UPDATE_VALUE" - An attempt was made to increment
   * an event by a non-positive value.
   * @return value or {@code null} for none
   */
  public java.lang.String getFailureCause() {
    return failureCause;
  }

  /**
   * The cause for the update failure. Possible values are:   - "NOT_FOUND" - An attempt was made to
   * set an event that was not defined.  - "INVALID_UPDATE_VALUE" - An attempt was made to increment
   * an event by a non-positive value.
   * @param failureCause failureCause or {@code null} for none
   */
  public EventRecordFailure setFailureCause(java.lang.String failureCause) {
    this.failureCause = failureCause;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordFailure.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordFailure.
   * @param kind kind or {@code null} for none
   */
  public EventRecordFailure setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public EventRecordFailure set(String fieldName, Object value) {
    return (EventRecordFailure) super.set(fieldName, value);
  }

  @Override
  public EventRecordFailure clone() {
    return (EventRecordFailure) super.clone();
  }

}
