/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-03 at 02:09:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a Quest Criterion resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QuestCriterion extends com.google.api.client.json.GenericJson {

  /**
   * The total number of times the associated event must be incremented for the player to complete
   * this quest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuestContribution completionContribution;

  /**
   * The number of increments the player has made toward the completion count event increments
   * required to complete the quest. This value will not exceed the completion contribution. There
   * will be no currentContribution until the player has accepted the quest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuestContribution currentContribution;

  /**
   * The ID of the event the criterion corresponds to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventId;

  /**
   * The value of the event associated with this quest at the time that the quest was accepted. This
   * value may change if event increments that took place before the start of quest are uploaded
   * after the quest starts. There will be no initialPlayerProgress until the player has accepted
   * the quest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuestContribution initialPlayerProgress;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#questCriterion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The total number of times the associated event must be incremented for the player to complete
   * this quest.
   * @return value or {@code null} for none
   */
  public QuestContribution getCompletionContribution() {
    return completionContribution;
  }

  /**
   * The total number of times the associated event must be incremented for the player to complete
   * this quest.
   * @param completionContribution completionContribution or {@code null} for none
   */
  public QuestCriterion setCompletionContribution(QuestContribution completionContribution) {
    this.completionContribution = completionContribution;
    return this;
  }

  /**
   * The number of increments the player has made toward the completion count event increments
   * required to complete the quest. This value will not exceed the completion contribution. There
   * will be no currentContribution until the player has accepted the quest.
   * @return value or {@code null} for none
   */
  public QuestContribution getCurrentContribution() {
    return currentContribution;
  }

  /**
   * The number of increments the player has made toward the completion count event increments
   * required to complete the quest. This value will not exceed the completion contribution. There
   * will be no currentContribution until the player has accepted the quest.
   * @param currentContribution currentContribution or {@code null} for none
   */
  public QuestCriterion setCurrentContribution(QuestContribution currentContribution) {
    this.currentContribution = currentContribution;
    return this;
  }

  /**
   * The ID of the event the criterion corresponds to.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventId() {
    return eventId;
  }

  /**
   * The ID of the event the criterion corresponds to.
   * @param eventId eventId or {@code null} for none
   */
  public QuestCriterion setEventId(java.lang.String eventId) {
    this.eventId = eventId;
    return this;
  }

  /**
   * The value of the event associated with this quest at the time that the quest was accepted. This
   * value may change if event increments that took place before the start of quest are uploaded
   * after the quest starts. There will be no initialPlayerProgress until the player has accepted
   * the quest.
   * @return value or {@code null} for none
   */
  public QuestContribution getInitialPlayerProgress() {
    return initialPlayerProgress;
  }

  /**
   * The value of the event associated with this quest at the time that the quest was accepted. This
   * value may change if event increments that took place before the start of quest are uploaded
   * after the quest starts. There will be no initialPlayerProgress until the player has accepted
   * the quest.
   * @param initialPlayerProgress initialPlayerProgress or {@code null} for none
   */
  public QuestCriterion setInitialPlayerProgress(QuestContribution initialPlayerProgress) {
    this.initialPlayerProgress = initialPlayerProgress;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#questCriterion.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#questCriterion.
   * @param kind kind or {@code null} for none
   */
  public QuestCriterion setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public QuestCriterion set(String fieldName, Object value) {
    return (QuestCriterion) super.set(fieldName, value);
  }

  @Override
  public QuestCriterion clone() {
    return (QuestCriterion) super.clone();
  }

}
