/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-17 at 03:15:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an achievement update response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AchievementUpdateResponse extends com.google.api.client.json.GenericJson {

  /**
   * The achievement this update is was applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String achievementId;

  /**
   * The current state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentState;

  /**
   * The current steps recorded for this achievement if it is incremental.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer currentSteps;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether this achievement was newly unlocked (that is, whether the unlock request for the
   * achievement was the first for the player).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean newlyUnlocked;

  /**
   * Whether the requested updates actually affected the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean updateOccurred;

  /**
   * The achievement this update is was applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAchievementId() {
    return achievementId;
  }

  /**
   * The achievement this update is was applied to.
   * @param achievementId achievementId or {@code null} for none
   */
  public AchievementUpdateResponse setAchievementId(java.lang.String achievementId) {
    this.achievementId = achievementId;
    return this;
  }

  /**
   * The current state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentState() {
    return currentState;
  }

  /**
   * The current state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @param currentState currentState or {@code null} for none
   */
  public AchievementUpdateResponse setCurrentState(java.lang.String currentState) {
    this.currentState = currentState;
    return this;
  }

  /**
   * The current steps recorded for this achievement if it is incremental.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCurrentSteps() {
    return currentSteps;
  }

  /**
   * The current steps recorded for this achievement if it is incremental.
   * @param currentSteps currentSteps or {@code null} for none
   */
  public AchievementUpdateResponse setCurrentSteps(java.lang.Integer currentSteps) {
    this.currentSteps = currentSteps;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateResponse.
   * @param kind kind or {@code null} for none
   */
  public AchievementUpdateResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Whether this achievement was newly unlocked (that is, whether the unlock request for the
   * achievement was the first for the player).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNewlyUnlocked() {
    return newlyUnlocked;
  }

  /**
   * Whether this achievement was newly unlocked (that is, whether the unlock request for the
   * achievement was the first for the player).
   * @param newlyUnlocked newlyUnlocked or {@code null} for none
   */
  public AchievementUpdateResponse setNewlyUnlocked(java.lang.Boolean newlyUnlocked) {
    this.newlyUnlocked = newlyUnlocked;
    return this;
  }

  /**
   * Whether the requested updates actually affected the achievement.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUpdateOccurred() {
    return updateOccurred;
  }

  /**
   * Whether the requested updates actually affected the achievement.
   * @param updateOccurred updateOccurred or {@code null} for none
   */
  public AchievementUpdateResponse setUpdateOccurred(java.lang.Boolean updateOccurred) {
    this.updateOccurred = updateOccurred;
    return this;
  }

  @Override
  public AchievementUpdateResponse set(String fieldName, Object value) {
    return (AchievementUpdateResponse) super.set(fieldName, value);
  }

  @Override
  public AchievementUpdateResponse clone() {
    return (AchievementUpdateResponse) super.clone();
  }

}
