/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-17 at 03:15:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a leave room request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RoomLeaveRequest extends com.google.api.client.json.GenericJson {

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomLeaveRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Diagnostics for a player leaving the room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RoomLeaveDiagnostics leaveDiagnostics;

  /**
   * Reason for leaving the match. Possible values are:   - "PLAYER_LEFT" - The player chose to
   * leave the room..  - "GAME_LEFT" - The game chose to remove the player from the room.  -
   * "REALTIME_ABANDONED" - The player switched to another application and abandoned the room.  -
   * "REALTIME_PEER_CONNECTION_FAILURE" - The client was unable to establish a connection to other
   * peer(s).  - "REALTIME_SERVER_CONNECTION_FAILURE" - The client was unable to communicate with
   * the server.  - "REALTIME_SERVER_ERROR" - The client received an error response when it tried to
   * communicate with the server.  - "REALTIME_TIMEOUT" - The client timed out while waiting for a
   * room.  - "REALTIME_CLIENT_DISCONNECTING" - The client disconnects without first calling Leave.
   * - "REALTIME_SIGN_OUT" - The user signed out of G+ while in the room.  - "REALTIME_GAME_CRASHED"
   * - The game crashed.  - "REALTIME_ROOM_SERVICE_CRASHED" - RoomAndroidService crashed.  -
   * "REALTIME_DIFFERENT_CLIENT_ROOM_OPERATION" - Another client is trying to enter a room.  -
   * "REALTIME_SAME_CLIENT_ROOM_OPERATION" - The same client is trying to enter a new room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomLeaveRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomLeaveRequest.
   * @param kind kind or {@code null} for none
   */
  public RoomLeaveRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Diagnostics for a player leaving the room.
   * @return value or {@code null} for none
   */
  public RoomLeaveDiagnostics getLeaveDiagnostics() {
    return leaveDiagnostics;
  }

  /**
   * Diagnostics for a player leaving the room.
   * @param leaveDiagnostics leaveDiagnostics or {@code null} for none
   */
  public RoomLeaveRequest setLeaveDiagnostics(RoomLeaveDiagnostics leaveDiagnostics) {
    this.leaveDiagnostics = leaveDiagnostics;
    return this;
  }

  /**
   * Reason for leaving the match. Possible values are:   - "PLAYER_LEFT" - The player chose to
   * leave the room..  - "GAME_LEFT" - The game chose to remove the player from the room.  -
   * "REALTIME_ABANDONED" - The player switched to another application and abandoned the room.  -
   * "REALTIME_PEER_CONNECTION_FAILURE" - The client was unable to establish a connection to other
   * peer(s).  - "REALTIME_SERVER_CONNECTION_FAILURE" - The client was unable to communicate with
   * the server.  - "REALTIME_SERVER_ERROR" - The client received an error response when it tried to
   * communicate with the server.  - "REALTIME_TIMEOUT" - The client timed out while waiting for a
   * room.  - "REALTIME_CLIENT_DISCONNECTING" - The client disconnects without first calling Leave.
   * - "REALTIME_SIGN_OUT" - The user signed out of G+ while in the room.  - "REALTIME_GAME_CRASHED"
   * - The game crashed.  - "REALTIME_ROOM_SERVICE_CRASHED" - RoomAndroidService crashed.  -
   * "REALTIME_DIFFERENT_CLIENT_ROOM_OPERATION" - Another client is trying to enter a room.  -
   * "REALTIME_SAME_CLIENT_ROOM_OPERATION" - The same client is trying to enter a new room.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * Reason for leaving the match. Possible values are:   - "PLAYER_LEFT" - The player chose to
   * leave the room..  - "GAME_LEFT" - The game chose to remove the player from the room.  -
   * "REALTIME_ABANDONED" - The player switched to another application and abandoned the room.  -
   * "REALTIME_PEER_CONNECTION_FAILURE" - The client was unable to establish a connection to other
   * peer(s).  - "REALTIME_SERVER_CONNECTION_FAILURE" - The client was unable to communicate with
   * the server.  - "REALTIME_SERVER_ERROR" - The client received an error response when it tried to
   * communicate with the server.  - "REALTIME_TIMEOUT" - The client timed out while waiting for a
   * room.  - "REALTIME_CLIENT_DISCONNECTING" - The client disconnects without first calling Leave.
   * - "REALTIME_SIGN_OUT" - The user signed out of G+ while in the room.  - "REALTIME_GAME_CRASHED"
   * - The game crashed.  - "REALTIME_ROOM_SERVICE_CRASHED" - RoomAndroidService crashed.  -
   * "REALTIME_DIFFERENT_CLIENT_ROOM_OPERATION" - Another client is trying to enter a room.  -
   * "REALTIME_SAME_CLIENT_ROOM_OPERATION" - The same client is trying to enter a new room.
   * @param reason reason or {@code null} for none
   */
  public RoomLeaveRequest setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  @Override
  public RoomLeaveRequest set(String fieldName, Object value) {
    return (RoomLeaveRequest) super.set(fieldName, value);
  }

  @Override
  public RoomLeaveRequest clone() {
    return (RoomLeaveRequest) super.clone();
  }

}
