/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-17 at 03:15:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for sending a turn-based match data object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatchDataRequest extends com.google.api.client.json.GenericJson {

  /**
   * The byte representation of the data (limited to 128 kB), as a Base64-encoded string with the
   * URL_SAFE encoding option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String data;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchDataRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The byte representation of the data (limited to 128 kB), as a Base64-encoded string with the
   * URL_SAFE encoding option.
   * @see #decodeData()
   * @return value or {@code null} for none
   */
  public java.lang.String getData() {
    return data;
  }

  /**
   * The byte representation of the data (limited to 128 kB), as a Base64-encoded string with the
   * URL_SAFE encoding option.
   * @see #getData()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeData() {
    return com.google.api.client.util.Base64.decodeBase64(data);
  }

  /**
   * The byte representation of the data (limited to 128 kB), as a Base64-encoded string with the
   * URL_SAFE encoding option.
   * @see #encodeData()
   * @param data data or {@code null} for none
   */
  public TurnBasedMatchDataRequest setData(java.lang.String data) {
    this.data = data;
    return this;
  }

  /**
   * The byte representation of the data (limited to 128 kB), as a Base64-encoded string with the
   * URL_SAFE encoding option.
   * @see #setData()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public TurnBasedMatchDataRequest encodeData(byte[] data) {
    this.data = com.google.api.client.util.Base64.encodeBase64URLSafeString(data);
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchDataRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchDataRequest.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatchDataRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public TurnBasedMatchDataRequest set(String fieldName, Object value) {
    return (TurnBasedMatchDataRequest) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatchDataRequest clone() {
    return (TurnBasedMatchDataRequest) super.clone();
  }

}
