/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * A batch update failure resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventBatchRecordFailure extends com.google.api.client.json.GenericJson {

  /**
   * The cause for the update failure.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String failureCause;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#eventBatchRecordFailure`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The time range which was rejected; empty for a request-wide failure.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventPeriodRange range;

  /**
   * The cause for the update failure.
   * @return value or {@code null} for none
   */
  public java.lang.String getFailureCause() {
    return failureCause;
  }

  /**
   * The cause for the update failure.
   * @param failureCause failureCause or {@code null} for none
   */
  public EventBatchRecordFailure setFailureCause(java.lang.String failureCause) {
    this.failureCause = failureCause;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#eventBatchRecordFailure`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#eventBatchRecordFailure`.
   * @param kind kind or {@code null} for none
   */
  public EventBatchRecordFailure setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The time range which was rejected; empty for a request-wide failure.
   * @return value or {@code null} for none
   */
  public EventPeriodRange getRange() {
    return range;
  }

  /**
   * The time range which was rejected; empty for a request-wide failure.
   * @param range range or {@code null} for none
   */
  public EventBatchRecordFailure setRange(EventPeriodRange range) {
    this.range = range;
    return this;
  }

  @Override
  public EventBatchRecordFailure set(String fieldName, Object value) {
    return (EventBatchRecordFailure) super.set(fieldName, value);
  }

  @Override
  public EventBatchRecordFailure clone() {
    return (EventBatchRecordFailure) super.clone();
  }

}
