/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * A player score.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerScore extends com.google.api.client.json.GenericJson {

  /**
   * The formatted score for this player score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedScore;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScore`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The numerical value for this player score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long score;

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scoreTag;

  /**
   * The time span for this player score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeSpan;

  /**
   * The formatted score for this player score.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedScore() {
    return formattedScore;
  }

  /**
   * The formatted score for this player score.
   * @param formattedScore formattedScore or {@code null} for none
   */
  public PlayerScore setFormattedScore(java.lang.String formattedScore) {
    this.formattedScore = formattedScore;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScore`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScore`.
   * @param kind kind or {@code null} for none
   */
  public PlayerScore setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The numerical value for this player score.
   * @return value or {@code null} for none
   */
  public java.lang.Long getScore() {
    return score;
  }

  /**
   * The numerical value for this player score.
   * @param score score or {@code null} for none
   */
  public PlayerScore setScore(java.lang.Long score) {
    this.score = score;
    return this;
  }

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * @return value or {@code null} for none
   */
  public java.lang.String getScoreTag() {
    return scoreTag;
  }

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * @param scoreTag scoreTag or {@code null} for none
   */
  public PlayerScore setScoreTag(java.lang.String scoreTag) {
    this.scoreTag = scoreTag;
    return this;
  }

  /**
   * The time span for this player score.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeSpan() {
    return timeSpan;
  }

  /**
   * The time span for this player score.
   * @param timeSpan timeSpan or {@code null} for none
   */
  public PlayerScore setTimeSpan(java.lang.String timeSpan) {
    this.timeSpan = timeSpan;
    return this;
  }

  @Override
  public PlayerScore set(String fieldName, Object value) {
    return (PlayerScore) super.set(fieldName, value);
  }

  @Override
  public PlayerScore clone() {
    return (PlayerScore) super.clone();
  }

}
