/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * A list of leaderboard entry resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerScoreResponse extends com.google.api.client.json.GenericJson {

  /**
   * The time spans where the submitted score is better than the existing score for that time span.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> beatenScoreTimeSpans;

  /**
   * The formatted value of the submitted score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedScore;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScoreResponse`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The leaderboard ID that this score was submitted to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String leaderboardId;

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scoreTag;

  /**
   * The scores in time spans that have not been beaten. As an example, the submitted score may be
   * better than the player's `DAILY` score, but not better than the player's scores for the
   * `WEEKLY` or `ALL_TIME` time spans.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlayerScore> unbeatenScores;

  static {
    // hack to force ProGuard to consider PlayerScore used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PlayerScore.class);
  }

  /**
   * The time spans where the submitted score is better than the existing score for that time span.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getBeatenScoreTimeSpans() {
    return beatenScoreTimeSpans;
  }

  /**
   * The time spans where the submitted score is better than the existing score for that time span.
   * @param beatenScoreTimeSpans beatenScoreTimeSpans or {@code null} for none
   */
  public PlayerScoreResponse setBeatenScoreTimeSpans(java.util.List<java.lang.String> beatenScoreTimeSpans) {
    this.beatenScoreTimeSpans = beatenScoreTimeSpans;
    return this;
  }

  /**
   * The formatted value of the submitted score.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedScore() {
    return formattedScore;
  }

  /**
   * The formatted value of the submitted score.
   * @param formattedScore formattedScore or {@code null} for none
   */
  public PlayerScoreResponse setFormattedScore(java.lang.String formattedScore) {
    this.formattedScore = formattedScore;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScoreResponse`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#playerScoreResponse`.
   * @param kind kind or {@code null} for none
   */
  public PlayerScoreResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The leaderboard ID that this score was submitted to.
   * @return value or {@code null} for none
   */
  public java.lang.String getLeaderboardId() {
    return leaderboardId;
  }

  /**
   * The leaderboard ID that this score was submitted to.
   * @param leaderboardId leaderboardId or {@code null} for none
   */
  public PlayerScoreResponse setLeaderboardId(java.lang.String leaderboardId) {
    this.leaderboardId = leaderboardId;
    return this;
  }

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * @return value or {@code null} for none
   */
  public java.lang.String getScoreTag() {
    return scoreTag;
  }

  /**
   * Additional information about this score. Values will contain no more than 64 URI-safe
   * characters as defined by section 2.3 of RFC 3986.
   * @param scoreTag scoreTag or {@code null} for none
   */
  public PlayerScoreResponse setScoreTag(java.lang.String scoreTag) {
    this.scoreTag = scoreTag;
    return this;
  }

  /**
   * The scores in time spans that have not been beaten. As an example, the submitted score may be
   * better than the player's `DAILY` score, but not better than the player's scores for the
   * `WEEKLY` or `ALL_TIME` time spans.
   * @return value or {@code null} for none
   */
  public java.util.List<PlayerScore> getUnbeatenScores() {
    return unbeatenScores;
  }

  /**
   * The scores in time spans that have not been beaten. As an example, the submitted score may be
   * better than the player's `DAILY` score, but not better than the player's scores for the
   * `WEEKLY` or `ALL_TIME` time spans.
   * @param unbeatenScores unbeatenScores or {@code null} for none
   */
  public PlayerScoreResponse setUnbeatenScores(java.util.List<PlayerScore> unbeatenScores) {
    this.unbeatenScores = unbeatenScores;
    return this;
  }

  @Override
  public PlayerScoreResponse set(String fieldName, Object value) {
    return (PlayerScoreResponse) super.set(fieldName, value);
  }

  @Override
  public PlayerScoreResponse clone() {
    return (PlayerScoreResponse) super.clone();
  }

}
