/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * A third party stats resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StatsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Average session length in minutes of the player. E.g., 1, 30, 60, ... . Not populated if there
   * is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("avg_session_length_minutes")
  private java.lang.Float avgSessionLengthMinutes;

  /**
   * The probability of the player not returning to play the game in the next day. E.g., 0, 0.1,
   * 0.5, ..., 1.0. Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("churn_probability")
  private java.lang.Float churnProbability;

  /**
   * Number of days since the player last played this game. E.g., 0, 1, 5, 10, ... . Not populated
   * if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("days_since_last_played")
  private java.lang.Integer daysSinceLastPlayed;

  /**
   * The probability of the player going to spend beyond a threshold amount of money. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("high_spender_probability")
  private java.lang.Float highSpenderProbability;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#statsResponse`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Number of in-app purchases made by the player in this game. E.g., 0, 1, 5, 10, ... . Not
   * populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("num_purchases")
  private java.lang.Integer numPurchases;

  /**
   * The approximate number of sessions of the player within the last 28 days, where a session
   * begins when the player is connected to Play Games Services and ends when they are disconnected.
   * E.g., 0, 1, 5, 10, ... . Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("num_sessions")
  private java.lang.Integer numSessions;

  /**
   * The approximation of the sessions percentile of the player within the last 30 days, where a
   * session begins when the player is connected to Play Games Services and ends when they are
   * disconnected. E.g., 0, 0.25, 0.5, 0.75. Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("num_sessions_percentile")
  private java.lang.Float numSessionsPercentile;

  /**
   * The approximate spend percentile of the player in this game. E.g., 0, 0.25, 0.5, 0.75. Not
   * populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("spend_percentile")
  private java.lang.Float spendPercentile;

  /**
   * The probability of the player going to spend the game in the next seven days. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("spend_probability")
  private java.lang.Float spendProbability;

  /**
   * The predicted amount of money that the player going to spend in the next 28 days. E.g., 1, 30,
   * 60, ... . Not populated if there is not enough information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("total_spend_next_28_days")
  private java.lang.Float totalSpendNext28Days;

  /**
   * Average session length in minutes of the player. E.g., 1, 30, 60, ... . Not populated if there
   * is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAvgSessionLengthMinutes() {
    return avgSessionLengthMinutes;
  }

  /**
   * Average session length in minutes of the player. E.g., 1, 30, 60, ... . Not populated if there
   * is not enough information.
   * @param avgSessionLengthMinutes avgSessionLengthMinutes or {@code null} for none
   */
  public StatsResponse setAvgSessionLengthMinutes(java.lang.Float avgSessionLengthMinutes) {
    this.avgSessionLengthMinutes = avgSessionLengthMinutes;
    return this;
  }

  /**
   * The probability of the player not returning to play the game in the next day. E.g., 0, 0.1,
   * 0.5, ..., 1.0. Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getChurnProbability() {
    return churnProbability;
  }

  /**
   * The probability of the player not returning to play the game in the next day. E.g., 0, 0.1,
   * 0.5, ..., 1.0. Not populated if there is not enough information.
   * @param churnProbability churnProbability or {@code null} for none
   */
  public StatsResponse setChurnProbability(java.lang.Float churnProbability) {
    this.churnProbability = churnProbability;
    return this;
  }

  /**
   * Number of days since the player last played this game. E.g., 0, 1, 5, 10, ... . Not populated
   * if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDaysSinceLastPlayed() {
    return daysSinceLastPlayed;
  }

  /**
   * Number of days since the player last played this game. E.g., 0, 1, 5, 10, ... . Not populated
   * if there is not enough information.
   * @param daysSinceLastPlayed daysSinceLastPlayed or {@code null} for none
   */
  public StatsResponse setDaysSinceLastPlayed(java.lang.Integer daysSinceLastPlayed) {
    this.daysSinceLastPlayed = daysSinceLastPlayed;
    return this;
  }

  /**
   * The probability of the player going to spend beyond a threshold amount of money. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getHighSpenderProbability() {
    return highSpenderProbability;
  }

  /**
   * The probability of the player going to spend beyond a threshold amount of money. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * @param highSpenderProbability highSpenderProbability or {@code null} for none
   */
  public StatsResponse setHighSpenderProbability(java.lang.Float highSpenderProbability) {
    this.highSpenderProbability = highSpenderProbability;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#statsResponse`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * `games#statsResponse`.
   * @param kind kind or {@code null} for none
   */
  public StatsResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Number of in-app purchases made by the player in this game. E.g., 0, 1, 5, 10, ... . Not
   * populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumPurchases() {
    return numPurchases;
  }

  /**
   * Number of in-app purchases made by the player in this game. E.g., 0, 1, 5, 10, ... . Not
   * populated if there is not enough information.
   * @param numPurchases numPurchases or {@code null} for none
   */
  public StatsResponse setNumPurchases(java.lang.Integer numPurchases) {
    this.numPurchases = numPurchases;
    return this;
  }

  /**
   * The approximate number of sessions of the player within the last 28 days, where a session
   * begins when the player is connected to Play Games Services and ends when they are disconnected.
   * E.g., 0, 1, 5, 10, ... . Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumSessions() {
    return numSessions;
  }

  /**
   * The approximate number of sessions of the player within the last 28 days, where a session
   * begins when the player is connected to Play Games Services and ends when they are disconnected.
   * E.g., 0, 1, 5, 10, ... . Not populated if there is not enough information.
   * @param numSessions numSessions or {@code null} for none
   */
  public StatsResponse setNumSessions(java.lang.Integer numSessions) {
    this.numSessions = numSessions;
    return this;
  }

  /**
   * The approximation of the sessions percentile of the player within the last 30 days, where a
   * session begins when the player is connected to Play Games Services and ends when they are
   * disconnected. E.g., 0, 0.25, 0.5, 0.75. Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getNumSessionsPercentile() {
    return numSessionsPercentile;
  }

  /**
   * The approximation of the sessions percentile of the player within the last 30 days, where a
   * session begins when the player is connected to Play Games Services and ends when they are
   * disconnected. E.g., 0, 0.25, 0.5, 0.75. Not populated if there is not enough information.
   * @param numSessionsPercentile numSessionsPercentile or {@code null} for none
   */
  public StatsResponse setNumSessionsPercentile(java.lang.Float numSessionsPercentile) {
    this.numSessionsPercentile = numSessionsPercentile;
    return this;
  }

  /**
   * The approximate spend percentile of the player in this game. E.g., 0, 0.25, 0.5, 0.75. Not
   * populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSpendPercentile() {
    return spendPercentile;
  }

  /**
   * The approximate spend percentile of the player in this game. E.g., 0, 0.25, 0.5, 0.75. Not
   * populated if there is not enough information.
   * @param spendPercentile spendPercentile or {@code null} for none
   */
  public StatsResponse setSpendPercentile(java.lang.Float spendPercentile) {
    this.spendPercentile = spendPercentile;
    return this;
  }

  /**
   * The probability of the player going to spend the game in the next seven days. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSpendProbability() {
    return spendProbability;
  }

  /**
   * The probability of the player going to spend the game in the next seven days. E.g., 0, 0.25,
   * 0.50, 0.75. Not populated if there is not enough information.
   * @param spendProbability spendProbability or {@code null} for none
   */
  public StatsResponse setSpendProbability(java.lang.Float spendProbability) {
    this.spendProbability = spendProbability;
    return this;
  }

  /**
   * The predicted amount of money that the player going to spend in the next 28 days. E.g., 1, 30,
   * 60, ... . Not populated if there is not enough information.
   * @return value or {@code null} for none
   */
  public java.lang.Float getTotalSpendNext28Days() {
    return totalSpendNext28Days;
  }

  /**
   * The predicted amount of money that the player going to spend in the next 28 days. E.g., 1, 30,
   * 60, ... . Not populated if there is not enough information.
   * @param totalSpendNext28Days totalSpendNext28Days or {@code null} for none
   */
  public StatsResponse setTotalSpendNext28Days(java.lang.Float totalSpendNext28Days) {
    this.totalSpendNext28Days = totalSpendNext28Days;
    return this;
  }

  @Override
  public StatsResponse set(String fieldName, Object value) {
    return (StatsResponse) super.set(fieldName, value);
  }

  @Override
  public StatsResponse clone() {
    return (StatsResponse) super.clone();
  }

}
