/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.games;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.games.GamesRequest;
import com.google.api.services.games.GamesRequestInitializer;
import com.google.api.services.games.model.AchievementDefinitionsListResponse;
import com.google.api.services.games.model.AchievementIncrementResponse;
import com.google.api.services.games.model.AchievementRevealResponse;
import com.google.api.services.games.model.AchievementSetStepsAtLeastResponse;
import com.google.api.services.games.model.AchievementUnlockResponse;
import com.google.api.services.games.model.AchievementUpdateMultipleRequest;
import com.google.api.services.games.model.AchievementUpdateMultipleResponse;
import com.google.api.services.games.model.Application;
import com.google.api.services.games.model.ApplicationVerifyResponse;
import com.google.api.services.games.model.CategoryListResponse;
import com.google.api.services.games.model.EventDefinitionListResponse;
import com.google.api.services.games.model.EventRecordRequest;
import com.google.api.services.games.model.EventUpdateResponse;
import com.google.api.services.games.model.Leaderboard;
import com.google.api.services.games.model.LeaderboardListResponse;
import com.google.api.services.games.model.LeaderboardScores;
import com.google.api.services.games.model.MetagameConfig;
import com.google.api.services.games.model.Player;
import com.google.api.services.games.model.PlayerAchievementListResponse;
import com.google.api.services.games.model.PlayerEventListResponse;
import com.google.api.services.games.model.PlayerLeaderboardScoreListResponse;
import com.google.api.services.games.model.PlayerListResponse;
import com.google.api.services.games.model.PlayerScoreListResponse;
import com.google.api.services.games.model.PlayerScoreResponse;
import com.google.api.services.games.model.PlayerScoreSubmissionList;
import com.google.api.services.games.model.RevisionCheckResponse;
import com.google.api.services.games.model.Snapshot;
import com.google.api.services.games.model.SnapshotListResponse;
import com.google.api.services.games.model.StatsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class Games
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://games.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://games.googleapis.com/";

    public Games(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Games(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public AchievementDefinitions achievementDefinitions() {
        return new AchievementDefinitions();
    }

    public Achievements achievements() {
        return new Achievements();
    }

    public Applications applications() {
        return new Applications();
    }

    public Events events() {
        return new Events();
    }

    public Leaderboards leaderboards() {
        return new Leaderboards();
    }

    public Metagame metagame() {
        return new Metagame();
    }

    public Players players() {
        return new Players();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    public Scores scores() {
        return new Scores();
    }

    public Snapshots snapshots() {
        return new Snapshots();
    }

    public Stats stats() {
        return new Stats();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Google Play Game Services library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://games.googleapis.com/", Games.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Games.DEFAULT_BATCH_PATH);
        }

        public Games build() {
            return new Games(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setGamesRequestInitializer(GamesRequestInitializer gamesRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)gamesRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Stats {
        public Get get() throws IOException {
            Get result = new Get();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends GamesRequest<StatsResponse> {
            private static final String REST_PATH = "games/v1/stats";

            protected Get() {
                super(Games.this, "GET", REST_PATH, null, StatsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Snapshots {
        public Get get(String snapshotId) throws IOException {
            Get result = new Get(snapshotId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String playerId) throws IOException {
            List result = new List(playerId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends GamesRequest<SnapshotListResponse> {
            private static final String REST_PATH = "games/v1/players/{playerId}/snapshots";
            @Key
            private String playerId;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String playerId) {
                super(Games.this, "GET", REST_PATH, null, SnapshotListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)playerId, (Object)"Required parameter playerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public List setPlayerId(String playerId) {
                this.playerId = playerId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends GamesRequest<Snapshot> {
            private static final String REST_PATH = "games/v1/snapshots/{snapshotId}";
            @Key
            private String snapshotId;
            @Key
            private String language;

            protected Get(String snapshotId) {
                super(Games.this, "GET", REST_PATH, null, Snapshot.class);
                this.snapshotId = (String)Preconditions.checkNotNull((Object)snapshotId, (Object)"Required parameter snapshotId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSnapshotId() {
                return this.snapshotId;
            }

            public Get setSnapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Scores {
        public Get get(String playerId, String leaderboardId, String timeSpan) throws IOException {
            Get result = new Get(playerId, leaderboardId, timeSpan);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String leaderboardId, String collection, String timeSpan) throws IOException {
            List result = new List(leaderboardId, collection, timeSpan);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListWindow listWindow(String leaderboardId, String collection, String timeSpan) throws IOException {
            ListWindow result = new ListWindow(leaderboardId, collection, timeSpan);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Submit submit(String leaderboardId, Long score) throws IOException {
            Submit result = new Submit(leaderboardId, score);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SubmitMultiple submitMultiple(PlayerScoreSubmissionList content) throws IOException {
            SubmitMultiple result = new SubmitMultiple(content);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class SubmitMultiple
        extends GamesRequest<PlayerScoreListResponse> {
            private static final String REST_PATH = "games/v1/leaderboards/scores";
            @Key
            private String language;

            protected SubmitMultiple(PlayerScoreSubmissionList content) {
                super(Games.this, "POST", REST_PATH, (Object)content, PlayerScoreListResponse.class);
            }

            public SubmitMultiple set$Xgafv(String $Xgafv) {
                return (SubmitMultiple)super.set$Xgafv($Xgafv);
            }

            public SubmitMultiple setAccessToken(String accessToken) {
                return (SubmitMultiple)super.setAccessToken(accessToken);
            }

            public SubmitMultiple setAlt(String alt) {
                return (SubmitMultiple)super.setAlt(alt);
            }

            public SubmitMultiple setCallback(String callback) {
                return (SubmitMultiple)super.setCallback(callback);
            }

            public SubmitMultiple setFields(String fields) {
                return (SubmitMultiple)super.setFields(fields);
            }

            public SubmitMultiple setKey(String key) {
                return (SubmitMultiple)super.setKey(key);
            }

            public SubmitMultiple setOauthToken(String oauthToken) {
                return (SubmitMultiple)super.setOauthToken(oauthToken);
            }

            public SubmitMultiple setPrettyPrint(Boolean prettyPrint) {
                return (SubmitMultiple)super.setPrettyPrint(prettyPrint);
            }

            public SubmitMultiple setQuotaUser(String quotaUser) {
                return (SubmitMultiple)super.setQuotaUser(quotaUser);
            }

            public SubmitMultiple setUploadType(String uploadType) {
                return (SubmitMultiple)super.setUploadType(uploadType);
            }

            public SubmitMultiple setUploadProtocol(String uploadProtocol) {
                return (SubmitMultiple)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public SubmitMultiple setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public SubmitMultiple set(String parameterName, Object value) {
                return (SubmitMultiple)super.set(parameterName, value);
            }
        }

        public class Submit
        extends GamesRequest<PlayerScoreResponse> {
            private static final String REST_PATH = "games/v1/leaderboards/{leaderboardId}/scores";
            private final Pattern SCORE_TAG_PATTERN;
            @Key
            private String leaderboardId;
            @Key
            private Long score;
            @Key
            private String language;
            @Key
            private String scoreTag;

            protected Submit(String leaderboardId, Long score) {
                super(Games.this, "POST", REST_PATH, null, PlayerScoreResponse.class);
                this.SCORE_TAG_PATTERN = Pattern.compile("[a-zA-Z0-9-._~]{0,64}");
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)leaderboardId, (Object)"Required parameter leaderboardId must be specified.");
                this.score = (Long)Preconditions.checkNotNull((Object)score, (Object)"Required parameter score must be specified.");
            }

            public Submit set$Xgafv(String $Xgafv) {
                return (Submit)super.set$Xgafv($Xgafv);
            }

            public Submit setAccessToken(String accessToken) {
                return (Submit)super.setAccessToken(accessToken);
            }

            public Submit setAlt(String alt) {
                return (Submit)super.setAlt(alt);
            }

            public Submit setCallback(String callback) {
                return (Submit)super.setCallback(callback);
            }

            public Submit setFields(String fields) {
                return (Submit)super.setFields(fields);
            }

            public Submit setKey(String key) {
                return (Submit)super.setKey(key);
            }

            public Submit setOauthToken(String oauthToken) {
                return (Submit)super.setOauthToken(oauthToken);
            }

            public Submit setPrettyPrint(Boolean prettyPrint) {
                return (Submit)super.setPrettyPrint(prettyPrint);
            }

            public Submit setQuotaUser(String quotaUser) {
                return (Submit)super.setQuotaUser(quotaUser);
            }

            public Submit setUploadType(String uploadType) {
                return (Submit)super.setUploadType(uploadType);
            }

            public Submit setUploadProtocol(String uploadProtocol) {
                return (Submit)super.setUploadProtocol(uploadProtocol);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Submit setLeaderboardId(String leaderboardId) {
                this.leaderboardId = leaderboardId;
                return this;
            }

            public Long getScore() {
                return this.score;
            }

            public Submit setScore(Long score) {
                this.score = score;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Submit setLanguage(String language) {
                this.language = language;
                return this;
            }

            public String getScoreTag() {
                return this.scoreTag;
            }

            public Submit setScoreTag(String scoreTag) {
                if (!Games.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCORE_TAG_PATTERN.matcher(scoreTag).matches(), (Object)"Parameter scoreTag must conform to the pattern [a-zA-Z0-9-._~]{0,64}");
                }
                this.scoreTag = scoreTag;
                return this;
            }

            @Override
            public Submit set(String parameterName, Object value) {
                return (Submit)super.set(parameterName, value);
            }
        }

        public class ListWindow
        extends GamesRequest<LeaderboardScores> {
            private static final String REST_PATH = "games/v1/leaderboards/{leaderboardId}/window/{collection}";
            @Key
            private String leaderboardId;
            @Key
            private String collection;
            @Key
            private String timeSpan;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private Integer resultsAbove;
            @Key
            private Boolean returnTopIfAbsent;

            protected ListWindow(String leaderboardId, String collection, String timeSpan) {
                super(Games.this, "GET", REST_PATH, null, LeaderboardScores.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)leaderboardId, (Object)"Required parameter leaderboardId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)timeSpan, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListWindow set$Xgafv(String $Xgafv) {
                return (ListWindow)super.set$Xgafv($Xgafv);
            }

            public ListWindow setAccessToken(String accessToken) {
                return (ListWindow)super.setAccessToken(accessToken);
            }

            public ListWindow setAlt(String alt) {
                return (ListWindow)super.setAlt(alt);
            }

            public ListWindow setCallback(String callback) {
                return (ListWindow)super.setCallback(callback);
            }

            public ListWindow setFields(String fields) {
                return (ListWindow)super.setFields(fields);
            }

            public ListWindow setKey(String key) {
                return (ListWindow)super.setKey(key);
            }

            public ListWindow setOauthToken(String oauthToken) {
                return (ListWindow)super.setOauthToken(oauthToken);
            }

            public ListWindow setPrettyPrint(Boolean prettyPrint) {
                return (ListWindow)super.setPrettyPrint(prettyPrint);
            }

            public ListWindow setQuotaUser(String quotaUser) {
                return (ListWindow)super.setQuotaUser(quotaUser);
            }

            public ListWindow setUploadType(String uploadType) {
                return (ListWindow)super.setUploadType(uploadType);
            }

            public ListWindow setUploadProtocol(String uploadProtocol) {
                return (ListWindow)super.setUploadProtocol(uploadProtocol);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public ListWindow setLeaderboardId(String leaderboardId) {
                this.leaderboardId = leaderboardId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListWindow setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public ListWindow setTimeSpan(String timeSpan) {
                this.timeSpan = timeSpan;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public ListWindow setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListWindow setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListWindow setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Integer getResultsAbove() {
                return this.resultsAbove;
            }

            public ListWindow setResultsAbove(Integer resultsAbove) {
                this.resultsAbove = resultsAbove;
                return this;
            }

            public Boolean getReturnTopIfAbsent() {
                return this.returnTopIfAbsent;
            }

            public ListWindow setReturnTopIfAbsent(Boolean returnTopIfAbsent) {
                this.returnTopIfAbsent = returnTopIfAbsent;
                return this;
            }

            @Override
            public ListWindow set(String parameterName, Object value) {
                return (ListWindow)super.set(parameterName, value);
            }
        }

        public class List
        extends GamesRequest<LeaderboardScores> {
            private static final String REST_PATH = "games/v1/leaderboards/{leaderboardId}/scores/{collection}";
            @Key
            private String leaderboardId;
            @Key
            private String collection;
            @Key
            private String timeSpan;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String leaderboardId, String collection, String timeSpan) {
                super(Games.this, "GET", REST_PATH, null, LeaderboardScores.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)leaderboardId, (Object)"Required parameter leaderboardId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)timeSpan, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public List setLeaderboardId(String leaderboardId) {
                this.leaderboardId = leaderboardId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public List setTimeSpan(String timeSpan) {
                this.timeSpan = timeSpan;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends GamesRequest<PlayerLeaderboardScoreListResponse> {
            private static final String REST_PATH = "games/v1/players/{playerId}/leaderboards/{leaderboardId}/scores/{timeSpan}";
            @Key
            private String playerId;
            @Key
            private String leaderboardId;
            @Key
            private String timeSpan;
            @Key
            private String includeRankType;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected Get(String playerId, String leaderboardId, String timeSpan) {
                super(Games.this, "GET", REST_PATH, null, PlayerLeaderboardScoreListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)playerId, (Object)"Required parameter playerId must be specified.");
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)leaderboardId, (Object)"Required parameter leaderboardId must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)timeSpan, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Get setPlayerId(String playerId) {
                this.playerId = playerId;
                return this;
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Get setLeaderboardId(String leaderboardId) {
                this.leaderboardId = leaderboardId;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public Get setTimeSpan(String timeSpan) {
                this.timeSpan = timeSpan;
                return this;
            }

            public String getIncludeRankType() {
                return this.includeRankType;
            }

            public Get setIncludeRankType(String includeRankType) {
                this.includeRankType = includeRankType;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Get setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Get setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Revisions {
        public Check check(String clientRevision) throws IOException {
            Check result = new Check(clientRevision);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Check
        extends GamesRequest<RevisionCheckResponse> {
            private static final String REST_PATH = "games/v1/revisions/check";
            @Key
            private String clientRevision;

            protected Check(String clientRevision) {
                super(Games.this, "GET", REST_PATH, null, RevisionCheckResponse.class);
                this.clientRevision = (String)Preconditions.checkNotNull((Object)clientRevision, (Object)"Required parameter clientRevision must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Check set$Xgafv(String $Xgafv) {
                return (Check)super.set$Xgafv($Xgafv);
            }

            public Check setAccessToken(String accessToken) {
                return (Check)super.setAccessToken(accessToken);
            }

            public Check setAlt(String alt) {
                return (Check)super.setAlt(alt);
            }

            public Check setCallback(String callback) {
                return (Check)super.setCallback(callback);
            }

            public Check setFields(String fields) {
                return (Check)super.setFields(fields);
            }

            public Check setKey(String key) {
                return (Check)super.setKey(key);
            }

            public Check setOauthToken(String oauthToken) {
                return (Check)super.setOauthToken(oauthToken);
            }

            public Check setPrettyPrint(Boolean prettyPrint) {
                return (Check)super.setPrettyPrint(prettyPrint);
            }

            public Check setQuotaUser(String quotaUser) {
                return (Check)super.setQuotaUser(quotaUser);
            }

            public Check setUploadType(String uploadType) {
                return (Check)super.setUploadType(uploadType);
            }

            public Check setUploadProtocol(String uploadProtocol) {
                return (Check)super.setUploadProtocol(uploadProtocol);
            }

            public String getClientRevision() {
                return this.clientRevision;
            }

            public Check setClientRevision(String clientRevision) {
                this.clientRevision = clientRevision;
                return this;
            }

            @Override
            public Check set(String parameterName, Object value) {
                return (Check)super.set(parameterName, value);
            }
        }
    }

    public class Players {
        public Get get(String playerId) throws IOException {
            Get result = new Get(playerId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String collection) throws IOException {
            List result = new List(collection);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends GamesRequest<PlayerListResponse> {
            private static final String REST_PATH = "games/v1/players/me/players/{collection}";
            @Key
            private String collection;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String collection) {
                super(Games.this, "GET", REST_PATH, null, PlayerListResponse.class);
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends GamesRequest<Player> {
            private static final String REST_PATH = "games/v1/players/{playerId}";
            @Key
            private String playerId;
            @Key
            private String language;

            protected Get(String playerId) {
                super(Games.this, "GET", REST_PATH, null, Player.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)playerId, (Object)"Required parameter playerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Get setPlayerId(String playerId) {
                this.playerId = playerId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Metagame {
        public GetMetagameConfig getMetagameConfig() throws IOException {
            GetMetagameConfig result = new GetMetagameConfig();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListCategoriesByPlayer listCategoriesByPlayer(String playerId, String collection) throws IOException {
            ListCategoriesByPlayer result = new ListCategoriesByPlayer(playerId, collection);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ListCategoriesByPlayer
        extends GamesRequest<CategoryListResponse> {
            private static final String REST_PATH = "games/v1/players/{playerId}/categories/{collection}";
            @Key
            private String playerId;
            @Key
            private String collection;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListCategoriesByPlayer(String playerId, String collection) {
                super(Games.this, "GET", REST_PATH, null, CategoryListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)playerId, (Object)"Required parameter playerId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)collection, (Object)"Required parameter collection must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListCategoriesByPlayer set$Xgafv(String $Xgafv) {
                return (ListCategoriesByPlayer)super.set$Xgafv($Xgafv);
            }

            public ListCategoriesByPlayer setAccessToken(String accessToken) {
                return (ListCategoriesByPlayer)super.setAccessToken(accessToken);
            }

            public ListCategoriesByPlayer setAlt(String alt) {
                return (ListCategoriesByPlayer)super.setAlt(alt);
            }

            public ListCategoriesByPlayer setCallback(String callback) {
                return (ListCategoriesByPlayer)super.setCallback(callback);
            }

            public ListCategoriesByPlayer setFields(String fields) {
                return (ListCategoriesByPlayer)super.setFields(fields);
            }

            public ListCategoriesByPlayer setKey(String key) {
                return (ListCategoriesByPlayer)super.setKey(key);
            }

            public ListCategoriesByPlayer setOauthToken(String oauthToken) {
                return (ListCategoriesByPlayer)super.setOauthToken(oauthToken);
            }

            public ListCategoriesByPlayer setPrettyPrint(Boolean prettyPrint) {
                return (ListCategoriesByPlayer)super.setPrettyPrint(prettyPrint);
            }

            public ListCategoriesByPlayer setQuotaUser(String quotaUser) {
                return (ListCategoriesByPlayer)super.setQuotaUser(quotaUser);
            }

            public ListCategoriesByPlayer setUploadType(String uploadType) {
                return (ListCategoriesByPlayer)super.setUploadType(uploadType);
            }

            public ListCategoriesByPlayer setUploadProtocol(String uploadProtocol) {
                return (ListCategoriesByPlayer)super.setUploadProtocol(uploadProtocol);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public ListCategoriesByPlayer setPlayerId(String playerId) {
                this.playerId = playerId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListCategoriesByPlayer setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public ListCategoriesByPlayer setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListCategoriesByPlayer setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListCategoriesByPlayer setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListCategoriesByPlayer set(String parameterName, Object value) {
                return (ListCategoriesByPlayer)super.set(parameterName, value);
            }
        }

        public class GetMetagameConfig
        extends GamesRequest<MetagameConfig> {
            private static final String REST_PATH = "games/v1/metagameConfig";

            protected GetMetagameConfig() {
                super(Games.this, "GET", REST_PATH, null, MetagameConfig.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetagameConfig set$Xgafv(String $Xgafv) {
                return (GetMetagameConfig)super.set$Xgafv($Xgafv);
            }

            public GetMetagameConfig setAccessToken(String accessToken) {
                return (GetMetagameConfig)super.setAccessToken(accessToken);
            }

            public GetMetagameConfig setAlt(String alt) {
                return (GetMetagameConfig)super.setAlt(alt);
            }

            public GetMetagameConfig setCallback(String callback) {
                return (GetMetagameConfig)super.setCallback(callback);
            }

            public GetMetagameConfig setFields(String fields) {
                return (GetMetagameConfig)super.setFields(fields);
            }

            public GetMetagameConfig setKey(String key) {
                return (GetMetagameConfig)super.setKey(key);
            }

            public GetMetagameConfig setOauthToken(String oauthToken) {
                return (GetMetagameConfig)super.setOauthToken(oauthToken);
            }

            public GetMetagameConfig setPrettyPrint(Boolean prettyPrint) {
                return (GetMetagameConfig)super.setPrettyPrint(prettyPrint);
            }

            public GetMetagameConfig setQuotaUser(String quotaUser) {
                return (GetMetagameConfig)super.setQuotaUser(quotaUser);
            }

            public GetMetagameConfig setUploadType(String uploadType) {
                return (GetMetagameConfig)super.setUploadType(uploadType);
            }

            public GetMetagameConfig setUploadProtocol(String uploadProtocol) {
                return (GetMetagameConfig)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public GetMetagameConfig set(String parameterName, Object value) {
                return (GetMetagameConfig)super.set(parameterName, value);
            }
        }
    }

    public class Leaderboards {
        public Get get(String leaderboardId) throws IOException {
            Get result = new Get(leaderboardId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends GamesRequest<LeaderboardListResponse> {
            private static final String REST_PATH = "games/v1/leaderboards";
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Games.this, "GET", REST_PATH, null, LeaderboardListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends GamesRequest<Leaderboard> {
            private static final String REST_PATH = "games/v1/leaderboards/{leaderboardId}";
            @Key
            private String leaderboardId;
            @Key
            private String language;

            protected Get(String leaderboardId) {
                super(Games.this, "GET", REST_PATH, null, Leaderboard.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)leaderboardId, (Object)"Required parameter leaderboardId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Get setLeaderboardId(String leaderboardId) {
                this.leaderboardId = leaderboardId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Events {
        public ListByPlayer listByPlayer() throws IOException {
            ListByPlayer result = new ListByPlayer();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListDefinitions listDefinitions() throws IOException {
            ListDefinitions result = new ListDefinitions();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Record record(EventRecordRequest content) throws IOException {
            Record result = new Record(content);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Record
        extends GamesRequest<EventUpdateResponse> {
            private static final String REST_PATH = "games/v1/events";
            @Key
            private String language;

            protected Record(EventRecordRequest content) {
                super(Games.this, "POST", REST_PATH, (Object)content, EventUpdateResponse.class);
            }

            public Record set$Xgafv(String $Xgafv) {
                return (Record)super.set$Xgafv($Xgafv);
            }

            public Record setAccessToken(String accessToken) {
                return (Record)super.setAccessToken(accessToken);
            }

            public Record setAlt(String alt) {
                return (Record)super.setAlt(alt);
            }

            public Record setCallback(String callback) {
                return (Record)super.setCallback(callback);
            }

            public Record setFields(String fields) {
                return (Record)super.setFields(fields);
            }

            public Record setKey(String key) {
                return (Record)super.setKey(key);
            }

            public Record setOauthToken(String oauthToken) {
                return (Record)super.setOauthToken(oauthToken);
            }

            public Record setPrettyPrint(Boolean prettyPrint) {
                return (Record)super.setPrettyPrint(prettyPrint);
            }

            public Record setQuotaUser(String quotaUser) {
                return (Record)super.setQuotaUser(quotaUser);
            }

            public Record setUploadType(String uploadType) {
                return (Record)super.setUploadType(uploadType);
            }

            public Record setUploadProtocol(String uploadProtocol) {
                return (Record)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public Record setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Record set(String parameterName, Object value) {
                return (Record)super.set(parameterName, value);
            }
        }

        public class ListDefinitions
        extends GamesRequest<EventDefinitionListResponse> {
            private static final String REST_PATH = "games/v1/eventDefinitions";
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListDefinitions() {
                super(Games.this, "GET", REST_PATH, null, EventDefinitionListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListDefinitions set$Xgafv(String $Xgafv) {
                return (ListDefinitions)super.set$Xgafv($Xgafv);
            }

            public ListDefinitions setAccessToken(String accessToken) {
                return (ListDefinitions)super.setAccessToken(accessToken);
            }

            public ListDefinitions setAlt(String alt) {
                return (ListDefinitions)super.setAlt(alt);
            }

            public ListDefinitions setCallback(String callback) {
                return (ListDefinitions)super.setCallback(callback);
            }

            public ListDefinitions setFields(String fields) {
                return (ListDefinitions)super.setFields(fields);
            }

            public ListDefinitions setKey(String key) {
                return (ListDefinitions)super.setKey(key);
            }

            public ListDefinitions setOauthToken(String oauthToken) {
                return (ListDefinitions)super.setOauthToken(oauthToken);
            }

            public ListDefinitions setPrettyPrint(Boolean prettyPrint) {
                return (ListDefinitions)super.setPrettyPrint(prettyPrint);
            }

            public ListDefinitions setQuotaUser(String quotaUser) {
                return (ListDefinitions)super.setQuotaUser(quotaUser);
            }

            public ListDefinitions setUploadType(String uploadType) {
                return (ListDefinitions)super.setUploadType(uploadType);
            }

            public ListDefinitions setUploadProtocol(String uploadProtocol) {
                return (ListDefinitions)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public ListDefinitions setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListDefinitions setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListDefinitions setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListDefinitions set(String parameterName, Object value) {
                return (ListDefinitions)super.set(parameterName, value);
            }
        }

        public class ListByPlayer
        extends GamesRequest<PlayerEventListResponse> {
            private static final String REST_PATH = "games/v1/events";
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListByPlayer() {
                super(Games.this, "GET", REST_PATH, null, PlayerEventListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListByPlayer set$Xgafv(String $Xgafv) {
                return (ListByPlayer)super.set$Xgafv($Xgafv);
            }

            public ListByPlayer setAccessToken(String accessToken) {
                return (ListByPlayer)super.setAccessToken(accessToken);
            }

            public ListByPlayer setAlt(String alt) {
                return (ListByPlayer)super.setAlt(alt);
            }

            public ListByPlayer setCallback(String callback) {
                return (ListByPlayer)super.setCallback(callback);
            }

            public ListByPlayer setFields(String fields) {
                return (ListByPlayer)super.setFields(fields);
            }

            public ListByPlayer setKey(String key) {
                return (ListByPlayer)super.setKey(key);
            }

            public ListByPlayer setOauthToken(String oauthToken) {
                return (ListByPlayer)super.setOauthToken(oauthToken);
            }

            public ListByPlayer setPrettyPrint(Boolean prettyPrint) {
                return (ListByPlayer)super.setPrettyPrint(prettyPrint);
            }

            public ListByPlayer setQuotaUser(String quotaUser) {
                return (ListByPlayer)super.setQuotaUser(quotaUser);
            }

            public ListByPlayer setUploadType(String uploadType) {
                return (ListByPlayer)super.setUploadType(uploadType);
            }

            public ListByPlayer setUploadProtocol(String uploadProtocol) {
                return (ListByPlayer)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public ListByPlayer setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListByPlayer setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByPlayer setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListByPlayer set(String parameterName, Object value) {
                return (ListByPlayer)super.set(parameterName, value);
            }
        }
    }

    public class Applications {
        public Get get(String applicationId) throws IOException {
            Get result = new Get(applicationId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Played played() throws IOException {
            Played result = new Played();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Verify verify(String applicationId) throws IOException {
            Verify result = new Verify(applicationId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Verify
        extends GamesRequest<ApplicationVerifyResponse> {
            private static final String REST_PATH = "games/v1/applications/{applicationId}/verify";
            @Key
            private String applicationId;

            protected Verify(String applicationId) {
                super(Games.this, "GET", REST_PATH, null, ApplicationVerifyResponse.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)applicationId, (Object)"Required parameter applicationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Verify set$Xgafv(String $Xgafv) {
                return (Verify)super.set$Xgafv($Xgafv);
            }

            public Verify setAccessToken(String accessToken) {
                return (Verify)super.setAccessToken(accessToken);
            }

            public Verify setAlt(String alt) {
                return (Verify)super.setAlt(alt);
            }

            public Verify setCallback(String callback) {
                return (Verify)super.setCallback(callback);
            }

            public Verify setFields(String fields) {
                return (Verify)super.setFields(fields);
            }

            public Verify setKey(String key) {
                return (Verify)super.setKey(key);
            }

            public Verify setOauthToken(String oauthToken) {
                return (Verify)super.setOauthToken(oauthToken);
            }

            public Verify setPrettyPrint(Boolean prettyPrint) {
                return (Verify)super.setPrettyPrint(prettyPrint);
            }

            public Verify setQuotaUser(String quotaUser) {
                return (Verify)super.setQuotaUser(quotaUser);
            }

            public Verify setUploadType(String uploadType) {
                return (Verify)super.setUploadType(uploadType);
            }

            public Verify setUploadProtocol(String uploadProtocol) {
                return (Verify)super.setUploadProtocol(uploadProtocol);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public Verify setApplicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            @Override
            public Verify set(String parameterName, Object value) {
                return (Verify)super.set(parameterName, value);
            }
        }

        public class Played
        extends GamesRequest<Void> {
            private static final String REST_PATH = "games/v1/applications/played";

            protected Played() {
                super(Games.this, "POST", REST_PATH, null, Void.class);
            }

            public Played set$Xgafv(String $Xgafv) {
                return (Played)super.set$Xgafv($Xgafv);
            }

            public Played setAccessToken(String accessToken) {
                return (Played)super.setAccessToken(accessToken);
            }

            public Played setAlt(String alt) {
                return (Played)super.setAlt(alt);
            }

            public Played setCallback(String callback) {
                return (Played)super.setCallback(callback);
            }

            public Played setFields(String fields) {
                return (Played)super.setFields(fields);
            }

            public Played setKey(String key) {
                return (Played)super.setKey(key);
            }

            public Played setOauthToken(String oauthToken) {
                return (Played)super.setOauthToken(oauthToken);
            }

            public Played setPrettyPrint(Boolean prettyPrint) {
                return (Played)super.setPrettyPrint(prettyPrint);
            }

            public Played setQuotaUser(String quotaUser) {
                return (Played)super.setQuotaUser(quotaUser);
            }

            public Played setUploadType(String uploadType) {
                return (Played)super.setUploadType(uploadType);
            }

            public Played setUploadProtocol(String uploadProtocol) {
                return (Played)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Played set(String parameterName, Object value) {
                return (Played)super.set(parameterName, value);
            }
        }

        public class Get
        extends GamesRequest<Application> {
            private static final String REST_PATH = "games/v1/applications/{applicationId}";
            @Key
            private String applicationId;
            @Key
            private String language;
            @Key
            private String platformType;

            protected Get(String applicationId) {
                super(Games.this, "GET", REST_PATH, null, Application.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)applicationId, (Object)"Required parameter applicationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public Get setApplicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            public String getPlatformType() {
                return this.platformType;
            }

            public Get setPlatformType(String platformType) {
                this.platformType = platformType;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Achievements {
        public Increment increment(String achievementId, Integer stepsToIncrement) throws IOException {
            Increment result = new Increment(achievementId, stepsToIncrement);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String playerId) throws IOException {
            List result = new List(playerId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Reveal reveal(String achievementId) throws IOException {
            Reveal result = new Reveal(achievementId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetStepsAtLeast setStepsAtLeast(String achievementId, Integer steps) throws IOException {
            SetStepsAtLeast result = new SetStepsAtLeast(achievementId, steps);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Unlock unlock(String achievementId) throws IOException {
            Unlock result = new Unlock(achievementId);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateMultiple updateMultiple(AchievementUpdateMultipleRequest content) throws IOException {
            UpdateMultiple result = new UpdateMultiple(content);
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateMultiple
        extends GamesRequest<AchievementUpdateMultipleResponse> {
            private static final String REST_PATH = "games/v1/achievements/updateMultiple";

            protected UpdateMultiple(AchievementUpdateMultipleRequest content) {
                super(Games.this, "POST", REST_PATH, (Object)content, AchievementUpdateMultipleResponse.class);
            }

            public UpdateMultiple set$Xgafv(String $Xgafv) {
                return (UpdateMultiple)super.set$Xgafv($Xgafv);
            }

            public UpdateMultiple setAccessToken(String accessToken) {
                return (UpdateMultiple)super.setAccessToken(accessToken);
            }

            public UpdateMultiple setAlt(String alt) {
                return (UpdateMultiple)super.setAlt(alt);
            }

            public UpdateMultiple setCallback(String callback) {
                return (UpdateMultiple)super.setCallback(callback);
            }

            public UpdateMultiple setFields(String fields) {
                return (UpdateMultiple)super.setFields(fields);
            }

            public UpdateMultiple setKey(String key) {
                return (UpdateMultiple)super.setKey(key);
            }

            public UpdateMultiple setOauthToken(String oauthToken) {
                return (UpdateMultiple)super.setOauthToken(oauthToken);
            }

            public UpdateMultiple setPrettyPrint(Boolean prettyPrint) {
                return (UpdateMultiple)super.setPrettyPrint(prettyPrint);
            }

            public UpdateMultiple setQuotaUser(String quotaUser) {
                return (UpdateMultiple)super.setQuotaUser(quotaUser);
            }

            public UpdateMultiple setUploadType(String uploadType) {
                return (UpdateMultiple)super.setUploadType(uploadType);
            }

            public UpdateMultiple setUploadProtocol(String uploadProtocol) {
                return (UpdateMultiple)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public UpdateMultiple set(String parameterName, Object value) {
                return (UpdateMultiple)super.set(parameterName, value);
            }
        }

        public class Unlock
        extends GamesRequest<AchievementUnlockResponse> {
            private static final String REST_PATH = "games/v1/achievements/{achievementId}/unlock";
            @Key
            private String achievementId;

            protected Unlock(String achievementId) {
                super(Games.this, "POST", REST_PATH, null, AchievementUnlockResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)achievementId, (Object)"Required parameter achievementId must be specified.");
            }

            public Unlock set$Xgafv(String $Xgafv) {
                return (Unlock)super.set$Xgafv($Xgafv);
            }

            public Unlock setAccessToken(String accessToken) {
                return (Unlock)super.setAccessToken(accessToken);
            }

            public Unlock setAlt(String alt) {
                return (Unlock)super.setAlt(alt);
            }

            public Unlock setCallback(String callback) {
                return (Unlock)super.setCallback(callback);
            }

            public Unlock setFields(String fields) {
                return (Unlock)super.setFields(fields);
            }

            public Unlock setKey(String key) {
                return (Unlock)super.setKey(key);
            }

            public Unlock setOauthToken(String oauthToken) {
                return (Unlock)super.setOauthToken(oauthToken);
            }

            public Unlock setPrettyPrint(Boolean prettyPrint) {
                return (Unlock)super.setPrettyPrint(prettyPrint);
            }

            public Unlock setQuotaUser(String quotaUser) {
                return (Unlock)super.setQuotaUser(quotaUser);
            }

            public Unlock setUploadType(String uploadType) {
                return (Unlock)super.setUploadType(uploadType);
            }

            public Unlock setUploadProtocol(String uploadProtocol) {
                return (Unlock)super.setUploadProtocol(uploadProtocol);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Unlock setAchievementId(String achievementId) {
                this.achievementId = achievementId;
                return this;
            }

            @Override
            public Unlock set(String parameterName, Object value) {
                return (Unlock)super.set(parameterName, value);
            }
        }

        public class SetStepsAtLeast
        extends GamesRequest<AchievementSetStepsAtLeastResponse> {
            private static final String REST_PATH = "games/v1/achievements/{achievementId}/setStepsAtLeast";
            @Key
            private String achievementId;
            @Key
            private Integer steps;

            protected SetStepsAtLeast(String achievementId, Integer steps) {
                super(Games.this, "POST", REST_PATH, null, AchievementSetStepsAtLeastResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)achievementId, (Object)"Required parameter achievementId must be specified.");
                this.steps = (Integer)Preconditions.checkNotNull((Object)steps, (Object)"Required parameter steps must be specified.");
            }

            public SetStepsAtLeast set$Xgafv(String $Xgafv) {
                return (SetStepsAtLeast)super.set$Xgafv($Xgafv);
            }

            public SetStepsAtLeast setAccessToken(String accessToken) {
                return (SetStepsAtLeast)super.setAccessToken(accessToken);
            }

            public SetStepsAtLeast setAlt(String alt) {
                return (SetStepsAtLeast)super.setAlt(alt);
            }

            public SetStepsAtLeast setCallback(String callback) {
                return (SetStepsAtLeast)super.setCallback(callback);
            }

            public SetStepsAtLeast setFields(String fields) {
                return (SetStepsAtLeast)super.setFields(fields);
            }

            public SetStepsAtLeast setKey(String key) {
                return (SetStepsAtLeast)super.setKey(key);
            }

            public SetStepsAtLeast setOauthToken(String oauthToken) {
                return (SetStepsAtLeast)super.setOauthToken(oauthToken);
            }

            public SetStepsAtLeast setPrettyPrint(Boolean prettyPrint) {
                return (SetStepsAtLeast)super.setPrettyPrint(prettyPrint);
            }

            public SetStepsAtLeast setQuotaUser(String quotaUser) {
                return (SetStepsAtLeast)super.setQuotaUser(quotaUser);
            }

            public SetStepsAtLeast setUploadType(String uploadType) {
                return (SetStepsAtLeast)super.setUploadType(uploadType);
            }

            public SetStepsAtLeast setUploadProtocol(String uploadProtocol) {
                return (SetStepsAtLeast)super.setUploadProtocol(uploadProtocol);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public SetStepsAtLeast setAchievementId(String achievementId) {
                this.achievementId = achievementId;
                return this;
            }

            public Integer getSteps() {
                return this.steps;
            }

            public SetStepsAtLeast setSteps(Integer steps) {
                this.steps = steps;
                return this;
            }

            @Override
            public SetStepsAtLeast set(String parameterName, Object value) {
                return (SetStepsAtLeast)super.set(parameterName, value);
            }
        }

        public class Reveal
        extends GamesRequest<AchievementRevealResponse> {
            private static final String REST_PATH = "games/v1/achievements/{achievementId}/reveal";
            @Key
            private String achievementId;

            protected Reveal(String achievementId) {
                super(Games.this, "POST", REST_PATH, null, AchievementRevealResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)achievementId, (Object)"Required parameter achievementId must be specified.");
            }

            public Reveal set$Xgafv(String $Xgafv) {
                return (Reveal)super.set$Xgafv($Xgafv);
            }

            public Reveal setAccessToken(String accessToken) {
                return (Reveal)super.setAccessToken(accessToken);
            }

            public Reveal setAlt(String alt) {
                return (Reveal)super.setAlt(alt);
            }

            public Reveal setCallback(String callback) {
                return (Reveal)super.setCallback(callback);
            }

            public Reveal setFields(String fields) {
                return (Reveal)super.setFields(fields);
            }

            public Reveal setKey(String key) {
                return (Reveal)super.setKey(key);
            }

            public Reveal setOauthToken(String oauthToken) {
                return (Reveal)super.setOauthToken(oauthToken);
            }

            public Reveal setPrettyPrint(Boolean prettyPrint) {
                return (Reveal)super.setPrettyPrint(prettyPrint);
            }

            public Reveal setQuotaUser(String quotaUser) {
                return (Reveal)super.setQuotaUser(quotaUser);
            }

            public Reveal setUploadType(String uploadType) {
                return (Reveal)super.setUploadType(uploadType);
            }

            public Reveal setUploadProtocol(String uploadProtocol) {
                return (Reveal)super.setUploadProtocol(uploadProtocol);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Reveal setAchievementId(String achievementId) {
                this.achievementId = achievementId;
                return this;
            }

            @Override
            public Reveal set(String parameterName, Object value) {
                return (Reveal)super.set(parameterName, value);
            }
        }

        public class List
        extends GamesRequest<PlayerAchievementListResponse> {
            private static final String REST_PATH = "games/v1/players/{playerId}/achievements";
            @Key
            private String playerId;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String state;

            protected List(String playerId) {
                super(Games.this, "GET", REST_PATH, null, PlayerAchievementListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)playerId, (Object)"Required parameter playerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public List setPlayerId(String playerId) {
                this.playerId = playerId;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getState() {
                return this.state;
            }

            public List setState(String state) {
                this.state = state;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Increment
        extends GamesRequest<AchievementIncrementResponse> {
            private static final String REST_PATH = "games/v1/achievements/{achievementId}/increment";
            @Key
            private String achievementId;
            @Key
            private Integer stepsToIncrement;
            @Key
            private Long requestId;

            protected Increment(String achievementId, Integer stepsToIncrement) {
                super(Games.this, "POST", REST_PATH, null, AchievementIncrementResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)achievementId, (Object)"Required parameter achievementId must be specified.");
                this.stepsToIncrement = (Integer)Preconditions.checkNotNull((Object)stepsToIncrement, (Object)"Required parameter stepsToIncrement must be specified.");
            }

            public Increment set$Xgafv(String $Xgafv) {
                return (Increment)super.set$Xgafv($Xgafv);
            }

            public Increment setAccessToken(String accessToken) {
                return (Increment)super.setAccessToken(accessToken);
            }

            public Increment setAlt(String alt) {
                return (Increment)super.setAlt(alt);
            }

            public Increment setCallback(String callback) {
                return (Increment)super.setCallback(callback);
            }

            public Increment setFields(String fields) {
                return (Increment)super.setFields(fields);
            }

            public Increment setKey(String key) {
                return (Increment)super.setKey(key);
            }

            public Increment setOauthToken(String oauthToken) {
                return (Increment)super.setOauthToken(oauthToken);
            }

            public Increment setPrettyPrint(Boolean prettyPrint) {
                return (Increment)super.setPrettyPrint(prettyPrint);
            }

            public Increment setQuotaUser(String quotaUser) {
                return (Increment)super.setQuotaUser(quotaUser);
            }

            public Increment setUploadType(String uploadType) {
                return (Increment)super.setUploadType(uploadType);
            }

            public Increment setUploadProtocol(String uploadProtocol) {
                return (Increment)super.setUploadProtocol(uploadProtocol);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Increment setAchievementId(String achievementId) {
                this.achievementId = achievementId;
                return this;
            }

            public Integer getStepsToIncrement() {
                return this.stepsToIncrement;
            }

            public Increment setStepsToIncrement(Integer stepsToIncrement) {
                this.stepsToIncrement = stepsToIncrement;
                return this;
            }

            public Long getRequestId() {
                return this.requestId;
            }

            public Increment setRequestId(Long requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Increment set(String parameterName, Object value) {
                return (Increment)super.set(parameterName, value);
            }
        }
    }

    public class AchievementDefinitions {
        public List list() throws IOException {
            List result = new List();
            Games.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends GamesRequest<AchievementDefinitionsListResponse> {
            private static final String REST_PATH = "games/v1/achievements";
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Games.this, "GET", REST_PATH, null, AchievementDefinitionsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String language) {
                this.language = language;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }
}

