/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2017-02-15 at 00:42:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a list of achievement objects.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerAchievementListResponse extends com.google.api.client.json.GenericJson {

  /**
   * The achievements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlayerAchievement> items;

  static {
    // hack to force ProGuard to consider PlayerAchievement used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(PlayerAchievement.class);
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerAchievementListResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Token corresponding to the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The achievements.
   * @return value or {@code null} for none
   */
  public java.util.List<PlayerAchievement> getItems() {
    return items;
  }

  /**
   * The achievements.
   * @param items items or {@code null} for none
   */
  public PlayerAchievementListResponse setItems(java.util.List<PlayerAchievement> items) {
    this.items = items;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerAchievementListResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerAchievementListResponse.
   * @param kind kind or {@code null} for none
   */
  public PlayerAchievementListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Token corresponding to the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token corresponding to the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public PlayerAchievementListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public PlayerAchievementListResponse set(String fieldName, Object value) {
    return (PlayerAchievementListResponse) super.set(fieldName, value);
  }

  @Override
  public PlayerAchievementListResponse clone() {
    return (PlayerAchievementListResponse) super.clone();
  }

}
