/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-03-06 at 22:51:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a turn-based match creation request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatchCreateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Criteria for auto-matching players into this match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedAutoMatchingCriteria autoMatchingCriteria;

  /**
   * The player ids to invite to the match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> invitedPlayerIds;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchCreateRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A randomly generated numeric ID. This number is used at the server to ensure that the request
   * is handled correctly across retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long requestId;

  /**
   * The variant / mode of the application to be played. This can be any integer value, or left
   * blank. You should use a small number of variants to keep the auto-matching pool as large as
   * possible.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer variant;

  /**
   * Criteria for auto-matching players into this match.
   * @return value or {@code null} for none
   */
  public TurnBasedAutoMatchingCriteria getAutoMatchingCriteria() {
    return autoMatchingCriteria;
  }

  /**
   * Criteria for auto-matching players into this match.
   * @param autoMatchingCriteria autoMatchingCriteria or {@code null} for none
   */
  public TurnBasedMatchCreateRequest setAutoMatchingCriteria(TurnBasedAutoMatchingCriteria autoMatchingCriteria) {
    this.autoMatchingCriteria = autoMatchingCriteria;
    return this;
  }

  /**
   * The player ids to invite to the match.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInvitedPlayerIds() {
    return invitedPlayerIds;
  }

  /**
   * The player ids to invite to the match.
   * @param invitedPlayerIds invitedPlayerIds or {@code null} for none
   */
  public TurnBasedMatchCreateRequest setInvitedPlayerIds(java.util.List<java.lang.String> invitedPlayerIds) {
    this.invitedPlayerIds = invitedPlayerIds;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchCreateRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchCreateRequest.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatchCreateRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A randomly generated numeric ID. This number is used at the server to ensure that the request
   * is handled correctly across retries.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRequestId() {
    return requestId;
  }

  /**
   * A randomly generated numeric ID. This number is used at the server to ensure that the request
   * is handled correctly across retries.
   * @param requestId requestId or {@code null} for none
   */
  public TurnBasedMatchCreateRequest setRequestId(java.lang.Long requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * The variant / mode of the application to be played. This can be any integer value, or left
   * blank. You should use a small number of variants to keep the auto-matching pool as large as
   * possible.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVariant() {
    return variant;
  }

  /**
   * The variant / mode of the application to be played. This can be any integer value, or left
   * blank. You should use a small number of variants to keep the auto-matching pool as large as
   * possible.
   * @param variant variant or {@code null} for none
   */
  public TurnBasedMatchCreateRequest setVariant(java.lang.Integer variant) {
    this.variant = variant;
    return this;
  }

  @Override
  public TurnBasedMatchCreateRequest set(String fieldName, Object value) {
    return (TurnBasedMatchCreateRequest) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatchCreateRequest clone() {
    return (TurnBasedMatchCreateRequest) super.clone();
  }

}
