/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-03-27 at 22:31:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a request to update an achievement.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AchievementUpdateRequest extends com.google.api.client.json.GenericJson {

  /**
   * The achievement this update is being applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String achievementId;

  /**
   * The payload if an update of type INCREMENT was requested for the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GamesAchievementIncrement incrementPayload;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The payload if an update of type SET_STEPS_AT_LEAST was requested for the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GamesAchievementSetStepsAtLeast setStepsAtLeastPayload;

  /**
   * The type of update being applied. Possible values are:   - "REVEAL" - Achievement is revealed.
   * - "UNLOCK" - Achievement is unlocked.  - "INCREMENT" - Achievement is incremented.  -
   * "SET_STEPS_AT_LEAST" - Achievement progress is set to at least the passed value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateType;

  /**
   * The achievement this update is being applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAchievementId() {
    return achievementId;
  }

  /**
   * The achievement this update is being applied to.
   * @param achievementId achievementId or {@code null} for none
   */
  public AchievementUpdateRequest setAchievementId(java.lang.String achievementId) {
    this.achievementId = achievementId;
    return this;
  }

  /**
   * The payload if an update of type INCREMENT was requested for the achievement.
   * @return value or {@code null} for none
   */
  public GamesAchievementIncrement getIncrementPayload() {
    return incrementPayload;
  }

  /**
   * The payload if an update of type INCREMENT was requested for the achievement.
   * @param incrementPayload incrementPayload or {@code null} for none
   */
  public AchievementUpdateRequest setIncrementPayload(GamesAchievementIncrement incrementPayload) {
    this.incrementPayload = incrementPayload;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementUpdateRequest.
   * @param kind kind or {@code null} for none
   */
  public AchievementUpdateRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The payload if an update of type SET_STEPS_AT_LEAST was requested for the achievement.
   * @return value or {@code null} for none
   */
  public GamesAchievementSetStepsAtLeast getSetStepsAtLeastPayload() {
    return setStepsAtLeastPayload;
  }

  /**
   * The payload if an update of type SET_STEPS_AT_LEAST was requested for the achievement.
   * @param setStepsAtLeastPayload setStepsAtLeastPayload or {@code null} for none
   */
  public AchievementUpdateRequest setSetStepsAtLeastPayload(GamesAchievementSetStepsAtLeast setStepsAtLeastPayload) {
    this.setStepsAtLeastPayload = setStepsAtLeastPayload;
    return this;
  }

  /**
   * The type of update being applied. Possible values are:   - "REVEAL" - Achievement is revealed.
   * - "UNLOCK" - Achievement is unlocked.  - "INCREMENT" - Achievement is incremented.  -
   * "SET_STEPS_AT_LEAST" - Achievement progress is set to at least the passed value.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateType() {
    return updateType;
  }

  /**
   * The type of update being applied. Possible values are:   - "REVEAL" - Achievement is revealed.
   * - "UNLOCK" - Achievement is unlocked.  - "INCREMENT" - Achievement is incremented.  -
   * "SET_STEPS_AT_LEAST" - Achievement progress is set to at least the passed value.
   * @param updateType updateType or {@code null} for none
   */
  public AchievementUpdateRequest setUpdateType(java.lang.String updateType) {
    this.updateType = updateType;
    return this;
  }

  @Override
  public AchievementUpdateRequest set(String fieldName, Object value) {
    return (AchievementUpdateRequest) super.set(fieldName, value);
  }

  @Override
  public AchievementUpdateRequest clone() {
    return (AchievementUpdateRequest) super.clone();
  }

}
