/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-03-27 at 22:31:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a push token ID resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PushTokenId extends com.google.api.client.json.GenericJson {

  /**
   * A push token ID for iOS devices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Ios ios;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushTokenId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A push token ID for iOS devices.
   * @return value or {@code null} for none
   */
  public Ios getIos() {
    return ios;
  }

  /**
   * A push token ID for iOS devices.
   * @param ios ios or {@code null} for none
   */
  public PushTokenId setIos(Ios ios) {
    this.ios = ios;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushTokenId.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushTokenId.
   * @param kind kind or {@code null} for none
   */
  public PushTokenId setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public PushTokenId set(String fieldName, Object value) {
    return (PushTokenId) super.set(fieldName, value);
  }

  @Override
  public PushTokenId clone() {
    return (PushTokenId) super.clone();
  }

  /**
   * A push token ID for iOS devices.
   */
  public static final class Ios extends com.google.api.client.json.GenericJson {

    /**
     * Device token supplied by an iOS system call to register for remote notifications. Encode this
     * field as web-safe base64.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("apns_device_token")
    private java.lang.String apnsDeviceToken;

    /**
     * Indicates whether this token should be used for the production or sandbox APNS server.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("apns_environment")
    private java.lang.String apnsEnvironment;

    /**
     * Device token supplied by an iOS system call to register for remote notifications. Encode this
     * field as web-safe base64.
     * @see #decodeApnsDeviceToken()
     * @return value or {@code null} for none
     */
    public java.lang.String getApnsDeviceToken() {
      return apnsDeviceToken;
    }

    /**
     * Device token supplied by an iOS system call to register for remote notifications. Encode this
     * field as web-safe base64.
     * @see #getApnsDeviceToken()
     * @return Base64 decoded value or {@code null} for none
     *
     * @since 1.14
     */
    public byte[] decodeApnsDeviceToken() {
      return com.google.api.client.util.Base64.decodeBase64(apnsDeviceToken);
    }

    /**
     * Device token supplied by an iOS system call to register for remote notifications. Encode this
     * field as web-safe base64.
     * @see #encodeApnsDeviceToken()
     * @param apnsDeviceToken apnsDeviceToken or {@code null} for none
     */
    public Ios setApnsDeviceToken(java.lang.String apnsDeviceToken) {
      this.apnsDeviceToken = apnsDeviceToken;
      return this;
    }

    /**
     * Device token supplied by an iOS system call to register for remote notifications. Encode this
     * field as web-safe base64.
     * @see #setApnsDeviceToken()
     *
     * <p>
     * The value is encoded Base64 or {@code null} for none.
     * </p>
     *
     * @since 1.14
     */
    public Ios encodeApnsDeviceToken(byte[] apnsDeviceToken) {
      this.apnsDeviceToken = com.google.api.client.util.Base64.encodeBase64URLSafeString(apnsDeviceToken);
      return this;
    }

    /**
     * Indicates whether this token should be used for the production or sandbox APNS server.
     * @return value or {@code null} for none
     */
    public java.lang.String getApnsEnvironment() {
      return apnsEnvironment;
    }

    /**
     * Indicates whether this token should be used for the production or sandbox APNS server.
     * @param apnsEnvironment apnsEnvironment or {@code null} for none
     */
    public Ios setApnsEnvironment(java.lang.String apnsEnvironment) {
      this.apnsEnvironment = apnsEnvironment;
      return this;
    }

    @Override
    public Ios set(String fieldName, Object value) {
      return (Ios) super.set(fieldName, value);
    }

    @Override
    public Ios clone() {
      return (Ios) super.clone();
    }

  }

}
