/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-24 at 22:25:05 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a participant in a turn-based match.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatchParticipant extends com.google.api.client.json.GenericJson {

  /**
   * True if this participant was auto-matched with the requesting player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoMatched;

  /**
   * Information about a player that has been anonymously auto-matched against the requesting
   * player. (Either player or autoMatchedPlayer will be set.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AnonymousPlayer autoMatchedPlayer;

  /**
   * An identifier for the participant in the scope of the match. Cannot be used to identify a
   * player across matches or in other contexts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchParticipant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about the player. Not populated if this player was anonymously auto-matched against
   * the requesting player. (Either player or autoMatchedPlayer will be set.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Player player;

  /**
   * The status of the participant with respect to the match. Possible values are:   -
   * "PARTICIPANT_NOT_INVITED_YET" - The participant is slated to be invited to the match, but the
   * invitation has not been sent; the invite will be sent when it becomes their turn.  -
   * "PARTICIPANT_INVITED" - The participant has been invited to join the match, but has not yet
   * responded.  - "PARTICIPANT_JOINED" - The participant has joined the match (either after
   * creating it or accepting an invitation.)  - "PARTICIPANT_DECLINED" - The participant declined
   * an invitation to join the match.  - "PARTICIPANT_LEFT" - The participant joined the match and
   * then left it.  - "PARTICIPANT_FINISHED" - The participant finished playing in the match.  -
   * "PARTICIPANT_UNRESPONSIVE" - The participant did not take their turn in the allotted time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * True if this participant was auto-matched with the requesting player.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoMatched() {
    return autoMatched;
  }

  /**
   * True if this participant was auto-matched with the requesting player.
   * @param autoMatched autoMatched or {@code null} for none
   */
  public TurnBasedMatchParticipant setAutoMatched(java.lang.Boolean autoMatched) {
    this.autoMatched = autoMatched;
    return this;
  }

  /**
   * Information about a player that has been anonymously auto-matched against the requesting
   * player. (Either player or autoMatchedPlayer will be set.)
   * @return value or {@code null} for none
   */
  public AnonymousPlayer getAutoMatchedPlayer() {
    return autoMatchedPlayer;
  }

  /**
   * Information about a player that has been anonymously auto-matched against the requesting
   * player. (Either player or autoMatchedPlayer will be set.)
   * @param autoMatchedPlayer autoMatchedPlayer or {@code null} for none
   */
  public TurnBasedMatchParticipant setAutoMatchedPlayer(AnonymousPlayer autoMatchedPlayer) {
    this.autoMatchedPlayer = autoMatchedPlayer;
    return this;
  }

  /**
   * An identifier for the participant in the scope of the match. Cannot be used to identify a
   * player across matches or in other contexts.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * An identifier for the participant in the scope of the match. Cannot be used to identify a
   * player across matches or in other contexts.
   * @param id id or {@code null} for none
   */
  public TurnBasedMatchParticipant setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchParticipant.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchParticipant.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatchParticipant setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about the player. Not populated if this player was anonymously auto-matched against
   * the requesting player. (Either player or autoMatchedPlayer will be set.)
   * @return value or {@code null} for none
   */
  public Player getPlayer() {
    return player;
  }

  /**
   * Information about the player. Not populated if this player was anonymously auto-matched against
   * the requesting player. (Either player or autoMatchedPlayer will be set.)
   * @param player player or {@code null} for none
   */
  public TurnBasedMatchParticipant setPlayer(Player player) {
    this.player = player;
    return this;
  }

  /**
   * The status of the participant with respect to the match. Possible values are:   -
   * "PARTICIPANT_NOT_INVITED_YET" - The participant is slated to be invited to the match, but the
   * invitation has not been sent; the invite will be sent when it becomes their turn.  -
   * "PARTICIPANT_INVITED" - The participant has been invited to join the match, but has not yet
   * responded.  - "PARTICIPANT_JOINED" - The participant has joined the match (either after
   * creating it or accepting an invitation.)  - "PARTICIPANT_DECLINED" - The participant declined
   * an invitation to join the match.  - "PARTICIPANT_LEFT" - The participant joined the match and
   * then left it.  - "PARTICIPANT_FINISHED" - The participant finished playing in the match.  -
   * "PARTICIPANT_UNRESPONSIVE" - The participant did not take their turn in the allotted time.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the participant with respect to the match. Possible values are:   -
   * "PARTICIPANT_NOT_INVITED_YET" - The participant is slated to be invited to the match, but the
   * invitation has not been sent; the invite will be sent when it becomes their turn.  -
   * "PARTICIPANT_INVITED" - The participant has been invited to join the match, but has not yet
   * responded.  - "PARTICIPANT_JOINED" - The participant has joined the match (either after
   * creating it or accepting an invitation.)  - "PARTICIPANT_DECLINED" - The participant declined
   * an invitation to join the match.  - "PARTICIPANT_LEFT" - The participant joined the match and
   * then left it.  - "PARTICIPANT_FINISHED" - The participant finished playing in the match.  -
   * "PARTICIPANT_UNRESPONSIVE" - The participant did not take their turn in the allotted time.
   * @param status status or {@code null} for none
   */
  public TurnBasedMatchParticipant setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public TurnBasedMatchParticipant set(String fieldName, Object value) {
    return (TurnBasedMatchParticipant) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatchParticipant clone() {
    return (TurnBasedMatchParticipant) super.clone();
  }

}
