/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-16 at 00:08:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a Player resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Player extends com.google.api.client.json.GenericJson {

  /**
   * The base URL for the image that represents the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String avatarImageUrl;

  /**
   * The url to the landscape mode player banner image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerUrlLandscape;

  /**
   * The url to the portrait mode player banner image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerUrlPortrait;

  /**
   * The name to display for the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * An object to represent Play Game experience information for the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlayerExperienceInfo experienceInfo;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Played lastPlayedWith;

  /**
   * An object representation of the individual components of the player's name. For some players,
   * these fields may not be present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Name name;

  /**
   * The player ID that was used for this player the first time they signed into the game in
   * question. This is only populated for calls to player.get for the requesting player, only if the
   * player ID has subsequently changed, and only to clients that support remapping player IDs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalPlayerId;

  /**
   * The ID of the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playerId;

  /**
   * The player's profile settings. Controls whether or not the player's profile is visible to other
   * players.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileSettings profileSettings;

  /**
   * The player's title rewarded for their game activities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The base URL for the image that represents the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvatarImageUrl() {
    return avatarImageUrl;
  }

  /**
   * The base URL for the image that represents the player.
   * @param avatarImageUrl avatarImageUrl or {@code null} for none
   */
  public Player setAvatarImageUrl(java.lang.String avatarImageUrl) {
    this.avatarImageUrl = avatarImageUrl;
    return this;
  }

  /**
   * The url to the landscape mode player banner image.
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerUrlLandscape() {
    return bannerUrlLandscape;
  }

  /**
   * The url to the landscape mode player banner image.
   * @param bannerUrlLandscape bannerUrlLandscape or {@code null} for none
   */
  public Player setBannerUrlLandscape(java.lang.String bannerUrlLandscape) {
    this.bannerUrlLandscape = bannerUrlLandscape;
    return this;
  }

  /**
   * The url to the portrait mode player banner image.
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerUrlPortrait() {
    return bannerUrlPortrait;
  }

  /**
   * The url to the portrait mode player banner image.
   * @param bannerUrlPortrait bannerUrlPortrait or {@code null} for none
   */
  public Player setBannerUrlPortrait(java.lang.String bannerUrlPortrait) {
    this.bannerUrlPortrait = bannerUrlPortrait;
    return this;
  }

  /**
   * The name to display for the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name to display for the player.
   * @param displayName displayName or {@code null} for none
   */
  public Player setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * An object to represent Play Game experience information for the player.
   * @return value or {@code null} for none
   */
  public PlayerExperienceInfo getExperienceInfo() {
    return experienceInfo;
  }

  /**
   * An object to represent Play Game experience information for the player.
   * @param experienceInfo experienceInfo or {@code null} for none
   */
  public Player setExperienceInfo(PlayerExperienceInfo experienceInfo) {
    this.experienceInfo = experienceInfo;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * @param kind kind or {@code null} for none
   */
  public Player setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * @return value or {@code null} for none
   */
  public Played getLastPlayedWith() {
    return lastPlayedWith;
  }

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * @param lastPlayedWith lastPlayedWith or {@code null} for none
   */
  public Player setLastPlayedWith(Played lastPlayedWith) {
    this.lastPlayedWith = lastPlayedWith;
    return this;
  }

  /**
   * An object representation of the individual components of the player's name. For some players,
   * these fields may not be present.
   * @return value or {@code null} for none
   */
  public Name getName() {
    return name;
  }

  /**
   * An object representation of the individual components of the player's name. For some players,
   * these fields may not be present.
   * @param name name or {@code null} for none
   */
  public Player setName(Name name) {
    this.name = name;
    return this;
  }

  /**
   * The player ID that was used for this player the first time they signed into the game in
   * question. This is only populated for calls to player.get for the requesting player, only if the
   * player ID has subsequently changed, and only to clients that support remapping player IDs.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalPlayerId() {
    return originalPlayerId;
  }

  /**
   * The player ID that was used for this player the first time they signed into the game in
   * question. This is only populated for calls to player.get for the requesting player, only if the
   * player ID has subsequently changed, and only to clients that support remapping player IDs.
   * @param originalPlayerId originalPlayerId or {@code null} for none
   */
  public Player setOriginalPlayerId(java.lang.String originalPlayerId) {
    this.originalPlayerId = originalPlayerId;
    return this;
  }

  /**
   * The ID of the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlayerId() {
    return playerId;
  }

  /**
   * The ID of the player.
   * @param playerId playerId or {@code null} for none
   */
  public Player setPlayerId(java.lang.String playerId) {
    this.playerId = playerId;
    return this;
  }

  /**
   * The player's profile settings. Controls whether or not the player's profile is visible to other
   * players.
   * @return value or {@code null} for none
   */
  public ProfileSettings getProfileSettings() {
    return profileSettings;
  }

  /**
   * The player's profile settings. Controls whether or not the player's profile is visible to other
   * players.
   * @param profileSettings profileSettings or {@code null} for none
   */
  public Player setProfileSettings(ProfileSettings profileSettings) {
    this.profileSettings = profileSettings;
    return this;
  }

  /**
   * The player's title rewarded for their game activities.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The player's title rewarded for their game activities.
   * @param title title or {@code null} for none
   */
  public Player setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public Player set(String fieldName, Object value) {
    return (Player) super.set(fieldName, value);
  }

  @Override
  public Player clone() {
    return (Player) super.clone();
  }

  /**
   * An object representation of the individual components of the player's name. For some players,
   * these fields may not be present.
   */
  public static final class Name extends com.google.api.client.json.GenericJson {

    /**
     * The family name of this player. In some places, this is known as the last name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String familyName;

    /**
     * The given name of this player. In some places, this is known as the first name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String givenName;

    /**
     * The family name of this player. In some places, this is known as the last name.
     * @return value or {@code null} for none
     */
    public java.lang.String getFamilyName() {
      return familyName;
    }

    /**
     * The family name of this player. In some places, this is known as the last name.
     * @param familyName familyName or {@code null} for none
     */
    public Name setFamilyName(java.lang.String familyName) {
      this.familyName = familyName;
      return this;
    }

    /**
     * The given name of this player. In some places, this is known as the first name.
     * @return value or {@code null} for none
     */
    public java.lang.String getGivenName() {
      return givenName;
    }

    /**
     * The given name of this player. In some places, this is known as the first name.
     * @param givenName givenName or {@code null} for none
     */
    public Name setGivenName(java.lang.String givenName) {
      this.givenName = givenName;
      return this;
    }

    @Override
    public Name set(String fieldName, Object value) {
      return (Name) super.set(fieldName, value);
    }

    @Override
    public Name clone() {
      return (Name) super.clone();
    }

  }

}
