/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-09 at 03:04:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an event period update resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventUpdateRequest extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the event being modified in this update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definitionId;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventUpdateRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The number of times this event occurred in this time period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long updateCount;

  /**
   * The ID of the event being modified in this update.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinitionId() {
    return definitionId;
  }

  /**
   * The ID of the event being modified in this update.
   * @param definitionId definitionId or {@code null} for none
   */
  public EventUpdateRequest setDefinitionId(java.lang.String definitionId) {
    this.definitionId = definitionId;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventUpdateRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventUpdateRequest.
   * @param kind kind or {@code null} for none
   */
  public EventUpdateRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The number of times this event occurred in this time period.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUpdateCount() {
    return updateCount;
  }

  /**
   * The number of times this event occurred in this time period.
   * @param updateCount updateCount or {@code null} for none
   */
  public EventUpdateRequest setUpdateCount(java.lang.Long updateCount) {
    this.updateCount = updateCount;
    return this;
  }

  @Override
  public EventUpdateRequest set(String fieldName, Object value) {
    return (EventUpdateRequest) super.set(fieldName, value);
  }

  @Override
  public EventUpdateRequest clone() {
    return (EventUpdateRequest) super.clone();
  }

}
