/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-09 at 03:04:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an update on the status of a peer in a room.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RoomP2PStatus extends com.google.api.client.json.GenericJson {

  /**
   * The amount of time in milliseconds it took to establish connections with this peer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer connectionSetupLatencyMillis;

  /**
   * The error code in event of a failure. Possible values are:   - "P2P_FAILED" - The client failed
   * to establish a P2P connection with the peer.  - "PRESENCE_FAILED" - The client failed to
   * register to receive P2P connections.  - "RELAY_SERVER_FAILED" - The client received an error
   * when trying to use the relay server to establish a P2P connection with the peer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String error;

  /**
   * More detailed diagnostic message returned in event of a failure.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("error_reason")
  private java.lang.String errorReason;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomP2PStatus.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the participant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String participantId;

  /**
   * The status of the peer in the room. Possible values are:   - "CONNECTION_ESTABLISHED" - The
   * client established a P2P connection with the peer.  - "CONNECTION_FAILED" - The client failed
   * to establish directed presence with the peer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The amount of time in milliseconds it took to send packets back and forth on the unreliable
   * channel with this peer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer unreliableRoundtripLatencyMillis;

  /**
   * The amount of time in milliseconds it took to establish connections with this peer.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getConnectionSetupLatencyMillis() {
    return connectionSetupLatencyMillis;
  }

  /**
   * The amount of time in milliseconds it took to establish connections with this peer.
   * @param connectionSetupLatencyMillis connectionSetupLatencyMillis or {@code null} for none
   */
  public RoomP2PStatus setConnectionSetupLatencyMillis(java.lang.Integer connectionSetupLatencyMillis) {
    this.connectionSetupLatencyMillis = connectionSetupLatencyMillis;
    return this;
  }

  /**
   * The error code in event of a failure. Possible values are:   - "P2P_FAILED" - The client failed
   * to establish a P2P connection with the peer.  - "PRESENCE_FAILED" - The client failed to
   * register to receive P2P connections.  - "RELAY_SERVER_FAILED" - The client received an error
   * when trying to use the relay server to establish a P2P connection with the peer.
   * @return value or {@code null} for none
   */
  public java.lang.String getError() {
    return error;
  }

  /**
   * The error code in event of a failure. Possible values are:   - "P2P_FAILED" - The client failed
   * to establish a P2P connection with the peer.  - "PRESENCE_FAILED" - The client failed to
   * register to receive P2P connections.  - "RELAY_SERVER_FAILED" - The client received an error
   * when trying to use the relay server to establish a P2P connection with the peer.
   * @param error error or {@code null} for none
   */
  public RoomP2PStatus setError(java.lang.String error) {
    this.error = error;
    return this;
  }

  /**
   * More detailed diagnostic message returned in event of a failure.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorReason() {
    return errorReason;
  }

  /**
   * More detailed diagnostic message returned in event of a failure.
   * @param errorReason errorReason or {@code null} for none
   */
  public RoomP2PStatus setErrorReason(java.lang.String errorReason) {
    this.errorReason = errorReason;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomP2PStatus.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomP2PStatus.
   * @param kind kind or {@code null} for none
   */
  public RoomP2PStatus setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The ID of the participant.
   * @return value or {@code null} for none
   */
  public java.lang.String getParticipantId() {
    return participantId;
  }

  /**
   * The ID of the participant.
   * @param participantId participantId or {@code null} for none
   */
  public RoomP2PStatus setParticipantId(java.lang.String participantId) {
    this.participantId = participantId;
    return this;
  }

  /**
   * The status of the peer in the room. Possible values are:   - "CONNECTION_ESTABLISHED" - The
   * client established a P2P connection with the peer.  - "CONNECTION_FAILED" - The client failed
   * to establish directed presence with the peer.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the peer in the room. Possible values are:   - "CONNECTION_ESTABLISHED" - The
   * client established a P2P connection with the peer.  - "CONNECTION_FAILED" - The client failed
   * to establish directed presence with the peer.
   * @param status status or {@code null} for none
   */
  public RoomP2PStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The amount of time in milliseconds it took to send packets back and forth on the unreliable
   * channel with this peer.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUnreliableRoundtripLatencyMillis() {
    return unreliableRoundtripLatencyMillis;
  }

  /**
   * The amount of time in milliseconds it took to send packets back and forth on the unreliable
   * channel with this peer.
   * @param unreliableRoundtripLatencyMillis unreliableRoundtripLatencyMillis or {@code null} for none
   */
  public RoomP2PStatus setUnreliableRoundtripLatencyMillis(java.lang.Integer unreliableRoundtripLatencyMillis) {
    this.unreliableRoundtripLatencyMillis = unreliableRoundtripLatencyMillis;
    return this;
  }

  @Override
  public RoomP2PStatus set(String fieldName, Object value) {
    return (RoomP2PStatus) super.set(fieldName, value);
  }

  @Override
  public RoomP2PStatus clone() {
    return (RoomP2PStatus) super.clone();
  }

}
