/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-10-09 at 05:45:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for 1P/3P metadata about a user's level.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerLevel extends com.google.api.client.json.GenericJson {

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerLevel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The level for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer level;

  /**
   * The maximum experience points for this level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxExperiencePoints;

  /**
   * The minimum experience points for this level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minExperiencePoints;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerLevel.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerLevel.
   * @param kind kind or {@code null} for none
   */
  public PlayerLevel setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The level for the user.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLevel() {
    return level;
  }

  /**
   * The level for the user.
   * @param level level or {@code null} for none
   */
  public PlayerLevel setLevel(java.lang.Integer level) {
    this.level = level;
    return this;
  }

  /**
   * The maximum experience points for this level.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxExperiencePoints() {
    return maxExperiencePoints;
  }

  /**
   * The maximum experience points for this level.
   * @param maxExperiencePoints maxExperiencePoints or {@code null} for none
   */
  public PlayerLevel setMaxExperiencePoints(java.lang.Long maxExperiencePoints) {
    this.maxExperiencePoints = maxExperiencePoints;
    return this;
  }

  /**
   * The minimum experience points for this level.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinExperiencePoints() {
    return minExperiencePoints;
  }

  /**
   * The minimum experience points for this level.
   * @param minExperiencePoints minExperiencePoints or {@code null} for none
   */
  public PlayerLevel setMinExperiencePoints(java.lang.Long minExperiencePoints) {
    this.minExperiencePoints = minExperiencePoints;
    return this;
  }

  @Override
  public PlayerLevel set(String fieldName, Object value) {
    return (PlayerLevel) super.set(fieldName, value);
  }

  @Override
  public PlayerLevel clone() {
    return (PlayerLevel) super.clone();
  }

}
