/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-06-26 16:27:34 UTC)
 * on 2013-07-31 at 20:33:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for the Application resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Application extends com.google.api.client.json.GenericJson {

  /**
   * The number of achievements visible to the currently authenticated player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("achievement_count")
  private java.lang.Integer achievementCount;

  /**
   * The assets of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageAsset> assets;

  static {
    // hack to force ProGuard to consider ImageAsset used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ImageAsset.class);
  }

  /**
   * The author of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String author;

  /**
   * The category of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ApplicationCategory category;

  /**
   * The description of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The ID of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The instances of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Instance> instances;

  static {
    // hack to force ProGuard to consider Instance used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Instance.class);
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The last updated timestamp of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastUpdatedTimestamp;

  /**
   * The number of leaderboards visible to the currently authenticated player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("leaderboard_count")
  private java.lang.Integer leaderboardCount;

  /**
   * The name of the application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The number of achievements visible to the currently authenticated player.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAchievementCount() {
    return achievementCount;
  }

  /**
   * The number of achievements visible to the currently authenticated player.
   * @param achievementCount achievementCount or {@code null} for none
   */
  public Application setAchievementCount(java.lang.Integer achievementCount) {
    this.achievementCount = achievementCount;
    return this;
  }

  /**
   * The assets of the application.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageAsset> getAssets() {
    return assets;
  }

  /**
   * The assets of the application.
   * @param assets assets or {@code null} for none
   */
  public Application setAssets(java.util.List<ImageAsset> assets) {
    this.assets = assets;
    return this;
  }

  /**
   * The author of the application.
   * @return value or {@code null} for none
   */
  public java.lang.String getAuthor() {
    return author;
  }

  /**
   * The author of the application.
   * @param author author or {@code null} for none
   */
  public Application setAuthor(java.lang.String author) {
    this.author = author;
    return this;
  }

  /**
   * The category of the application.
   * @return value or {@code null} for none
   */
  public ApplicationCategory getCategory() {
    return category;
  }

  /**
   * The category of the application.
   * @param category category or {@code null} for none
   */
  public Application setCategory(ApplicationCategory category) {
    this.category = category;
    return this;
  }

  /**
   * The description of the application.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the application.
   * @param description description or {@code null} for none
   */
  public Application setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The ID of the application.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the application.
   * @param id id or {@code null} for none
   */
  public Application setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The instances of the application.
   * @return value or {@code null} for none
   */
  public java.util.List<Instance> getInstances() {
    return instances;
  }

  /**
   * The instances of the application.
   * @param instances instances or {@code null} for none
   */
  public Application setInstances(java.util.List<Instance> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#application.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#application.
   * @param kind kind or {@code null} for none
   */
  public Application setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The last updated timestamp of the application.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastUpdatedTimestamp() {
    return lastUpdatedTimestamp;
  }

  /**
   * The last updated timestamp of the application.
   * @param lastUpdatedTimestamp lastUpdatedTimestamp or {@code null} for none
   */
  public Application setLastUpdatedTimestamp(java.lang.Long lastUpdatedTimestamp) {
    this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    return this;
  }

  /**
   * The number of leaderboards visible to the currently authenticated player.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLeaderboardCount() {
    return leaderboardCount;
  }

  /**
   * The number of leaderboards visible to the currently authenticated player.
   * @param leaderboardCount leaderboardCount or {@code null} for none
   */
  public Application setLeaderboardCount(java.lang.Integer leaderboardCount) {
    this.leaderboardCount = leaderboardCount;
    return this;
  }

  /**
   * The name of the application.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the application.
   * @param name name or {@code null} for none
   */
  public Application setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Application set(String fieldName, Object value) {
    return (Application) super.set(fieldName, value);
  }

  @Override
  public Application clone() {
    return (Application) super.clone();
  }

}
