/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-02-26 at 05:17:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a Player resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Player extends com.google.api.client.json.GenericJson {

  /**
   * The base URL for the image that represents the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String avatarImageUrl;

  /**
   * The name to display for the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Played lastPlayedWith;

  /**
   * The ID of the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playerId;

  /**
   * The base URL for the image that represents the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvatarImageUrl() {
    return avatarImageUrl;
  }

  /**
   * The base URL for the image that represents the player.
   * @param avatarImageUrl avatarImageUrl or {@code null} for none
   */
  public Player setAvatarImageUrl(java.lang.String avatarImageUrl) {
    this.avatarImageUrl = avatarImageUrl;
    return this;
  }

  /**
   * The name to display for the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name to display for the player.
   * @param displayName displayName or {@code null} for none
   */
  public Player setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#player.
   * @param kind kind or {@code null} for none
   */
  public Player setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * @return value or {@code null} for none
   */
  public Played getLastPlayedWith() {
    return lastPlayedWith;
  }

  /**
   * Details about the last time this player played a multiplayer game with the currently
   * authenticated player. Populated for PLAYED_WITH player collection members.
   * @param lastPlayedWith lastPlayedWith or {@code null} for none
   */
  public Player setLastPlayedWith(Played lastPlayedWith) {
    this.lastPlayedWith = lastPlayedWith;
    return this;
  }

  /**
   * The ID of the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlayerId() {
    return playerId;
  }

  /**
   * The ID of the player.
   * @param playerId playerId or {@code null} for none
   */
  public Player setPlayerId(java.lang.String playerId) {
    this.playerId = playerId;
    return this;
  }

  @Override
  public Player set(String fieldName, Object value) {
    return (Player) super.set(fieldName, value);
  }

  @Override
  public Player clone() {
    return (Player) super.clone();
  }

}
