/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-02-26 at 05:17:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a room auto-match criteria object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RoomAutoMatchingCriteria extends com.google.api.client.json.GenericJson {

  /**
   * A bitmask indicating when auto-matches are valid. When ANDed with other exclusive bitmasks, the
   * result must be zero. Can be used to support exclusive roles within a game.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long exclusiveBitmask;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomAutoMatchingCriteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The maximum number of players that should be added to the room by auto-matching.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxAutoMatchingPlayers;

  /**
   * The minimum number of players that should be added to the room by auto-matching.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minAutoMatchingPlayers;

  /**
   * A bitmask indicating when auto-matches are valid. When ANDed with other exclusive bitmasks, the
   * result must be zero. Can be used to support exclusive roles within a game.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExclusiveBitmask() {
    return exclusiveBitmask;
  }

  /**
   * A bitmask indicating when auto-matches are valid. When ANDed with other exclusive bitmasks, the
   * result must be zero. Can be used to support exclusive roles within a game.
   * @param exclusiveBitmask exclusiveBitmask or {@code null} for none
   */
  public RoomAutoMatchingCriteria setExclusiveBitmask(java.lang.Long exclusiveBitmask) {
    this.exclusiveBitmask = exclusiveBitmask;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomAutoMatchingCriteria.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#roomAutoMatchingCriteria.
   * @param kind kind or {@code null} for none
   */
  public RoomAutoMatchingCriteria setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The maximum number of players that should be added to the room by auto-matching.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxAutoMatchingPlayers() {
    return maxAutoMatchingPlayers;
  }

  /**
   * The maximum number of players that should be added to the room by auto-matching.
   * @param maxAutoMatchingPlayers maxAutoMatchingPlayers or {@code null} for none
   */
  public RoomAutoMatchingCriteria setMaxAutoMatchingPlayers(java.lang.Integer maxAutoMatchingPlayers) {
    this.maxAutoMatchingPlayers = maxAutoMatchingPlayers;
    return this;
  }

  /**
   * The minimum number of players that should be added to the room by auto-matching.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinAutoMatchingPlayers() {
    return minAutoMatchingPlayers;
  }

  /**
   * The minimum number of players that should be added to the room by auto-matching.
   * @param minAutoMatchingPlayers minAutoMatchingPlayers or {@code null} for none
   */
  public RoomAutoMatchingCriteria setMinAutoMatchingPlayers(java.lang.Integer minAutoMatchingPlayers) {
    this.minAutoMatchingPlayers = minAutoMatchingPlayers;
    return this;
  }

  @Override
  public RoomAutoMatchingCriteria set(String fieldName, Object value) {
    return (RoomAutoMatchingCriteria) super.set(fieldName, value);
  }

  @Override
  public RoomAutoMatchingCriteria clone() {
    return (RoomAutoMatchingCriteria) super.clone();
  }

}
