/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-02-26 at 05:17:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a turn-based match resource object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatch extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the application being played.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String applicationId;

  /**
   * Criteria for auto-matching players into this match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedAutoMatchingCriteria autoMatchingCriteria;

  /**
   * Details about the match creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatchModification creationDetails;

  /**
   * The data / game state for this match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatchData data;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Details about the last update to the match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatchModification lastUpdateDetails;

  /**
   * Globally unique ID for a turn-based match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matchId;

  /**
   * The number of the match in a chain of rematches. Will be set to 1 for the first match and
   * incremented by 1 for each rematch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer matchNumber;

  /**
   * The version of this match: an increasing counter, used to avoid out-of-date updates to the
   * match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer matchVersion;

  /**
   * The participants involved in the match, along with their statuses. Includes participants who
   * have left or declined invitations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TurnBasedMatchParticipant> participants;

  /**
   * The ID of the participant that is taking a turn.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pendingParticipantId;

  /**
   * The data / game state for the previous match; set for the first turn of rematches only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatchData previousMatchData;

  /**
   * The ID of a rematch of this match. Only set for completed matches that have been rematched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rematchId;

  /**
   * The results reported for this match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParticipantResult> results;

  static {
    // hack to force ProGuard to consider ParticipantResult used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ParticipantResult.class);
  }

  /**
   * The status of the match. Possible values are:   - "MATCH_AUTO_MATCHING" - One or more slots
   * need to be filled by auto-matching; the match cannot be established until they are filled.  -
   * "MATCH_ACTIVE" - The match has started.  - "MATCH_COMPLETE" - The match has finished.  -
   * "MATCH_CANCELED" - The match was canceled.  - "MATCH_EXPIRED" - The match expired due to
   * inactivity.  - "MATCH_DELETED" - The match should no longer be shown on the client. Returned
   * only for tombstones for matches when sync is called.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The status of the current user in the match. Derived from the match type, match status, the
   * user's participant status, and the pending participant for the match. Possible values are:   -
   * "USER_INVITED" - The user has been invited to join the match and has not responded yet.  -
   * "USER_AWAITING_TURN" - The user is waiting for their turn.  - "USER_TURN" - The user has an
   * action to take in the match.  - "USER_MATCH_COMPLETED" - The match has ended (it is completed,
   * canceled, or expired.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userMatchStatus;

  /**
   * The variant / mode of the application being played; can be any integer value, or left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer variant;

  /**
   * The ID of the application being played.
   * @return value or {@code null} for none
   */
  public java.lang.String getApplicationId() {
    return applicationId;
  }

  /**
   * The ID of the application being played.
   * @param applicationId applicationId or {@code null} for none
   */
  public TurnBasedMatch setApplicationId(java.lang.String applicationId) {
    this.applicationId = applicationId;
    return this;
  }

  /**
   * Criteria for auto-matching players into this match.
   * @return value or {@code null} for none
   */
  public TurnBasedAutoMatchingCriteria getAutoMatchingCriteria() {
    return autoMatchingCriteria;
  }

  /**
   * Criteria for auto-matching players into this match.
   * @param autoMatchingCriteria autoMatchingCriteria or {@code null} for none
   */
  public TurnBasedMatch setAutoMatchingCriteria(TurnBasedAutoMatchingCriteria autoMatchingCriteria) {
    this.autoMatchingCriteria = autoMatchingCriteria;
    return this;
  }

  /**
   * Details about the match creation.
   * @return value or {@code null} for none
   */
  public TurnBasedMatchModification getCreationDetails() {
    return creationDetails;
  }

  /**
   * Details about the match creation.
   * @param creationDetails creationDetails or {@code null} for none
   */
  public TurnBasedMatch setCreationDetails(TurnBasedMatchModification creationDetails) {
    this.creationDetails = creationDetails;
    return this;
  }

  /**
   * The data / game state for this match.
   * @return value or {@code null} for none
   */
  public TurnBasedMatchData getData() {
    return data;
  }

  /**
   * The data / game state for this match.
   * @param data data or {@code null} for none
   */
  public TurnBasedMatch setData(TurnBasedMatchData data) {
    this.data = data;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatch.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatch.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatch setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Details about the last update to the match.
   * @return value or {@code null} for none
   */
  public TurnBasedMatchModification getLastUpdateDetails() {
    return lastUpdateDetails;
  }

  /**
   * Details about the last update to the match.
   * @param lastUpdateDetails lastUpdateDetails or {@code null} for none
   */
  public TurnBasedMatch setLastUpdateDetails(TurnBasedMatchModification lastUpdateDetails) {
    this.lastUpdateDetails = lastUpdateDetails;
    return this;
  }

  /**
   * Globally unique ID for a turn-based match.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatchId() {
    return matchId;
  }

  /**
   * Globally unique ID for a turn-based match.
   * @param matchId matchId or {@code null} for none
   */
  public TurnBasedMatch setMatchId(java.lang.String matchId) {
    this.matchId = matchId;
    return this;
  }

  /**
   * The number of the match in a chain of rematches. Will be set to 1 for the first match and
   * incremented by 1 for each rematch.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMatchNumber() {
    return matchNumber;
  }

  /**
   * The number of the match in a chain of rematches. Will be set to 1 for the first match and
   * incremented by 1 for each rematch.
   * @param matchNumber matchNumber or {@code null} for none
   */
  public TurnBasedMatch setMatchNumber(java.lang.Integer matchNumber) {
    this.matchNumber = matchNumber;
    return this;
  }

  /**
   * The version of this match: an increasing counter, used to avoid out-of-date updates to the
   * match.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMatchVersion() {
    return matchVersion;
  }

  /**
   * The version of this match: an increasing counter, used to avoid out-of-date updates to the
   * match.
   * @param matchVersion matchVersion or {@code null} for none
   */
  public TurnBasedMatch setMatchVersion(java.lang.Integer matchVersion) {
    this.matchVersion = matchVersion;
    return this;
  }

  /**
   * The participants involved in the match, along with their statuses. Includes participants who
   * have left or declined invitations.
   * @return value or {@code null} for none
   */
  public java.util.List<TurnBasedMatchParticipant> getParticipants() {
    return participants;
  }

  /**
   * The participants involved in the match, along with their statuses. Includes participants who
   * have left or declined invitations.
   * @param participants participants or {@code null} for none
   */
  public TurnBasedMatch setParticipants(java.util.List<TurnBasedMatchParticipant> participants) {
    this.participants = participants;
    return this;
  }

  /**
   * The ID of the participant that is taking a turn.
   * @return value or {@code null} for none
   */
  public java.lang.String getPendingParticipantId() {
    return pendingParticipantId;
  }

  /**
   * The ID of the participant that is taking a turn.
   * @param pendingParticipantId pendingParticipantId or {@code null} for none
   */
  public TurnBasedMatch setPendingParticipantId(java.lang.String pendingParticipantId) {
    this.pendingParticipantId = pendingParticipantId;
    return this;
  }

  /**
   * The data / game state for the previous match; set for the first turn of rematches only.
   * @return value or {@code null} for none
   */
  public TurnBasedMatchData getPreviousMatchData() {
    return previousMatchData;
  }

  /**
   * The data / game state for the previous match; set for the first turn of rematches only.
   * @param previousMatchData previousMatchData or {@code null} for none
   */
  public TurnBasedMatch setPreviousMatchData(TurnBasedMatchData previousMatchData) {
    this.previousMatchData = previousMatchData;
    return this;
  }

  /**
   * The ID of a rematch of this match. Only set for completed matches that have been rematched.
   * @return value or {@code null} for none
   */
  public java.lang.String getRematchId() {
    return rematchId;
  }

  /**
   * The ID of a rematch of this match. Only set for completed matches that have been rematched.
   * @param rematchId rematchId or {@code null} for none
   */
  public TurnBasedMatch setRematchId(java.lang.String rematchId) {
    this.rematchId = rematchId;
    return this;
  }

  /**
   * The results reported for this match.
   * @return value or {@code null} for none
   */
  public java.util.List<ParticipantResult> getResults() {
    return results;
  }

  /**
   * The results reported for this match.
   * @param results results or {@code null} for none
   */
  public TurnBasedMatch setResults(java.util.List<ParticipantResult> results) {
    this.results = results;
    return this;
  }

  /**
   * The status of the match. Possible values are:   - "MATCH_AUTO_MATCHING" - One or more slots
   * need to be filled by auto-matching; the match cannot be established until they are filled.  -
   * "MATCH_ACTIVE" - The match has started.  - "MATCH_COMPLETE" - The match has finished.  -
   * "MATCH_CANCELED" - The match was canceled.  - "MATCH_EXPIRED" - The match expired due to
   * inactivity.  - "MATCH_DELETED" - The match should no longer be shown on the client. Returned
   * only for tombstones for matches when sync is called.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the match. Possible values are:   - "MATCH_AUTO_MATCHING" - One or more slots
   * need to be filled by auto-matching; the match cannot be established until they are filled.  -
   * "MATCH_ACTIVE" - The match has started.  - "MATCH_COMPLETE" - The match has finished.  -
   * "MATCH_CANCELED" - The match was canceled.  - "MATCH_EXPIRED" - The match expired due to
   * inactivity.  - "MATCH_DELETED" - The match should no longer be shown on the client. Returned
   * only for tombstones for matches when sync is called.
   * @param status status or {@code null} for none
   */
  public TurnBasedMatch setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the current user in the match. Derived from the match type, match status, the
   * user's participant status, and the pending participant for the match. Possible values are:   -
   * "USER_INVITED" - The user has been invited to join the match and has not responded yet.  -
   * "USER_AWAITING_TURN" - The user is waiting for their turn.  - "USER_TURN" - The user has an
   * action to take in the match.  - "USER_MATCH_COMPLETED" - The match has ended (it is completed,
   * canceled, or expired.)
   * @return value or {@code null} for none
   */
  public java.lang.String getUserMatchStatus() {
    return userMatchStatus;
  }

  /**
   * The status of the current user in the match. Derived from the match type, match status, the
   * user's participant status, and the pending participant for the match. Possible values are:   -
   * "USER_INVITED" - The user has been invited to join the match and has not responded yet.  -
   * "USER_AWAITING_TURN" - The user is waiting for their turn.  - "USER_TURN" - The user has an
   * action to take in the match.  - "USER_MATCH_COMPLETED" - The match has ended (it is completed,
   * canceled, or expired.)
   * @param userMatchStatus userMatchStatus or {@code null} for none
   */
  public TurnBasedMatch setUserMatchStatus(java.lang.String userMatchStatus) {
    this.userMatchStatus = userMatchStatus;
    return this;
  }

  /**
   * The variant / mode of the application being played; can be any integer value, or left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVariant() {
    return variant;
  }

  /**
   * The variant / mode of the application being played; can be any integer value, or left blank.
   * @param variant variant or {@code null} for none
   */
  public TurnBasedMatch setVariant(java.lang.Integer variant) {
    this.variant = variant;
    return this;
  }

  @Override
  public TurnBasedMatch set(String fieldName, Object value) {
    return (TurnBasedMatch) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatch clone() {
    return (TurnBasedMatch) super.clone();
  }

}
