/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-02-26 at 05:17:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for turn-based match modification metadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatchModification extends com.google.api.client.json.GenericJson {

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchModification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The timestamp at which they modified the match, in milliseconds since the epoch in UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long modifiedTimestampMillis;

  /**
   * The ID of the participant that modified the match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String participantId;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchModification.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchModification.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatchModification setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The timestamp at which they modified the match, in milliseconds since the epoch in UTC.
   * @return value or {@code null} for none
   */
  public java.lang.Long getModifiedTimestampMillis() {
    return modifiedTimestampMillis;
  }

  /**
   * The timestamp at which they modified the match, in milliseconds since the epoch in UTC.
   * @param modifiedTimestampMillis modifiedTimestampMillis or {@code null} for none
   */
  public TurnBasedMatchModification setModifiedTimestampMillis(java.lang.Long modifiedTimestampMillis) {
    this.modifiedTimestampMillis = modifiedTimestampMillis;
    return this;
  }

  /**
   * The ID of the participant that modified the match.
   * @return value or {@code null} for none
   */
  public java.lang.String getParticipantId() {
    return participantId;
  }

  /**
   * The ID of the participant that modified the match.
   * @param participantId participantId or {@code null} for none
   */
  public TurnBasedMatchModification setParticipantId(java.lang.String participantId) {
    this.participantId = participantId;
    return this;
  }

  @Override
  public TurnBasedMatchModification set(String fieldName, Object value) {
    return (TurnBasedMatchModification) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatchModification clone() {
    return (TurnBasedMatchModification) super.clone();
  }

}
