/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-29 at 01:46:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an achievement definition object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AchievementDefinition extends com.google.api.client.json.GenericJson {

  /**
   * The type of the achievement. Possible values are:   - "STANDARD" - Achievement is either locked
   * or unlocked.  - "INCREMENTAL" - Achievement is incremental.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String achievementType;

  /**
   * The description of the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Experience points which will be earned when unlocking this achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long experiencePoints;

  /**
   * The total steps for an incremental achievement as a string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedTotalSteps;

  /**
   * The ID of the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The initial state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String initialState;

  /**
   * Indicates whether the revealed icon image being returned is a default image, or is provided by
   * the game.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRevealedIconUrlDefault;

  /**
   * Indicates whether the unlocked icon image being returned is a default image, or is game-
   * provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isUnlockedIconUrlDefault;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementDefinition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The image URL for the revealed achievement icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String revealedIconUrl;

  /**
   * The total steps for an incremental achievement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSteps;

  /**
   * The image URL for the unlocked achievement icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unlockedIconUrl;

  /**
   * The type of the achievement. Possible values are:   - "STANDARD" - Achievement is either locked
   * or unlocked.  - "INCREMENTAL" - Achievement is incremental.
   * @return value or {@code null} for none
   */
  public java.lang.String getAchievementType() {
    return achievementType;
  }

  /**
   * The type of the achievement. Possible values are:   - "STANDARD" - Achievement is either locked
   * or unlocked.  - "INCREMENTAL" - Achievement is incremental.
   * @param achievementType achievementType or {@code null} for none
   */
  public AchievementDefinition setAchievementType(java.lang.String achievementType) {
    this.achievementType = achievementType;
    return this;
  }

  /**
   * The description of the achievement.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the achievement.
   * @param description description or {@code null} for none
   */
  public AchievementDefinition setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Experience points which will be earned when unlocking this achievement.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExperiencePoints() {
    return experiencePoints;
  }

  /**
   * Experience points which will be earned when unlocking this achievement.
   * @param experiencePoints experiencePoints or {@code null} for none
   */
  public AchievementDefinition setExperiencePoints(java.lang.Long experiencePoints) {
    this.experiencePoints = experiencePoints;
    return this;
  }

  /**
   * The total steps for an incremental achievement as a string.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedTotalSteps() {
    return formattedTotalSteps;
  }

  /**
   * The total steps for an incremental achievement as a string.
   * @param formattedTotalSteps formattedTotalSteps or {@code null} for none
   */
  public AchievementDefinition setFormattedTotalSteps(java.lang.String formattedTotalSteps) {
    this.formattedTotalSteps = formattedTotalSteps;
    return this;
  }

  /**
   * The ID of the achievement.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the achievement.
   * @param id id or {@code null} for none
   */
  public AchievementDefinition setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The initial state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @return value or {@code null} for none
   */
  public java.lang.String getInitialState() {
    return initialState;
  }

  /**
   * The initial state of the achievement. Possible values are:   - "HIDDEN" - Achievement is
   * hidden.  - "REVEALED" - Achievement is revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @param initialState initialState or {@code null} for none
   */
  public AchievementDefinition setInitialState(java.lang.String initialState) {
    this.initialState = initialState;
    return this;
  }

  /**
   * Indicates whether the revealed icon image being returned is a default image, or is provided by
   * the game.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRevealedIconUrlDefault() {
    return isRevealedIconUrlDefault;
  }

  /**
   * Indicates whether the revealed icon image being returned is a default image, or is provided by
   * the game.
   * @param isRevealedIconUrlDefault isRevealedIconUrlDefault or {@code null} for none
   */
  public AchievementDefinition setIsRevealedIconUrlDefault(java.lang.Boolean isRevealedIconUrlDefault) {
    this.isRevealedIconUrlDefault = isRevealedIconUrlDefault;
    return this;
  }

  /**
   * Indicates whether the unlocked icon image being returned is a default image, or is game-
   * provided.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsUnlockedIconUrlDefault() {
    return isUnlockedIconUrlDefault;
  }

  /**
   * Indicates whether the unlocked icon image being returned is a default image, or is game-
   * provided.
   * @param isUnlockedIconUrlDefault isUnlockedIconUrlDefault or {@code null} for none
   */
  public AchievementDefinition setIsUnlockedIconUrlDefault(java.lang.Boolean isUnlockedIconUrlDefault) {
    this.isUnlockedIconUrlDefault = isUnlockedIconUrlDefault;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementDefinition.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementDefinition.
   * @param kind kind or {@code null} for none
   */
  public AchievementDefinition setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the achievement.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the achievement.
   * @param name name or {@code null} for none
   */
  public AchievementDefinition setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The image URL for the revealed achievement icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getRevealedIconUrl() {
    return revealedIconUrl;
  }

  /**
   * The image URL for the revealed achievement icon.
   * @param revealedIconUrl revealedIconUrl or {@code null} for none
   */
  public AchievementDefinition setRevealedIconUrl(java.lang.String revealedIconUrl) {
    this.revealedIconUrl = revealedIconUrl;
    return this;
  }

  /**
   * The total steps for an incremental achievement.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSteps() {
    return totalSteps;
  }

  /**
   * The total steps for an incremental achievement.
   * @param totalSteps totalSteps or {@code null} for none
   */
  public AchievementDefinition setTotalSteps(java.lang.Integer totalSteps) {
    this.totalSteps = totalSteps;
    return this;
  }

  /**
   * The image URL for the unlocked achievement icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnlockedIconUrl() {
    return unlockedIconUrl;
  }

  /**
   * The image URL for the unlocked achievement icon.
   * @param unlockedIconUrl unlockedIconUrl or {@code null} for none
   */
  public AchievementDefinition setUnlockedIconUrl(java.lang.String unlockedIconUrl) {
    this.unlockedIconUrl = unlockedIconUrl;
    return this;
  }

  @Override
  public AchievementDefinition set(String fieldName, Object value) {
    return (AchievementDefinition) super.set(fieldName, value);
  }

  @Override
  public AchievementDefinition clone() {
    return (AchievementDefinition) super.clone();
  }

}
