/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-29 at 01:46:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for network diagnostics reported for a client.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkDiagnostics extends com.google.api.client.json.GenericJson {

  /**
   * The Android network subtype.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer androidNetworkSubtype;

  /**
   * The Android network type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer androidNetworkType;

  /**
   * iOS network type as defined in Reachability.h.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer iosNetworkType;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#networkDiagnostics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The MCC+MNC code for the client's network connection. On Android: http://developer.android.com/
   * reference/android/telephony/TelephonyManager.html#getNetworkOperator() On iOS, see: https://dev
   * eloper.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Reference/Ref
   * erence.html
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkOperatorCode;

  /**
   * The name of the carrier of the client's network connection. On Android: http://developer.androi
   * d.com/reference/android/telephony/TelephonyManager.html#getNetworkOperatorName() On iOS: https:
   * //developer.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Referenc
   * e/Reference.html#//apple_ref/occ/instp/CTCarrier/carrierName
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkOperatorName;

  /**
   * The amount of time in milliseconds it took for the client to establish a connection with the
   * XMPP server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer registrationLatencyMillis;

  /**
   * The Android network subtype.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAndroidNetworkSubtype() {
    return androidNetworkSubtype;
  }

  /**
   * The Android network subtype.
   * @param androidNetworkSubtype androidNetworkSubtype or {@code null} for none
   */
  public NetworkDiagnostics setAndroidNetworkSubtype(java.lang.Integer androidNetworkSubtype) {
    this.androidNetworkSubtype = androidNetworkSubtype;
    return this;
  }

  /**
   * The Android network type.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAndroidNetworkType() {
    return androidNetworkType;
  }

  /**
   * The Android network type.
   * @param androidNetworkType androidNetworkType or {@code null} for none
   */
  public NetworkDiagnostics setAndroidNetworkType(java.lang.Integer androidNetworkType) {
    this.androidNetworkType = androidNetworkType;
    return this;
  }

  /**
   * iOS network type as defined in Reachability.h.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIosNetworkType() {
    return iosNetworkType;
  }

  /**
   * iOS network type as defined in Reachability.h.
   * @param iosNetworkType iosNetworkType or {@code null} for none
   */
  public NetworkDiagnostics setIosNetworkType(java.lang.Integer iosNetworkType) {
    this.iosNetworkType = iosNetworkType;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#networkDiagnostics.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#networkDiagnostics.
   * @param kind kind or {@code null} for none
   */
  public NetworkDiagnostics setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The MCC+MNC code for the client's network connection. On Android: http://developer.android.com/
   * reference/android/telephony/TelephonyManager.html#getNetworkOperator() On iOS, see: https://dev
   * eloper.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Reference/Ref
   * erence.html
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkOperatorCode() {
    return networkOperatorCode;
  }

  /**
   * The MCC+MNC code for the client's network connection. On Android: http://developer.android.com/
   * reference/android/telephony/TelephonyManager.html#getNetworkOperator() On iOS, see: https://dev
   * eloper.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Reference/Ref
   * erence.html
   * @param networkOperatorCode networkOperatorCode or {@code null} for none
   */
  public NetworkDiagnostics setNetworkOperatorCode(java.lang.String networkOperatorCode) {
    this.networkOperatorCode = networkOperatorCode;
    return this;
  }

  /**
   * The name of the carrier of the client's network connection. On Android: http://developer.androi
   * d.com/reference/android/telephony/TelephonyManager.html#getNetworkOperatorName() On iOS: https:
   * //developer.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Referenc
   * e/Reference.html#//apple_ref/occ/instp/CTCarrier/carrierName
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkOperatorName() {
    return networkOperatorName;
  }

  /**
   * The name of the carrier of the client's network connection. On Android: http://developer.androi
   * d.com/reference/android/telephony/TelephonyManager.html#getNetworkOperatorName() On iOS: https:
   * //developer.apple.com/library/ios/documentation/NetworkingInternet/Reference/CTCarrier/Referenc
   * e/Reference.html#//apple_ref/occ/instp/CTCarrier/carrierName
   * @param networkOperatorName networkOperatorName or {@code null} for none
   */
  public NetworkDiagnostics setNetworkOperatorName(java.lang.String networkOperatorName) {
    this.networkOperatorName = networkOperatorName;
    return this;
  }

  /**
   * The amount of time in milliseconds it took for the client to establish a connection with the
   * XMPP server.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRegistrationLatencyMillis() {
    return registrationLatencyMillis;
  }

  /**
   * The amount of time in milliseconds it took for the client to establish a connection with the
   * XMPP server.
   * @param registrationLatencyMillis registrationLatencyMillis or {@code null} for none
   */
  public NetworkDiagnostics setRegistrationLatencyMillis(java.lang.Integer registrationLatencyMillis) {
    this.registrationLatencyMillis = registrationLatencyMillis;
    return this;
  }

  @Override
  public NetworkDiagnostics set(String fieldName, Object value) {
    return (NetworkDiagnostics) super.set(fieldName, value);
  }

  @Override
  public NetworkDiagnostics clone() {
    return (NetworkDiagnostics) super.clone();
  }

}
