/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-29 at 01:46:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a push token resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PushToken extends com.google.api.client.json.GenericJson {

  /**
   * The revision of the client SDK used by your application, in the same format that's used by
   * revisions.check. Used to send backward compatible messages. Format:
   * [PLATFORM_TYPE]:[VERSION_NUMBER]. Possible values of PLATFORM_TYPE are: - IOS - Push token is
   * for iOS
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientRevision;

  /**
   * Unique identifier for this push token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PushTokenId id;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushToken.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The preferred language for notifications that are sent using this token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The revision of the client SDK used by your application, in the same format that's used by
   * revisions.check. Used to send backward compatible messages. Format:
   * [PLATFORM_TYPE]:[VERSION_NUMBER]. Possible values of PLATFORM_TYPE are: - IOS - Push token is
   * for iOS
   * @return value or {@code null} for none
   */
  public java.lang.String getClientRevision() {
    return clientRevision;
  }

  /**
   * The revision of the client SDK used by your application, in the same format that's used by
   * revisions.check. Used to send backward compatible messages. Format:
   * [PLATFORM_TYPE]:[VERSION_NUMBER]. Possible values of PLATFORM_TYPE are: - IOS - Push token is
   * for iOS
   * @param clientRevision clientRevision or {@code null} for none
   */
  public PushToken setClientRevision(java.lang.String clientRevision) {
    this.clientRevision = clientRevision;
    return this;
  }

  /**
   * Unique identifier for this push token.
   * @return value or {@code null} for none
   */
  public PushTokenId getId() {
    return id;
  }

  /**
   * Unique identifier for this push token.
   * @param id id or {@code null} for none
   */
  public PushToken setId(PushTokenId id) {
    this.id = id;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushToken.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#pushToken.
   * @param kind kind or {@code null} for none
   */
  public PushToken setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The preferred language for notifications that are sent using this token.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The preferred language for notifications that are sent using this token.
   * @param language language or {@code null} for none
   */
  public PushToken setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  @Override
  public PushToken set(String fieldName, Object value) {
    return (PushToken) super.set(fieldName, value);
  }

  @Override
  public PushToken clone() {
    return (PushToken) super.clone();
  }

}
