/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-16 at 00:28:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gamesManagement;

/**
 * Service definition for GamesManagement (v1management).
 *
 * <p>
 * The Management API for Google Play Game Services.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/games/services" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link GamesManagementRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class GamesManagement extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Google Play Game Services Management API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "games/v1management/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public GamesManagement(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  GamesManagement(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Achievements collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Achievements.List request = gamesManagement.achievements().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Achievements achievements() {
    return new Achievements();
  }

  /**
   * The "achievements" collection of methods.
   */
  public class Achievements {

    /**
     * Resets the achievement with the given ID for the currently authenticated player. This method is
     * only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "achievements.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param achievementId The ID of the achievement used by this method.
     * @return the request
     */
    public Reset reset(java.lang.String achievementId) throws java.io.IOException {
      Reset result = new Reset(achievementId);
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<com.google.api.services.gamesManagement.model.AchievementResetResponse> {

      private static final String REST_PATH = "achievements/{achievementId}/reset";

      /**
       * Resets the achievement with the given ID for the currently authenticated player. This method is
       * only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "achievements.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param achievementId The ID of the achievement used by this method.
       * @since 1.13
       */
      protected Reset(java.lang.String achievementId) {
        super(GamesManagement.this, "POST", REST_PATH, null, com.google.api.services.gamesManagement.model.AchievementResetResponse.class);
        this.achievementId = com.google.api.client.util.Preconditions.checkNotNull(achievementId, "Required parameter achievementId must be specified.");
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** The ID of the achievement used by this method. */
      @com.google.api.client.util.Key
      private java.lang.String achievementId;

      /** The ID of the achievement used by this method.
       */
      public java.lang.String getAchievementId() {
        return achievementId;
      }

      /** The ID of the achievement used by this method. */
      public Reset setAchievementId(java.lang.String achievementId) {
        this.achievementId = achievementId;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Resets all achievements for the currently authenticated player for your application. This method
     * is only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "achievements.resetAll".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ResetAll resetAll() throws java.io.IOException {
      ResetAll result = new ResetAll();
      initialize(result);
      return result;
    }

    public class ResetAll extends GamesManagementRequest<com.google.api.services.gamesManagement.model.AchievementResetAllResponse> {

      private static final String REST_PATH = "achievements/reset";

      /**
       * Resets all achievements for the currently authenticated player for your application. This
       * method is only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "achievements.resetAll".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
       * <p> {@link
       * ResetAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAll() {
        super(GamesManagement.this, "POST", REST_PATH, null, com.google.api.services.gamesManagement.model.AchievementResetAllResponse.class);
      }

      @Override
      public ResetAll setAlt(java.lang.String alt) {
        return (ResetAll) super.setAlt(alt);
      }

      @Override
      public ResetAll setFields(java.lang.String fields) {
        return (ResetAll) super.setFields(fields);
      }

      @Override
      public ResetAll setKey(java.lang.String key) {
        return (ResetAll) super.setKey(key);
      }

      @Override
      public ResetAll setOauthToken(java.lang.String oauthToken) {
        return (ResetAll) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAll setQuotaUser(java.lang.String quotaUser) {
        return (ResetAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAll setUserIp(java.lang.String userIp) {
        return (ResetAll) super.setUserIp(userIp);
      }

      @Override
      public ResetAll set(String parameterName, Object value) {
        return (ResetAll) super.set(parameterName, value);
      }
    }
    /**
     * Resets all draft achievements for all players. This method is only available to user accounts for
     * your developer console.
     *
     * Create a request for the method "achievements.resetAllForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetAllForAllPlayers resetAllForAllPlayers() throws java.io.IOException {
      ResetAllForAllPlayers result = new ResetAllForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetAllForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "achievements/resetAllForAllPlayers";

      /**
       * Resets all draft achievements for all players. This method is only available to user accounts
       * for your developer console.
       *
       * Create a request for the method "achievements.resetAllForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetAllForAllPlayers#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAllForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAllForAllPlayers setAlt(java.lang.String alt) {
        return (ResetAllForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetAllForAllPlayers setFields(java.lang.String fields) {
        return (ResetAllForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetAllForAllPlayers setKey(java.lang.String key) {
        return (ResetAllForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetAllForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetAllForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAllForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAllForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAllForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetAllForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAllForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetAllForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetAllForAllPlayers set(String parameterName, Object value) {
        return (ResetAllForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets the achievement with the given ID for all players. This method is only available to user
     * accounts for your developer console. Only draft achievements can be reset.
     *
     * Create a request for the method "achievements.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @param achievementId The ID of the achievement used by this method.
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers(java.lang.String achievementId) throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers(achievementId);
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "achievements/{achievementId}/resetForAllPlayers";

      /**
       * Resets the achievement with the given ID for all players. This method is only available to user
       * accounts for your developer console. Only draft achievements can be reset.
       *
       * Create a request for the method "achievements.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param achievementId The ID of the achievement used by this method.
       * @since 1.13
       */
      protected ResetForAllPlayers(java.lang.String achievementId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.achievementId = com.google.api.client.util.Preconditions.checkNotNull(achievementId, "Required parameter achievementId must be specified.");
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      /** The ID of the achievement used by this method. */
      @com.google.api.client.util.Key
      private java.lang.String achievementId;

      /** The ID of the achievement used by this method.
       */
      public java.lang.String getAchievementId() {
        return achievementId;
      }

      /** The ID of the achievement used by this method. */
      public ResetForAllPlayers setAchievementId(java.lang.String achievementId) {
        this.achievementId = achievementId;
        return this;
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets achievements with the given IDs for all players. This method is only available to user
     * accounts for your developer console. Only draft achievements may be reset.
     *
     * Create a request for the method "achievements.resetMultipleForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.gamesManagement.model.AchievementResetMultipleForAllRequest}
     * @return the request
     */
    public ResetMultipleForAllPlayers resetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.AchievementResetMultipleForAllRequest content) throws java.io.IOException {
      ResetMultipleForAllPlayers result = new ResetMultipleForAllPlayers(content);
      initialize(result);
      return result;
    }

    public class ResetMultipleForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "achievements/resetMultipleForAllPlayers";

      /**
       * Resets achievements with the given IDs for all players. This method is only available to user
       * accounts for your developer console. Only draft achievements may be reset.
       *
       * Create a request for the method "achievements.resetMultipleForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetMultipleForAllPlayers#initialize(com.google.api.client.google
       * apis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.gamesManagement.model.AchievementResetMultipleForAllRequest}
       * @since 1.13
       */
      protected ResetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.AchievementResetMultipleForAllRequest content) {
        super(GamesManagement.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ResetMultipleForAllPlayers setAlt(java.lang.String alt) {
        return (ResetMultipleForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetMultipleForAllPlayers setFields(java.lang.String fields) {
        return (ResetMultipleForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetMultipleForAllPlayers setKey(java.lang.String key) {
        return (ResetMultipleForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetMultipleForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetMultipleForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetMultipleForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetMultipleForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetMultipleForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetMultipleForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetMultipleForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetMultipleForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetMultipleForAllPlayers set(String parameterName, Object value) {
        return (ResetMultipleForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Applications collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Applications.List request = gamesManagement.applications().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Applications applications() {
    return new Applications();
  }

  /**
   * The "applications" collection of methods.
   */
  public class Applications {

    /**
     * Get the list of players hidden from the given application. This method is only available to user
     * accounts for your developer console.
     *
     * Create a request for the method "applications.listHidden".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ListHidden#execute()} method to invoke the remote operation.
     *
     * @param applicationId The application ID from the Google Play developer console.
     * @return the request
     */
    public ListHidden listHidden(java.lang.String applicationId) throws java.io.IOException {
      ListHidden result = new ListHidden(applicationId);
      initialize(result);
      return result;
    }

    public class ListHidden extends GamesManagementRequest<com.google.api.services.gamesManagement.model.HiddenPlayerList> {

      private static final String REST_PATH = "applications/{applicationId}/players/hidden";

      /**
       * Get the list of players hidden from the given application. This method is only available to
       * user accounts for your developer console.
       *
       * Create a request for the method "applications.listHidden".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ListHidden#execute()} method to invoke the remote
       * operation. <p> {@link
       * ListHidden#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param applicationId The application ID from the Google Play developer console.
       * @since 1.13
       */
      protected ListHidden(java.lang.String applicationId) {
        super(GamesManagement.this, "GET", REST_PATH, null, com.google.api.services.gamesManagement.model.HiddenPlayerList.class);
        this.applicationId = com.google.api.client.util.Preconditions.checkNotNull(applicationId, "Required parameter applicationId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListHidden setAlt(java.lang.String alt) {
        return (ListHidden) super.setAlt(alt);
      }

      @Override
      public ListHidden setFields(java.lang.String fields) {
        return (ListHidden) super.setFields(fields);
      }

      @Override
      public ListHidden setKey(java.lang.String key) {
        return (ListHidden) super.setKey(key);
      }

      @Override
      public ListHidden setOauthToken(java.lang.String oauthToken) {
        return (ListHidden) super.setOauthToken(oauthToken);
      }

      @Override
      public ListHidden setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListHidden) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListHidden setQuotaUser(java.lang.String quotaUser) {
        return (ListHidden) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListHidden setUserIp(java.lang.String userIp) {
        return (ListHidden) super.setUserIp(userIp);
      }

      /** The application ID from the Google Play developer console. */
      @com.google.api.client.util.Key
      private java.lang.String applicationId;

      /** The application ID from the Google Play developer console.
       */
      public java.lang.String getApplicationId() {
        return applicationId;
      }

      /** The application ID from the Google Play developer console. */
      public ListHidden setApplicationId(java.lang.String applicationId) {
        this.applicationId = applicationId;
        return this;
      }

      /**
       * The maximum number of player resources to return in the response, used for paging. For any
       * response, the actual number of player resources returned may be less than the specified
       * maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of player resources to return in the response, used for paging. For any
     response, the actual number of player resources returned may be less than the specified maxResults.

     [minimum: 1] [maximum: 50]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of player resources to return in the response, used for paging. For any
       * response, the actual number of player resources returned may be less than the specified
       * maxResults.
       */
      public ListHidden setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public ListHidden setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public ListHidden set(String parameterName, Object value) {
        return (ListHidden) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Events collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Events.List request = gamesManagement.events().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Events events() {
    return new Events();
  }

  /**
   * The "events" collection of methods.
   */
  public class Events {

    /**
     * Resets all player progress on the event with the given ID for the currently authenticated player.
     * This method is only accessible to whitelisted tester accounts for your application. All quests
     * for this player that use the event will also be reset.
     *
     * Create a request for the method "events.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param eventId The ID of the event.
     * @return the request
     */
    public Reset reset(java.lang.String eventId) throws java.io.IOException {
      Reset result = new Reset(eventId);
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "events/{eventId}/reset";

      /**
       * Resets all player progress on the event with the given ID for the currently authenticated
       * player. This method is only accessible to whitelisted tester accounts for your application. All
       * quests for this player that use the event will also be reset.
       *
       * Create a request for the method "events.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param eventId The ID of the event.
       * @since 1.13
       */
      protected Reset(java.lang.String eventId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** The ID of the event. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** The ID of the event.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** The ID of the event. */
      public Reset setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Resets all player progress on all events for the currently authenticated player. This method is
     * only accessible to whitelisted tester accounts for your application. All quests for this player
     * will also be reset.
     *
     * Create a request for the method "events.resetAll".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ResetAll resetAll() throws java.io.IOException {
      ResetAll result = new ResetAll();
      initialize(result);
      return result;
    }

    public class ResetAll extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "events/reset";

      /**
       * Resets all player progress on all events for the currently authenticated player. This method is
       * only accessible to whitelisted tester accounts for your application. All quests for this player
       * will also be reset.
       *
       * Create a request for the method "events.resetAll".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
       * <p> {@link
       * ResetAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAll() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAll setAlt(java.lang.String alt) {
        return (ResetAll) super.setAlt(alt);
      }

      @Override
      public ResetAll setFields(java.lang.String fields) {
        return (ResetAll) super.setFields(fields);
      }

      @Override
      public ResetAll setKey(java.lang.String key) {
        return (ResetAll) super.setKey(key);
      }

      @Override
      public ResetAll setOauthToken(java.lang.String oauthToken) {
        return (ResetAll) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAll setQuotaUser(java.lang.String quotaUser) {
        return (ResetAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAll setUserIp(java.lang.String userIp) {
        return (ResetAll) super.setUserIp(userIp);
      }

      @Override
      public ResetAll set(String parameterName, Object value) {
        return (ResetAll) super.set(parameterName, value);
      }
    }
    /**
     * Resets all draft events for all players. This method is only available to user accounts for your
     * developer console. All quests that use any of these events will also be reset.
     *
     * Create a request for the method "events.resetAllForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetAllForAllPlayers resetAllForAllPlayers() throws java.io.IOException {
      ResetAllForAllPlayers result = new ResetAllForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetAllForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "events/resetAllForAllPlayers";

      /**
       * Resets all draft events for all players. This method is only available to user accounts for
       * your developer console. All quests that use any of these events will also be reset.
       *
       * Create a request for the method "events.resetAllForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetAllForAllPlayers#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAllForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAllForAllPlayers setAlt(java.lang.String alt) {
        return (ResetAllForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetAllForAllPlayers setFields(java.lang.String fields) {
        return (ResetAllForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetAllForAllPlayers setKey(java.lang.String key) {
        return (ResetAllForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetAllForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetAllForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAllForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAllForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAllForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetAllForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAllForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetAllForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetAllForAllPlayers set(String parameterName, Object value) {
        return (ResetAllForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets the event with the given ID for all players. This method is only available to user
     * accounts for your developer console. Only draft events can be reset. All quests that use the
     * event will also be reset.
     *
     * Create a request for the method "events.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @param eventId The ID of the event.
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers(java.lang.String eventId) throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers(eventId);
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "events/{eventId}/resetForAllPlayers";

      /**
       * Resets the event with the given ID for all players. This method is only available to user
       * accounts for your developer console. Only draft events can be reset. All quests that use the
       * event will also be reset.
       *
       * Create a request for the method "events.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param eventId The ID of the event.
       * @since 1.13
       */
      protected ResetForAllPlayers(java.lang.String eventId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      /** The ID of the event. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** The ID of the event.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** The ID of the event. */
      public ResetForAllPlayers setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets events with the given IDs for all players. This method is only available to user accounts
     * for your developer console. Only draft events may be reset. All quests that use any of the events
     * will also be reset.
     *
     * Create a request for the method "events.resetMultipleForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.gamesManagement.model.EventsResetMultipleForAllRequest}
     * @return the request
     */
    public ResetMultipleForAllPlayers resetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.EventsResetMultipleForAllRequest content) throws java.io.IOException {
      ResetMultipleForAllPlayers result = new ResetMultipleForAllPlayers(content);
      initialize(result);
      return result;
    }

    public class ResetMultipleForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "events/resetMultipleForAllPlayers";

      /**
       * Resets events with the given IDs for all players. This method is only available to user
       * accounts for your developer console. Only draft events may be reset. All quests that use any of
       * the events will also be reset.
       *
       * Create a request for the method "events.resetMultipleForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetMultipleForAllPlayers#initialize(com.google.api.client.google
       * apis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.gamesManagement.model.EventsResetMultipleForAllRequest}
       * @since 1.13
       */
      protected ResetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.EventsResetMultipleForAllRequest content) {
        super(GamesManagement.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ResetMultipleForAllPlayers setAlt(java.lang.String alt) {
        return (ResetMultipleForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetMultipleForAllPlayers setFields(java.lang.String fields) {
        return (ResetMultipleForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetMultipleForAllPlayers setKey(java.lang.String key) {
        return (ResetMultipleForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetMultipleForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetMultipleForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetMultipleForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetMultipleForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetMultipleForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetMultipleForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetMultipleForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetMultipleForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetMultipleForAllPlayers set(String parameterName, Object value) {
        return (ResetMultipleForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Players collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Players.List request = gamesManagement.players().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Players players() {
    return new Players();
  }

  /**
   * The "players" collection of methods.
   */
  public class Players {

    /**
     * Hide the given player's leaderboard scores from the given application. This method is only
     * available to user accounts for your developer console.
     *
     * Create a request for the method "players.hide".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Hide#execute()} method to invoke the remote operation.
     *
     * @param applicationId The application ID from the Google Play developer console.
     * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
     * @return the request
     */
    public Hide hide(java.lang.String applicationId, java.lang.String playerId) throws java.io.IOException {
      Hide result = new Hide(applicationId, playerId);
      initialize(result);
      return result;
    }

    public class Hide extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "applications/{applicationId}/players/hidden/{playerId}";

      /**
       * Hide the given player's leaderboard scores from the given application. This method is only
       * available to user accounts for your developer console.
       *
       * Create a request for the method "players.hide".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Hide#execute()} method to invoke the remote operation. <p>
       * {@link Hide#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param applicationId The application ID from the Google Play developer console.
       * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
       * @since 1.13
       */
      protected Hide(java.lang.String applicationId, java.lang.String playerId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.applicationId = com.google.api.client.util.Preconditions.checkNotNull(applicationId, "Required parameter applicationId must be specified.");
        this.playerId = com.google.api.client.util.Preconditions.checkNotNull(playerId, "Required parameter playerId must be specified.");
      }

      @Override
      public Hide setAlt(java.lang.String alt) {
        return (Hide) super.setAlt(alt);
      }

      @Override
      public Hide setFields(java.lang.String fields) {
        return (Hide) super.setFields(fields);
      }

      @Override
      public Hide setKey(java.lang.String key) {
        return (Hide) super.setKey(key);
      }

      @Override
      public Hide setOauthToken(java.lang.String oauthToken) {
        return (Hide) super.setOauthToken(oauthToken);
      }

      @Override
      public Hide setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Hide) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Hide setQuotaUser(java.lang.String quotaUser) {
        return (Hide) super.setQuotaUser(quotaUser);
      }

      @Override
      public Hide setUserIp(java.lang.String userIp) {
        return (Hide) super.setUserIp(userIp);
      }

      /** The application ID from the Google Play developer console. */
      @com.google.api.client.util.Key
      private java.lang.String applicationId;

      /** The application ID from the Google Play developer console.
       */
      public java.lang.String getApplicationId() {
        return applicationId;
      }

      /** The application ID from the Google Play developer console. */
      public Hide setApplicationId(java.lang.String applicationId) {
        this.applicationId = applicationId;
        return this;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      @com.google.api.client.util.Key
      private java.lang.String playerId;

      /** A player ID. A value of me may be used in place of the authenticated player's ID.
       */
      public java.lang.String getPlayerId() {
        return playerId;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      public Hide setPlayerId(java.lang.String playerId) {
        this.playerId = playerId;
        return this;
      }

      @Override
      public Hide set(String parameterName, Object value) {
        return (Hide) super.set(parameterName, value);
      }
    }
    /**
     * Unhide the given player's leaderboard scores from the given application. This method is only
     * available to user accounts for your developer console.
     *
     * Create a request for the method "players.unhide".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Unhide#execute()} method to invoke the remote operation.
     *
     * @param applicationId The application ID from the Google Play developer console.
     * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
     * @return the request
     */
    public Unhide unhide(java.lang.String applicationId, java.lang.String playerId) throws java.io.IOException {
      Unhide result = new Unhide(applicationId, playerId);
      initialize(result);
      return result;
    }

    public class Unhide extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "applications/{applicationId}/players/hidden/{playerId}";

      /**
       * Unhide the given player's leaderboard scores from the given application. This method is only
       * available to user accounts for your developer console.
       *
       * Create a request for the method "players.unhide".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Unhide#execute()} method to invoke the remote operation.
       * <p> {@link
       * Unhide#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param applicationId The application ID from the Google Play developer console.
       * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
       * @since 1.13
       */
      protected Unhide(java.lang.String applicationId, java.lang.String playerId) {
        super(GamesManagement.this, "DELETE", REST_PATH, null, Void.class);
        this.applicationId = com.google.api.client.util.Preconditions.checkNotNull(applicationId, "Required parameter applicationId must be specified.");
        this.playerId = com.google.api.client.util.Preconditions.checkNotNull(playerId, "Required parameter playerId must be specified.");
      }

      @Override
      public Unhide setAlt(java.lang.String alt) {
        return (Unhide) super.setAlt(alt);
      }

      @Override
      public Unhide setFields(java.lang.String fields) {
        return (Unhide) super.setFields(fields);
      }

      @Override
      public Unhide setKey(java.lang.String key) {
        return (Unhide) super.setKey(key);
      }

      @Override
      public Unhide setOauthToken(java.lang.String oauthToken) {
        return (Unhide) super.setOauthToken(oauthToken);
      }

      @Override
      public Unhide setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unhide) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unhide setQuotaUser(java.lang.String quotaUser) {
        return (Unhide) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unhide setUserIp(java.lang.String userIp) {
        return (Unhide) super.setUserIp(userIp);
      }

      /** The application ID from the Google Play developer console. */
      @com.google.api.client.util.Key
      private java.lang.String applicationId;

      /** The application ID from the Google Play developer console.
       */
      public java.lang.String getApplicationId() {
        return applicationId;
      }

      /** The application ID from the Google Play developer console. */
      public Unhide setApplicationId(java.lang.String applicationId) {
        this.applicationId = applicationId;
        return this;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      @com.google.api.client.util.Key
      private java.lang.String playerId;

      /** A player ID. A value of me may be used in place of the authenticated player's ID.
       */
      public java.lang.String getPlayerId() {
        return playerId;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      public Unhide setPlayerId(java.lang.String playerId) {
        this.playerId = playerId;
        return this;
      }

      @Override
      public Unhide set(String parameterName, Object value) {
        return (Unhide) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Quests collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Quests.List request = gamesManagement.quests().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Quests quests() {
    return new Quests();
  }

  /**
   * The "quests" collection of methods.
   */
  public class Quests {

    /**
     * Resets all player progress on the quest with the given ID for the currently authenticated player.
     * This method is only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "quests.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param questId The ID of the quest.
     * @return the request
     */
    public Reset reset(java.lang.String questId) throws java.io.IOException {
      Reset result = new Reset(questId);
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "quests/{questId}/reset";

      /**
       * Resets all player progress on the quest with the given ID for the currently authenticated
       * player. This method is only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "quests.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param questId The ID of the quest.
       * @since 1.13
       */
      protected Reset(java.lang.String questId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.questId = com.google.api.client.util.Preconditions.checkNotNull(questId, "Required parameter questId must be specified.");
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** The ID of the quest. */
      @com.google.api.client.util.Key
      private java.lang.String questId;

      /** The ID of the quest.
       */
      public java.lang.String getQuestId() {
        return questId;
      }

      /** The ID of the quest. */
      public Reset setQuestId(java.lang.String questId) {
        this.questId = questId;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Resets all player progress on all quests for the currently authenticated player. This method is
     * only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "quests.resetAll".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ResetAll resetAll() throws java.io.IOException {
      ResetAll result = new ResetAll();
      initialize(result);
      return result;
    }

    public class ResetAll extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "quests/reset";

      /**
       * Resets all player progress on all quests for the currently authenticated player. This method is
       * only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "quests.resetAll".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
       * <p> {@link
       * ResetAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAll() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAll setAlt(java.lang.String alt) {
        return (ResetAll) super.setAlt(alt);
      }

      @Override
      public ResetAll setFields(java.lang.String fields) {
        return (ResetAll) super.setFields(fields);
      }

      @Override
      public ResetAll setKey(java.lang.String key) {
        return (ResetAll) super.setKey(key);
      }

      @Override
      public ResetAll setOauthToken(java.lang.String oauthToken) {
        return (ResetAll) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAll setQuotaUser(java.lang.String quotaUser) {
        return (ResetAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAll setUserIp(java.lang.String userIp) {
        return (ResetAll) super.setUserIp(userIp);
      }

      @Override
      public ResetAll set(String parameterName, Object value) {
        return (ResetAll) super.set(parameterName, value);
      }
    }
    /**
     * Resets all draft quests for all players. This method is only available to user accounts for your
     * developer console.
     *
     * Create a request for the method "quests.resetAllForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetAllForAllPlayers resetAllForAllPlayers() throws java.io.IOException {
      ResetAllForAllPlayers result = new ResetAllForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetAllForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "quests/resetAllForAllPlayers";

      /**
       * Resets all draft quests for all players. This method is only available to user accounts for
       * your developer console.
       *
       * Create a request for the method "quests.resetAllForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetAllForAllPlayers#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAllForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAllForAllPlayers setAlt(java.lang.String alt) {
        return (ResetAllForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetAllForAllPlayers setFields(java.lang.String fields) {
        return (ResetAllForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetAllForAllPlayers setKey(java.lang.String key) {
        return (ResetAllForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetAllForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetAllForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAllForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAllForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAllForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetAllForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAllForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetAllForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetAllForAllPlayers set(String parameterName, Object value) {
        return (ResetAllForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets all player progress on the quest with the given ID for all players. This method is only
     * available to user accounts for your developer console. Only draft quests can be reset.
     *
     * Create a request for the method "quests.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @param questId The ID of the quest.
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers(java.lang.String questId) throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers(questId);
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "quests/{questId}/resetForAllPlayers";

      /**
       * Resets all player progress on the quest with the given ID for all players. This method is only
       * available to user accounts for your developer console. Only draft quests can be reset.
       *
       * Create a request for the method "quests.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param questId The ID of the quest.
       * @since 1.13
       */
      protected ResetForAllPlayers(java.lang.String questId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.questId = com.google.api.client.util.Preconditions.checkNotNull(questId, "Required parameter questId must be specified.");
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      /** The ID of the quest. */
      @com.google.api.client.util.Key
      private java.lang.String questId;

      /** The ID of the quest.
       */
      public java.lang.String getQuestId() {
        return questId;
      }

      /** The ID of the quest. */
      public ResetForAllPlayers setQuestId(java.lang.String questId) {
        this.questId = questId;
        return this;
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets quests with the given IDs for all players. This method is only available to user accounts
     * for your developer console. Only draft quests may be reset.
     *
     * Create a request for the method "quests.resetMultipleForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.gamesManagement.model.QuestsResetMultipleForAllRequest}
     * @return the request
     */
    public ResetMultipleForAllPlayers resetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.QuestsResetMultipleForAllRequest content) throws java.io.IOException {
      ResetMultipleForAllPlayers result = new ResetMultipleForAllPlayers(content);
      initialize(result);
      return result;
    }

    public class ResetMultipleForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "quests/resetMultipleForAllPlayers";

      /**
       * Resets quests with the given IDs for all players. This method is only available to user
       * accounts for your developer console. Only draft quests may be reset.
       *
       * Create a request for the method "quests.resetMultipleForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetMultipleForAllPlayers#initialize(com.google.api.client.google
       * apis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.gamesManagement.model.QuestsResetMultipleForAllRequest}
       * @since 1.13
       */
      protected ResetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.QuestsResetMultipleForAllRequest content) {
        super(GamesManagement.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ResetMultipleForAllPlayers setAlt(java.lang.String alt) {
        return (ResetMultipleForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetMultipleForAllPlayers setFields(java.lang.String fields) {
        return (ResetMultipleForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetMultipleForAllPlayers setKey(java.lang.String key) {
        return (ResetMultipleForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetMultipleForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetMultipleForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetMultipleForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetMultipleForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetMultipleForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetMultipleForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetMultipleForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetMultipleForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetMultipleForAllPlayers set(String parameterName, Object value) {
        return (ResetMultipleForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Rooms collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Rooms.List request = gamesManagement.rooms().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Rooms rooms() {
    return new Rooms();
  }

  /**
   * The "rooms" collection of methods.
   */
  public class Rooms {

    /**
     * Reset all rooms for the currently authenticated player for your application. This method is only
     * accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "rooms.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Reset reset() throws java.io.IOException {
      Reset result = new Reset();
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "rooms/reset";

      /**
       * Reset all rooms for the currently authenticated player for your application. This method is
       * only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "rooms.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Reset() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Deletes rooms where the only room participants are from whitelisted tester accounts for your
     * application. This method is only available to user accounts for your developer console.
     *
     * Create a request for the method "rooms.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers() throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "rooms/resetForAllPlayers";

      /**
       * Deletes rooms where the only room participants are from whitelisted tester accounts for your
       * application. This method is only available to user accounts for your developer console.
       *
       * Create a request for the method "rooms.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Scores collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.Scores.List request = gamesManagement.scores().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Scores scores() {
    return new Scores();
  }

  /**
   * The "scores" collection of methods.
   */
  public class Scores {

    /**
     * Resets scores for the leaderboard with the given ID for the currently authenticated player. This
     * method is only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "scores.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @return the request
     */
    public Reset reset(java.lang.String leaderboardId) throws java.io.IOException {
      Reset result = new Reset(leaderboardId);
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<com.google.api.services.gamesManagement.model.PlayerScoreResetResponse> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/reset";

      /**
       * Resets scores for the leaderboard with the given ID for the currently authenticated player.
       * This method is only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "scores.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @since 1.13
       */
      protected Reset(java.lang.String leaderboardId) {
        super(GamesManagement.this, "POST", REST_PATH, null, com.google.api.services.gamesManagement.model.PlayerScoreResetResponse.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public Reset setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Resets all scores for all leaderboards for the currently authenticated players. This method is
     * only accessible to whitelisted tester accounts for your application.
     *
     * Create a request for the method "scores.resetAll".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ResetAll resetAll() throws java.io.IOException {
      ResetAll result = new ResetAll();
      initialize(result);
      return result;
    }

    public class ResetAll extends GamesManagementRequest<com.google.api.services.gamesManagement.model.PlayerScoreResetAllResponse> {

      private static final String REST_PATH = "scores/reset";

      /**
       * Resets all scores for all leaderboards for the currently authenticated players. This method is
       * only accessible to whitelisted tester accounts for your application.
       *
       * Create a request for the method "scores.resetAll".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAll#execute()} method to invoke the remote operation.
       * <p> {@link
       * ResetAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAll() {
        super(GamesManagement.this, "POST", REST_PATH, null, com.google.api.services.gamesManagement.model.PlayerScoreResetAllResponse.class);
      }

      @Override
      public ResetAll setAlt(java.lang.String alt) {
        return (ResetAll) super.setAlt(alt);
      }

      @Override
      public ResetAll setFields(java.lang.String fields) {
        return (ResetAll) super.setFields(fields);
      }

      @Override
      public ResetAll setKey(java.lang.String key) {
        return (ResetAll) super.setKey(key);
      }

      @Override
      public ResetAll setOauthToken(java.lang.String oauthToken) {
        return (ResetAll) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAll setQuotaUser(java.lang.String quotaUser) {
        return (ResetAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAll setUserIp(java.lang.String userIp) {
        return (ResetAll) super.setUserIp(userIp);
      }

      @Override
      public ResetAll set(String parameterName, Object value) {
        return (ResetAll) super.set(parameterName, value);
      }
    }
    /**
     * Resets scores for all draft leaderboards for all players. This method is only available to user
     * accounts for your developer console.
     *
     * Create a request for the method "scores.resetAllForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetAllForAllPlayers resetAllForAllPlayers() throws java.io.IOException {
      ResetAllForAllPlayers result = new ResetAllForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetAllForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "scores/resetAllForAllPlayers";

      /**
       * Resets scores for all draft leaderboards for all players. This method is only available to user
       * accounts for your developer console.
       *
       * Create a request for the method "scores.resetAllForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetAllForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetAllForAllPlayers#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetAllForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetAllForAllPlayers setAlt(java.lang.String alt) {
        return (ResetAllForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetAllForAllPlayers setFields(java.lang.String fields) {
        return (ResetAllForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetAllForAllPlayers setKey(java.lang.String key) {
        return (ResetAllForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetAllForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetAllForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetAllForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetAllForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetAllForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetAllForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetAllForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetAllForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetAllForAllPlayers set(String parameterName, Object value) {
        return (ResetAllForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets scores for the leaderboard with the given ID for all players. This method is only
     * available to user accounts for your developer console. Only draft leaderboards can be reset.
     *
     * Create a request for the method "scores.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers(java.lang.String leaderboardId) throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers(leaderboardId);
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/resetForAllPlayers";

      /**
       * Resets scores for the leaderboard with the given ID for all players. This method is only
       * available to user accounts for your developer console. Only draft leaderboards can be reset.
       *
       * Create a request for the method "scores.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @since 1.13
       */
      protected ResetForAllPlayers(java.lang.String leaderboardId) {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public ResetForAllPlayers setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }
    /**
     * Resets scores for the leaderboards with the given IDs for all players. This method is only
     * available to user accounts for your developer console. Only draft leaderboards may be reset.
     *
     * Create a request for the method "scores.resetMultipleForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.gamesManagement.model.ScoresResetMultipleForAllRequest}
     * @return the request
     */
    public ResetMultipleForAllPlayers resetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.ScoresResetMultipleForAllRequest content) throws java.io.IOException {
      ResetMultipleForAllPlayers result = new ResetMultipleForAllPlayers(content);
      initialize(result);
      return result;
    }

    public class ResetMultipleForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "scores/resetMultipleForAllPlayers";

      /**
       * Resets scores for the leaderboards with the given IDs for all players. This method is only
       * available to user accounts for your developer console. Only draft leaderboards may be reset.
       *
       * Create a request for the method "scores.resetMultipleForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetMultipleForAllPlayers#execute()} method to invoke the
       * remote operation. <p> {@link ResetMultipleForAllPlayers#initialize(com.google.api.client.google
       * apis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.gamesManagement.model.ScoresResetMultipleForAllRequest}
       * @since 1.13
       */
      protected ResetMultipleForAllPlayers(com.google.api.services.gamesManagement.model.ScoresResetMultipleForAllRequest content) {
        super(GamesManagement.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ResetMultipleForAllPlayers setAlt(java.lang.String alt) {
        return (ResetMultipleForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetMultipleForAllPlayers setFields(java.lang.String fields) {
        return (ResetMultipleForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetMultipleForAllPlayers setKey(java.lang.String key) {
        return (ResetMultipleForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetMultipleForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetMultipleForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetMultipleForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetMultipleForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetMultipleForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetMultipleForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetMultipleForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetMultipleForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetMultipleForAllPlayers set(String parameterName, Object value) {
        return (ResetMultipleForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TurnBasedMatches collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GamesManagement gamesManagement = new GamesManagement(...);}
   *   {@code GamesManagement.TurnBasedMatches.List request = gamesManagement.turnBasedMatches().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TurnBasedMatches turnBasedMatches() {
    return new TurnBasedMatches();
  }

  /**
   * The "turnBasedMatches" collection of methods.
   */
  public class TurnBasedMatches {

    /**
     * Reset all turn-based match data for a user. This method is only accessible to whitelisted tester
     * accounts for your application.
     *
     * Create a request for the method "turnBasedMatches.reset".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Reset reset() throws java.io.IOException {
      Reset result = new Reset();
      initialize(result);
      return result;
    }

    public class Reset extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "turnbasedmatches/reset";

      /**
       * Reset all turn-based match data for a user. This method is only accessible to whitelisted
       * tester accounts for your application.
       *
       * Create a request for the method "turnBasedMatches.reset".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
       * <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Reset() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Deletes turn-based matches where the only match participants are from whitelisted tester accounts
     * for your application. This method is only available to user accounts for your developer console.
     *
     * Create a request for the method "turnBasedMatches.resetForAllPlayers".
     *
     * This request holds the parameters needed by the gamesManagement server.  After setting any
     * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public ResetForAllPlayers resetForAllPlayers() throws java.io.IOException {
      ResetForAllPlayers result = new ResetForAllPlayers();
      initialize(result);
      return result;
    }

    public class ResetForAllPlayers extends GamesManagementRequest<Void> {

      private static final String REST_PATH = "turnbasedmatches/resetForAllPlayers";

      /**
       * Deletes turn-based matches where the only match participants are from whitelisted tester
       * accounts for your application. This method is only available to user accounts for your
       * developer console.
       *
       * Create a request for the method "turnBasedMatches.resetForAllPlayers".
       *
       * This request holds the parameters needed by the the gamesManagement server.  After setting any
       * optional parameters, call the {@link ResetForAllPlayers#execute()} method to invoke the remote
       * operation. <p> {@link ResetForAllPlayers#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ResetForAllPlayers() {
        super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public ResetForAllPlayers setAlt(java.lang.String alt) {
        return (ResetForAllPlayers) super.setAlt(alt);
      }

      @Override
      public ResetForAllPlayers setFields(java.lang.String fields) {
        return (ResetForAllPlayers) super.setFields(fields);
      }

      @Override
      public ResetForAllPlayers setKey(java.lang.String key) {
        return (ResetForAllPlayers) super.setKey(key);
      }

      @Override
      public ResetForAllPlayers setOauthToken(java.lang.String oauthToken) {
        return (ResetForAllPlayers) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetForAllPlayers setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetForAllPlayers) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetForAllPlayers setQuotaUser(java.lang.String quotaUser) {
        return (ResetForAllPlayers) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetForAllPlayers setUserIp(java.lang.String userIp) {
        return (ResetForAllPlayers) super.setUserIp(userIp);
      }

      @Override
      public ResetForAllPlayers set(String parameterName, Object value) {
        return (ResetForAllPlayers) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link GamesManagement}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link GamesManagement}. */
    @Override
    public GamesManagement build() {
      return new GamesManagement(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link GamesManagementRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setGamesManagementRequestInitializer(
        GamesManagementRequestInitializer gamesmanagementRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(gamesmanagementRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
