/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-16 at 00:28:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gamesManagement.model;

/**
 * This is a JSON template for an achievement reset response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services Management API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AchievementResetResponse extends com.google.api.client.json.GenericJson {

  /**
   * The current state of the achievement. This is the same as the initial state of the achievement.
   * Possible values are:   - "HIDDEN"- Achievement is hidden.  - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentState;

  /**
   * The ID of an achievement for which player state has been updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definitionId;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#achievementResetResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Flag to indicate if the requested update actually occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean updateOccurred;

  /**
   * The current state of the achievement. This is the same as the initial state of the achievement.
   * Possible values are:   - "HIDDEN"- Achievement is hidden.  - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentState() {
    return currentState;
  }

  /**
   * The current state of the achievement. This is the same as the initial state of the achievement.
   * Possible values are:   - "HIDDEN"- Achievement is hidden.  - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @param currentState currentState or {@code null} for none
   */
  public AchievementResetResponse setCurrentState(java.lang.String currentState) {
    this.currentState = currentState;
    return this;
  }

  /**
   * The ID of an achievement for which player state has been updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinitionId() {
    return definitionId;
  }

  /**
   * The ID of an achievement for which player state has been updated.
   * @param definitionId definitionId or {@code null} for none
   */
  public AchievementResetResponse setDefinitionId(java.lang.String definitionId) {
    this.definitionId = definitionId;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#achievementResetResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#achievementResetResponse.
   * @param kind kind or {@code null} for none
   */
  public AchievementResetResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Flag to indicate if the requested update actually occurred.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUpdateOccurred() {
    return updateOccurred;
  }

  /**
   * Flag to indicate if the requested update actually occurred.
   * @param updateOccurred updateOccurred or {@code null} for none
   */
  public AchievementResetResponse setUpdateOccurred(java.lang.Boolean updateOccurred) {
    this.updateOccurred = updateOccurred;
    return this;
  }

  @Override
  public AchievementResetResponse set(String fieldName, Object value) {
    return (AchievementResetResponse) super.set(fieldName, value);
  }

  @Override
  public AchievementResetResponse clone() {
    return (AchievementResetResponse) super.clone();
  }

}
