/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-16 at 00:28:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gamesManagement.model;

/**
 * This is a JSON template for metadata about a player playing a game with the currently
 * authenticated user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services Management API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GamesPlayedResource extends com.google.api.client.json.GenericJson {

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoMatched;

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long timeMillis;

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoMatched() {
    return autoMatched;
  }

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * @param autoMatched autoMatched or {@code null} for none
   */
  public GamesPlayedResource setAutoMatched(java.lang.Boolean autoMatched) {
    this.autoMatched = autoMatched;
    return this;
  }

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimeMillis() {
    return timeMillis;
  }

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * @param timeMillis timeMillis or {@code null} for none
   */
  public GamesPlayedResource setTimeMillis(java.lang.Long timeMillis) {
    this.timeMillis = timeMillis;
    return this;
  }

  @Override
  public GamesPlayedResource set(String fieldName, Object value) {
    return (GamesPlayedResource) super.set(fieldName, value);
  }

  @Override
  public GamesPlayedResource clone() {
    return (GamesPlayedResource) super.clone();
  }

}
