/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-16 at 00:28:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gamesManagement.model;

/**
 * This is a JSON template for a list of reset leaderboard entry resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services Management API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerScoreResetResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ID of an leaderboard for which player state has been updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definitionId;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#playerScoreResetResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The time spans of the updated score. Possible values are:   - "ALL_TIME" - The score is an all-
   * time score.  - "WEEKLY" - The score is a weekly score.  - "DAILY" - The score is a daily score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> resetScoreTimeSpans;

  /**
   * The ID of an leaderboard for which player state has been updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinitionId() {
    return definitionId;
  }

  /**
   * The ID of an leaderboard for which player state has been updated.
   * @param definitionId definitionId or {@code null} for none
   */
  public PlayerScoreResetResponse setDefinitionId(java.lang.String definitionId) {
    this.definitionId = definitionId;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#playerScoreResetResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * gamesManagement#playerScoreResetResponse.
   * @param kind kind or {@code null} for none
   */
  public PlayerScoreResetResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The time spans of the updated score. Possible values are:   - "ALL_TIME" - The score is an all-
   * time score.  - "WEEKLY" - The score is a weekly score.  - "DAILY" - The score is a daily score.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getResetScoreTimeSpans() {
    return resetScoreTimeSpans;
  }

  /**
   * The time spans of the updated score. Possible values are:   - "ALL_TIME" - The score is an all-
   * time score.  - "WEEKLY" - The score is a weekly score.  - "DAILY" - The score is a daily score.
   * @param resetScoreTimeSpans resetScoreTimeSpans or {@code null} for none
   */
  public PlayerScoreResetResponse setResetScoreTimeSpans(java.util.List<java.lang.String> resetScoreTimeSpans) {
    this.resetScoreTimeSpans = resetScoreTimeSpans;
    return this;
  }

  @Override
  public PlayerScoreResetResponse set(String fieldName, Object value) {
    return (PlayerScoreResetResponse) super.set(fieldName, value);
  }

  @Override
  public PlayerScoreResetResponse clone() {
    return (PlayerScoreResetResponse) super.clone();
  }

}
