/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.gamesManagement;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.gamesManagement.GamesManagementRequest;
import com.google.api.services.gamesManagement.GamesManagementRequestInitializer;
import com.google.api.services.gamesManagement.model.AchievementResetAllResponse;
import com.google.api.services.gamesManagement.model.AchievementResetMultipleForAllRequest;
import com.google.api.services.gamesManagement.model.AchievementResetResponse;
import com.google.api.services.gamesManagement.model.EventsResetMultipleForAllRequest;
import com.google.api.services.gamesManagement.model.HiddenPlayerList;
import com.google.api.services.gamesManagement.model.PlayerScoreResetAllResponse;
import com.google.api.services.gamesManagement.model.PlayerScoreResetResponse;
import com.google.api.services.gamesManagement.model.QuestsResetMultipleForAllRequest;
import com.google.api.services.gamesManagement.model.ScoresResetMultipleForAllRequest;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamesManagement
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "games/v1management/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/games/v1management/";

    public GamesManagement(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    GamesManagement(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Achievements achievements() {
        return new Achievements();
    }

    public Applications applications() {
        return new Applications();
    }

    public Events events() {
        return new Events();
    }

    public Players players() {
        return new Players();
    }

    public Quests quests() {
        return new Quests();
    }

    public Rooms rooms() {
        return new Rooms();
    }

    public Scores scores() {
        return new Scores();
    }

    public TurnBasedMatches turnBasedMatches() {
        return new TurnBasedMatches();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Play Game Services Management API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, GamesManagement.DEFAULT_ROOT_URL, GamesManagement.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public GamesManagement build() {
            return new GamesManagement(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setGamesManagementRequestInitializer(GamesManagementRequestInitializer gamesManagementRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)gamesManagementRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class TurnBasedMatches {
        public Reset reset() throws IOException {
            Reset reset = new Reset();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetForAllPlayers resetForAllPlayers() throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "turnbasedmatches/resetForAllPlayers";

            protected ResetForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "turnbasedmatches/reset";

            protected Reset() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }

    public class Scores {
        public Reset reset(String string) throws IOException {
            Reset reset = new Reset(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetAll resetAll() throws IOException {
            ResetAll resetAll = new ResetAll();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAll);
            return resetAll;
        }

        public ResetAllForAllPlayers resetAllForAllPlayers() throws IOException {
            ResetAllForAllPlayers resetAllForAllPlayers = new ResetAllForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAllForAllPlayers);
            return resetAllForAllPlayers;
        }

        public ResetForAllPlayers resetForAllPlayers(String string) throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        public ResetMultipleForAllPlayers resetMultipleForAllPlayers(ScoresResetMultipleForAllRequest scoresResetMultipleForAllRequest) throws IOException {
            ResetMultipleForAllPlayers resetMultipleForAllPlayers = new ResetMultipleForAllPlayers(scoresResetMultipleForAllRequest);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetMultipleForAllPlayers);
            return resetMultipleForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetMultipleForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "scores/resetMultipleForAllPlayers";

            protected ResetMultipleForAllPlayers(ScoresResetMultipleForAllRequest scoresResetMultipleForAllRequest) {
                super(GamesManagement.this, "POST", REST_PATH, (Object)scoresResetMultipleForAllRequest, Void.class);
            }

            public ResetMultipleForAllPlayers setAlt(String string) {
                return (ResetMultipleForAllPlayers)super.setAlt(string);
            }

            public ResetMultipleForAllPlayers setFields(String string) {
                return (ResetMultipleForAllPlayers)super.setFields(string);
            }

            public ResetMultipleForAllPlayers setKey(String string) {
                return (ResetMultipleForAllPlayers)super.setKey(string);
            }

            public ResetMultipleForAllPlayers setOauthToken(String string) {
                return (ResetMultipleForAllPlayers)super.setOauthToken(string);
            }

            public ResetMultipleForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetMultipleForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetMultipleForAllPlayers setQuotaUser(String string) {
                return (ResetMultipleForAllPlayers)super.setQuotaUser(string);
            }

            public ResetMultipleForAllPlayers setUserIp(String string) {
                return (ResetMultipleForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetMultipleForAllPlayers set(String string, Object object) {
                return (ResetMultipleForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/resetForAllPlayers";
            @Key
            private String leaderboardId;

            protected ResetForAllPlayers(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public ResetForAllPlayers setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAllForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "scores/resetAllForAllPlayers";

            protected ResetAllForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAllForAllPlayers setAlt(String string) {
                return (ResetAllForAllPlayers)super.setAlt(string);
            }

            public ResetAllForAllPlayers setFields(String string) {
                return (ResetAllForAllPlayers)super.setFields(string);
            }

            public ResetAllForAllPlayers setKey(String string) {
                return (ResetAllForAllPlayers)super.setKey(string);
            }

            public ResetAllForAllPlayers setOauthToken(String string) {
                return (ResetAllForAllPlayers)super.setOauthToken(string);
            }

            public ResetAllForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetAllForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetAllForAllPlayers setQuotaUser(String string) {
                return (ResetAllForAllPlayers)super.setQuotaUser(string);
            }

            public ResetAllForAllPlayers setUserIp(String string) {
                return (ResetAllForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetAllForAllPlayers set(String string, Object object) {
                return (ResetAllForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAll
        extends GamesManagementRequest<PlayerScoreResetAllResponse> {
            private static final String REST_PATH = "scores/reset";

            protected ResetAll() {
                super(GamesManagement.this, "POST", REST_PATH, null, PlayerScoreResetAllResponse.class);
            }

            public ResetAll setAlt(String string) {
                return (ResetAll)super.setAlt(string);
            }

            public ResetAll setFields(String string) {
                return (ResetAll)super.setFields(string);
            }

            public ResetAll setKey(String string) {
                return (ResetAll)super.setKey(string);
            }

            public ResetAll setOauthToken(String string) {
                return (ResetAll)super.setOauthToken(string);
            }

            public ResetAll setPrettyPrint(Boolean bl) {
                return (ResetAll)super.setPrettyPrint(bl);
            }

            public ResetAll setQuotaUser(String string) {
                return (ResetAll)super.setQuotaUser(string);
            }

            public ResetAll setUserIp(String string) {
                return (ResetAll)super.setUserIp(string);
            }

            @Override
            public ResetAll set(String string, Object object) {
                return (ResetAll)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<PlayerScoreResetResponse> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/reset";
            @Key
            private String leaderboardId;

            protected Reset(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, PlayerScoreResetResponse.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Reset setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }

    public class Rooms {
        public Reset reset() throws IOException {
            Reset reset = new Reset();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetForAllPlayers resetForAllPlayers() throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "rooms/resetForAllPlayers";

            protected ResetForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "rooms/reset";

            protected Reset() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }

    public class Quests {
        public Reset reset(String string) throws IOException {
            Reset reset = new Reset(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetAll resetAll() throws IOException {
            ResetAll resetAll = new ResetAll();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAll);
            return resetAll;
        }

        public ResetAllForAllPlayers resetAllForAllPlayers() throws IOException {
            ResetAllForAllPlayers resetAllForAllPlayers = new ResetAllForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAllForAllPlayers);
            return resetAllForAllPlayers;
        }

        public ResetForAllPlayers resetForAllPlayers(String string) throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        public ResetMultipleForAllPlayers resetMultipleForAllPlayers(QuestsResetMultipleForAllRequest questsResetMultipleForAllRequest) throws IOException {
            ResetMultipleForAllPlayers resetMultipleForAllPlayers = new ResetMultipleForAllPlayers(questsResetMultipleForAllRequest);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetMultipleForAllPlayers);
            return resetMultipleForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetMultipleForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "quests/resetMultipleForAllPlayers";

            protected ResetMultipleForAllPlayers(QuestsResetMultipleForAllRequest questsResetMultipleForAllRequest) {
                super(GamesManagement.this, "POST", REST_PATH, (Object)questsResetMultipleForAllRequest, Void.class);
            }

            public ResetMultipleForAllPlayers setAlt(String string) {
                return (ResetMultipleForAllPlayers)super.setAlt(string);
            }

            public ResetMultipleForAllPlayers setFields(String string) {
                return (ResetMultipleForAllPlayers)super.setFields(string);
            }

            public ResetMultipleForAllPlayers setKey(String string) {
                return (ResetMultipleForAllPlayers)super.setKey(string);
            }

            public ResetMultipleForAllPlayers setOauthToken(String string) {
                return (ResetMultipleForAllPlayers)super.setOauthToken(string);
            }

            public ResetMultipleForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetMultipleForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetMultipleForAllPlayers setQuotaUser(String string) {
                return (ResetMultipleForAllPlayers)super.setQuotaUser(string);
            }

            public ResetMultipleForAllPlayers setUserIp(String string) {
                return (ResetMultipleForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetMultipleForAllPlayers set(String string, Object object) {
                return (ResetMultipleForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "quests/{questId}/resetForAllPlayers";
            @Key
            private String questId;

            protected ResetForAllPlayers(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.questId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter questId must be specified.");
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            public String getQuestId() {
                return this.questId;
            }

            public ResetForAllPlayers setQuestId(String string) {
                this.questId = string;
                return this;
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAllForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "quests/resetAllForAllPlayers";

            protected ResetAllForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAllForAllPlayers setAlt(String string) {
                return (ResetAllForAllPlayers)super.setAlt(string);
            }

            public ResetAllForAllPlayers setFields(String string) {
                return (ResetAllForAllPlayers)super.setFields(string);
            }

            public ResetAllForAllPlayers setKey(String string) {
                return (ResetAllForAllPlayers)super.setKey(string);
            }

            public ResetAllForAllPlayers setOauthToken(String string) {
                return (ResetAllForAllPlayers)super.setOauthToken(string);
            }

            public ResetAllForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetAllForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetAllForAllPlayers setQuotaUser(String string) {
                return (ResetAllForAllPlayers)super.setQuotaUser(string);
            }

            public ResetAllForAllPlayers setUserIp(String string) {
                return (ResetAllForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetAllForAllPlayers set(String string, Object object) {
                return (ResetAllForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAll
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "quests/reset";

            protected ResetAll() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAll setAlt(String string) {
                return (ResetAll)super.setAlt(string);
            }

            public ResetAll setFields(String string) {
                return (ResetAll)super.setFields(string);
            }

            public ResetAll setKey(String string) {
                return (ResetAll)super.setKey(string);
            }

            public ResetAll setOauthToken(String string) {
                return (ResetAll)super.setOauthToken(string);
            }

            public ResetAll setPrettyPrint(Boolean bl) {
                return (ResetAll)super.setPrettyPrint(bl);
            }

            public ResetAll setQuotaUser(String string) {
                return (ResetAll)super.setQuotaUser(string);
            }

            public ResetAll setUserIp(String string) {
                return (ResetAll)super.setUserIp(string);
            }

            @Override
            public ResetAll set(String string, Object object) {
                return (ResetAll)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "quests/{questId}/reset";
            @Key
            private String questId;

            protected Reset(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.questId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter questId must be specified.");
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getQuestId() {
                return this.questId;
            }

            public Reset setQuestId(String string) {
                this.questId = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }

    public class Players {
        public Hide hide(String string, String string2) throws IOException {
            Hide hide = new Hide(string, string2);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)hide);
            return hide;
        }

        public Unhide unhide(String string, String string2) throws IOException {
            Unhide unhide = new Unhide(string, string2);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)unhide);
            return unhide;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Unhide
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "applications/{applicationId}/players/hidden/{playerId}";
            @Key
            private String applicationId;
            @Key
            private String playerId;

            protected Unhide(String string, String string2) {
                super(GamesManagement.this, "DELETE", REST_PATH, null, Void.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter applicationId must be specified.");
                this.playerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter playerId must be specified.");
            }

            public Unhide setAlt(String string) {
                return (Unhide)super.setAlt(string);
            }

            public Unhide setFields(String string) {
                return (Unhide)super.setFields(string);
            }

            public Unhide setKey(String string) {
                return (Unhide)super.setKey(string);
            }

            public Unhide setOauthToken(String string) {
                return (Unhide)super.setOauthToken(string);
            }

            public Unhide setPrettyPrint(Boolean bl) {
                return (Unhide)super.setPrettyPrint(bl);
            }

            public Unhide setQuotaUser(String string) {
                return (Unhide)super.setQuotaUser(string);
            }

            public Unhide setUserIp(String string) {
                return (Unhide)super.setUserIp(string);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public Unhide setApplicationId(String string) {
                this.applicationId = string;
                return this;
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Unhide setPlayerId(String string) {
                this.playerId = string;
                return this;
            }

            @Override
            public Unhide set(String string, Object object) {
                return (Unhide)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Hide
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "applications/{applicationId}/players/hidden/{playerId}";
            @Key
            private String applicationId;
            @Key
            private String playerId;

            protected Hide(String string, String string2) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter applicationId must be specified.");
                this.playerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter playerId must be specified.");
            }

            public Hide setAlt(String string) {
                return (Hide)super.setAlt(string);
            }

            public Hide setFields(String string) {
                return (Hide)super.setFields(string);
            }

            public Hide setKey(String string) {
                return (Hide)super.setKey(string);
            }

            public Hide setOauthToken(String string) {
                return (Hide)super.setOauthToken(string);
            }

            public Hide setPrettyPrint(Boolean bl) {
                return (Hide)super.setPrettyPrint(bl);
            }

            public Hide setQuotaUser(String string) {
                return (Hide)super.setQuotaUser(string);
            }

            public Hide setUserIp(String string) {
                return (Hide)super.setUserIp(string);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public Hide setApplicationId(String string) {
                this.applicationId = string;
                return this;
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Hide setPlayerId(String string) {
                this.playerId = string;
                return this;
            }

            @Override
            public Hide set(String string, Object object) {
                return (Hide)super.set(string, object);
            }
        }
    }

    public class Events {
        public Reset reset(String string) throws IOException {
            Reset reset = new Reset(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetAll resetAll() throws IOException {
            ResetAll resetAll = new ResetAll();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAll);
            return resetAll;
        }

        public ResetAllForAllPlayers resetAllForAllPlayers() throws IOException {
            ResetAllForAllPlayers resetAllForAllPlayers = new ResetAllForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAllForAllPlayers);
            return resetAllForAllPlayers;
        }

        public ResetForAllPlayers resetForAllPlayers(String string) throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        public ResetMultipleForAllPlayers resetMultipleForAllPlayers(EventsResetMultipleForAllRequest eventsResetMultipleForAllRequest) throws IOException {
            ResetMultipleForAllPlayers resetMultipleForAllPlayers = new ResetMultipleForAllPlayers(eventsResetMultipleForAllRequest);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetMultipleForAllPlayers);
            return resetMultipleForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetMultipleForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "events/resetMultipleForAllPlayers";

            protected ResetMultipleForAllPlayers(EventsResetMultipleForAllRequest eventsResetMultipleForAllRequest) {
                super(GamesManagement.this, "POST", REST_PATH, (Object)eventsResetMultipleForAllRequest, Void.class);
            }

            public ResetMultipleForAllPlayers setAlt(String string) {
                return (ResetMultipleForAllPlayers)super.setAlt(string);
            }

            public ResetMultipleForAllPlayers setFields(String string) {
                return (ResetMultipleForAllPlayers)super.setFields(string);
            }

            public ResetMultipleForAllPlayers setKey(String string) {
                return (ResetMultipleForAllPlayers)super.setKey(string);
            }

            public ResetMultipleForAllPlayers setOauthToken(String string) {
                return (ResetMultipleForAllPlayers)super.setOauthToken(string);
            }

            public ResetMultipleForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetMultipleForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetMultipleForAllPlayers setQuotaUser(String string) {
                return (ResetMultipleForAllPlayers)super.setQuotaUser(string);
            }

            public ResetMultipleForAllPlayers setUserIp(String string) {
                return (ResetMultipleForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetMultipleForAllPlayers set(String string, Object object) {
                return (ResetMultipleForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "events/{eventId}/resetForAllPlayers";
            @Key
            private String eventId;

            protected ResetForAllPlayers(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.eventId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter eventId must be specified.");
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            public String getEventId() {
                return this.eventId;
            }

            public ResetForAllPlayers setEventId(String string) {
                this.eventId = string;
                return this;
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAllForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "events/resetAllForAllPlayers";

            protected ResetAllForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAllForAllPlayers setAlt(String string) {
                return (ResetAllForAllPlayers)super.setAlt(string);
            }

            public ResetAllForAllPlayers setFields(String string) {
                return (ResetAllForAllPlayers)super.setFields(string);
            }

            public ResetAllForAllPlayers setKey(String string) {
                return (ResetAllForAllPlayers)super.setKey(string);
            }

            public ResetAllForAllPlayers setOauthToken(String string) {
                return (ResetAllForAllPlayers)super.setOauthToken(string);
            }

            public ResetAllForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetAllForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetAllForAllPlayers setQuotaUser(String string) {
                return (ResetAllForAllPlayers)super.setQuotaUser(string);
            }

            public ResetAllForAllPlayers setUserIp(String string) {
                return (ResetAllForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetAllForAllPlayers set(String string, Object object) {
                return (ResetAllForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAll
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "events/reset";

            protected ResetAll() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAll setAlt(String string) {
                return (ResetAll)super.setAlt(string);
            }

            public ResetAll setFields(String string) {
                return (ResetAll)super.setFields(string);
            }

            public ResetAll setKey(String string) {
                return (ResetAll)super.setKey(string);
            }

            public ResetAll setOauthToken(String string) {
                return (ResetAll)super.setOauthToken(string);
            }

            public ResetAll setPrettyPrint(Boolean bl) {
                return (ResetAll)super.setPrettyPrint(bl);
            }

            public ResetAll setQuotaUser(String string) {
                return (ResetAll)super.setQuotaUser(string);
            }

            public ResetAll setUserIp(String string) {
                return (ResetAll)super.setUserIp(string);
            }

            @Override
            public ResetAll set(String string, Object object) {
                return (ResetAll)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "events/{eventId}/reset";
            @Key
            private String eventId;

            protected Reset(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.eventId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter eventId must be specified.");
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getEventId() {
                return this.eventId;
            }

            public Reset setEventId(String string) {
                this.eventId = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }

    public class Applications {
        public ListHidden listHidden(String string) throws IOException {
            ListHidden listHidden = new ListHidden(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)listHidden);
            return listHidden;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListHidden
        extends GamesManagementRequest<HiddenPlayerList> {
            private static final String REST_PATH = "applications/{applicationId}/players/hidden";
            @Key
            private String applicationId;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListHidden(String string) {
                super(GamesManagement.this, "GET", REST_PATH, null, HiddenPlayerList.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter applicationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListHidden setAlt(String string) {
                return (ListHidden)super.setAlt(string);
            }

            public ListHidden setFields(String string) {
                return (ListHidden)super.setFields(string);
            }

            public ListHidden setKey(String string) {
                return (ListHidden)super.setKey(string);
            }

            public ListHidden setOauthToken(String string) {
                return (ListHidden)super.setOauthToken(string);
            }

            public ListHidden setPrettyPrint(Boolean bl) {
                return (ListHidden)super.setPrettyPrint(bl);
            }

            public ListHidden setQuotaUser(String string) {
                return (ListHidden)super.setQuotaUser(string);
            }

            public ListHidden setUserIp(String string) {
                return (ListHidden)super.setUserIp(string);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public ListHidden setApplicationId(String string) {
                this.applicationId = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListHidden setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListHidden setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public ListHidden set(String string, Object object) {
                return (ListHidden)super.set(string, object);
            }
        }
    }

    public class Achievements {
        public Reset reset(String string) throws IOException {
            Reset reset = new Reset(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public ResetAll resetAll() throws IOException {
            ResetAll resetAll = new ResetAll();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAll);
            return resetAll;
        }

        public ResetAllForAllPlayers resetAllForAllPlayers() throws IOException {
            ResetAllForAllPlayers resetAllForAllPlayers = new ResetAllForAllPlayers();
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetAllForAllPlayers);
            return resetAllForAllPlayers;
        }

        public ResetForAllPlayers resetForAllPlayers(String string) throws IOException {
            ResetForAllPlayers resetForAllPlayers = new ResetForAllPlayers(string);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetForAllPlayers);
            return resetForAllPlayers;
        }

        public ResetMultipleForAllPlayers resetMultipleForAllPlayers(AchievementResetMultipleForAllRequest achievementResetMultipleForAllRequest) throws IOException {
            ResetMultipleForAllPlayers resetMultipleForAllPlayers = new ResetMultipleForAllPlayers(achievementResetMultipleForAllRequest);
            GamesManagement.this.initialize((AbstractGoogleClientRequest<?>)resetMultipleForAllPlayers);
            return resetMultipleForAllPlayers;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetMultipleForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "achievements/resetMultipleForAllPlayers";

            protected ResetMultipleForAllPlayers(AchievementResetMultipleForAllRequest achievementResetMultipleForAllRequest) {
                super(GamesManagement.this, "POST", REST_PATH, (Object)achievementResetMultipleForAllRequest, Void.class);
            }

            public ResetMultipleForAllPlayers setAlt(String string) {
                return (ResetMultipleForAllPlayers)super.setAlt(string);
            }

            public ResetMultipleForAllPlayers setFields(String string) {
                return (ResetMultipleForAllPlayers)super.setFields(string);
            }

            public ResetMultipleForAllPlayers setKey(String string) {
                return (ResetMultipleForAllPlayers)super.setKey(string);
            }

            public ResetMultipleForAllPlayers setOauthToken(String string) {
                return (ResetMultipleForAllPlayers)super.setOauthToken(string);
            }

            public ResetMultipleForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetMultipleForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetMultipleForAllPlayers setQuotaUser(String string) {
                return (ResetMultipleForAllPlayers)super.setQuotaUser(string);
            }

            public ResetMultipleForAllPlayers setUserIp(String string) {
                return (ResetMultipleForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetMultipleForAllPlayers set(String string, Object object) {
                return (ResetMultipleForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "achievements/{achievementId}/resetForAllPlayers";
            @Key
            private String achievementId;

            protected ResetForAllPlayers(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter achievementId must be specified.");
            }

            public ResetForAllPlayers setAlt(String string) {
                return (ResetForAllPlayers)super.setAlt(string);
            }

            public ResetForAllPlayers setFields(String string) {
                return (ResetForAllPlayers)super.setFields(string);
            }

            public ResetForAllPlayers setKey(String string) {
                return (ResetForAllPlayers)super.setKey(string);
            }

            public ResetForAllPlayers setOauthToken(String string) {
                return (ResetForAllPlayers)super.setOauthToken(string);
            }

            public ResetForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetForAllPlayers setQuotaUser(String string) {
                return (ResetForAllPlayers)super.setQuotaUser(string);
            }

            public ResetForAllPlayers setUserIp(String string) {
                return (ResetForAllPlayers)super.setUserIp(string);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public ResetForAllPlayers setAchievementId(String string) {
                this.achievementId = string;
                return this;
            }

            @Override
            public ResetForAllPlayers set(String string, Object object) {
                return (ResetForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAllForAllPlayers
        extends GamesManagementRequest<Void> {
            private static final String REST_PATH = "achievements/resetAllForAllPlayers";

            protected ResetAllForAllPlayers() {
                super(GamesManagement.this, "POST", REST_PATH, null, Void.class);
            }

            public ResetAllForAllPlayers setAlt(String string) {
                return (ResetAllForAllPlayers)super.setAlt(string);
            }

            public ResetAllForAllPlayers setFields(String string) {
                return (ResetAllForAllPlayers)super.setFields(string);
            }

            public ResetAllForAllPlayers setKey(String string) {
                return (ResetAllForAllPlayers)super.setKey(string);
            }

            public ResetAllForAllPlayers setOauthToken(String string) {
                return (ResetAllForAllPlayers)super.setOauthToken(string);
            }

            public ResetAllForAllPlayers setPrettyPrint(Boolean bl) {
                return (ResetAllForAllPlayers)super.setPrettyPrint(bl);
            }

            public ResetAllForAllPlayers setQuotaUser(String string) {
                return (ResetAllForAllPlayers)super.setQuotaUser(string);
            }

            public ResetAllForAllPlayers setUserIp(String string) {
                return (ResetAllForAllPlayers)super.setUserIp(string);
            }

            @Override
            public ResetAllForAllPlayers set(String string, Object object) {
                return (ResetAllForAllPlayers)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResetAll
        extends GamesManagementRequest<AchievementResetAllResponse> {
            private static final String REST_PATH = "achievements/reset";

            protected ResetAll() {
                super(GamesManagement.this, "POST", REST_PATH, null, AchievementResetAllResponse.class);
            }

            public ResetAll setAlt(String string) {
                return (ResetAll)super.setAlt(string);
            }

            public ResetAll setFields(String string) {
                return (ResetAll)super.setFields(string);
            }

            public ResetAll setKey(String string) {
                return (ResetAll)super.setKey(string);
            }

            public ResetAll setOauthToken(String string) {
                return (ResetAll)super.setOauthToken(string);
            }

            public ResetAll setPrettyPrint(Boolean bl) {
                return (ResetAll)super.setPrettyPrint(bl);
            }

            public ResetAll setQuotaUser(String string) {
                return (ResetAll)super.setQuotaUser(string);
            }

            public ResetAll setUserIp(String string) {
                return (ResetAll)super.setUserIp(string);
            }

            @Override
            public ResetAll set(String string, Object object) {
                return (ResetAll)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends GamesManagementRequest<AchievementResetResponse> {
            private static final String REST_PATH = "achievements/{achievementId}/reset";
            @Key
            private String achievementId;

            protected Reset(String string) {
                super(GamesManagement.this, "POST", REST_PATH, null, AchievementResetResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter achievementId must be specified.");
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Reset setAchievementId(String string) {
                this.achievementId = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }
    }
}

