/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmailpostmastertools.v1;

/**
 * Service definition for PostmasterTools (v1).
 *
 * <p>
 * The Postmaster Tools API is a RESTful API that provides programmatic access to email traffic metrics (like spam reports, delivery errors etc) otherwise available through the Gmail Postmaster Tools UI currently.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/gmail/postmaster" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PostmasterToolsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class PostmasterTools extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Gmail Postmaster Tools API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://gmailpostmastertools.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://gmailpostmastertools.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public PostmasterTools(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  PostmasterTools(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Domains collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code PostmasterTools gmailpostmastertools = new PostmasterTools(...);}
   *   {@code PostmasterTools.Domains.List request = gmailpostmastertools.domains().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Domains domains() {
    return new Domains();
  }

  /**
   * The "domains" collection of methods.
   */
  public class Domains {

    /**
     * Gets a specific domain registered by the client. Returns NOT_FOUND if the domain does not exist.
     *
     * Create a request for the method "domains.get".
     *
     * This request holds the parameters needed by the gmailpostmastertools server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The resource name of the domain. It should have the form `domains/{domain_name}`, where domain_name
     *        is the fully qualified domain name.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends PostmasterToolsRequest<com.google.api.services.gmailpostmastertools.v1.model.Domain> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^domains/[^/]+$");

      /**
       * Gets a specific domain registered by the client. Returns NOT_FOUND if the domain does not
       * exist.
       *
       * Create a request for the method "domains.get".
       *
       * This request holds the parameters needed by the the gmailpostmastertools server.  After setting
       * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       * <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The resource name of the domain. It should have the form `domains/{domain_name}`, where domain_name
     *        is the fully qualified domain name.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(PostmasterTools.this, "GET", REST_PATH, null, com.google.api.services.gmailpostmastertools.v1.model.Domain.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^domains/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The resource name of the domain. It should have the form `domains/{domain_name}`, where
       * domain_name is the fully qualified domain name.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The resource name of the domain. It should have the form `domains/{domain_name}`, where domain_name
     is the fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * The resource name of the domain. It should have the form `domains/{domain_name}`, where
       * domain_name is the fully qualified domain name.
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^domains/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the domains that have been registered by the client. The order of domains in the response
     * is unspecified and non-deterministic. Newly created domains will not necessarily be added to the
     * end of this list.
     *
     * Create a request for the method "domains.list".
     *
     * This request holds the parameters needed by the gmailpostmastertools server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends PostmasterToolsRequest<com.google.api.services.gmailpostmastertools.v1.model.ListDomainsResponse> {

      private static final String REST_PATH = "v1/domains";

      /**
       * Lists the domains that have been registered by the client. The order of domains in the response
       * is unspecified and non-deterministic. Newly created domains will not necessarily be added to
       * the end of this list.
       *
       * Create a request for the method "domains.list".
       *
       * This request holds the parameters needed by the the gmailpostmastertools server.  After setting
       * any optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       * <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(PostmasterTools.this, "GET", REST_PATH, null, com.google.api.services.gmailpostmastertools.v1.model.ListDomainsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Requested page size. Server may return fewer domains than requested. If unspecified, server
       * will pick an appropriate default.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Requested page size. Server may return fewer domains than requested. If unspecified, server will
     pick an appropriate default.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Requested page size. Server may return fewer domains than requested. If unspecified, server
       * will pick an appropriate default.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The next_page_token value returned from a previous List request, if any. This is the value
       * of ListDomainsResponse.next_page_token returned from the previous call to `ListDomains`
       * method.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The next_page_token value returned from a previous List request, if any. This is the value of
     ListDomainsResponse.next_page_token returned from the previous call to `ListDomains` method.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The next_page_token value returned from a previous List request, if any. This is the value
       * of ListDomainsResponse.next_page_token returned from the previous call to `ListDomains`
       * method.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the TrafficStats collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code PostmasterTools gmailpostmastertools = new PostmasterTools(...);}
     *   {@code PostmasterTools.TrafficStats.List request = gmailpostmastertools.trafficStats().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public TrafficStats trafficStats() {
      return new TrafficStats();
    }

    /**
     * The "trafficStats" collection of methods.
     */
    public class TrafficStats {

      /**
       * Get traffic statistics for a domain on a specific date. Returns PERMISSION_DENIED if user does
       * not have permission to access TrafficStats for the domain.
       *
       * Create a request for the method "trafficStats.get".
       *
       * This request holds the parameters needed by the gmailpostmastertools server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the traffic statistics to get. E.g.,
       *        domains/mymail.mydomain.com/trafficStats/20160807.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PostmasterToolsRequest<com.google.api.services.gmailpostmastertools.v1.model.TrafficStats> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^domains/[^/]+/trafficStats/[^/]+$");

        /**
         * Get traffic statistics for a domain on a specific date. Returns PERMISSION_DENIED if user does
         * not have permission to access TrafficStats for the domain.
         *
         * Create a request for the method "trafficStats.get".
         *
         * This request holds the parameters needed by the the gmailpostmastertools server.  After setting
         * any optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
         * <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the traffic statistics to get. E.g.,
       *        domains/mymail.mydomain.com/trafficStats/20160807.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(PostmasterTools.this, "GET", REST_PATH, null, com.google.api.services.gmailpostmastertools.v1.model.TrafficStats.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^domains/[^/]+/trafficStats/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the traffic statistics to get. E.g.,
         * domains/mymail.mydomain.com/trafficStats/20160807.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the traffic statistics to get. E.g.,
       domains/mymail.mydomain.com/trafficStats/20160807.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the traffic statistics to get. E.g.,
         * domains/mymail.mydomain.com/trafficStats/20160807.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^domains/[^/]+/trafficStats/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * List traffic statistics for all available days. Returns PERMISSION_DENIED if user does not have
       * permission to access TrafficStats for the domain.
       *
       * Create a request for the method "trafficStats.list".
       *
       * This request holds the parameters needed by the gmailpostmastertools server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The resource name of the domain whose traffic statistics we'd like to list. It should have the form
       *        `domains/{domain_name}`, where domain_name is the fully qualified domain name.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends PostmasterToolsRequest<com.google.api.services.gmailpostmastertools.v1.model.ListTrafficStatsResponse> {

        private static final String REST_PATH = "v1/{+parent}/trafficStats";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^domains/[^/]+$");

        /**
         * List traffic statistics for all available days. Returns PERMISSION_DENIED if user does not have
         * permission to access TrafficStats for the domain.
         *
         * Create a request for the method "trafficStats.list".
         *
         * This request holds the parameters needed by the the gmailpostmastertools server.  After setting
         * any optional parameters, call the {@link List#execute()} method to invoke the remote operation.
         * <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The resource name of the domain whose traffic statistics we'd like to list. It should have the form
       *        `domains/{domain_name}`, where domain_name is the fully qualified domain name.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(PostmasterTools.this, "GET", REST_PATH, null, com.google.api.services.gmailpostmastertools.v1.model.ListTrafficStatsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^domains/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the domain whose traffic statistics we'd like to list. It should
         * have the form `domains/{domain_name}`, where domain_name is the fully qualified domain
         * name.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The resource name of the domain whose traffic statistics we'd like to list. It should have the form
       `domains/{domain_name}`, where domain_name is the fully qualified domain name.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The resource name of the domain whose traffic statistics we'd like to list. It should
         * have the form `domains/{domain_name}`, where domain_name is the fully qualified domain
         * name.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^domains/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a
         * year by itself or a year and month where the day isn't significant.
         */
        @com.google.api.client.util.Key("endDate.day")
        private java.lang.Integer endDateDay;

        /** Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by
       itself or a year and month where the day isn't significant.
         */
        public java.lang.Integer getEndDateDay() {
          return endDateDay;
        }

        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a
         * year by itself or a year and month where the day isn't significant.
         */
        public List setEndDateDay(java.lang.Integer endDateDay) {
          this.endDateDay = endDateDay;
          return this;
        }

        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        @com.google.api.client.util.Key("endDate.month")
        private java.lang.Integer endDateMonth;

        /** Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        public java.lang.Integer getEndDateMonth() {
          return endDateMonth;
        }

        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        public List setEndDateMonth(java.lang.Integer endDateMonth) {
          this.endDateMonth = endDateMonth;
          return this;
        }

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year. */
        @com.google.api.client.util.Key("endDate.year")
        private java.lang.Integer endDateYear;

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        public java.lang.Integer getEndDateYear() {
          return endDateYear;
        }

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year. */
        public List setEndDateYear(java.lang.Integer endDateYear) {
          this.endDateYear = endDateYear;
          return this;
        }

        /**
         * Requested page size. Server may return fewer TrafficStats than requested. If unspecified,
         * server will pick an appropriate default.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Requested page size. Server may return fewer TrafficStats than requested. If unspecified, server
       will pick an appropriate default.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Requested page size. Server may return fewer TrafficStats than requested. If unspecified,
         * server will pick an appropriate default.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * The next_page_token value returned from a previous List request, if any. This is the
         * value of ListTrafficStatsResponse.next_page_token returned from the previous call to
         * `ListTrafficStats` method.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The next_page_token value returned from a previous List request, if any. This is the value of
       ListTrafficStatsResponse.next_page_token returned from the previous call to `ListTrafficStats`
       method.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The next_page_token value returned from a previous List request, if any. This is the
         * value of ListTrafficStatsResponse.next_page_token returned from the previous call to
         * `ListTrafficStats` method.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a
         * year by itself or a year and month where the day isn't significant.
         */
        @com.google.api.client.util.Key("startDate.day")
        private java.lang.Integer startDateDay;

        /** Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by
       itself or a year and month where the day isn't significant.
         */
        public java.lang.Integer getStartDateDay() {
          return startDateDay;
        }

        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a
         * year by itself or a year and month where the day isn't significant.
         */
        public List setStartDateDay(java.lang.Integer startDateDay) {
          this.startDateDay = startDateDay;
          return this;
        }

        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        @com.google.api.client.util.Key("startDate.month")
        private java.lang.Integer startDateMonth;

        /** Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        public java.lang.Integer getStartDateMonth() {
          return startDateMonth;
        }

        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        public List setStartDateMonth(java.lang.Integer startDateMonth) {
          this.startDateMonth = startDateMonth;
          return this;
        }

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year. */
        @com.google.api.client.util.Key("startDate.year")
        private java.lang.Integer startDateYear;

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        public java.lang.Integer getStartDateYear() {
          return startDateYear;
        }

        /** Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year. */
        public List setStartDateYear(java.lang.Integer startDateYear) {
          this.startDateYear = startDateYear;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link PostmasterTools}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link PostmasterTools}. */
    @Override
    public PostmasterTools build() {
      return new PostmasterTools(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PostmasterToolsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPostmasterToolsRequestInitializer(
        PostmasterToolsRequestInitializer postmastertoolsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(postmastertoolsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
