/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmailpostmastertools.v1.model;

/**
 * A registered domain resource in the Postmaster API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail Postmaster Tools API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Domain extends com.google.api.client.json.GenericJson {

  /**
   * Timestamp when the user registered this domain. Assigned by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The resource name of the Domain. Domain names have the form `domains/{domain_name}`, where
   * domain_name is the fully qualified domain name (i.e., mymail.mydomain.com).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * User’s permission for this domain. Assigned by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permission;

  /**
   * Timestamp when the user registered this domain. Assigned by the server.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Timestamp when the user registered this domain. Assigned by the server.
   * @param createTime createTime or {@code null} for none
   */
  public Domain setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The resource name of the Domain. Domain names have the form `domains/{domain_name}`, where
   * domain_name is the fully qualified domain name (i.e., mymail.mydomain.com).
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the Domain. Domain names have the form `domains/{domain_name}`, where
   * domain_name is the fully qualified domain name (i.e., mymail.mydomain.com).
   * @param name name or {@code null} for none
   */
  public Domain setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * User’s permission for this domain. Assigned by the server.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermission() {
    return permission;
  }

  /**
   * User’s permission for this domain. Assigned by the server.
   * @param permission permission or {@code null} for none
   */
  public Domain setPermission(java.lang.String permission) {
    this.permission = permission;
    return this;
  }

  @Override
  public Domain set(String fieldName, Object value) {
    return (Domain) super.set(fieldName, value);
  }

  @Override
  public Domain clone() {
    return (Domain) super.clone();
  }

}
