/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmailpostmastertools.v1.model;

/**
 * [Feedback loop](https://support.google.com/mail/answer/6254652) identifier information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail Postmaster Tools API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FeedbackLoop extends com.google.api.client.json.GenericJson {

  /**
   * Feedback loop identifier that uniquely identifies individual campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The ratio of user marked spam messages with the identifier vs the total number of inboxed
   * messages with that identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double spamRatio;

  /**
   * Feedback loop identifier that uniquely identifies individual campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Feedback loop identifier that uniquely identifies individual campaigns.
   * @param id id or {@code null} for none
   */
  public FeedbackLoop setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The ratio of user marked spam messages with the identifier vs the total number of inboxed
   * messages with that identifier.
   * @return value or {@code null} for none
   */
  public java.lang.Double getSpamRatio() {
    return spamRatio;
  }

  /**
   * The ratio of user marked spam messages with the identifier vs the total number of inboxed
   * messages with that identifier.
   * @param spamRatio spamRatio or {@code null} for none
   */
  public FeedbackLoop setSpamRatio(java.lang.Double spamRatio) {
    this.spamRatio = spamRatio;
    return this;
  }

  @Override
  public FeedbackLoop set(String fieldName, Object value) {
    return (FeedbackLoop) super.set(fieldName, value);
  }

  @Override
  public FeedbackLoop clone() {
    return (FeedbackLoop) super.clone();
  }

}
