/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmailpostmastertools.v1.model;

/**
 * IP Reputation information for a set of IPs in a specific reputation category.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail Postmaster Tools API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IpReputation extends com.google.api.client.json.GenericJson {

  /**
   * Total number of unique IPs in this reputation category. This metric only pertains to traffic
   * that passed [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long ipCount;

  /**
   * The reputation category this IP reputation represents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reputation;

  /**
   * A sample of IPs in this reputation category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sampleIps;

  /**
   * Total number of unique IPs in this reputation category. This metric only pertains to traffic
   * that passed [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Long getIpCount() {
    return ipCount;
  }

  /**
   * Total number of unique IPs in this reputation category. This metric only pertains to traffic
   * that passed [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @param ipCount ipCount or {@code null} for none
   */
  public IpReputation setIpCount(java.lang.Long ipCount) {
    this.ipCount = ipCount;
    return this;
  }

  /**
   * The reputation category this IP reputation represents.
   * @return value or {@code null} for none
   */
  public java.lang.String getReputation() {
    return reputation;
  }

  /**
   * The reputation category this IP reputation represents.
   * @param reputation reputation or {@code null} for none
   */
  public IpReputation setReputation(java.lang.String reputation) {
    this.reputation = reputation;
    return this;
  }

  /**
   * A sample of IPs in this reputation category.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSampleIps() {
    return sampleIps;
  }

  /**
   * A sample of IPs in this reputation category.
   * @param sampleIps sampleIps or {@code null} for none
   */
  public IpReputation setSampleIps(java.util.List<java.lang.String> sampleIps) {
    this.sampleIps = sampleIps;
    return this;
  }

  @Override
  public IpReputation set(String fieldName, Object value) {
    return (IpReputation) super.set(fieldName, value);
  }

  @Override
  public IpReputation clone() {
    return (IpReputation) super.clone();
  }

}
