/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmailpostmastertools.v1.model;

/**
 * Email traffic statistics pertaining to a specific date.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail Postmaster Tools API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrafficStats extends com.google.api.client.json.GenericJson {

  /**
   * Delivery errors for the domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DeliveryError> deliveryErrors;

  static {
    // hack to force ProGuard to consider DeliveryError used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DeliveryError.class);
  }

  /**
   * The ratio of mail that successfully authenticated with DKIM vs. all mail that attempted to
   * authenticate with [DKIM](http://www.dkim.org/). Spoofed mail is excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double dkimSuccessRatio;

  /**
   * The ratio of mail that passed [DMARC](https://dmarc.org/) alignment checks vs all mail received
   * from the domain that successfully authenticated with either of [SPF](http://www.openspf.org/)
   * or [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double dmarcSuccessRatio;

  /**
   * Reputation of the domain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domainReputation;

  /**
   * The ratio of incoming mail (to Gmail), that passed secure transport (TLS) vs all mail received
   * from that domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double inboundEncryptionRatio;

  /**
   * Reputation information pertaining to the IP addresses of the email servers for the domain.
   * There is exactly one entry for each reputation category except REPUTATION_CATEGORY_UNSPECIFIED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IpReputation> ipReputations;

  static {
    // hack to force ProGuard to consider IpReputation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IpReputation.class);
  }

  /**
   * The resource name of the traffic statistics. Traffic statistic names have the form
   * `domains/{domain}/trafficStats/{date}`, where domain_name is the fully qualified domain name
   * (i.e., mymail.mydomain.com) of the domain this traffic statistics pertains to and date is the
   * date in yyyymmdd format that these statistics corresponds to. For example:
   * domains/mymail.mydomain.com/trafficStats/20160807
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ratio of outgoing mail (from Gmail) that was accepted over secure transport (TLS).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double outboundEncryptionRatio;

  /**
   * Spammy [Feedback loop identifiers] (https://support.google.com/mail/answer/6254652) with their
   * individual spam rates. This metric only pertains to traffic that is authenticated by
   * [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FeedbackLoop> spammyFeedbackLoops;

  static {
    // hack to force ProGuard to consider FeedbackLoop used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FeedbackLoop.class);
  }

  /**
   * The ratio of mail that successfully authenticated with SPF vs. all mail that attempted to
   * authenticate with [SPF](http://www.openspf.org/). Spoofed mail is excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double spfSuccessRatio;

  /**
   * The ratio of user-report spam vs. email that was sent to the inbox. This is potentially inexact
   * -- users may want to refer to the description of the interval fields
   * userReportedSpamRatioLowerBound and userReportedSpamRatioUpperBound for more explicit accuracy
   * guarantees. This metric only pertains to emails authenticated by [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double userReportedSpamRatio;

  /**
   * The lower bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this lower bound and the
   * corresponding upper bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double userReportedSpamRatioLowerBound;

  /**
   * The upper bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this upper bound and the
   * corresponding lower bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double userReportedSpamRatioUpperBound;

  /**
   * Delivery errors for the domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.util.List<DeliveryError> getDeliveryErrors() {
    return deliveryErrors;
  }

  /**
   * Delivery errors for the domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @param deliveryErrors deliveryErrors or {@code null} for none
   */
  public TrafficStats setDeliveryErrors(java.util.List<DeliveryError> deliveryErrors) {
    this.deliveryErrors = deliveryErrors;
    return this;
  }

  /**
   * The ratio of mail that successfully authenticated with DKIM vs. all mail that attempted to
   * authenticate with [DKIM](http://www.dkim.org/). Spoofed mail is excluded.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDkimSuccessRatio() {
    return dkimSuccessRatio;
  }

  /**
   * The ratio of mail that successfully authenticated with DKIM vs. all mail that attempted to
   * authenticate with [DKIM](http://www.dkim.org/). Spoofed mail is excluded.
   * @param dkimSuccessRatio dkimSuccessRatio or {@code null} for none
   */
  public TrafficStats setDkimSuccessRatio(java.lang.Double dkimSuccessRatio) {
    this.dkimSuccessRatio = dkimSuccessRatio;
    return this;
  }

  /**
   * The ratio of mail that passed [DMARC](https://dmarc.org/) alignment checks vs all mail received
   * from the domain that successfully authenticated with either of [SPF](http://www.openspf.org/)
   * or [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Double getDmarcSuccessRatio() {
    return dmarcSuccessRatio;
  }

  /**
   * The ratio of mail that passed [DMARC](https://dmarc.org/) alignment checks vs all mail received
   * from the domain that successfully authenticated with either of [SPF](http://www.openspf.org/)
   * or [DKIM](http://www.dkim.org/).
   * @param dmarcSuccessRatio dmarcSuccessRatio or {@code null} for none
   */
  public TrafficStats setDmarcSuccessRatio(java.lang.Double dmarcSuccessRatio) {
    this.dmarcSuccessRatio = dmarcSuccessRatio;
    return this;
  }

  /**
   * Reputation of the domain.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomainReputation() {
    return domainReputation;
  }

  /**
   * Reputation of the domain.
   * @param domainReputation domainReputation or {@code null} for none
   */
  public TrafficStats setDomainReputation(java.lang.String domainReputation) {
    this.domainReputation = domainReputation;
    return this;
  }

  /**
   * The ratio of incoming mail (to Gmail), that passed secure transport (TLS) vs all mail received
   * from that domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Double getInboundEncryptionRatio() {
    return inboundEncryptionRatio;
  }

  /**
   * The ratio of incoming mail (to Gmail), that passed secure transport (TLS) vs all mail received
   * from that domain. This metric only pertains to traffic that passed
   * [SPF](http://www.openspf.org/) or [DKIM](http://www.dkim.org/).
   * @param inboundEncryptionRatio inboundEncryptionRatio or {@code null} for none
   */
  public TrafficStats setInboundEncryptionRatio(java.lang.Double inboundEncryptionRatio) {
    this.inboundEncryptionRatio = inboundEncryptionRatio;
    return this;
  }

  /**
   * Reputation information pertaining to the IP addresses of the email servers for the domain.
   * There is exactly one entry for each reputation category except REPUTATION_CATEGORY_UNSPECIFIED.
   * @return value or {@code null} for none
   */
  public java.util.List<IpReputation> getIpReputations() {
    return ipReputations;
  }

  /**
   * Reputation information pertaining to the IP addresses of the email servers for the domain.
   * There is exactly one entry for each reputation category except REPUTATION_CATEGORY_UNSPECIFIED.
   * @param ipReputations ipReputations or {@code null} for none
   */
  public TrafficStats setIpReputations(java.util.List<IpReputation> ipReputations) {
    this.ipReputations = ipReputations;
    return this;
  }

  /**
   * The resource name of the traffic statistics. Traffic statistic names have the form
   * `domains/{domain}/trafficStats/{date}`, where domain_name is the fully qualified domain name
   * (i.e., mymail.mydomain.com) of the domain this traffic statistics pertains to and date is the
   * date in yyyymmdd format that these statistics corresponds to. For example:
   * domains/mymail.mydomain.com/trafficStats/20160807
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the traffic statistics. Traffic statistic names have the form
   * `domains/{domain}/trafficStats/{date}`, where domain_name is the fully qualified domain name
   * (i.e., mymail.mydomain.com) of the domain this traffic statistics pertains to and date is the
   * date in yyyymmdd format that these statistics corresponds to. For example:
   * domains/mymail.mydomain.com/trafficStats/20160807
   * @param name name or {@code null} for none
   */
  public TrafficStats setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ratio of outgoing mail (from Gmail) that was accepted over secure transport (TLS).
   * @return value or {@code null} for none
   */
  public java.lang.Double getOutboundEncryptionRatio() {
    return outboundEncryptionRatio;
  }

  /**
   * The ratio of outgoing mail (from Gmail) that was accepted over secure transport (TLS).
   * @param outboundEncryptionRatio outboundEncryptionRatio or {@code null} for none
   */
  public TrafficStats setOutboundEncryptionRatio(java.lang.Double outboundEncryptionRatio) {
    this.outboundEncryptionRatio = outboundEncryptionRatio;
    return this;
  }

  /**
   * Spammy [Feedback loop identifiers] (https://support.google.com/mail/answer/6254652) with their
   * individual spam rates. This metric only pertains to traffic that is authenticated by
   * [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.util.List<FeedbackLoop> getSpammyFeedbackLoops() {
    return spammyFeedbackLoops;
  }

  /**
   * Spammy [Feedback loop identifiers] (https://support.google.com/mail/answer/6254652) with their
   * individual spam rates. This metric only pertains to traffic that is authenticated by
   * [DKIM](http://www.dkim.org/).
   * @param spammyFeedbackLoops spammyFeedbackLoops or {@code null} for none
   */
  public TrafficStats setSpammyFeedbackLoops(java.util.List<FeedbackLoop> spammyFeedbackLoops) {
    this.spammyFeedbackLoops = spammyFeedbackLoops;
    return this;
  }

  /**
   * The ratio of mail that successfully authenticated with SPF vs. all mail that attempted to
   * authenticate with [SPF](http://www.openspf.org/). Spoofed mail is excluded.
   * @return value or {@code null} for none
   */
  public java.lang.Double getSpfSuccessRatio() {
    return spfSuccessRatio;
  }

  /**
   * The ratio of mail that successfully authenticated with SPF vs. all mail that attempted to
   * authenticate with [SPF](http://www.openspf.org/). Spoofed mail is excluded.
   * @param spfSuccessRatio spfSuccessRatio or {@code null} for none
   */
  public TrafficStats setSpfSuccessRatio(java.lang.Double spfSuccessRatio) {
    this.spfSuccessRatio = spfSuccessRatio;
    return this;
  }

  /**
   * The ratio of user-report spam vs. email that was sent to the inbox. This is potentially inexact
   * -- users may want to refer to the description of the interval fields
   * userReportedSpamRatioLowerBound and userReportedSpamRatioUpperBound for more explicit accuracy
   * guarantees. This metric only pertains to emails authenticated by [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Double getUserReportedSpamRatio() {
    return userReportedSpamRatio;
  }

  /**
   * The ratio of user-report spam vs. email that was sent to the inbox. This is potentially inexact
   * -- users may want to refer to the description of the interval fields
   * userReportedSpamRatioLowerBound and userReportedSpamRatioUpperBound for more explicit accuracy
   * guarantees. This metric only pertains to emails authenticated by [DKIM](http://www.dkim.org/).
   * @param userReportedSpamRatio userReportedSpamRatio or {@code null} for none
   */
  public TrafficStats setUserReportedSpamRatio(java.lang.Double userReportedSpamRatio) {
    this.userReportedSpamRatio = userReportedSpamRatio;
    return this;
  }

  /**
   * The lower bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this lower bound and the
   * corresponding upper bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Double getUserReportedSpamRatioLowerBound() {
    return userReportedSpamRatioLowerBound;
  }

  /**
   * The lower bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this lower bound and the
   * corresponding upper bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * @param userReportedSpamRatioLowerBound userReportedSpamRatioLowerBound or {@code null} for none
   */
  public TrafficStats setUserReportedSpamRatioLowerBound(java.lang.Double userReportedSpamRatioLowerBound) {
    this.userReportedSpamRatioLowerBound = userReportedSpamRatioLowerBound;
    return this;
  }

  /**
   * The upper bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this upper bound and the
   * corresponding lower bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * @return value or {@code null} for none
   */
  public java.lang.Double getUserReportedSpamRatioUpperBound() {
    return userReportedSpamRatioUpperBound;
  }

  /**
   * The upper bound of the confidence interval for the user reported spam ratio. If this field is
   * set, then the value of userReportedSpamRatio is set to the midpoint of this interval and is
   * thus inexact. However, the true ratio is guaranteed to be in between this upper bound and the
   * corresponding lower bound 95% of the time. This metric only pertains to emails authenticated by
   * [DKIM](http://www.dkim.org/).
   * @param userReportedSpamRatioUpperBound userReportedSpamRatioUpperBound or {@code null} for none
   */
  public TrafficStats setUserReportedSpamRatioUpperBound(java.lang.Double userReportedSpamRatioUpperBound) {
    this.userReportedSpamRatioUpperBound = userReportedSpamRatioUpperBound;
    return this;
  }

  @Override
  public TrafficStats set(String fieldName, Object value) {
    return (TrafficStats) super.set(fieldName, value);
  }

  @Override
  public TrafficStats clone() {
    return (TrafficStats) super.clone();
  }

}
