/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.gmailpostmastertools.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.gmailpostmastertools.v1.PostmasterToolsRequest;
import com.google.api.services.gmailpostmastertools.v1.PostmasterToolsRequestInitializer;
import com.google.api.services.gmailpostmastertools.v1.model.Domain;
import com.google.api.services.gmailpostmastertools.v1.model.ListDomainsResponse;
import com.google.api.services.gmailpostmastertools.v1.model.ListTrafficStatsResponse;
import com.google.api.services.gmailpostmastertools.v1.model.TrafficStats;
import java.io.IOException;
import java.util.regex.Pattern;

public class PostmasterTools
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://gmailpostmastertools.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://gmailpostmastertools.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://gmailpostmastertools.googleapis.com/";

    public PostmasterTools(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    PostmasterTools(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Domains domains() {
        return new Domains();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Gmail Postmaster Tools API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return PostmasterTools.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://gmailpostmastertools.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), PostmasterTools.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(PostmasterTools.DEFAULT_BATCH_PATH);
        }

        public PostmasterTools build() {
            return new PostmasterTools(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPostmasterToolsRequestInitializer(PostmasterToolsRequestInitializer postmastertoolsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)postmastertoolsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Domains {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            PostmasterTools.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            PostmasterTools.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TrafficStats trafficStats() {
            return new TrafficStats();
        }

        public class TrafficStats {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                PostmasterTools.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                PostmasterTools.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends PostmasterToolsRequest<ListTrafficStatsResponse> {
                private static final String REST_PATH = "v1/{+parent}/trafficStats";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="endDate.day")
                private Integer endDateDay;
                @Key(value="endDate.month")
                private Integer endDateMonth;
                @Key(value="endDate.year")
                private Integer endDateYear;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key(value="startDate.day")
                private Integer startDateDay;
                @Key(value="startDate.month")
                private Integer startDateMonth;
                @Key(value="startDate.year")
                private Integer startDateYear;

                protected List(String parent) {
                    super(PostmasterTools.this, "GET", REST_PATH, null, ListTrafficStatsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^domains/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!PostmasterTools.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^domains/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!PostmasterTools.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^domains/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getEndDateDay() {
                    return this.endDateDay;
                }

                public List setEndDateDay(Integer endDateDay) {
                    this.endDateDay = endDateDay;
                    return this;
                }

                public Integer getEndDateMonth() {
                    return this.endDateMonth;
                }

                public List setEndDateMonth(Integer endDateMonth) {
                    this.endDateMonth = endDateMonth;
                    return this;
                }

                public Integer getEndDateYear() {
                    return this.endDateYear;
                }

                public List setEndDateYear(Integer endDateYear) {
                    this.endDateYear = endDateYear;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Integer getStartDateDay() {
                    return this.startDateDay;
                }

                public List setStartDateDay(Integer startDateDay) {
                    this.startDateDay = startDateDay;
                    return this;
                }

                public Integer getStartDateMonth() {
                    return this.startDateMonth;
                }

                public List setStartDateMonth(Integer startDateMonth) {
                    this.startDateMonth = startDateMonth;
                    return this;
                }

                public Integer getStartDateYear() {
                    return this.startDateYear;
                }

                public List setStartDateYear(Integer startDateYear) {
                    this.startDateYear = startDateYear;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends PostmasterToolsRequest<com.google.api.services.gmailpostmastertools.v1.model.TrafficStats> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(PostmasterTools.this, "GET", REST_PATH, null, com.google.api.services.gmailpostmastertools.v1.model.TrafficStats.class);
                    this.NAME_PATTERN = Pattern.compile("^domains/[^/]+/trafficStats/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!PostmasterTools.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^domains/[^/]+/trafficStats/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!PostmasterTools.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^domains/[^/]+/trafficStats/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends PostmasterToolsRequest<ListDomainsResponse> {
            private static final String REST_PATH = "v1/domains";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(PostmasterTools.this, "GET", REST_PATH, null, ListDomainsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PostmasterToolsRequest<Domain> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(PostmasterTools.this, "GET", REST_PATH, null, Domain.class);
                this.NAME_PATTERN = Pattern.compile("^domains/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!PostmasterTools.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^domains/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!PostmasterTools.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^domains/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

