# Groups Settings API Client Library for Java

Manages permission levels and related settings of a group.

This page contains information about getting started with the Groups Settings API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Groups Settings API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Groups Settings API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-groupssettings</artifactId>
      <version>v1-rev20210624-2.0.0</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  implementation 'com.google.apis:google-api-services-groupssettings:v1-rev20210624-2.0.0'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-groupssettings/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/groupssettings/v1/
