/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.groupssettings.model;

/**
 * JSON template for Group resource
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Groups Settings API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Groups extends com.google.api.client.json.GenericJson {

  /**
   * Identifies whether members external to your organization can join the group. Possible values
   * are: - true: G Suite users external to your organization can become members of this group.  -
   * false: Users not belonging to the organization are not allowed to become members of this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowExternalMembers;

  /**
   * Deprecated. Allows Google to contact administrator of the group. - true: Allow Google to
   * contact managers of this group. Occasionally Google may send updates on the latest features,
   * ask for input on new features, or ask for permission to highlight your group.  - false: Google
   * can not contact managers of this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowGoogleCommunication;

  /**
   * Allows posting from web. Possible values are: - true: Allows any member to post to the group
   * forum.  - false: Members only use Gmail to communicate with the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowWebPosting;

  /**
   * Allows the group to be archived only. Possible values are: - true: Group is archived and the
   * group is inactive. New messages to this group are rejected. The older archived messages are
   * browseable and searchable.   - If true, the whoCanPostMessage property is set to NONE_CAN_POST.
   * - If reverted from true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   -
   * false: The group is active and can receive messages.   - When false, updating whoCanPostMessage
   * to NONE_CAN_POST, results in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String archiveOnly;

  /**
   * Set the content of custom footer text. The maximum number of characters is 1,000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customFooterText;

  /**
   * An email address used when replying to a message if the replyTo property is set to
   * REPLY_TO_CUSTOM. This address is defined by an account administrator. - When the group's
   * ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo property holds a custom email
   * address used when replying to a message.  - If the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property must have a text value or an error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customReplyTo;

  /**
   * Specifies whether the group has a custom role that's included in one of the settings being
   * merged. This field is read-only and update/patch requests to it are ignored. Possible values
   * are: - true  - false
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customRolesEnabledForSettingsToBeMerged;

  /**
   * When a message is rejected, this is text for the rejection notification sent to the message's
   * author. By default, this property is empty and has no value in the API's response body. The
   * maximum notification text size is 10,000 characters. Note: Requires sendMessageDenyNotification
   * property to be true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultMessageDenyNotificationText;

  /**
   * Default sender for members who can post messages as the group. Possible values are: -
   * `DEFAULT_SELF`: By default messages will be sent from the user - `GROUP`: By default messages
   * will be sent from the group
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("default_sender")
  private java.lang.String defaultSender;

  /**
   * Description of the group. This property value may be an empty string if no group description
   * has been entered. If entered, the maximum group description is no more than 300 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The group's email address. This property can be updated using the Directory API. Note: Only a
   * group owner can change a group's email address. A group manager can't do this. When you change
   * your group's address using the Directory API or the control panel, you are changing the address
   * your subscribers use to send email and the web address people use to access your group. People
   * can't reach your group by visiting the old address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Specifies whether a collaborative inbox will remain turned on for the group. Possible values
   * are: - true  - false
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enableCollaborativeInbox;

  /**
   * Indicates if favorite replies should be displayed above other replies. - true: Favorite replies
   * will be displayed above other replies.  - false: Favorite replies will not be displayed above
   * other replies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String favoriteRepliesOnTop;

  /**
   * Whether to include custom footer. Possible values are: - true  - false
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String includeCustomFooter;

  /**
   * Enables the group to be included in the Global Address List. For more information, see the help
   * center. Possible values are: - true: Group is included in the Global Address List.  - false:
   * Group is not included in the Global Address List.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String includeInGlobalAddressList;

  /**
   * Allows the Group contents to be archived. Possible values are: - true: Archive messages sent to
   * the group.  - false: Do not keep an archive of messages sent to this group. If false,
   * previously archived messages remain in the archive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String isArchived;

  /**
   * The type of the resource. It is always groupsSettings#groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Deprecated. The maximum size of a message is 25Mb.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxMessageBytes;

  /**
   * Enables members to post messages as the group. Possible values are: - true: Group member can
   * post messages using the group's email address instead of their own email address. Message
   * appear to originate from the group itself. Note: When true, any message moderation settings on
   * individual users or new members do not apply to posts made on behalf of the group.  - false:
   * Members can not post in behalf of the group's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String membersCanPostAsTheGroup;

  /**
   * Deprecated. The default message display font always has a value of "DEFAULT_FONT".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageDisplayFont;

  /**
   * Moderation level of incoming messages. Possible values are: - MODERATE_ALL_MESSAGES: All
   * messages are sent to the group owner's email address for approval. If approved, the message is
   * sent to the group.  - MODERATE_NON_MEMBERS: All messages from non group members are sent to the
   * group owner's email address for approval. If approved, the message is sent to the group.  -
   * MODERATE_NEW_MEMBERS: All messages from new members are sent to the group owner's email address
   * for approval. If approved, the message is sent to the group.  - MODERATE_NONE: No moderator
   * approval is required. Messages are delivered directly to the group. Note: When the
   * whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the messageModerationLevel be set to
   * MODERATE_NON_MEMBERS to protect the group from possible spam. When memberCanPostAsTheGroup is
   * true, any message moderation settings on individual users or new members will not apply to
   * posts made on behalf of the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageModerationLevel;

  /**
   * Name of the group, which has a maximum size of 75 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The primary language for group. For a group's primary language use the language tags from the G
   * Suite languages found at G Suite Email Settings API Email Language Tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryLanguage;

  /**
   * Specifies who receives the default reply. Possible values are: - REPLY_TO_CUSTOM: For replies
   * to messages, use the group's custom email address. When the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property holds the custom email address used when replying
   * to a message. If the group's ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo
   * property must have a value. Otherwise an error is returned.   - REPLY_TO_SENDER: The reply sent
   * to author of message.  - REPLY_TO_LIST: This reply message is sent to the group.  -
   * REPLY_TO_OWNER: The reply is sent to the owner(s) of the group. This does not include the
   * group's managers.  - REPLY_TO_IGNORE: Group users individually decide where the message reply
   * is sent.  - REPLY_TO_MANAGERS: This reply message is sent to the group's managers, which
   * includes all managers and the group owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replyTo;

  /**
   * Allows a member to be notified if the member's message to the group is denied by the group
   * owner. Possible values are: - true: When a message is rejected, send the deny message
   * notification to the message author. The defaultMessageDenyNotificationText property is
   * dependent on the sendMessageDenyNotification property being true.   - false: When a message is
   * rejected, no notification is sent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sendMessageDenyNotification;

  /**
   * Deprecated. This is merged into the new whoCanDiscoverGroup setting. Allows the group to be
   * visible in the Groups Directory. Possible values are: - true: All groups in the account are
   * listed in the Groups directory.  - false: All groups in the account are not listed in the
   * directory.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String showInGroupDirectory;

  /**
   * Specifies moderation levels for messages detected as spam. Possible values are: - ALLOW: Post
   * the message to the group.  - MODERATE: Send the message to the moderation queue. This is the
   * default.  - SILENTLY_MODERATE: Send the message to the moderation queue, but do not send
   * notification to moderators.  - REJECT: Immediately reject the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spamModerationLevel;

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to add
   * members. Possible values are: - ALL_MEMBERS_CAN_ADD: Managers and members can directly add new
   * members.  - ALL_MANAGERS_CAN_ADD: Only managers can directly add new members. this includes the
   * group's owner.  - ALL_OWNERS_CAN_ADD: Only owners can directly add new members.  -
   * NONE_CAN_ADD: No one can directly add new members.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanAdd;

  /**
   * Deprecated. This functionality is no longer supported in the Google Groups UI. The value is
   * always "NONE".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanAddReferences;

  /**
   * Specifies who can approve members who ask to join groups. This permission will be deprecated
   * once it is merged into the new whoCanModerateMembers setting. Possible values are: -
   * ALL_MEMBERS_CAN_APPROVE  - ALL_MANAGERS_CAN_APPROVE  - ALL_OWNERS_CAN_APPROVE  -
   * NONE_CAN_APPROVE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanApproveMembers;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * approve pending messages in the moderation queue. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanApproveMessages;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to assign
   * topics in a forum to another user. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanAssignTopics;

  /**
   * Specifies who can moderate metadata. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanAssistContent;

  /**
   * Specifies who can deny membership to users. This permission will be deprecated once it is
   * merged into the new whoCanModerateMembers setting. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanBanUsers;

  /**
   * Permission to contact owner of the group via web UI. Possible values are: -
   * ALL_IN_DOMAIN_CAN_CONTACT  - ALL_MANAGERS_CAN_CONTACT  - ALL_MEMBERS_CAN_CONTACT  -
   * ANYONE_CAN_CONTACT  - ALL_OWNERS_CAN_CONTACT
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanContactOwner;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * replies to topics. (Authors can always delete their own posts). Possible values are: -
   * ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanDeleteAnyPost;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * topics. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanDeleteTopics;

  /**
   * Specifies the set of users for whom this group is discoverable. Possible values are: -
   * ANYONE_CAN_DISCOVER  - ALL_IN_DOMAIN_CAN_DISCOVER  - ALL_MEMBERS_CAN_DISCOVER
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanDiscoverGroup;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to enter free
   * form tags for topics in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanEnterFreeFormTags;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can hide
   * posts by reporting them as abuse. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanHideAbuse;

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to invite
   * new members. Possible values are: - ALL_MEMBERS_CAN_INVITE: Managers and members can invite a
   * new member candidate.  - ALL_MANAGERS_CAN_INVITE: Only managers can invite a new member. This
   * includes the group's owner.  - ALL_OWNERS_CAN_INVITE: Only owners can invite a new member.  -
   * NONE_CAN_INVITE: No one can invite a new member candidate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanInvite;

  /**
   * Permission to join group. Possible values are: - ANYONE_CAN_JOIN: Anyone in the account domain
   * can join. This includes accounts with multiple domains.  - ALL_IN_DOMAIN_CAN_JOIN: Any Internet
   * user who is outside your domain can access your Google Groups service and view the list of
   * groups in your Groups directory. Warning: Group owners can add external addresses, outside of
   * the domain to their groups. They can also allow people outside your domain to join their
   * groups. If you later disable this option, any external addresses already added to users' groups
   * remain in those groups.  - INVITED_CAN_JOIN: Candidates for membership can be invited to join.
   * - CAN_REQUEST_TO_JOIN: Non members can request an invitation to join.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanJoin;

  /**
   * Permission to leave the group. Possible values are: - ALL_MANAGERS_CAN_LEAVE  -
   * ALL_MEMBERS_CAN_LEAVE  - NONE_CAN_LEAVE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanLeaveGroup;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * prevent users from posting replies to topics. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanLockTopics;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can make
   * topics appear at the top of the topic list. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMakeTopicsSticky;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as a duplicate of another topic. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMarkDuplicate;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark any
   * other user's post as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMarkFavoriteReplyOnAnyTopic;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a post
   * for a topic they started as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMarkFavoriteReplyOnOwnTopic;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as not needing a response. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMarkNoResponseNeeded;

  /**
   * Specifies who can moderate content. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanModerateContent;

  /**
   * Specifies who can manage members. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanModerateMembers;

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Specifies who can change
   * group members' roles. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY
   * - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanModifyMembers;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to change tags
   * and categories. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanModifyTagsAndCategories;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics into the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMoveTopicsIn;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics out of the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanMoveTopicsOut;

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can post
   * announcements, a special topic type. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanPostAnnouncements;

  /**
   * Permissions to post messages. Possible values are: - NONE_CAN_POST: The group is disabled and
   * archived. No one can post a message to this group.   - When archiveOnly is false, updating
   * whoCanPostMessage to NONE_CAN_POST, results in an error.  - If archiveOnly is reverted from
   * true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   - ALL_MANAGERS_CAN_POST:
   * Managers, including group owners, can post messages.  - ALL_MEMBERS_CAN_POST: Any group member
   * can post a message.  - ALL_OWNERS_CAN_POST: Only group owners can post a message.  -
   * ALL_IN_DOMAIN_CAN_POST: Anyone in the account can post a message.   - ANYONE_CAN_POST: Any
   * Internet user who outside your account can access your Google Groups service and post a
   * message. Note: When whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the
   * messageModerationLevel be set to MODERATE_NON_MEMBERS to protect the group from possible spam.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanPostMessage;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to take topics
   * in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanTakeTopics;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unassign any
   * topic in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanUnassignTopic;

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unmark any
   * post from a favorite reply. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanUnmarkFavoriteReplyOnAnyTopic;

  /**
   * Permissions to view group messages. Possible values are: - ANYONE_CAN_VIEW: Any Internet user
   * can view the group's messages.   - ALL_IN_DOMAIN_CAN_VIEW: Anyone in your account can view this
   * group's messages.  - ALL_MEMBERS_CAN_VIEW: All group members can view the group's messages.  -
   * ALL_MANAGERS_CAN_VIEW: Any group manager can view this group's messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanViewGroup;

  /**
   * Permissions to view membership. Possible values are: - ALL_IN_DOMAIN_CAN_VIEW: Anyone in the
   * account can view the group members list. If a group already has external members, those members
   * can still send email to this group.   - ALL_MEMBERS_CAN_VIEW: The group members can view the
   * group members list.  - ALL_MANAGERS_CAN_VIEW: The group managers can view group members list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String whoCanViewMembership;

  /**
   * Identifies whether members external to your organization can join the group. Possible values
   * are: - true: G Suite users external to your organization can become members of this group.  -
   * false: Users not belonging to the organization are not allowed to become members of this group.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowExternalMembers() {
    return allowExternalMembers;
  }

  /**
   * Identifies whether members external to your organization can join the group. Possible values
   * are: - true: G Suite users external to your organization can become members of this group.  -
   * false: Users not belonging to the organization are not allowed to become members of this group.
   * @param allowExternalMembers allowExternalMembers or {@code null} for none
   */
  public Groups setAllowExternalMembers(java.lang.String allowExternalMembers) {
    this.allowExternalMembers = allowExternalMembers;
    return this;
  }

  /**
   * Deprecated. Allows Google to contact administrator of the group. - true: Allow Google to
   * contact managers of this group. Occasionally Google may send updates on the latest features,
   * ask for input on new features, or ask for permission to highlight your group.  - false: Google
   * can not contact managers of this group.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowGoogleCommunication() {
    return allowGoogleCommunication;
  }

  /**
   * Deprecated. Allows Google to contact administrator of the group. - true: Allow Google to
   * contact managers of this group. Occasionally Google may send updates on the latest features,
   * ask for input on new features, or ask for permission to highlight your group.  - false: Google
   * can not contact managers of this group.
   * @param allowGoogleCommunication allowGoogleCommunication or {@code null} for none
   */
  public Groups setAllowGoogleCommunication(java.lang.String allowGoogleCommunication) {
    this.allowGoogleCommunication = allowGoogleCommunication;
    return this;
  }

  /**
   * Allows posting from web. Possible values are: - true: Allows any member to post to the group
   * forum.  - false: Members only use Gmail to communicate with the group.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowWebPosting() {
    return allowWebPosting;
  }

  /**
   * Allows posting from web. Possible values are: - true: Allows any member to post to the group
   * forum.  - false: Members only use Gmail to communicate with the group.
   * @param allowWebPosting allowWebPosting or {@code null} for none
   */
  public Groups setAllowWebPosting(java.lang.String allowWebPosting) {
    this.allowWebPosting = allowWebPosting;
    return this;
  }

  /**
   * Allows the group to be archived only. Possible values are: - true: Group is archived and the
   * group is inactive. New messages to this group are rejected. The older archived messages are
   * browseable and searchable.   - If true, the whoCanPostMessage property is set to NONE_CAN_POST.
   * - If reverted from true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   -
   * false: The group is active and can receive messages.   - When false, updating whoCanPostMessage
   * to NONE_CAN_POST, results in an error.
   * @return value or {@code null} for none
   */
  public java.lang.String getArchiveOnly() {
    return archiveOnly;
  }

  /**
   * Allows the group to be archived only. Possible values are: - true: Group is archived and the
   * group is inactive. New messages to this group are rejected. The older archived messages are
   * browseable and searchable.   - If true, the whoCanPostMessage property is set to NONE_CAN_POST.
   * - If reverted from true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   -
   * false: The group is active and can receive messages.   - When false, updating whoCanPostMessage
   * to NONE_CAN_POST, results in an error.
   * @param archiveOnly archiveOnly or {@code null} for none
   */
  public Groups setArchiveOnly(java.lang.String archiveOnly) {
    this.archiveOnly = archiveOnly;
    return this;
  }

  /**
   * Set the content of custom footer text. The maximum number of characters is 1,000.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomFooterText() {
    return customFooterText;
  }

  /**
   * Set the content of custom footer text. The maximum number of characters is 1,000.
   * @param customFooterText customFooterText or {@code null} for none
   */
  public Groups setCustomFooterText(java.lang.String customFooterText) {
    this.customFooterText = customFooterText;
    return this;
  }

  /**
   * An email address used when replying to a message if the replyTo property is set to
   * REPLY_TO_CUSTOM. This address is defined by an account administrator. - When the group's
   * ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo property holds a custom email
   * address used when replying to a message.  - If the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property must have a text value or an error is returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomReplyTo() {
    return customReplyTo;
  }

  /**
   * An email address used when replying to a message if the replyTo property is set to
   * REPLY_TO_CUSTOM. This address is defined by an account administrator. - When the group's
   * ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo property holds a custom email
   * address used when replying to a message.  - If the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property must have a text value or an error is returned.
   * @param customReplyTo customReplyTo or {@code null} for none
   */
  public Groups setCustomReplyTo(java.lang.String customReplyTo) {
    this.customReplyTo = customReplyTo;
    return this;
  }

  /**
   * Specifies whether the group has a custom role that's included in one of the settings being
   * merged. This field is read-only and update/patch requests to it are ignored. Possible values
   * are: - true  - false
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomRolesEnabledForSettingsToBeMerged() {
    return customRolesEnabledForSettingsToBeMerged;
  }

  /**
   * Specifies whether the group has a custom role that's included in one of the settings being
   * merged. This field is read-only and update/patch requests to it are ignored. Possible values
   * are: - true  - false
   * @param customRolesEnabledForSettingsToBeMerged customRolesEnabledForSettingsToBeMerged or {@code null} for none
   */
  public Groups setCustomRolesEnabledForSettingsToBeMerged(java.lang.String customRolesEnabledForSettingsToBeMerged) {
    this.customRolesEnabledForSettingsToBeMerged = customRolesEnabledForSettingsToBeMerged;
    return this;
  }

  /**
   * When a message is rejected, this is text for the rejection notification sent to the message's
   * author. By default, this property is empty and has no value in the API's response body. The
   * maximum notification text size is 10,000 characters. Note: Requires sendMessageDenyNotification
   * property to be true.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultMessageDenyNotificationText() {
    return defaultMessageDenyNotificationText;
  }

  /**
   * When a message is rejected, this is text for the rejection notification sent to the message's
   * author. By default, this property is empty and has no value in the API's response body. The
   * maximum notification text size is 10,000 characters. Note: Requires sendMessageDenyNotification
   * property to be true.
   * @param defaultMessageDenyNotificationText defaultMessageDenyNotificationText or {@code null} for none
   */
  public Groups setDefaultMessageDenyNotificationText(java.lang.String defaultMessageDenyNotificationText) {
    this.defaultMessageDenyNotificationText = defaultMessageDenyNotificationText;
    return this;
  }

  /**
   * Default sender for members who can post messages as the group. Possible values are: -
   * `DEFAULT_SELF`: By default messages will be sent from the user - `GROUP`: By default messages
   * will be sent from the group
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultSender() {
    return defaultSender;
  }

  /**
   * Default sender for members who can post messages as the group. Possible values are: -
   * `DEFAULT_SELF`: By default messages will be sent from the user - `GROUP`: By default messages
   * will be sent from the group
   * @param defaultSender defaultSender or {@code null} for none
   */
  public Groups setDefaultSender(java.lang.String defaultSender) {
    this.defaultSender = defaultSender;
    return this;
  }

  /**
   * Description of the group. This property value may be an empty string if no group description
   * has been entered. If entered, the maximum group description is no more than 300 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the group. This property value may be an empty string if no group description
   * has been entered. If entered, the maximum group description is no more than 300 characters.
   * @param description description or {@code null} for none
   */
  public Groups setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The group's email address. This property can be updated using the Directory API. Note: Only a
   * group owner can change a group's email address. A group manager can't do this. When you change
   * your group's address using the Directory API or the control panel, you are changing the address
   * your subscribers use to send email and the web address people use to access your group. People
   * can't reach your group by visiting the old address.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The group's email address. This property can be updated using the Directory API. Note: Only a
   * group owner can change a group's email address. A group manager can't do this. When you change
   * your group's address using the Directory API or the control panel, you are changing the address
   * your subscribers use to send email and the web address people use to access your group. People
   * can't reach your group by visiting the old address.
   * @param email email or {@code null} for none
   */
  public Groups setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Specifies whether a collaborative inbox will remain turned on for the group. Possible values
   * are: - true  - false
   * @return value or {@code null} for none
   */
  public java.lang.String getEnableCollaborativeInbox() {
    return enableCollaborativeInbox;
  }

  /**
   * Specifies whether a collaborative inbox will remain turned on for the group. Possible values
   * are: - true  - false
   * @param enableCollaborativeInbox enableCollaborativeInbox or {@code null} for none
   */
  public Groups setEnableCollaborativeInbox(java.lang.String enableCollaborativeInbox) {
    this.enableCollaborativeInbox = enableCollaborativeInbox;
    return this;
  }

  /**
   * Indicates if favorite replies should be displayed above other replies. - true: Favorite replies
   * will be displayed above other replies.  - false: Favorite replies will not be displayed above
   * other replies.
   * @return value or {@code null} for none
   */
  public java.lang.String getFavoriteRepliesOnTop() {
    return favoriteRepliesOnTop;
  }

  /**
   * Indicates if favorite replies should be displayed above other replies. - true: Favorite replies
   * will be displayed above other replies.  - false: Favorite replies will not be displayed above
   * other replies.
   * @param favoriteRepliesOnTop favoriteRepliesOnTop or {@code null} for none
   */
  public Groups setFavoriteRepliesOnTop(java.lang.String favoriteRepliesOnTop) {
    this.favoriteRepliesOnTop = favoriteRepliesOnTop;
    return this;
  }

  /**
   * Whether to include custom footer. Possible values are: - true  - false
   * @return value or {@code null} for none
   */
  public java.lang.String getIncludeCustomFooter() {
    return includeCustomFooter;
  }

  /**
   * Whether to include custom footer. Possible values are: - true  - false
   * @param includeCustomFooter includeCustomFooter or {@code null} for none
   */
  public Groups setIncludeCustomFooter(java.lang.String includeCustomFooter) {
    this.includeCustomFooter = includeCustomFooter;
    return this;
  }

  /**
   * Enables the group to be included in the Global Address List. For more information, see the help
   * center. Possible values are: - true: Group is included in the Global Address List.  - false:
   * Group is not included in the Global Address List.
   * @return value or {@code null} for none
   */
  public java.lang.String getIncludeInGlobalAddressList() {
    return includeInGlobalAddressList;
  }

  /**
   * Enables the group to be included in the Global Address List. For more information, see the help
   * center. Possible values are: - true: Group is included in the Global Address List.  - false:
   * Group is not included in the Global Address List.
   * @param includeInGlobalAddressList includeInGlobalAddressList or {@code null} for none
   */
  public Groups setIncludeInGlobalAddressList(java.lang.String includeInGlobalAddressList) {
    this.includeInGlobalAddressList = includeInGlobalAddressList;
    return this;
  }

  /**
   * Allows the Group contents to be archived. Possible values are: - true: Archive messages sent to
   * the group.  - false: Do not keep an archive of messages sent to this group. If false,
   * previously archived messages remain in the archive.
   * @return value or {@code null} for none
   */
  public java.lang.String getIsArchived() {
    return isArchived;
  }

  /**
   * Allows the Group contents to be archived. Possible values are: - true: Archive messages sent to
   * the group.  - false: Do not keep an archive of messages sent to this group. If false,
   * previously archived messages remain in the archive.
   * @param isArchived isArchived or {@code null} for none
   */
  public Groups setIsArchived(java.lang.String isArchived) {
    this.isArchived = isArchived;
    return this;
  }

  /**
   * The type of the resource. It is always groupsSettings#groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of the resource. It is always groupsSettings#groups.
   * @param kind kind or {@code null} for none
   */
  public Groups setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Deprecated. The maximum size of a message is 25Mb.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxMessageBytes() {
    return maxMessageBytes;
  }

  /**
   * Deprecated. The maximum size of a message is 25Mb.
   * @param maxMessageBytes maxMessageBytes or {@code null} for none
   */
  public Groups setMaxMessageBytes(java.lang.Integer maxMessageBytes) {
    this.maxMessageBytes = maxMessageBytes;
    return this;
  }

  /**
   * Enables members to post messages as the group. Possible values are: - true: Group member can
   * post messages using the group's email address instead of their own email address. Message
   * appear to originate from the group itself. Note: When true, any message moderation settings on
   * individual users or new members do not apply to posts made on behalf of the group.  - false:
   * Members can not post in behalf of the group's email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getMembersCanPostAsTheGroup() {
    return membersCanPostAsTheGroup;
  }

  /**
   * Enables members to post messages as the group. Possible values are: - true: Group member can
   * post messages using the group's email address instead of their own email address. Message
   * appear to originate from the group itself. Note: When true, any message moderation settings on
   * individual users or new members do not apply to posts made on behalf of the group.  - false:
   * Members can not post in behalf of the group's email address.
   * @param membersCanPostAsTheGroup membersCanPostAsTheGroup or {@code null} for none
   */
  public Groups setMembersCanPostAsTheGroup(java.lang.String membersCanPostAsTheGroup) {
    this.membersCanPostAsTheGroup = membersCanPostAsTheGroup;
    return this;
  }

  /**
   * Deprecated. The default message display font always has a value of "DEFAULT_FONT".
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageDisplayFont() {
    return messageDisplayFont;
  }

  /**
   * Deprecated. The default message display font always has a value of "DEFAULT_FONT".
   * @param messageDisplayFont messageDisplayFont or {@code null} for none
   */
  public Groups setMessageDisplayFont(java.lang.String messageDisplayFont) {
    this.messageDisplayFont = messageDisplayFont;
    return this;
  }

  /**
   * Moderation level of incoming messages. Possible values are: - MODERATE_ALL_MESSAGES: All
   * messages are sent to the group owner's email address for approval. If approved, the message is
   * sent to the group.  - MODERATE_NON_MEMBERS: All messages from non group members are sent to the
   * group owner's email address for approval. If approved, the message is sent to the group.  -
   * MODERATE_NEW_MEMBERS: All messages from new members are sent to the group owner's email address
   * for approval. If approved, the message is sent to the group.  - MODERATE_NONE: No moderator
   * approval is required. Messages are delivered directly to the group. Note: When the
   * whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the messageModerationLevel be set to
   * MODERATE_NON_MEMBERS to protect the group from possible spam. When memberCanPostAsTheGroup is
   * true, any message moderation settings on individual users or new members will not apply to
   * posts made on behalf of the group.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageModerationLevel() {
    return messageModerationLevel;
  }

  /**
   * Moderation level of incoming messages. Possible values are: - MODERATE_ALL_MESSAGES: All
   * messages are sent to the group owner's email address for approval. If approved, the message is
   * sent to the group.  - MODERATE_NON_MEMBERS: All messages from non group members are sent to the
   * group owner's email address for approval. If approved, the message is sent to the group.  -
   * MODERATE_NEW_MEMBERS: All messages from new members are sent to the group owner's email address
   * for approval. If approved, the message is sent to the group.  - MODERATE_NONE: No moderator
   * approval is required. Messages are delivered directly to the group. Note: When the
   * whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the messageModerationLevel be set to
   * MODERATE_NON_MEMBERS to protect the group from possible spam. When memberCanPostAsTheGroup is
   * true, any message moderation settings on individual users or new members will not apply to
   * posts made on behalf of the group.
   * @param messageModerationLevel messageModerationLevel or {@code null} for none
   */
  public Groups setMessageModerationLevel(java.lang.String messageModerationLevel) {
    this.messageModerationLevel = messageModerationLevel;
    return this;
  }

  /**
   * Name of the group, which has a maximum size of 75 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the group, which has a maximum size of 75 characters.
   * @param name name or {@code null} for none
   */
  public Groups setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The primary language for group. For a group's primary language use the language tags from the G
   * Suite languages found at G Suite Email Settings API Email Language Tags.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryLanguage() {
    return primaryLanguage;
  }

  /**
   * The primary language for group. For a group's primary language use the language tags from the G
   * Suite languages found at G Suite Email Settings API Email Language Tags.
   * @param primaryLanguage primaryLanguage or {@code null} for none
   */
  public Groups setPrimaryLanguage(java.lang.String primaryLanguage) {
    this.primaryLanguage = primaryLanguage;
    return this;
  }

  /**
   * Specifies who receives the default reply. Possible values are: - REPLY_TO_CUSTOM: For replies
   * to messages, use the group's custom email address. When the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property holds the custom email address used when replying
   * to a message. If the group's ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo
   * property must have a value. Otherwise an error is returned.   - REPLY_TO_SENDER: The reply sent
   * to author of message.  - REPLY_TO_LIST: This reply message is sent to the group.  -
   * REPLY_TO_OWNER: The reply is sent to the owner(s) of the group. This does not include the
   * group's managers.  - REPLY_TO_IGNORE: Group users individually decide where the message reply
   * is sent.  - REPLY_TO_MANAGERS: This reply message is sent to the group's managers, which
   * includes all managers and the group owner.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplyTo() {
    return replyTo;
  }

  /**
   * Specifies who receives the default reply. Possible values are: - REPLY_TO_CUSTOM: For replies
   * to messages, use the group's custom email address. When the group's ReplyTo property is set to
   * REPLY_TO_CUSTOM, the customReplyTo property holds the custom email address used when replying
   * to a message. If the group's ReplyTo property is set to REPLY_TO_CUSTOM, the customReplyTo
   * property must have a value. Otherwise an error is returned.   - REPLY_TO_SENDER: The reply sent
   * to author of message.  - REPLY_TO_LIST: This reply message is sent to the group.  -
   * REPLY_TO_OWNER: The reply is sent to the owner(s) of the group. This does not include the
   * group's managers.  - REPLY_TO_IGNORE: Group users individually decide where the message reply
   * is sent.  - REPLY_TO_MANAGERS: This reply message is sent to the group's managers, which
   * includes all managers and the group owner.
   * @param replyTo replyTo or {@code null} for none
   */
  public Groups setReplyTo(java.lang.String replyTo) {
    this.replyTo = replyTo;
    return this;
  }

  /**
   * Allows a member to be notified if the member's message to the group is denied by the group
   * owner. Possible values are: - true: When a message is rejected, send the deny message
   * notification to the message author. The defaultMessageDenyNotificationText property is
   * dependent on the sendMessageDenyNotification property being true.   - false: When a message is
   * rejected, no notification is sent.
   * @return value or {@code null} for none
   */
  public java.lang.String getSendMessageDenyNotification() {
    return sendMessageDenyNotification;
  }

  /**
   * Allows a member to be notified if the member's message to the group is denied by the group
   * owner. Possible values are: - true: When a message is rejected, send the deny message
   * notification to the message author. The defaultMessageDenyNotificationText property is
   * dependent on the sendMessageDenyNotification property being true.   - false: When a message is
   * rejected, no notification is sent.
   * @param sendMessageDenyNotification sendMessageDenyNotification or {@code null} for none
   */
  public Groups setSendMessageDenyNotification(java.lang.String sendMessageDenyNotification) {
    this.sendMessageDenyNotification = sendMessageDenyNotification;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanDiscoverGroup setting. Allows the group to be
   * visible in the Groups Directory. Possible values are: - true: All groups in the account are
   * listed in the Groups directory.  - false: All groups in the account are not listed in the
   * directory.
   * @return value or {@code null} for none
   */
  public java.lang.String getShowInGroupDirectory() {
    return showInGroupDirectory;
  }

  /**
   * Deprecated. This is merged into the new whoCanDiscoverGroup setting. Allows the group to be
   * visible in the Groups Directory. Possible values are: - true: All groups in the account are
   * listed in the Groups directory.  - false: All groups in the account are not listed in the
   * directory.
   * @param showInGroupDirectory showInGroupDirectory or {@code null} for none
   */
  public Groups setShowInGroupDirectory(java.lang.String showInGroupDirectory) {
    this.showInGroupDirectory = showInGroupDirectory;
    return this;
  }

  /**
   * Specifies moderation levels for messages detected as spam. Possible values are: - ALLOW: Post
   * the message to the group.  - MODERATE: Send the message to the moderation queue. This is the
   * default.  - SILENTLY_MODERATE: Send the message to the moderation queue, but do not send
   * notification to moderators.  - REJECT: Immediately reject the message.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpamModerationLevel() {
    return spamModerationLevel;
  }

  /**
   * Specifies moderation levels for messages detected as spam. Possible values are: - ALLOW: Post
   * the message to the group.  - MODERATE: Send the message to the moderation queue. This is the
   * default.  - SILENTLY_MODERATE: Send the message to the moderation queue, but do not send
   * notification to moderators.  - REJECT: Immediately reject the message.
   * @param spamModerationLevel spamModerationLevel or {@code null} for none
   */
  public Groups setSpamModerationLevel(java.lang.String spamModerationLevel) {
    this.spamModerationLevel = spamModerationLevel;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to add
   * members. Possible values are: - ALL_MEMBERS_CAN_ADD: Managers and members can directly add new
   * members.  - ALL_MANAGERS_CAN_ADD: Only managers can directly add new members. this includes the
   * group's owner.  - ALL_OWNERS_CAN_ADD: Only owners can directly add new members.  -
   * NONE_CAN_ADD: No one can directly add new members.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanAdd() {
    return whoCanAdd;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to add
   * members. Possible values are: - ALL_MEMBERS_CAN_ADD: Managers and members can directly add new
   * members.  - ALL_MANAGERS_CAN_ADD: Only managers can directly add new members. this includes the
   * group's owner.  - ALL_OWNERS_CAN_ADD: Only owners can directly add new members.  -
   * NONE_CAN_ADD: No one can directly add new members.
   * @param whoCanAdd whoCanAdd or {@code null} for none
   */
  public Groups setWhoCanAdd(java.lang.String whoCanAdd) {
    this.whoCanAdd = whoCanAdd;
    return this;
  }

  /**
   * Deprecated. This functionality is no longer supported in the Google Groups UI. The value is
   * always "NONE".
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanAddReferences() {
    return whoCanAddReferences;
  }

  /**
   * Deprecated. This functionality is no longer supported in the Google Groups UI. The value is
   * always "NONE".
   * @param whoCanAddReferences whoCanAddReferences or {@code null} for none
   */
  public Groups setWhoCanAddReferences(java.lang.String whoCanAddReferences) {
    this.whoCanAddReferences = whoCanAddReferences;
    return this;
  }

  /**
   * Specifies who can approve members who ask to join groups. This permission will be deprecated
   * once it is merged into the new whoCanModerateMembers setting. Possible values are: -
   * ALL_MEMBERS_CAN_APPROVE  - ALL_MANAGERS_CAN_APPROVE  - ALL_OWNERS_CAN_APPROVE  -
   * NONE_CAN_APPROVE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanApproveMembers() {
    return whoCanApproveMembers;
  }

  /**
   * Specifies who can approve members who ask to join groups. This permission will be deprecated
   * once it is merged into the new whoCanModerateMembers setting. Possible values are: -
   * ALL_MEMBERS_CAN_APPROVE  - ALL_MANAGERS_CAN_APPROVE  - ALL_OWNERS_CAN_APPROVE  -
   * NONE_CAN_APPROVE
   * @param whoCanApproveMembers whoCanApproveMembers or {@code null} for none
   */
  public Groups setWhoCanApproveMembers(java.lang.String whoCanApproveMembers) {
    this.whoCanApproveMembers = whoCanApproveMembers;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * approve pending messages in the moderation queue. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanApproveMessages() {
    return whoCanApproveMessages;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * approve pending messages in the moderation queue. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanApproveMessages whoCanApproveMessages or {@code null} for none
   */
  public Groups setWhoCanApproveMessages(java.lang.String whoCanApproveMessages) {
    this.whoCanApproveMessages = whoCanApproveMessages;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to assign
   * topics in a forum to another user. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanAssignTopics() {
    return whoCanAssignTopics;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to assign
   * topics in a forum to another user. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanAssignTopics whoCanAssignTopics or {@code null} for none
   */
  public Groups setWhoCanAssignTopics(java.lang.String whoCanAssignTopics) {
    this.whoCanAssignTopics = whoCanAssignTopics;
    return this;
  }

  /**
   * Specifies who can moderate metadata. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanAssistContent() {
    return whoCanAssistContent;
  }

  /**
   * Specifies who can moderate metadata. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanAssistContent whoCanAssistContent or {@code null} for none
   */
  public Groups setWhoCanAssistContent(java.lang.String whoCanAssistContent) {
    this.whoCanAssistContent = whoCanAssistContent;
    return this;
  }

  /**
   * Specifies who can deny membership to users. This permission will be deprecated once it is
   * merged into the new whoCanModerateMembers setting. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanBanUsers() {
    return whoCanBanUsers;
  }

  /**
   * Specifies who can deny membership to users. This permission will be deprecated once it is
   * merged into the new whoCanModerateMembers setting. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanBanUsers whoCanBanUsers or {@code null} for none
   */
  public Groups setWhoCanBanUsers(java.lang.String whoCanBanUsers) {
    this.whoCanBanUsers = whoCanBanUsers;
    return this;
  }

  /**
   * Permission to contact owner of the group via web UI. Possible values are: -
   * ALL_IN_DOMAIN_CAN_CONTACT  - ALL_MANAGERS_CAN_CONTACT  - ALL_MEMBERS_CAN_CONTACT  -
   * ANYONE_CAN_CONTACT  - ALL_OWNERS_CAN_CONTACT
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanContactOwner() {
    return whoCanContactOwner;
  }

  /**
   * Permission to contact owner of the group via web UI. Possible values are: -
   * ALL_IN_DOMAIN_CAN_CONTACT  - ALL_MANAGERS_CAN_CONTACT  - ALL_MEMBERS_CAN_CONTACT  -
   * ANYONE_CAN_CONTACT  - ALL_OWNERS_CAN_CONTACT
   * @param whoCanContactOwner whoCanContactOwner or {@code null} for none
   */
  public Groups setWhoCanContactOwner(java.lang.String whoCanContactOwner) {
    this.whoCanContactOwner = whoCanContactOwner;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * replies to topics. (Authors can always delete their own posts). Possible values are: -
   * ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanDeleteAnyPost() {
    return whoCanDeleteAnyPost;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * replies to topics. (Authors can always delete their own posts). Possible values are: -
   * ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanDeleteAnyPost whoCanDeleteAnyPost or {@code null} for none
   */
  public Groups setWhoCanDeleteAnyPost(java.lang.String whoCanDeleteAnyPost) {
    this.whoCanDeleteAnyPost = whoCanDeleteAnyPost;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * topics. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanDeleteTopics() {
    return whoCanDeleteTopics;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can delete
   * topics. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanDeleteTopics whoCanDeleteTopics or {@code null} for none
   */
  public Groups setWhoCanDeleteTopics(java.lang.String whoCanDeleteTopics) {
    this.whoCanDeleteTopics = whoCanDeleteTopics;
    return this;
  }

  /**
   * Specifies the set of users for whom this group is discoverable. Possible values are: -
   * ANYONE_CAN_DISCOVER  - ALL_IN_DOMAIN_CAN_DISCOVER  - ALL_MEMBERS_CAN_DISCOVER
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanDiscoverGroup() {
    return whoCanDiscoverGroup;
  }

  /**
   * Specifies the set of users for whom this group is discoverable. Possible values are: -
   * ANYONE_CAN_DISCOVER  - ALL_IN_DOMAIN_CAN_DISCOVER  - ALL_MEMBERS_CAN_DISCOVER
   * @param whoCanDiscoverGroup whoCanDiscoverGroup or {@code null} for none
   */
  public Groups setWhoCanDiscoverGroup(java.lang.String whoCanDiscoverGroup) {
    this.whoCanDiscoverGroup = whoCanDiscoverGroup;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to enter free
   * form tags for topics in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanEnterFreeFormTags() {
    return whoCanEnterFreeFormTags;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to enter free
   * form tags for topics in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanEnterFreeFormTags whoCanEnterFreeFormTags or {@code null} for none
   */
  public Groups setWhoCanEnterFreeFormTags(java.lang.String whoCanEnterFreeFormTags) {
    this.whoCanEnterFreeFormTags = whoCanEnterFreeFormTags;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can hide
   * posts by reporting them as abuse. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanHideAbuse() {
    return whoCanHideAbuse;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can hide
   * posts by reporting them as abuse. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @param whoCanHideAbuse whoCanHideAbuse or {@code null} for none
   */
  public Groups setWhoCanHideAbuse(java.lang.String whoCanHideAbuse) {
    this.whoCanHideAbuse = whoCanHideAbuse;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to invite
   * new members. Possible values are: - ALL_MEMBERS_CAN_INVITE: Managers and members can invite a
   * new member candidate.  - ALL_MANAGERS_CAN_INVITE: Only managers can invite a new member. This
   * includes the group's owner.  - ALL_OWNERS_CAN_INVITE: Only owners can invite a new member.  -
   * NONE_CAN_INVITE: No one can invite a new member candidate.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanInvite() {
    return whoCanInvite;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Permissions to invite
   * new members. Possible values are: - ALL_MEMBERS_CAN_INVITE: Managers and members can invite a
   * new member candidate.  - ALL_MANAGERS_CAN_INVITE: Only managers can invite a new member. This
   * includes the group's owner.  - ALL_OWNERS_CAN_INVITE: Only owners can invite a new member.  -
   * NONE_CAN_INVITE: No one can invite a new member candidate.
   * @param whoCanInvite whoCanInvite or {@code null} for none
   */
  public Groups setWhoCanInvite(java.lang.String whoCanInvite) {
    this.whoCanInvite = whoCanInvite;
    return this;
  }

  /**
   * Permission to join group. Possible values are: - ANYONE_CAN_JOIN: Anyone in the account domain
   * can join. This includes accounts with multiple domains.  - ALL_IN_DOMAIN_CAN_JOIN: Any Internet
   * user who is outside your domain can access your Google Groups service and view the list of
   * groups in your Groups directory. Warning: Group owners can add external addresses, outside of
   * the domain to their groups. They can also allow people outside your domain to join their
   * groups. If you later disable this option, any external addresses already added to users' groups
   * remain in those groups.  - INVITED_CAN_JOIN: Candidates for membership can be invited to join.
   * - CAN_REQUEST_TO_JOIN: Non members can request an invitation to join.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanJoin() {
    return whoCanJoin;
  }

  /**
   * Permission to join group. Possible values are: - ANYONE_CAN_JOIN: Anyone in the account domain
   * can join. This includes accounts with multiple domains.  - ALL_IN_DOMAIN_CAN_JOIN: Any Internet
   * user who is outside your domain can access your Google Groups service and view the list of
   * groups in your Groups directory. Warning: Group owners can add external addresses, outside of
   * the domain to their groups. They can also allow people outside your domain to join their
   * groups. If you later disable this option, any external addresses already added to users' groups
   * remain in those groups.  - INVITED_CAN_JOIN: Candidates for membership can be invited to join.
   * - CAN_REQUEST_TO_JOIN: Non members can request an invitation to join.
   * @param whoCanJoin whoCanJoin or {@code null} for none
   */
  public Groups setWhoCanJoin(java.lang.String whoCanJoin) {
    this.whoCanJoin = whoCanJoin;
    return this;
  }

  /**
   * Permission to leave the group. Possible values are: - ALL_MANAGERS_CAN_LEAVE  -
   * ALL_MEMBERS_CAN_LEAVE  - NONE_CAN_LEAVE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanLeaveGroup() {
    return whoCanLeaveGroup;
  }

  /**
   * Permission to leave the group. Possible values are: - ALL_MANAGERS_CAN_LEAVE  -
   * ALL_MEMBERS_CAN_LEAVE  - NONE_CAN_LEAVE
   * @param whoCanLeaveGroup whoCanLeaveGroup or {@code null} for none
   */
  public Groups setWhoCanLeaveGroup(java.lang.String whoCanLeaveGroup) {
    this.whoCanLeaveGroup = whoCanLeaveGroup;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * prevent users from posting replies to topics. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanLockTopics() {
    return whoCanLockTopics;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can
   * prevent users from posting replies to topics. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanLockTopics whoCanLockTopics or {@code null} for none
   */
  public Groups setWhoCanLockTopics(java.lang.String whoCanLockTopics) {
    this.whoCanLockTopics = whoCanLockTopics;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can make
   * topics appear at the top of the topic list. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMakeTopicsSticky() {
    return whoCanMakeTopicsSticky;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can make
   * topics appear at the top of the topic list. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - OWNERS_ONLY  - NONE
   * @param whoCanMakeTopicsSticky whoCanMakeTopicsSticky or {@code null} for none
   */
  public Groups setWhoCanMakeTopicsSticky(java.lang.String whoCanMakeTopicsSticky) {
    this.whoCanMakeTopicsSticky = whoCanMakeTopicsSticky;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as a duplicate of another topic. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMarkDuplicate() {
    return whoCanMarkDuplicate;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as a duplicate of another topic. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanMarkDuplicate whoCanMarkDuplicate or {@code null} for none
   */
  public Groups setWhoCanMarkDuplicate(java.lang.String whoCanMarkDuplicate) {
    this.whoCanMarkDuplicate = whoCanMarkDuplicate;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark any
   * other user's post as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMarkFavoriteReplyOnAnyTopic() {
    return whoCanMarkFavoriteReplyOnAnyTopic;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark any
   * other user's post as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanMarkFavoriteReplyOnAnyTopic whoCanMarkFavoriteReplyOnAnyTopic or {@code null} for none
   */
  public Groups setWhoCanMarkFavoriteReplyOnAnyTopic(java.lang.String whoCanMarkFavoriteReplyOnAnyTopic) {
    this.whoCanMarkFavoriteReplyOnAnyTopic = whoCanMarkFavoriteReplyOnAnyTopic;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a post
   * for a topic they started as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMarkFavoriteReplyOnOwnTopic() {
    return whoCanMarkFavoriteReplyOnOwnTopic;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a post
   * for a topic they started as a favorite reply. Possible values are: - ALL_MEMBERS  -
   * OWNERS_AND_MANAGERS  - MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanMarkFavoriteReplyOnOwnTopic whoCanMarkFavoriteReplyOnOwnTopic or {@code null} for none
   */
  public Groups setWhoCanMarkFavoriteReplyOnOwnTopic(java.lang.String whoCanMarkFavoriteReplyOnOwnTopic) {
    this.whoCanMarkFavoriteReplyOnOwnTopic = whoCanMarkFavoriteReplyOnOwnTopic;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as not needing a response. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMarkNoResponseNeeded() {
    return whoCanMarkNoResponseNeeded;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to mark a topic
   * as not needing a response. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanMarkNoResponseNeeded whoCanMarkNoResponseNeeded or {@code null} for none
   */
  public Groups setWhoCanMarkNoResponseNeeded(java.lang.String whoCanMarkNoResponseNeeded) {
    this.whoCanMarkNoResponseNeeded = whoCanMarkNoResponseNeeded;
    return this;
  }

  /**
   * Specifies who can moderate content. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanModerateContent() {
    return whoCanModerateContent;
  }

  /**
   * Specifies who can moderate content. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * @param whoCanModerateContent whoCanModerateContent or {@code null} for none
   */
  public Groups setWhoCanModerateContent(java.lang.String whoCanModerateContent) {
    this.whoCanModerateContent = whoCanModerateContent;
    return this;
  }

  /**
   * Specifies who can manage members. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanModerateMembers() {
    return whoCanModerateMembers;
  }

  /**
   * Specifies who can manage members. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @param whoCanModerateMembers whoCanModerateMembers or {@code null} for none
   */
  public Groups setWhoCanModerateMembers(java.lang.String whoCanModerateMembers) {
    this.whoCanModerateMembers = whoCanModerateMembers;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Specifies who can change
   * group members' roles. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY
   * - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanModifyMembers() {
    return whoCanModifyMembers;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateMembers setting. Specifies who can change
   * group members' roles. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - OWNERS_ONLY
   * - NONE
   * @param whoCanModifyMembers whoCanModifyMembers or {@code null} for none
   */
  public Groups setWhoCanModifyMembers(java.lang.String whoCanModifyMembers) {
    this.whoCanModifyMembers = whoCanModifyMembers;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to change tags
   * and categories. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanModifyTagsAndCategories() {
    return whoCanModifyTagsAndCategories;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to change tags
   * and categories. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @param whoCanModifyTagsAndCategories whoCanModifyTagsAndCategories or {@code null} for none
   */
  public Groups setWhoCanModifyTagsAndCategories(java.lang.String whoCanModifyTagsAndCategories) {
    this.whoCanModifyTagsAndCategories = whoCanModifyTagsAndCategories;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics into the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMoveTopicsIn() {
    return whoCanMoveTopicsIn;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics into the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @param whoCanMoveTopicsIn whoCanMoveTopicsIn or {@code null} for none
   */
  public Groups setWhoCanMoveTopicsIn(java.lang.String whoCanMoveTopicsIn) {
    this.whoCanMoveTopicsIn = whoCanMoveTopicsIn;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics out of the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanMoveTopicsOut() {
    return whoCanMoveTopicsOut;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can move
   * topics out of the group or forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * OWNERS_ONLY  - NONE
   * @param whoCanMoveTopicsOut whoCanMoveTopicsOut or {@code null} for none
   */
  public Groups setWhoCanMoveTopicsOut(java.lang.String whoCanMoveTopicsOut) {
    this.whoCanMoveTopicsOut = whoCanMoveTopicsOut;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can post
   * announcements, a special topic type. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanPostAnnouncements() {
    return whoCanPostAnnouncements;
  }

  /**
   * Deprecated. This is merged into the new whoCanModerateContent setting. Specifies who can post
   * announcements, a special topic type. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS
   * - OWNERS_ONLY  - NONE
   * @param whoCanPostAnnouncements whoCanPostAnnouncements or {@code null} for none
   */
  public Groups setWhoCanPostAnnouncements(java.lang.String whoCanPostAnnouncements) {
    this.whoCanPostAnnouncements = whoCanPostAnnouncements;
    return this;
  }

  /**
   * Permissions to post messages. Possible values are: - NONE_CAN_POST: The group is disabled and
   * archived. No one can post a message to this group.   - When archiveOnly is false, updating
   * whoCanPostMessage to NONE_CAN_POST, results in an error.  - If archiveOnly is reverted from
   * true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   - ALL_MANAGERS_CAN_POST:
   * Managers, including group owners, can post messages.  - ALL_MEMBERS_CAN_POST: Any group member
   * can post a message.  - ALL_OWNERS_CAN_POST: Only group owners can post a message.  -
   * ALL_IN_DOMAIN_CAN_POST: Anyone in the account can post a message.   - ANYONE_CAN_POST: Any
   * Internet user who outside your account can access your Google Groups service and post a
   * message. Note: When whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the
   * messageModerationLevel be set to MODERATE_NON_MEMBERS to protect the group from possible spam.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanPostMessage() {
    return whoCanPostMessage;
  }

  /**
   * Permissions to post messages. Possible values are: - NONE_CAN_POST: The group is disabled and
   * archived. No one can post a message to this group.   - When archiveOnly is false, updating
   * whoCanPostMessage to NONE_CAN_POST, results in an error.  - If archiveOnly is reverted from
   * true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.   - ALL_MANAGERS_CAN_POST:
   * Managers, including group owners, can post messages.  - ALL_MEMBERS_CAN_POST: Any group member
   * can post a message.  - ALL_OWNERS_CAN_POST: Only group owners can post a message.  -
   * ALL_IN_DOMAIN_CAN_POST: Anyone in the account can post a message.   - ANYONE_CAN_POST: Any
   * Internet user who outside your account can access your Google Groups service and post a
   * message. Note: When whoCanPostMessage is set to ANYONE_CAN_POST, we recommend the
   * messageModerationLevel be set to MODERATE_NON_MEMBERS to protect the group from possible spam.
   * @param whoCanPostMessage whoCanPostMessage or {@code null} for none
   */
  public Groups setWhoCanPostMessage(java.lang.String whoCanPostMessage) {
    this.whoCanPostMessage = whoCanPostMessage;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to take topics
   * in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanTakeTopics() {
    return whoCanTakeTopics;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to take topics
   * in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @param whoCanTakeTopics whoCanTakeTopics or {@code null} for none
   */
  public Groups setWhoCanTakeTopics(java.lang.String whoCanTakeTopics) {
    this.whoCanTakeTopics = whoCanTakeTopics;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unassign any
   * topic in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanUnassignTopic() {
    return whoCanUnassignTopic;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unassign any
   * topic in a forum. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  - MANAGERS_ONLY  -
   * OWNERS_ONLY  - NONE
   * @param whoCanUnassignTopic whoCanUnassignTopic or {@code null} for none
   */
  public Groups setWhoCanUnassignTopic(java.lang.String whoCanUnassignTopic) {
    this.whoCanUnassignTopic = whoCanUnassignTopic;
    return this;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unmark any
   * post from a favorite reply. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanUnmarkFavoriteReplyOnAnyTopic() {
    return whoCanUnmarkFavoriteReplyOnAnyTopic;
  }

  /**
   * Deprecated. This is merged into the new whoCanAssistContent setting. Permission to unmark any
   * post from a favorite reply. Possible values are: - ALL_MEMBERS  - OWNERS_AND_MANAGERS  -
   * MANAGERS_ONLY  - OWNERS_ONLY  - NONE
   * @param whoCanUnmarkFavoriteReplyOnAnyTopic whoCanUnmarkFavoriteReplyOnAnyTopic or {@code null} for none
   */
  public Groups setWhoCanUnmarkFavoriteReplyOnAnyTopic(java.lang.String whoCanUnmarkFavoriteReplyOnAnyTopic) {
    this.whoCanUnmarkFavoriteReplyOnAnyTopic = whoCanUnmarkFavoriteReplyOnAnyTopic;
    return this;
  }

  /**
   * Permissions to view group messages. Possible values are: - ANYONE_CAN_VIEW: Any Internet user
   * can view the group's messages.   - ALL_IN_DOMAIN_CAN_VIEW: Anyone in your account can view this
   * group's messages.  - ALL_MEMBERS_CAN_VIEW: All group members can view the group's messages.  -
   * ALL_MANAGERS_CAN_VIEW: Any group manager can view this group's messages.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanViewGroup() {
    return whoCanViewGroup;
  }

  /**
   * Permissions to view group messages. Possible values are: - ANYONE_CAN_VIEW: Any Internet user
   * can view the group's messages.   - ALL_IN_DOMAIN_CAN_VIEW: Anyone in your account can view this
   * group's messages.  - ALL_MEMBERS_CAN_VIEW: All group members can view the group's messages.  -
   * ALL_MANAGERS_CAN_VIEW: Any group manager can view this group's messages.
   * @param whoCanViewGroup whoCanViewGroup or {@code null} for none
   */
  public Groups setWhoCanViewGroup(java.lang.String whoCanViewGroup) {
    this.whoCanViewGroup = whoCanViewGroup;
    return this;
  }

  /**
   * Permissions to view membership. Possible values are: - ALL_IN_DOMAIN_CAN_VIEW: Anyone in the
   * account can view the group members list. If a group already has external members, those members
   * can still send email to this group.   - ALL_MEMBERS_CAN_VIEW: The group members can view the
   * group members list.  - ALL_MANAGERS_CAN_VIEW: The group managers can view group members list.
   * @return value or {@code null} for none
   */
  public java.lang.String getWhoCanViewMembership() {
    return whoCanViewMembership;
  }

  /**
   * Permissions to view membership. Possible values are: - ALL_IN_DOMAIN_CAN_VIEW: Anyone in the
   * account can view the group members list. If a group already has external members, those members
   * can still send email to this group.   - ALL_MEMBERS_CAN_VIEW: The group members can view the
   * group members list.  - ALL_MANAGERS_CAN_VIEW: The group managers can view group members list.
   * @param whoCanViewMembership whoCanViewMembership or {@code null} for none
   */
  public Groups setWhoCanViewMembership(java.lang.String whoCanViewMembership) {
    this.whoCanViewMembership = whoCanViewMembership;
    return this;
  }

  @Override
  public Groups set(String fieldName, Object value) {
    return (Groups) super.set(fieldName, value);
  }

  @Override
  public Groups clone() {
    return (Groups) super.clone();
  }

}
