/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1;

/**
 * Service definition for CloudHealthcare (v1).
 *
 * <p>
 * Manage, store, and access healthcare data in Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/healthcare" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudHealthcareRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class CloudHealthcare extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Cloud Healthcare API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://healthcare.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://healthcare.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public CloudHealthcare(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  CloudHealthcare(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
   *   {@code CloudHealthcare.Projects.List request = healthcare.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
     *   {@code CloudHealthcare.Locations.List request = healthcare.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Gets information about a location.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the healthcare server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Resource name for the location.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Location> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Gets information about a location.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the healthcare server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name for the location.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name for the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name for the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name for the location. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists information about the supported locations for this service.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the healthcare server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The resource that owns the locations collection, if applicable.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListLocationsResponse> {

        private static final String REST_PATH = "v1/{+name}/locations";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists information about the supported locations for this service.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the healthcare server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource that owns the locations collection, if applicable.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource that owns the locations collection, if applicable. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource that owns the locations collection, if applicable.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource that owns the locations collection, if applicable. */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A filter to narrow down results to a preferred subset. The filtering language accepts strings like
       "displayName=tokyo", and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return. If not set, the service selects a default.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token received from the `next_page_token` field in the response. Send that page token to
       receive the subsequent page.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Datasets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
       *   {@code CloudHealthcare.Datasets.List request = healthcare.datasets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Datasets datasets() {
        return new Datasets();
      }

      /**
       * The "datasets" collection of methods.
       */
      public class Datasets {

        /**
         * Creates a new health dataset. Results are returned through the Operation interface which returns
         * either an `Operation.response` which contains a Dataset or `Operation.error`. The metadata field
         * type is OperationMetadata.
         *
         * Create a request for the method "datasets.create".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the project where the server creates the dataset. For example,
         *        `projects/{project_id}/locations/{location_id}`.
         * @param content the {@link com.google.api.services.healthcare.v1.model.Dataset}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Dataset content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/datasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new health dataset. Results are returned through the Operation interface which
           * returns either an `Operation.response` which contains a Dataset or `Operation.error`. The
           * metadata field type is OperationMetadata.
           *
           * Create a request for the method "datasets.create".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the project where the server creates the dataset. For example,
         *        `projects/{project_id}/locations/{location_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.Dataset}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Dataset content) {
            super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of the project where the server creates the dataset. For example,
           * `projects/{project_id}/locations/{location_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the project where the server creates the dataset. For example,
         `projects/{project_id}/locations/{location_id}`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The name of the project where the server creates the dataset. For example,
           * `projects/{project_id}/locations/{location_id}`.
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * The ID of the dataset that is being created. The string must match the following regex:
           * `[\p{L}\p{N}_\-\.]{1,256}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String datasetId;

          /** The ID of the dataset that is being created. The string must match the following regex:
         `[\p{L}\p{N}_\-\.]{1,256}`.
           */
          public java.lang.String getDatasetId() {
            return datasetId;
          }

          /**
           * The ID of the dataset that is being created. The string must match the following regex:
           * `[\p{L}\p{N}_\-\.]{1,256}`.
           */
          public Create setDatasetId(java.lang.String datasetId) {
            this.datasetId = datasetId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Creates a new dataset containing de-identified data from the source dataset. The metadata field
         * type is OperationMetadata. If the request is successful, the response field type is
         * DeidentifySummary. If errors occur, error is set. The LRO result may still be successful if de-
         * identification fails for some DICOM instances. The new de-identified dataset will not contain
         * these failed resources. Failed resource totals are tracked in Operation.metadata. Error details
         * are also logged to Cloud Logging. For more information, see [Viewing error logs in Cloud
         * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
         *
         * Create a request for the method "datasets.deidentify".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link Deidentify#execute()} method to invoke the remote operation.
         *
         * @param sourceDataset Source dataset resource name. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
         * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyDatasetRequest}
         * @return the request
         */
        public Deidentify deidentify(java.lang.String sourceDataset, com.google.api.services.healthcare.v1.model.DeidentifyDatasetRequest content) throws java.io.IOException {
          Deidentify result = new Deidentify(sourceDataset, content);
          initialize(result);
          return result;
        }

        public class Deidentify extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+sourceDataset}:deidentify";

          private final java.util.regex.Pattern SOURCE_DATASET_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Creates a new dataset containing de-identified data from the source dataset. The metadata field
           * type is OperationMetadata. If the request is successful, the response field type is
           * DeidentifySummary. If errors occur, error is set. The LRO result may still be successful if de-
           * identification fails for some DICOM instances. The new de-identified dataset will not contain
           * these failed resources. Failed resource totals are tracked in Operation.metadata. Error details
           * are also logged to Cloud Logging. For more information, see [Viewing error logs in Cloud
           * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
           *
           * Create a request for the method "datasets.deidentify".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link Deidentify#execute()} method to invoke the remote
           * operation. <p> {@link
           * Deidentify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param sourceDataset Source dataset resource name. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyDatasetRequest}
           * @since 1.13
           */
          protected Deidentify(java.lang.String sourceDataset, com.google.api.services.healthcare.v1.model.DeidentifyDatasetRequest content) {
            super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
            this.sourceDataset = com.google.api.client.util.Preconditions.checkNotNull(sourceDataset, "Required parameter sourceDataset must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(SOURCE_DATASET_PATTERN.matcher(sourceDataset).matches(),
                  "Parameter sourceDataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public Deidentify set$Xgafv(java.lang.String $Xgafv) {
            return (Deidentify) super.set$Xgafv($Xgafv);
          }

          @Override
          public Deidentify setAccessToken(java.lang.String accessToken) {
            return (Deidentify) super.setAccessToken(accessToken);
          }

          @Override
          public Deidentify setAlt(java.lang.String alt) {
            return (Deidentify) super.setAlt(alt);
          }

          @Override
          public Deidentify setCallback(java.lang.String callback) {
            return (Deidentify) super.setCallback(callback);
          }

          @Override
          public Deidentify setFields(java.lang.String fields) {
            return (Deidentify) super.setFields(fields);
          }

          @Override
          public Deidentify setKey(java.lang.String key) {
            return (Deidentify) super.setKey(key);
          }

          @Override
          public Deidentify setOauthToken(java.lang.String oauthToken) {
            return (Deidentify) super.setOauthToken(oauthToken);
          }

          @Override
          public Deidentify setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Deidentify) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Deidentify setQuotaUser(java.lang.String quotaUser) {
            return (Deidentify) super.setQuotaUser(quotaUser);
          }

          @Override
          public Deidentify setUploadType(java.lang.String uploadType) {
            return (Deidentify) super.setUploadType(uploadType);
          }

          @Override
          public Deidentify setUploadProtocol(java.lang.String uploadProtocol) {
            return (Deidentify) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Source dataset resource name. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String sourceDataset;

          /** Source dataset resource name. For example,
         `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public java.lang.String getSourceDataset() {
            return sourceDataset;
          }

          /**
           * Source dataset resource name. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public Deidentify setSourceDataset(java.lang.String sourceDataset) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(SOURCE_DATASET_PATTERN.matcher(sourceDataset).matches(),
                  "Parameter sourceDataset must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.sourceDataset = sourceDataset;
            return this;
          }

          @Override
          public Deidentify set(String parameterName, Object value) {
            return (Deidentify) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the specified health dataset and all data contained in the dataset. Deleting a dataset
         * does not affect the sources from which the dataset was imported (if any).
         *
         * Create a request for the method "datasets.delete".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the dataset to delete. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Deletes the specified health dataset and all data contained in the dataset. Deleting a dataset
           * does not affect the sources from which the dataset was imported (if any).
           *
           * Create a request for the method "datasets.delete".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the dataset to delete. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of the dataset to delete. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the dataset to delete. For example,
         `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name of the dataset to delete. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets any metadata associated with a dataset.
         *
         * Create a request for the method "datasets.get".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the dataset to read. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Dataset> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Gets any metadata associated with a dataset.
           *
           * Create a request for the method "datasets.get".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the dataset to read. For example,
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Dataset.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of the dataset to read. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the dataset to read. For example,
         `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name of the dataset to read. For example,
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "datasets.getIamPolicy".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "datasets.getIamPolicy".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
         specifying an invalid value will be rejected. Requests for policies with any conditional bindings
         must specify version 3. Policies without any conditional bindings may specify any valid value or
         leave the field unset. To learn which resources support conditions in their IAM policies, see the
         [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Lists the health datasets in the current project.
         *
         * Create a request for the method "datasets.list".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the project whose datasets should be listed. For example,
         *        `projects/{project_id}/locations/{location_id}`.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListDatasetsResponse> {

          private static final String REST_PATH = "v1/{+parent}/datasets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists the health datasets in the current project.
           *
           * Create a request for the method "datasets.list".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the project whose datasets should be listed. For example,
         *        `projects/{project_id}/locations/{location_id}`.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListDatasetsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of the project whose datasets should be listed. For example,
           * `projects/{project_id}/locations/{location_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the project whose datasets should be listed. For example,
         `projects/{project_id}/locations/{location_id}`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The name of the project whose datasets should be listed. For example,
           * `projects/{project_id}/locations/{location_id}`.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * The maximum number of items to return. If not specified, 100 is used. May not be larger
           * than 1000.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of items to return. If not specified, 100 is used. May not be larger than 1000.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of items to return. If not specified, 100 is used. May not be larger
           * than 1000.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /** The next_page_token value returned from a previous List request, if any. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The next_page_token value returned from a previous List request, if any.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The next_page_token value returned from a previous List request, if any. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates dataset metadata.
         *
         * Create a request for the method "datasets.patch".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name Resource name of the dataset, of the form
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
         * @param content the {@link com.google.api.services.healthcare.v1.model.Dataset}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Dataset content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Dataset> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Updates dataset metadata.
           *
           * Create a request for the method "datasets.patch".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Resource name of the dataset, of the form
         *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.Dataset}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Dataset content) {
            super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.Dataset.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Resource name of the dataset, of the form
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Resource name of the dataset, of the form
         `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Resource name of the dataset, of the form
           * `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The update mask applies to the resource. For the `FieldMask` definition, see
           * https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The update mask applies to the resource. For the `FieldMask` definition, see
         https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * The update mask applies to the resource. For the `FieldMask` definition, see
           * https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "datasets.setIamPolicy".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "datasets.setIamPolicy".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) {
            super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
         * designed to be used for building permission-aware UIs and command-line tools, not for
         * authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "datasets.testIamPermissions".
         *
         * This request holds the parameters needed by the healthcare server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
           * operation is designed to be used for building permission-aware UIs and command-line tools, not
           * for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "datasets.testIamPermissions".
           *
           * This request holds the parameters needed by the the healthcare server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) {
            super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the ConsentStores collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
         *   {@code CloudHealthcare.ConsentStores.List request = healthcare.consentStores().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public ConsentStores consentStores() {
          return new ConsentStores();
        }

        /**
         * The "consentStores" collection of methods.
         */
        public class ConsentStores {

          /**
           * Checks if a particular data_id of a User data mapping in the specified consent store is consented
           * for the specified use.
           *
           * Create a request for the method "consentStores.checkDataAccess".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link CheckDataAccess#execute()} method to invoke the remote operation.
           *
           * @param consentStore Required. Name of the consent store where the requested data_id is stored, of the form `projects/{pr
           *        oject_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.CheckDataAccessRequest}
           * @return the request
           */
          public CheckDataAccess checkDataAccess(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.CheckDataAccessRequest content) throws java.io.IOException {
            CheckDataAccess result = new CheckDataAccess(consentStore, content);
            initialize(result);
            return result;
          }

          public class CheckDataAccess extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.CheckDataAccessResponse> {

            private static final String REST_PATH = "v1/{+consentStore}:checkDataAccess";

            private final java.util.regex.Pattern CONSENT_STORE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Checks if a particular data_id of a User data mapping in the specified consent store is
             * consented for the specified use.
             *
             * Create a request for the method "consentStores.checkDataAccess".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link CheckDataAccess#execute()} method to invoke the remote
             * operation. <p> {@link CheckDataAccess#initialize(com.google.api.client.googleapis.services.Abst
             * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param consentStore Required. Name of the consent store where the requested data_id is stored, of the form `projects/{pr
           *        oject_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.CheckDataAccessRequest}
             * @since 1.13
             */
            protected CheckDataAccess(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.CheckDataAccessRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.CheckDataAccessResponse.class);
              this.consentStore = com.google.api.client.util.Preconditions.checkNotNull(consentStore, "Required parameter consentStore must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public CheckDataAccess set$Xgafv(java.lang.String $Xgafv) {
              return (CheckDataAccess) super.set$Xgafv($Xgafv);
            }

            @Override
            public CheckDataAccess setAccessToken(java.lang.String accessToken) {
              return (CheckDataAccess) super.setAccessToken(accessToken);
            }

            @Override
            public CheckDataAccess setAlt(java.lang.String alt) {
              return (CheckDataAccess) super.setAlt(alt);
            }

            @Override
            public CheckDataAccess setCallback(java.lang.String callback) {
              return (CheckDataAccess) super.setCallback(callback);
            }

            @Override
            public CheckDataAccess setFields(java.lang.String fields) {
              return (CheckDataAccess) super.setFields(fields);
            }

            @Override
            public CheckDataAccess setKey(java.lang.String key) {
              return (CheckDataAccess) super.setKey(key);
            }

            @Override
            public CheckDataAccess setOauthToken(java.lang.String oauthToken) {
              return (CheckDataAccess) super.setOauthToken(oauthToken);
            }

            @Override
            public CheckDataAccess setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (CheckDataAccess) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public CheckDataAccess setQuotaUser(java.lang.String quotaUser) {
              return (CheckDataAccess) super.setQuotaUser(quotaUser);
            }

            @Override
            public CheckDataAccess setUploadType(java.lang.String uploadType) {
              return (CheckDataAccess) super.setUploadType(uploadType);
            }

            @Override
            public CheckDataAccess setUploadProtocol(java.lang.String uploadProtocol) {
              return (CheckDataAccess) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. Name of the consent store where the requested data_id is stored, of the
             * form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStor
             * es/{consent_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String consentStore;

            /** Required. Name of the consent store where the requested data_id is stored, of the form `projects/{p
           roject_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`.
             */
            public java.lang.String getConsentStore() {
              return consentStore;
            }

            /**
             * Required. Name of the consent store where the requested data_id is stored, of the
             * form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStor
             * es/{consent_store_id}`.
             */
            public CheckDataAccess setConsentStore(java.lang.String consentStore) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.consentStore = consentStore;
              return this;
            }

            @Override
            public CheckDataAccess set(String parameterName, Object value) {
              return (CheckDataAccess) super.set(parameterName, value);
            }
          }
          /**
           * Creates a new consent store in the parent dataset. Attempting to create a consent store with the
           * same ID as an existing store fails with an ALREADY_EXISTS error.
           *
           * Create a request for the method "consentStores.create".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The name of the dataset this consent store belongs to.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentStore}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.ConsentStore content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ConsentStore> {

            private static final String REST_PATH = "v1/{+parent}/consentStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Creates a new consent store in the parent dataset. Attempting to create a consent store with
             * the same ID as an existing store fails with an ALREADY_EXISTS error.
             *
             * Create a request for the method "consentStores.create".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The name of the dataset this consent store belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentStore}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.ConsentStore content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.ConsentStore.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The name of the dataset this consent store belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The name of the dataset this consent store belongs to.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Required. The name of the dataset this consent store belongs to. */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Required. The ID of the consent store to create. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`. Cannot be changed after creation.
             */
            @com.google.api.client.util.Key
            private java.lang.String consentStoreId;

            /** Required. The ID of the consent store to create. The string must match the following regex:
           `[\p{L}\p{N}_\-\.]{1,256}`. Cannot be changed after creation.
             */
            public java.lang.String getConsentStoreId() {
              return consentStoreId;
            }

            /**
             * Required. The ID of the consent store to create. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`. Cannot be changed after creation.
             */
            public Create setConsentStoreId(java.lang.String consentStoreId) {
              this.consentStoreId = consentStoreId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Deletes the specified consent store and removes all the consent store's data.
           *
           * Create a request for the method "consentStores.delete".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the consent store to delete.
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Deletes the specified consent store and removes all the consent store's data.
             *
             * Create a request for the method "consentStores.delete".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the consent store to delete.
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the consent store to delete. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the consent store to delete.
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The resource name of the consent store to delete. */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Evaluates the user's Consents for all matching User data mappings. Note: User data mappings are
           * indexed asynchronously, which can cause a slight delay between the time mappings are created or
           * updated and when they are included in EvaluateUserConsents results.
           *
           * Create a request for the method "consentStores.evaluateUserConsents".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link EvaluateUserConsents#execute()} method to invoke the remote
           * operation.
           *
           * @param consentStore Required. Name of the consent store to retrieve User data mappings from.
           * @param content the {@link com.google.api.services.healthcare.v1.model.EvaluateUserConsentsRequest}
           * @return the request
           */
          public EvaluateUserConsents evaluateUserConsents(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.EvaluateUserConsentsRequest content) throws java.io.IOException {
            EvaluateUserConsents result = new EvaluateUserConsents(consentStore, content);
            initialize(result);
            return result;
          }

          public class EvaluateUserConsents extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.EvaluateUserConsentsResponse> {

            private static final String REST_PATH = "v1/{+consentStore}:evaluateUserConsents";

            private final java.util.regex.Pattern CONSENT_STORE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Evaluates the user's Consents for all matching User data mappings. Note: User data mappings are
             * indexed asynchronously, which can cause a slight delay between the time mappings are created or
             * updated and when they are included in EvaluateUserConsents results.
             *
             * Create a request for the method "consentStores.evaluateUserConsents".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link EvaluateUserConsents#execute()} method to invoke the
             * remote operation. <p> {@link EvaluateUserConsents#initialize(com.google.api.client.googleapis.s
             * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
             * after invoking the constructor. </p>
             *
             * @param consentStore Required. Name of the consent store to retrieve User data mappings from.
             * @param content the {@link com.google.api.services.healthcare.v1.model.EvaluateUserConsentsRequest}
             * @since 1.13
             */
            protected EvaluateUserConsents(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.EvaluateUserConsentsRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.EvaluateUserConsentsResponse.class);
              this.consentStore = com.google.api.client.util.Preconditions.checkNotNull(consentStore, "Required parameter consentStore must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public EvaluateUserConsents set$Xgafv(java.lang.String $Xgafv) {
              return (EvaluateUserConsents) super.set$Xgafv($Xgafv);
            }

            @Override
            public EvaluateUserConsents setAccessToken(java.lang.String accessToken) {
              return (EvaluateUserConsents) super.setAccessToken(accessToken);
            }

            @Override
            public EvaluateUserConsents setAlt(java.lang.String alt) {
              return (EvaluateUserConsents) super.setAlt(alt);
            }

            @Override
            public EvaluateUserConsents setCallback(java.lang.String callback) {
              return (EvaluateUserConsents) super.setCallback(callback);
            }

            @Override
            public EvaluateUserConsents setFields(java.lang.String fields) {
              return (EvaluateUserConsents) super.setFields(fields);
            }

            @Override
            public EvaluateUserConsents setKey(java.lang.String key) {
              return (EvaluateUserConsents) super.setKey(key);
            }

            @Override
            public EvaluateUserConsents setOauthToken(java.lang.String oauthToken) {
              return (EvaluateUserConsents) super.setOauthToken(oauthToken);
            }

            @Override
            public EvaluateUserConsents setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (EvaluateUserConsents) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public EvaluateUserConsents setQuotaUser(java.lang.String quotaUser) {
              return (EvaluateUserConsents) super.setQuotaUser(quotaUser);
            }

            @Override
            public EvaluateUserConsents setUploadType(java.lang.String uploadType) {
              return (EvaluateUserConsents) super.setUploadType(uploadType);
            }

            @Override
            public EvaluateUserConsents setUploadProtocol(java.lang.String uploadProtocol) {
              return (EvaluateUserConsents) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. Name of the consent store to retrieve User data mappings from. */
            @com.google.api.client.util.Key
            private java.lang.String consentStore;

            /** Required. Name of the consent store to retrieve User data mappings from.
             */
            public java.lang.String getConsentStore() {
              return consentStore;
            }

            /** Required. Name of the consent store to retrieve User data mappings from. */
            public EvaluateUserConsents setConsentStore(java.lang.String consentStore) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.consentStore = consentStore;
              return this;
            }

            @Override
            public EvaluateUserConsents set(String parameterName, Object value) {
              return (EvaluateUserConsents) super.set(parameterName, value);
            }
          }
          /**
           * Gets the specified consent store.
           *
           * Create a request for the method "consentStores.get".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the consent store to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ConsentStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Gets the specified consent store.
             *
             * Create a request for the method "consentStores.get".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the consent store to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ConsentStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the consent store to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the consent store to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The resource name of the consent store to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "consentStores.getIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "consentStores.getIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
           specifying an invalid value will be rejected. Requests for policies with any conditional bindings
           must specify version 3. Policies without any conditional bindings may specify any valid value or
           leave the field unset. To learn which resources support conditions in their IAM policies, see the
           [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Lists the consent stores in the specified dataset.
           *
           * Create a request for the method "consentStores.list".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. Name of the dataset.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListConsentStoresResponse> {

            private static final String REST_PATH = "v1/{+parent}/consentStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Lists the consent stores in the specified dataset.
             *
             * Create a request for the method "consentStores.list".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. Name of the dataset.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListConsentStoresResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. Name of the dataset. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. Name of the dataset.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Required. Name of the dataset. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Optional. Restricts the stores returned to those matching a filter. Only filtering on
             * labels is supported. For example, `filter=labels.key=value`.
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Optional. Restricts the stores returned to those matching a filter. Only filtering on labels is
           supported. For example, `filter=labels.key=value`.
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Optional. Restricts the stores returned to those matching a filter. Only filtering on
             * labels is supported. For example, `filter=labels.key=value`.
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Optional. Limit on the number of consent stores to return in a single response. If
             * not specified, 100 is used. May not be larger than 1000.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional. Limit on the number of consent stores to return in a single response. If not specified,
           100 is used. May not be larger than 1000.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Optional. Limit on the number of consent stores to return in a single response. If
             * not specified, 100 is used. May not be larger than 1000.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. Token to retrieve the next page of results, or empty to get the first page.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. Token to retrieve the next page of results, or empty to get the first page.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. Token to retrieve the next page of results, or empty to get the first page.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Updates the specified consent store.
           *
           * Create a request for the method "consentStores.patch".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Resource name of the consent store, of the form `projects/{project_id}/locations/{location_id}/datas
           *        ets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed after creation.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentStore}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.ConsentStore content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ConsentStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Updates the specified consent store.
             *
             * Create a request for the method "consentStores.patch".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Resource name of the consent store, of the form `projects/{project_id}/locations/{location_id}/datas
           *        ets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed after creation.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentStore}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.ConsentStore content) {
              super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.ConsentStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Resource name of the consent store, of the form `projects/{project_id}/locations/{loc
             * ation_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed
             * after creation.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Resource name of the consent store, of the form `projects/{project_id}/locations/{location_id}/data
           sets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed after creation.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Resource name of the consent store, of the form `projects/{project_id}/locations/{loc
             * ation_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`. Cannot be changed
             * after creation.
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * Required. The update mask that applies to the resource. For the `FieldMask`
             * definition, see https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask. Only the `labels`,
             * `default_consent_ttl`, and `enable_consent_create_on_update` fields are allowed to be
             * updated.
             */
            @com.google.api.client.util.Key
            private String updateMask;

            /** Required. The update mask that applies to the resource. For the `FieldMask` definition, see
           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask. Only the
           `labels`, `default_consent_ttl`, and `enable_consent_create_on_update` fields are allowed to be
           updated.
             */
            public String getUpdateMask() {
              return updateMask;
            }

            /**
             * Required. The update mask that applies to the resource. For the `FieldMask`
             * definition, see https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask. Only the `labels`,
             * `default_consent_ttl`, and `enable_consent_create_on_update` fields are allowed to be
             * updated.
             */
            public Patch setUpdateMask(String updateMask) {
              this.updateMask = updateMask;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }
          /**
           * Queries all data_ids that are consented for a specified use in the given consent store and writes
           * them to a specified destination. The returned Operation includes a progress counter for the
           * number of User data mappings processed. If the request is successful, a detailed response is
           * returned of type QueryAccessibleDataResponse, contained in the response field when the operation
           * finishes. The metadata field type is OperationMetadata. Errors are logged to Cloud Logging (see
           * [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
           * For example, the following sample log entry shows a `failed to evaluate consent policy` error
           * that occurred during a QueryAccessibleData call to consent store `projects/{project_id}/locations
           * /{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`. ```json jsonPayload: {
           * @type: "type.googleapis.com/google.cloud.healthcare.logging.QueryAccessibleDataLogEntry" error: {
           * code: 9 message: "failed to evaluate consent policy" } resourceName: "projects/{project_id}/locat
           * ions/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}"
           * } logName: "projects/{project_id}/logs/healthcare.googleapis.com%2Fquery_accessible_data"
           * operation: { id:
           * "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operations/{operation_id}"
           * producer: "healthcare.googleapis.com/QueryAccessibleData" } receiveTimestamp: "TIMESTAMP"
           * resource: { labels: { consent_store_id: "{consent_store_id}" dataset_id: "{dataset_id}" location:
           * "{location_id}" project_id: "{project_id}" } type: "healthcare_consent_store" } severity: "ERROR"
           * timestamp: "TIMESTAMP" ```
           *
           * Create a request for the method "consentStores.queryAccessibleData".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link QueryAccessibleData#execute()} method to invoke the remote operation.
           *
           * @param consentStore Required. Name of the consent store to retrieve User data mappings from.
           * @param content the {@link com.google.api.services.healthcare.v1.model.QueryAccessibleDataRequest}
           * @return the request
           */
          public QueryAccessibleData queryAccessibleData(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.QueryAccessibleDataRequest content) throws java.io.IOException {
            QueryAccessibleData result = new QueryAccessibleData(consentStore, content);
            initialize(result);
            return result;
          }

          public class QueryAccessibleData extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+consentStore}:queryAccessibleData";

            private final java.util.regex.Pattern CONSENT_STORE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Queries all data_ids that are consented for a specified use in the given consent store and
             * writes them to a specified destination. The returned Operation includes a progress counter for
             * the number of User data mappings processed. If the request is successful, a detailed response
             * is returned of type QueryAccessibleDataResponse, contained in the response field when the
             * operation finishes. The metadata field type is OperationMetadata. Errors are logged to Cloud
             * Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs
             * /how-tos/logging)). For example, the following sample log entry shows a `failed to evaluate
             * consent policy` error that occurred during a QueryAccessibleData call to consent store `project
             * s/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`.
             * ```json jsonPayload: { @type:
             * "type.googleapis.com/google.cloud.healthcare.logging.QueryAccessibleDataLogEntry" error: {
             * code: 9 message: "failed to evaluate consent policy" } resourceName: "projects/{project_id}/loc
             * ations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_i
             * d}" } logName: "projects/{project_id}/logs/healthcare.googleapis.com%2Fquery_accessible_data"
             * operation: { id:
             * "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operations/{operation_id}"
             * producer: "healthcare.googleapis.com/QueryAccessibleData" } receiveTimestamp: "TIMESTAMP"
             * resource: { labels: { consent_store_id: "{consent_store_id}" dataset_id: "{dataset_id}"
             * location: "{location_id}" project_id: "{project_id}" } type: "healthcare_consent_store" }
             * severity: "ERROR" timestamp: "TIMESTAMP" ```
             *
             * Create a request for the method "consentStores.queryAccessibleData".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link QueryAccessibleData#execute()} method to invoke the remote
             * operation. <p> {@link QueryAccessibleData#initialize(com.google.api.client.googleapis.services.
             * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param consentStore Required. Name of the consent store to retrieve User data mappings from.
             * @param content the {@link com.google.api.services.healthcare.v1.model.QueryAccessibleDataRequest}
             * @since 1.13
             */
            protected QueryAccessibleData(java.lang.String consentStore, com.google.api.services.healthcare.v1.model.QueryAccessibleDataRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.consentStore = com.google.api.client.util.Preconditions.checkNotNull(consentStore, "Required parameter consentStore must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public QueryAccessibleData set$Xgafv(java.lang.String $Xgafv) {
              return (QueryAccessibleData) super.set$Xgafv($Xgafv);
            }

            @Override
            public QueryAccessibleData setAccessToken(java.lang.String accessToken) {
              return (QueryAccessibleData) super.setAccessToken(accessToken);
            }

            @Override
            public QueryAccessibleData setAlt(java.lang.String alt) {
              return (QueryAccessibleData) super.setAlt(alt);
            }

            @Override
            public QueryAccessibleData setCallback(java.lang.String callback) {
              return (QueryAccessibleData) super.setCallback(callback);
            }

            @Override
            public QueryAccessibleData setFields(java.lang.String fields) {
              return (QueryAccessibleData) super.setFields(fields);
            }

            @Override
            public QueryAccessibleData setKey(java.lang.String key) {
              return (QueryAccessibleData) super.setKey(key);
            }

            @Override
            public QueryAccessibleData setOauthToken(java.lang.String oauthToken) {
              return (QueryAccessibleData) super.setOauthToken(oauthToken);
            }

            @Override
            public QueryAccessibleData setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (QueryAccessibleData) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public QueryAccessibleData setQuotaUser(java.lang.String quotaUser) {
              return (QueryAccessibleData) super.setQuotaUser(quotaUser);
            }

            @Override
            public QueryAccessibleData setUploadType(java.lang.String uploadType) {
              return (QueryAccessibleData) super.setUploadType(uploadType);
            }

            @Override
            public QueryAccessibleData setUploadProtocol(java.lang.String uploadProtocol) {
              return (QueryAccessibleData) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. Name of the consent store to retrieve User data mappings from. */
            @com.google.api.client.util.Key
            private java.lang.String consentStore;

            /** Required. Name of the consent store to retrieve User data mappings from.
             */
            public java.lang.String getConsentStore() {
              return consentStore;
            }

            /** Required. Name of the consent store to retrieve User data mappings from. */
            public QueryAccessibleData setConsentStore(java.lang.String consentStore) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(CONSENT_STORE_PATTERN.matcher(consentStore).matches(),
                    "Parameter consentStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.consentStore = consentStore;
              return this;
            }

            @Override
            public QueryAccessibleData set(String parameterName, Object value) {
              return (QueryAccessibleData) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "consentStores.setIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy. Can
             * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "consentStores.setIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
           * designed to be used for building permission-aware UIs and command-line tools, not for
           * authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "consentStores.testIamPermissions".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
             * operation is designed to be used for building permission-aware UIs and command-line tools, not
             * for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "consentStores.testIamPermissions".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the AttributeDefinitions collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.AttributeDefinitions.List request = healthcare.attributeDefinitions().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public AttributeDefinitions attributeDefinitions() {
            return new AttributeDefinitions();
          }

          /**
           * The "attributeDefinitions" collection of methods.
           */
          public class AttributeDefinitions {

            /**
             * Creates a new Attribute definition in the parent consent store.
             *
             * Create a request for the method "attributeDefinitions.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The name of the consent store that this Attribute definition belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.AttributeDefinition}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.AttributeDefinition content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.AttributeDefinition> {

              private static final String REST_PATH = "v1/{+parent}/attributeDefinitions";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Creates a new Attribute definition in the parent consent store.
               *
               * Create a request for the method "attributeDefinitions.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. The name of the consent store that this Attribute definition belongs to.
               * @param content the {@link com.google.api.services.healthcare.v1.model.AttributeDefinition}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.AttributeDefinition content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.AttributeDefinition.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The name of the consent store that this Attribute definition belongs to.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The name of the consent store that this Attribute definition belongs to.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * Required. The name of the consent store that this Attribute definition belongs to.
               */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Required. The ID of the Attribute definition to create. The string must match the
               * following regex: `_a-zA-Z{0,255}` and must not be a reserved keyword within the
               * Common Expression Language as listed on https://github.com/google/cel-
               * spec/blob/master/doc/langdef.md.
               */
              @com.google.api.client.util.Key
              private java.lang.String attributeDefinitionId;

              /** Required. The ID of the Attribute definition to create. The string must match the following regex:
             `_a-zA-Z{0,255}` and must not be a reserved keyword within the Common Expression Language as listed
             on https://github.com/google/cel-spec/blob/master/doc/langdef.md.
               */
              public java.lang.String getAttributeDefinitionId() {
                return attributeDefinitionId;
              }

              /**
               * Required. The ID of the Attribute definition to create. The string must match the
               * following regex: `_a-zA-Z{0,255}` and must not be a reserved keyword within the
               * Common Expression Language as listed on https://github.com/google/cel-
               * spec/blob/master/doc/langdef.md.
               */
              public Create setAttributeDefinitionId(java.lang.String attributeDefinitionId) {
                this.attributeDefinitionId = attributeDefinitionId;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes the specified Attribute definition. Fails if the Attribute definition is referenced by
             * any User data mapping, or the latest revision of any Consent.
             *
             * Create a request for the method "attributeDefinitions.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Attribute definition to delete. To preserve referential
             *        integrity, Attribute definitions referenced by a User data mapping or the latest revision
             *        of a Consent cannot be deleted.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");

              /**
               * Deletes the specified Attribute definition. Fails if the Attribute definition is referenced by
               * any User data mapping, or the latest revision of any Consent.
               *
               * Create a request for the method "attributeDefinitions.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Attribute definition to delete. To preserve referential
             *        integrity, Attribute definitions referenced by a User data mapping or the latest revision
             *        of a Consent cannot be deleted.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Attribute definition to delete. To preserve
               * referential integrity, Attribute definitions referenced by a User data mapping or
               * the latest revision of a Consent cannot be deleted.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Attribute definition to delete. To preserve referential
             integrity, Attribute definitions referenced by a User data mapping or the latest revision of a
             Consent cannot be deleted.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Attribute definition to delete. To preserve
               * referential integrity, Attribute definitions referenced by a User data mapping or
               * the latest revision of a Consent cannot be deleted.
               */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Gets the specified Attribute definition.
             *
             * Create a request for the method "attributeDefinitions.get".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Attribute definition to get.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.AttributeDefinition> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");

              /**
               * Gets the specified Attribute definition.
               *
               * Create a request for the method "attributeDefinitions.get".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Attribute definition to get.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.AttributeDefinition.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the Attribute definition to get. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Attribute definition to get.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the Attribute definition to get. */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }
            /**
             * Lists the Attribute definitions in the specified consent store.
             *
             * Create a request for the method "attributeDefinitions.list".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store to retrieve Attribute definitions from.
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListAttributeDefinitionsResponse> {

              private static final String REST_PATH = "v1/{+parent}/attributeDefinitions";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Lists the Attribute definitions in the specified consent store.
               *
               * Create a request for the method "attributeDefinitions.list".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store to retrieve Attribute definitions from.
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListAttributeDefinitionsResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store to retrieve Attribute definitions from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store to retrieve Attribute definitions from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store to retrieve Attribute definitions from. */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Optional. Restricts the attributes returned to those matching a filter. The only
               * field available for filtering is `category`. For example,
               * `filter=category=\"REQUEST\"`.
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Restricts the attributes returned to those matching a filter. The only field available
             for filtering is `category`. For example, `filter=category=\"REQUEST\"`.
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Restricts the attributes returned to those matching a filter. The only
               * field available for filtering is `category`. For example,
               * `filter=category=\"REQUEST\"`.
               */
              public List setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Limit on the number of Attribute definitions to return in a single
               * response. If not specified, 100 is used. May not be larger than 1000.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Limit on the number of Attribute definitions to return in a single response. If not
             specified, 100 is used. May not be larger than 1000.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Limit on the number of Attribute definitions to return in a single
               * response. If not specified, 100 is used. May not be larger than 1000.
               */
              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. Token to retrieve the next page of results or empty to get the first
               * page.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. Token to retrieve the next page of results or empty to get the first page.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. Token to retrieve the next page of results or empty to get the first
               * page.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }
            /**
             * Updates the specified Attribute definition.
             *
             * Create a request for the method "attributeDefinitions.patch".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             *
             * @param name Resource name of the Attribute definition, of the form `projects/{project_id}/locations/{location_id
             *        }/datasets/{dataset_id}/consentStores/{consent_store_id}/attributeDefinitions/{attribute_d
             *        efinition_id}`. Cannot be changed after creation.
             * @param content the {@link com.google.api.services.healthcare.v1.model.AttributeDefinition}
             * @return the request
             */
            public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.AttributeDefinition content) throws java.io.IOException {
              Patch result = new Patch(name, content);
              initialize(result);
              return result;
            }

            public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.AttributeDefinition> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");

              /**
               * Updates the specified Attribute definition.
               *
               * Create a request for the method "attributeDefinitions.patch".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
               * <p> {@link
               * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Resource name of the Attribute definition, of the form `projects/{project_id}/locations/{location_id
             *        }/datasets/{dataset_id}/consentStores/{consent_store_id}/attributeDefinitions/{attribute_d
             *        efinition_id}`. Cannot be changed after creation.
               * @param content the {@link com.google.api.services.healthcare.v1.model.AttributeDefinition}
               * @since 1.13
               */
              protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.AttributeDefinition content) {
                super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.AttributeDefinition.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
              }

              @Override
              public Patch set$Xgafv(java.lang.String $Xgafv) {
                return (Patch) super.set$Xgafv($Xgafv);
              }

              @Override
              public Patch setAccessToken(java.lang.String accessToken) {
                return (Patch) super.setAccessToken(accessToken);
              }

              @Override
              public Patch setAlt(java.lang.String alt) {
                return (Patch) super.setAlt(alt);
              }

              @Override
              public Patch setCallback(java.lang.String callback) {
                return (Patch) super.setCallback(callback);
              }

              @Override
              public Patch setFields(java.lang.String fields) {
                return (Patch) super.setFields(fields);
              }

              @Override
              public Patch setKey(java.lang.String key) {
                return (Patch) super.setKey(key);
              }

              @Override
              public Patch setOauthToken(java.lang.String oauthToken) {
                return (Patch) super.setOauthToken(oauthToken);
              }

              @Override
              public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Patch) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Patch setQuotaUser(java.lang.String quotaUser) {
                return (Patch) super.setQuotaUser(quotaUser);
              }

              @Override
              public Patch setUploadType(java.lang.String uploadType) {
                return (Patch) super.setUploadType(uploadType);
              }

              @Override
              public Patch setUploadProtocol(java.lang.String uploadProtocol) {
                return (Patch) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Resource name of the Attribute definition, of the form `projects/{project_id}/locat
               * ions/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/attribute
               * Definitions/{attribute_definition_id}`. Cannot be changed after creation.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Resource name of the Attribute definition, of the form `projects/{project_id}/locations/{location_i
             d}/datasets/{dataset_id}/consentStores/{consent_store_id}/attributeDefinitions/{attribute_definitio
             n_id}`. Cannot be changed after creation.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Resource name of the Attribute definition, of the form `projects/{project_id}/locat
               * ions/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/attribute
               * Definitions/{attribute_definition_id}`. Cannot be changed after creation.
               */
              public Patch setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/attributeDefinitions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Required. The update mask that applies to the resource. For the `FieldMask`
               * definition, see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `description`,
               * `allowed_values`, `consent_default_values` and `data_mapping_default_value` fields
               * can be updated. The updated `allowed_values` must contain all values from the
               * previous `allowed_values`.
               */
              @com.google.api.client.util.Key
              private String updateMask;

              /** Required. The update mask that applies to the resource. For the `FieldMask` definition, see
             https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask. Only the
             `description`, `allowed_values`, `consent_default_values` and `data_mapping_default_value` fields
             can be updated. The updated `allowed_values` must contain all values from the previous
             `allowed_values`.
               */
              public String getUpdateMask() {
                return updateMask;
              }

              /**
               * Required. The update mask that applies to the resource. For the `FieldMask`
               * definition, see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `description`,
               * `allowed_values`, `consent_default_values` and `data_mapping_default_value` fields
               * can be updated. The updated `allowed_values` must contain all values from the
               * previous `allowed_values`.
               */
              public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
              }

              @Override
              public Patch set(String parameterName, Object value) {
                return (Patch) super.set(parameterName, value);
              }
            }

          }
          /**
           * An accessor for creating requests from the ConsentArtifacts collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.ConsentArtifacts.List request = healthcare.consentArtifacts().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public ConsentArtifacts consentArtifacts() {
            return new ConsentArtifacts();
          }

          /**
           * The "consentArtifacts" collection of methods.
           */
          public class ConsentArtifacts {

            /**
             * Creates a new Consent artifact in the parent consent store.
             *
             * Create a request for the method "consentArtifacts.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The name of the consent store this Consent artifact belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentArtifact}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.ConsentArtifact content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ConsentArtifact> {

              private static final String REST_PATH = "v1/{+parent}/consentArtifacts";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Creates a new Consent artifact in the parent consent store.
               *
               * Create a request for the method "consentArtifacts.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. The name of the consent store this Consent artifact belongs to.
               * @param content the {@link com.google.api.services.healthcare.v1.model.ConsentArtifact}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.ConsentArtifact content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.ConsentArtifact.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The name of the consent store this Consent artifact belongs to. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The name of the consent store this Consent artifact belongs to.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. The name of the consent store this Consent artifact belongs to. */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes the specified Consent artifact. Fails if the artifact is referenced by the latest
             * revision of any Consent.
             *
             * Create a request for the method "consentArtifacts.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent artifact to delete. To preserve referential integrity,
             *        Consent artifacts referenced by the latest revision of a Consent cannot be deleted.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");

              /**
               * Deletes the specified Consent artifact. Fails if the artifact is referenced by the latest
               * revision of any Consent.
               *
               * Create a request for the method "consentArtifacts.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent artifact to delete. To preserve referential integrity,
             *        Consent artifacts referenced by the latest revision of a Consent cannot be deleted.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent artifact to delete. To preserve
               * referential integrity, Consent artifacts referenced by the latest revision of a
               * Consent cannot be deleted.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent artifact to delete. To preserve referential integrity,
             Consent artifacts referenced by the latest revision of a Consent cannot be deleted.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent artifact to delete. To preserve
               * referential integrity, Consent artifacts referenced by the latest revision of a
               * Consent cannot be deleted.
               */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Gets the specified Consent artifact.
             *
             * Create a request for the method "consentArtifacts.get".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent artifact to retrieve.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ConsentArtifact> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");

              /**
               * Gets the specified Consent artifact.
               *
               * Create a request for the method "consentArtifacts.get".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent artifact to retrieve.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ConsentArtifact.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the Consent artifact to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent artifact to retrieve.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the Consent artifact to retrieve. */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consentArtifacts/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }
            /**
             * Lists the Consent artifacts in the specified consent store.
             *
             * Create a request for the method "consentArtifacts.list".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store to retrieve consent artifacts from.
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListConsentArtifactsResponse> {

              private static final String REST_PATH = "v1/{+parent}/consentArtifacts";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Lists the Consent artifacts in the specified consent store.
               *
               * Create a request for the method "consentArtifacts.list".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store to retrieve consent artifacts from.
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListConsentArtifactsResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store to retrieve consent artifacts from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store to retrieve consent artifacts from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store to retrieve consent artifacts from. */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Optional. Restricts the artifacts returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - user_id. For example, `filter=user_id=\"user123\"`. -
               * consent_content_version - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Restricts the artifacts returned to those matching a filter. The following syntax is
             available: * A string field value can be written as text inside quotation marks, for example
             `"query text"`. The only valid relational operation for text fields is equality (`=`), where text
             is searched within the field, rather than having the field be equal to the text. For example,
             `"Comment = great"` returns messages with `great` in the comment field. * A number field value can
             be written as an integer, a decimal, or an exponential. The valid relational operators for number
             fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`,
             `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to
             an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with
             date and time use the RFC3339 time format. Leading zeros are required for one-digit months and
             days. The valid relational operators for date fields are the equality operator (`=`) , along with
             the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality
             (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             query expressions can be combined in one query by adding `AND` or `OR` operators between the
             expressions. If a boolean operator appears within a quoted string, it is not treated as special,
             it's just another part of the character string to be matched. You can prepend the `NOT` operator to
             an expression to negate it. The fields available for filtering are: - user_id. For example,
             `filter=user_id=\"user123\"`. - consent_content_version - metadata. For example,
             `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Restricts the artifacts returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - user_id. For example, `filter=user_id=\"user123\"`. -
               * consent_content_version - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public List setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Limit on the number of consent artifacts to return in a single response.
               * If not specified, 100 is used. May not be larger than 1000.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Limit on the number of consent artifacts to return in a single response. If not
             specified, 100 is used. May not be larger than 1000.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Limit on the number of consent artifacts to return in a single response.
               * If not specified, 100 is used. May not be larger than 1000.
               */
              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. The next_page_token value returned from the previous List request, if
               * any.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. The next_page_token value returned from the previous List request, if any.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. The next_page_token value returned from the previous List request, if
               * any.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }

          }
          /**
           * An accessor for creating requests from the Consents collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.Consents.List request = healthcare.consents().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public Consents consents() {
            return new Consents();
          }

          /**
           * The "consents" collection of methods.
           */
          public class Consents {

            /**
             * Activates the latest revision of the specified Consent by committing a new revision with `state`
             * updated to `ACTIVE`. If the latest revision of the specified Consent is in the `ACTIVE` state, no
             * new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision of the
             * specified Consent is in the `REJECTED` or `REVOKED` state.
             *
             * Create a request for the method "consents.activate".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Activate#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to activate, of the form `projects/{project_id}/locations
             *        /{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id
             *        }`. An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ActivateConsentRequest}
             * @return the request
             */
            public Activate activate(java.lang.String name, com.google.api.services.healthcare.v1.model.ActivateConsentRequest content) throws java.io.IOException {
              Activate result = new Activate(name, content);
              initialize(result);
              return result;
            }

            public class Activate extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+name}:activate";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Activates the latest revision of the specified Consent by committing a new revision with
               * `state` updated to `ACTIVE`. If the latest revision of the specified Consent is in the `ACTIVE`
               * state, no new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision
               * of the specified Consent is in the `REJECTED` or `REVOKED` state.
               *
               * Create a request for the method "consents.activate".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Activate#execute()} method to invoke the remote operation.
               * <p> {@link
               * Activate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to activate, of the form `projects/{project_id}/locations
             *        /{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id
             *        }`. An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               * @param content the {@link com.google.api.services.healthcare.v1.model.ActivateConsentRequest}
               * @since 1.13
               */
              protected Activate(java.lang.String name, com.google.api.services.healthcare.v1.model.ActivateConsentRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Consent.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public Activate set$Xgafv(java.lang.String $Xgafv) {
                return (Activate) super.set$Xgafv($Xgafv);
              }

              @Override
              public Activate setAccessToken(java.lang.String accessToken) {
                return (Activate) super.setAccessToken(accessToken);
              }

              @Override
              public Activate setAlt(java.lang.String alt) {
                return (Activate) super.setAlt(alt);
              }

              @Override
              public Activate setCallback(java.lang.String callback) {
                return (Activate) super.setCallback(callback);
              }

              @Override
              public Activate setFields(java.lang.String fields) {
                return (Activate) super.setFields(fields);
              }

              @Override
              public Activate setKey(java.lang.String key) {
                return (Activate) super.setKey(key);
              }

              @Override
              public Activate setOauthToken(java.lang.String oauthToken) {
                return (Activate) super.setOauthToken(oauthToken);
              }

              @Override
              public Activate setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Activate) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Activate setQuotaUser(java.lang.String quotaUser) {
                return (Activate) super.setQuotaUser(quotaUser);
              }

              @Override
              public Activate setUploadType(java.lang.String uploadType) {
                return (Activate) super.setUploadType(uploadType);
              }

              @Override
              public Activate setUploadProtocol(java.lang.String uploadProtocol) {
                return (Activate) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent to activate, of the form `projects/{proj
               * ect_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_
               * id}/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to activate, of the form `projects/{project_id}/location
             s/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. An
             INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent to activate, of the form `projects/{proj
               * ect_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_
               * id}/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              public Activate setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Activate set(String parameterName, Object value) {
                return (Activate) super.set(parameterName, value);
              }
            }
            /**
             * Creates a new Consent in the parent consent store.
             *
             * Create a request for the method "consents.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store.
             * @param content the {@link com.google.api.services.healthcare.v1.model.Consent}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Consent content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+parent}/consents";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Creates a new Consent in the parent consent store.
               *
               * Create a request for the method "consents.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store.
               * @param content the {@link com.google.api.services.healthcare.v1.model.Consent}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Consent content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Consent.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store. */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes the Consent and its revisions. To keep a record of the Consent but mark it inactive, see
             * [RevokeConsent]. To delete a revision of a Consent, see [DeleteConsentRevision]. This operation
             * does not delete the related Consent artifact.
             *
             * Create a request for the method "consents.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to delete, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Deletes the Consent and its revisions. To keep a record of the Consent but mark it inactive,
               * see [RevokeConsent]. To delete a revision of a Consent, see [DeleteConsentRevision]. This
               * operation does not delete the related Consent artifact.
               *
               * Create a request for the method "consents.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to delete, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent to delete, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to delete, of the form `projects/{project_id}/locations/
             {location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. An
             INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent to delete, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Deletes the specified revision of a Consent. An INVALID_ARGUMENT error occurs if the specified
             * revision is the latest revision.
             *
             * Create a request for the method "consents.deleteRevision".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link DeleteRevision#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent revision to delete, of the form `projects/{project_id}/lo
             *        cations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{con
             *        sent_id}@{revision_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is not
             *        specified in the name.
             * @return the request
             */
            public DeleteRevision deleteRevision(java.lang.String name) throws java.io.IOException {
              DeleteRevision result = new DeleteRevision(name);
              initialize(result);
              return result;
            }

            public class DeleteRevision extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}:deleteRevision";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Deletes the specified revision of a Consent. An INVALID_ARGUMENT error occurs if the specified
               * revision is the latest revision.
               *
               * Create a request for the method "consents.deleteRevision".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link DeleteRevision#execute()} method to invoke the remote
               * operation. <p> {@link DeleteRevision#initialize(com.google.api.client.googleapis.services.Abstr
               * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param name Required. The resource name of the Consent revision to delete, of the form `projects/{project_id}/lo
             *        cations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{con
             *        sent_id}@{revision_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is not
             *        specified in the name.
               * @since 1.13
               */
              protected DeleteRevision(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public DeleteRevision set$Xgafv(java.lang.String $Xgafv) {
                return (DeleteRevision) super.set$Xgafv($Xgafv);
              }

              @Override
              public DeleteRevision setAccessToken(java.lang.String accessToken) {
                return (DeleteRevision) super.setAccessToken(accessToken);
              }

              @Override
              public DeleteRevision setAlt(java.lang.String alt) {
                return (DeleteRevision) super.setAlt(alt);
              }

              @Override
              public DeleteRevision setCallback(java.lang.String callback) {
                return (DeleteRevision) super.setCallback(callback);
              }

              @Override
              public DeleteRevision setFields(java.lang.String fields) {
                return (DeleteRevision) super.setFields(fields);
              }

              @Override
              public DeleteRevision setKey(java.lang.String key) {
                return (DeleteRevision) super.setKey(key);
              }

              @Override
              public DeleteRevision setOauthToken(java.lang.String oauthToken) {
                return (DeleteRevision) super.setOauthToken(oauthToken);
              }

              @Override
              public DeleteRevision setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (DeleteRevision) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public DeleteRevision setQuotaUser(java.lang.String quotaUser) {
                return (DeleteRevision) super.setQuotaUser(quotaUser);
              }

              @Override
              public DeleteRevision setUploadType(java.lang.String uploadType) {
                return (DeleteRevision) super.setUploadType(uploadType);
              }

              @Override
              public DeleteRevision setUploadProtocol(java.lang.String uploadProtocol) {
                return (DeleteRevision) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent revision to delete, of the form `project
               * s/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent
               * _store_id}/consents/{consent_id}@{revision_id}`. An INVALID_ARGUMENT error occurs
               * if `revision_id` is not specified in the name.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent revision to delete, of the form `projects/{project_id}/l
             ocations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}
             @{revision_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is not specified in the name.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent revision to delete, of the form `project
               * s/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent
               * _store_id}/consents/{consent_id}@{revision_id}`. An INVALID_ARGUMENT error occurs
               * if `revision_id` is not specified in the name.
               */
              public DeleteRevision setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public DeleteRevision set(String parameterName, Object value) {
                return (DeleteRevision) super.set(parameterName, value);
              }
            }
            /**
             * Gets the specified revision of a Consent, or the latest revision if `revision_id` is not
             * specified in the resource name.
             *
             * Create a request for the method "consents.get".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to retrieve, of the form `projects/{project_id}/locations
             *        /{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id
             *        }`. In order to retrieve a previous revision of the Consent, also provide the revision ID:
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consen
             *        t_store_id}/consents/{consent_id}@{revision_id}`
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Gets the specified revision of a Consent, or the latest revision if `revision_id` is not
               * specified in the resource name.
               *
               * Create a request for the method "consents.get".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to retrieve, of the form `projects/{project_id}/locations
             *        /{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id
             *        }`. In order to retrieve a previous revision of the Consent, also provide the revision ID:
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consen
             *        t_store_id}/consents/{consent_id}@{revision_id}`
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Consent.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent to retrieve, of the form `projects/{proj
               * ect_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_
               * id}/consents/{consent_id}`. In order to retrieve a previous revision of the
               * Consent, also provide the revision ID: `projects/{project_id}/locations/{location_i
               * d}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}@{re
               * vision_id}`
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to retrieve, of the form `projects/{project_id}/location
             s/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. In
             order to retrieve a previous revision of the Consent, also provide the revision ID: `projects/{proj
             ect_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{co
             nsent_id}@{revision_id}`
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent to retrieve, of the form `projects/{proj
               * ect_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_
               * id}/consents/{consent_id}`. In order to retrieve a previous revision of the
               * Consent, also provide the revision ID: `projects/{project_id}/locations/{location_i
               * d}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}@{re
               * vision_id}`
               */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }
            /**
             * Lists the Consent in the given consent store, returning each Consent's latest revision.
             *
             * Create a request for the method "consents.list".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store to retrieve Consents from.
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListConsentsResponse> {

              private static final String REST_PATH = "v1/{+parent}/consents";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Lists the Consent in the given consent store, returning each Consent's latest revision.
               *
               * Create a request for the method "consents.list".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store to retrieve Consents from.
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListConsentsResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store to retrieve Consents from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store to retrieve Consents from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store to retrieve Consents from. */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Optional. Restricts the Consents returned to those matching a filter. The following
               * syntax is available: * A string field value can be written as text inside quotation
               * marks, for example `"query text"`. The only valid relational operation for text
               * fields is equality (`=`), where text is searched within the field, rather than
               * having the field be equal to the text. For example, `"Comment = great"` returns
               * messages with `great` in the comment field. * A number field value can be written
               * as an integer, a decimal, or an exponential. The valid relational operators for
               * number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - user_id. For example, `filter='user_id="user123"'`. - consent_artifact -
               * state - revision_create_time - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Restricts the Consents returned to those matching a filter. The following syntax is
             available: * A string field value can be written as text inside quotation marks, for example
             `"query text"`. The only valid relational operation for text fields is equality (`=`), where text
             is searched within the field, rather than having the field be equal to the text. For example,
             `"Comment = great"` returns messages with `great` in the comment field. * A number field value can
             be written as an integer, a decimal, or an exponential. The valid relational operators for number
             fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`,
             `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to
             an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with
             date and time use the RFC3339 time format. Leading zeros are required for one-digit months and
             days. The valid relational operators for date fields are the equality operator (`=`) , along with
             the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality
             (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             query expressions can be combined in one query by adding `AND` or `OR` operators between the
             expressions. If a boolean operator appears within a quoted string, it is not treated as special,
             it's just another part of the character string to be matched. You can prepend the `NOT` operator to
             an expression to negate it. The fields available for filtering are: - user_id. For example,
             `filter='user_id="user123"'`. - consent_artifact - state - revision_create_time - metadata. For
             example, `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Restricts the Consents returned to those matching a filter. The following
               * syntax is available: * A string field value can be written as text inside quotation
               * marks, for example `"query text"`. The only valid relational operation for text
               * fields is equality (`=`), where text is searched within the field, rather than
               * having the field be equal to the text. For example, `"Comment = great"` returns
               * messages with `great` in the comment field. * A number field value can be written
               * as an integer, a decimal, or an exponential. The valid relational operators for
               * number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - user_id. For example, `filter='user_id="user123"'`. - consent_artifact -
               * state - revision_create_time - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public List setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Limit on the number of Consents to return in a single response. If not
               * specified, 100 is used. May not be larger than 1000.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Limit on the number of Consents to return in a single response. If not specified, 100 is
             used. May not be larger than 1000.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Limit on the number of Consents to return in a single response. If not
               * specified, 100 is used. May not be larger than 1000.
               */
              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. The next_page_token value returned from the previous List request, if
               * any.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. The next_page_token value returned from the previous List request, if any.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. The next_page_token value returned from the previous List request, if
               * any.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }
            /**
             * Lists the revisions of the specified Consent in reverse chronological order.
             *
             * Create a request for the method "consents.listRevisions".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link ListRevisions#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to retrieve revisions for.
             * @return the request
             */
            public ListRevisions listRevisions(java.lang.String name) throws java.io.IOException {
              ListRevisions result = new ListRevisions(name);
              initialize(result);
              return result;
            }

            public class ListRevisions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListConsentRevisionsResponse> {

              private static final String REST_PATH = "v1/{+name}:listRevisions";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Lists the revisions of the specified Consent in reverse chronological order.
               *
               * Create a request for the method "consents.listRevisions".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link ListRevisions#execute()} method to invoke the remote
               * operation. <p> {@link ListRevisions#initialize(com.google.api.client.googleapis.services.Abstra
               * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to retrieve revisions for.
               * @since 1.13
               */
              protected ListRevisions(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListConsentRevisionsResponse.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public ListRevisions set$Xgafv(java.lang.String $Xgafv) {
                return (ListRevisions) super.set$Xgafv($Xgafv);
              }

              @Override
              public ListRevisions setAccessToken(java.lang.String accessToken) {
                return (ListRevisions) super.setAccessToken(accessToken);
              }

              @Override
              public ListRevisions setAlt(java.lang.String alt) {
                return (ListRevisions) super.setAlt(alt);
              }

              @Override
              public ListRevisions setCallback(java.lang.String callback) {
                return (ListRevisions) super.setCallback(callback);
              }

              @Override
              public ListRevisions setFields(java.lang.String fields) {
                return (ListRevisions) super.setFields(fields);
              }

              @Override
              public ListRevisions setKey(java.lang.String key) {
                return (ListRevisions) super.setKey(key);
              }

              @Override
              public ListRevisions setOauthToken(java.lang.String oauthToken) {
                return (ListRevisions) super.setOauthToken(oauthToken);
              }

              @Override
              public ListRevisions setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (ListRevisions) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public ListRevisions setQuotaUser(java.lang.String quotaUser) {
                return (ListRevisions) super.setQuotaUser(quotaUser);
              }

              @Override
              public ListRevisions setUploadType(java.lang.String uploadType) {
                return (ListRevisions) super.setUploadType(uploadType);
              }

              @Override
              public ListRevisions setUploadProtocol(java.lang.String uploadProtocol) {
                return (ListRevisions) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the Consent to retrieve revisions for. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to retrieve revisions for.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the Consent to retrieve revisions for. */
              public ListRevisions setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Optional. Restricts the revisions returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. Fields available for filtering are: -
               * user_id. For example, `filter='user_id="user123"'`. - consent_artifact - state -
               * revision_create_time - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Restricts the revisions returned to those matching a filter. The following syntax is
             available: * A string field value can be written as text inside quotation marks, for example
             `"query text"`. The only valid relational operation for text fields is equality (`=`), where text
             is searched within the field, rather than having the field be equal to the text. For example,
             `"Comment = great"` returns messages with `great` in the comment field. * A number field value can
             be written as an integer, a decimal, or an exponential. The valid relational operators for number
             fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`,
             `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to
             an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with
             date and time use the RFC3339 time format. Leading zeros are required for one-digit months and
             days. The valid relational operators for date fields are the equality operator (`=`) , along with
             the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality
             (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             query expressions can be combined in one query by adding `AND` or `OR` operators between the
             expressions. If a boolean operator appears within a quoted string, it is not treated as special,
             it's just another part of the character string to be matched. You can prepend the `NOT` operator to
             an expression to negate it. Fields available for filtering are: - user_id. For example,
             `filter='user_id="user123"'`. - consent_artifact - state - revision_create_time - metadata. For
             example, `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Restricts the revisions returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. Fields available for filtering are: -
               * user_id. For example, `filter='user_id="user123"'`. - consent_artifact - state -
               * revision_create_time - metadata. For example,
               * `filter=Metadata(\"testkey\")=\"value\"` or `filter=HasMetadata(\"testkey\")`.
               */
              public ListRevisions setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Limit on the number of revisions to return in a single response. If not
               * specified, 100 is used. May not be larger than 1000.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Limit on the number of revisions to return in a single response. If not specified, 100 is
             used. May not be larger than 1000.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Limit on the number of revisions to return in a single response. If not
               * specified, 100 is used. May not be larger than 1000.
               */
              public ListRevisions setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. Token to retrieve the next page of results or empty if there are no more
               * results in the list.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. Token to retrieve the next page of results or empty if there are no more results in the
             list.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. Token to retrieve the next page of results or empty if there are no more
               * results in the list.
               */
              public ListRevisions setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public ListRevisions set(String parameterName, Object value) {
                return (ListRevisions) super.set(parameterName, value);
              }
            }
            /**
             * Updates the latest revision of the specified Consent by committing a new revision with the
             * changes. A FAILED_PRECONDITION error occurs if the latest revision of the specified Consent is in
             * the `REJECTED` or `REVOKED` state.
             *
             * Create a request for the method "consents.patch".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             *
             * @param name Resource name of the Consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{d
             *        ataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be changed
             *        after creation.
             * @param content the {@link com.google.api.services.healthcare.v1.model.Consent}
             * @return the request
             */
            public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Consent content) throws java.io.IOException {
              Patch result = new Patch(name, content);
              initialize(result);
              return result;
            }

            public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Updates the latest revision of the specified Consent by committing a new revision with the
               * changes. A FAILED_PRECONDITION error occurs if the latest revision of the specified Consent is
               * in the `REJECTED` or `REVOKED` state.
               *
               * Create a request for the method "consents.patch".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
               * <p> {@link
               * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Resource name of the Consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{d
             *        ataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be changed
             *        after creation.
               * @param content the {@link com.google.api.services.healthcare.v1.model.Consent}
               * @since 1.13
               */
              protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Consent content) {
                super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.Consent.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public Patch set$Xgafv(java.lang.String $Xgafv) {
                return (Patch) super.set$Xgafv($Xgafv);
              }

              @Override
              public Patch setAccessToken(java.lang.String accessToken) {
                return (Patch) super.setAccessToken(accessToken);
              }

              @Override
              public Patch setAlt(java.lang.String alt) {
                return (Patch) super.setAlt(alt);
              }

              @Override
              public Patch setCallback(java.lang.String callback) {
                return (Patch) super.setCallback(callback);
              }

              @Override
              public Patch setFields(java.lang.String fields) {
                return (Patch) super.setFields(fields);
              }

              @Override
              public Patch setKey(java.lang.String key) {
                return (Patch) super.setKey(key);
              }

              @Override
              public Patch setOauthToken(java.lang.String oauthToken) {
                return (Patch) super.setOauthToken(oauthToken);
              }

              @Override
              public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Patch) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Patch setQuotaUser(java.lang.String quotaUser) {
                return (Patch) super.setQuotaUser(quotaUser);
              }

              @Override
              public Patch setUploadType(java.lang.String uploadType) {
                return (Patch) super.setUploadType(uploadType);
              }

              @Override
              public Patch setUploadProtocol(java.lang.String uploadProtocol) {
                return (Patch) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Resource name of the Consent, of the form `projects/{project_id}/locations/{locatio
               * n_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
               * . Cannot be changed after creation.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Resource name of the Consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{
             dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be changed after
             creation.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Resource name of the Consent, of the form `projects/{project_id}/locations/{locatio
               * n_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
               * . Cannot be changed after creation.
               */
              public Patch setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Required. The update mask to apply to the resource. For the `FieldMask` definition,
               * see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `user_id`, `policies`,
               * `consent_artifact`, and `metadata` fields can be updated.
               */
              @com.google.api.client.util.Key
              private String updateMask;

              /** Required. The update mask to apply to the resource. For the `FieldMask` definition, see
             https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask. Only the
             `user_id`, `policies`, `consent_artifact`, and `metadata` fields can be updated.
               */
              public String getUpdateMask() {
                return updateMask;
              }

              /**
               * Required. The update mask to apply to the resource. For the `FieldMask` definition,
               * see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `user_id`, `policies`,
               * `consent_artifact`, and `metadata` fields can be updated.
               */
              public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
              }

              @Override
              public Patch set(String parameterName, Object value) {
                return (Patch) super.set(parameterName, value);
              }
            }
            /**
             * Rejects the latest revision of the specified Consent by committing a new revision with `state`
             * updated to `REJECTED`. If the latest revision of the specified Consent is in the `REJECTED`
             * state, no new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision of
             * the specified Consent is in the `ACTIVE` or `REVOKED` state.
             *
             * Create a request for the method "consents.reject".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Reject#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to reject, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
             * @param content the {@link com.google.api.services.healthcare.v1.model.RejectConsentRequest}
             * @return the request
             */
            public Reject reject(java.lang.String name, com.google.api.services.healthcare.v1.model.RejectConsentRequest content) throws java.io.IOException {
              Reject result = new Reject(name, content);
              initialize(result);
              return result;
            }

            public class Reject extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+name}:reject";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Rejects the latest revision of the specified Consent by committing a new revision with `state`
               * updated to `REJECTED`. If the latest revision of the specified Consent is in the `REJECTED`
               * state, no new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision
               * of the specified Consent is in the `ACTIVE` or `REVOKED` state.
               *
               * Create a request for the method "consents.reject".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Reject#execute()} method to invoke the remote operation.
               * <p> {@link
               * Reject#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to reject, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               * @param content the {@link com.google.api.services.healthcare.v1.model.RejectConsentRequest}
               * @since 1.13
               */
              protected Reject(java.lang.String name, com.google.api.services.healthcare.v1.model.RejectConsentRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Consent.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public Reject set$Xgafv(java.lang.String $Xgafv) {
                return (Reject) super.set$Xgafv($Xgafv);
              }

              @Override
              public Reject setAccessToken(java.lang.String accessToken) {
                return (Reject) super.setAccessToken(accessToken);
              }

              @Override
              public Reject setAlt(java.lang.String alt) {
                return (Reject) super.setAlt(alt);
              }

              @Override
              public Reject setCallback(java.lang.String callback) {
                return (Reject) super.setCallback(callback);
              }

              @Override
              public Reject setFields(java.lang.String fields) {
                return (Reject) super.setFields(fields);
              }

              @Override
              public Reject setKey(java.lang.String key) {
                return (Reject) super.setKey(key);
              }

              @Override
              public Reject setOauthToken(java.lang.String oauthToken) {
                return (Reject) super.setOauthToken(oauthToken);
              }

              @Override
              public Reject setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Reject) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Reject setQuotaUser(java.lang.String quotaUser) {
                return (Reject) super.setQuotaUser(quotaUser);
              }

              @Override
              public Reject setUploadType(java.lang.String uploadType) {
                return (Reject) super.setUploadType(uploadType);
              }

              @Override
              public Reject setUploadProtocol(java.lang.String uploadProtocol) {
                return (Reject) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent to reject, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to reject, of the form `projects/{project_id}/locations/
             {location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. An
             INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent to reject, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              public Reject setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Reject set(String parameterName, Object value) {
                return (Reject) super.set(parameterName, value);
              }
            }
            /**
             * Revokes the latest revision of the specified Consent by committing a new revision with `state`
             * updated to `REVOKED`. If the latest revision of the specified Consent is in the `REVOKED` state,
             * no new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision of the
             * given consent is in `DRAFT` or `REJECTED` state.
             *
             * Create a request for the method "consents.revoke".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Revoke#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the Consent to revoke, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
             * @param content the {@link com.google.api.services.healthcare.v1.model.RevokeConsentRequest}
             * @return the request
             */
            public Revoke revoke(java.lang.String name, com.google.api.services.healthcare.v1.model.RevokeConsentRequest content) throws java.io.IOException {
              Revoke result = new Revoke(name, content);
              initialize(result);
              return result;
            }

            public class Revoke extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Consent> {

              private static final String REST_PATH = "v1/{+name}:revoke";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");

              /**
               * Revokes the latest revision of the specified Consent by committing a new revision with `state`
               * updated to `REVOKED`. If the latest revision of the specified Consent is in the `REVOKED`
               * state, no new revision is committed. A FAILED_PRECONDITION error occurs if the latest revision
               * of the given consent is in `DRAFT` or `REJECTED` state.
               *
               * Create a request for the method "consents.revoke".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Revoke#execute()} method to invoke the remote operation.
               * <p> {@link
               * Revoke#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the Consent to revoke, of the form `projects/{project_id}/locations/{
             *        location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`
             *        . An INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               * @param content the {@link com.google.api.services.healthcare.v1.model.RevokeConsentRequest}
               * @since 1.13
               */
              protected Revoke(java.lang.String name, com.google.api.services.healthcare.v1.model.RevokeConsentRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Consent.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
              }

              @Override
              public Revoke set$Xgafv(java.lang.String $Xgafv) {
                return (Revoke) super.set$Xgafv($Xgafv);
              }

              @Override
              public Revoke setAccessToken(java.lang.String accessToken) {
                return (Revoke) super.setAccessToken(accessToken);
              }

              @Override
              public Revoke setAlt(java.lang.String alt) {
                return (Revoke) super.setAlt(alt);
              }

              @Override
              public Revoke setCallback(java.lang.String callback) {
                return (Revoke) super.setCallback(callback);
              }

              @Override
              public Revoke setFields(java.lang.String fields) {
                return (Revoke) super.setFields(fields);
              }

              @Override
              public Revoke setKey(java.lang.String key) {
                return (Revoke) super.setKey(key);
              }

              @Override
              public Revoke setOauthToken(java.lang.String oauthToken) {
                return (Revoke) super.setOauthToken(oauthToken);
              }

              @Override
              public Revoke setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Revoke) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Revoke setQuotaUser(java.lang.String quotaUser) {
                return (Revoke) super.setQuotaUser(quotaUser);
              }

              @Override
              public Revoke setUploadType(java.lang.String uploadType) {
                return (Revoke) super.setUploadType(uploadType);
              }

              @Override
              public Revoke setUploadProtocol(java.lang.String uploadProtocol) {
                return (Revoke) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the Consent to revoke, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the Consent to revoke, of the form `projects/{project_id}/locations/
             {location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. An
             INVALID_ARGUMENT error occurs if `revision_id` is specified in the name.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the Consent to revoke, of the form `projects/{projec
               * t_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id
               * }/consents/{consent_id}`. An INVALID_ARGUMENT error occurs if `revision_id` is
               * specified in the name.
               */
              public Revoke setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/consents/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Revoke set(String parameterName, Object value) {
                return (Revoke) super.set(parameterName, value);
              }
            }

          }
          /**
           * An accessor for creating requests from the UserDataMappings collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.UserDataMappings.List request = healthcare.userDataMappings().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public UserDataMappings userDataMappings() {
            return new UserDataMappings();
          }

          /**
           * The "userDataMappings" collection of methods.
           */
          public class UserDataMappings {

            /**
             * Archives the specified User data mapping.
             *
             * Create a request for the method "userDataMappings.archive".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Archive#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the User data mapping to archive.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingRequest}
             * @return the request
             */
            public Archive archive(java.lang.String name, com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingRequest content) throws java.io.IOException {
              Archive result = new Archive(name, content);
              initialize(result);
              return result;
            }

            public class Archive extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingResponse> {

              private static final String REST_PATH = "v1/{+name}:archive";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");

              /**
               * Archives the specified User data mapping.
               *
               * Create a request for the method "userDataMappings.archive".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Archive#execute()} method to invoke the remote operation.
               * <p> {@link
               * Archive#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the User data mapping to archive.
               * @param content the {@link com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingRequest}
               * @since 1.13
               */
              protected Archive(java.lang.String name, com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.ArchiveUserDataMappingResponse.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
              }

              @Override
              public Archive set$Xgafv(java.lang.String $Xgafv) {
                return (Archive) super.set$Xgafv($Xgafv);
              }

              @Override
              public Archive setAccessToken(java.lang.String accessToken) {
                return (Archive) super.setAccessToken(accessToken);
              }

              @Override
              public Archive setAlt(java.lang.String alt) {
                return (Archive) super.setAlt(alt);
              }

              @Override
              public Archive setCallback(java.lang.String callback) {
                return (Archive) super.setCallback(callback);
              }

              @Override
              public Archive setFields(java.lang.String fields) {
                return (Archive) super.setFields(fields);
              }

              @Override
              public Archive setKey(java.lang.String key) {
                return (Archive) super.setKey(key);
              }

              @Override
              public Archive setOauthToken(java.lang.String oauthToken) {
                return (Archive) super.setOauthToken(oauthToken);
              }

              @Override
              public Archive setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Archive) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Archive setQuotaUser(java.lang.String quotaUser) {
                return (Archive) super.setQuotaUser(quotaUser);
              }

              @Override
              public Archive setUploadType(java.lang.String uploadType) {
                return (Archive) super.setUploadType(uploadType);
              }

              @Override
              public Archive setUploadProtocol(java.lang.String uploadProtocol) {
                return (Archive) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the User data mapping to archive. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the User data mapping to archive.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the User data mapping to archive. */
              public Archive setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Archive set(String parameterName, Object value) {
                return (Archive) super.set(parameterName, value);
              }
            }
            /**
             * Creates a new User data mapping in the parent consent store.
             *
             * Create a request for the method "userDataMappings.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store.
             * @param content the {@link com.google.api.services.healthcare.v1.model.UserDataMapping}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.UserDataMapping content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.UserDataMapping> {

              private static final String REST_PATH = "v1/{+parent}/userDataMappings";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Creates a new User data mapping in the parent consent store.
               *
               * Create a request for the method "userDataMappings.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store.
               * @param content the {@link com.google.api.services.healthcare.v1.model.UserDataMapping}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.UserDataMapping content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.UserDataMapping.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store. */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes the specified User data mapping.
             *
             * Create a request for the method "userDataMappings.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the User data mapping to delete.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");

              /**
               * Deletes the specified User data mapping.
               *
               * Create a request for the method "userDataMappings.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the User data mapping to delete.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the User data mapping to delete. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the User data mapping to delete.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the User data mapping to delete. */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Gets the specified User data mapping.
             *
             * Create a request for the method "userDataMappings.get".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the User data mapping to retrieve.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.UserDataMapping> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");

              /**
               * Gets the specified User data mapping.
               *
               * Create a request for the method "userDataMappings.get".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the User data mapping to retrieve.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.UserDataMapping.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the User data mapping to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the User data mapping to retrieve.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the User data mapping to retrieve. */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }
            /**
             * Lists the User data mappings in the specified consent store.
             *
             * Create a request for the method "userDataMappings.list".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. Name of the consent store to retrieve User data mappings from.
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListUserDataMappingsResponse> {

              private static final String REST_PATH = "v1/{+parent}/userDataMappings";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");

              /**
               * Lists the User data mappings in the specified consent store.
               *
               * Create a request for the method "userDataMappings.list".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. Name of the consent store to retrieve User data mappings from.
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListUserDataMappingsResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. Name of the consent store to retrieve User data mappings from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. Name of the consent store to retrieve User data mappings from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Required. Name of the consent store to retrieve User data mappings from. */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Optional. Restricts the User data mappings returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - data_id - user_id. For example, `filter=user_id=\"user123\"`. - archived -
               * archive_time
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Restricts the User data mappings returned to those matching a filter. The following
             syntax is available: * A string field value can be written as text inside quotation marks, for
             example `"query text"`. The only valid relational operation for text fields is equality (`=`),
             where text is searched within the field, rather than having the field be equal to the text. For
             example, `"Comment = great"` returns messages with `great` in the comment field. * A number field
             value can be written as an integer, a decimal, or an exponential. The valid relational operators
             for number fields are the equality operator (`=`), along with the less than/greater than operators
             (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form.
             Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit
             months and days. The valid relational operators for date fields are the equality operator (`=`) ,
             along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
             inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. *
             Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators
             between the expressions. If a boolean operator appears within a quoted string, it is not treated as
             special, it's just another part of the character string to be matched. You can prepend the `NOT`
             operator to an expression to negate it. The fields available for filtering are: - data_id -
             user_id. For example, `filter=user_id=\"user123\"`. - archived - archive_time
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Restricts the User data mappings returned to those matching a filter. The
               * following syntax is available: * A string field value can be written as text inside
               * quotation marks, for example `"query text"`. The only valid relational operation
               * for text fields is equality (`=`), where text is searched within the field, rather
               * than having the field be equal to the text. For example, `"Comment = great"`
               * returns messages with `great` in the comment field. * A number field value can be
               * written as an integer, a decimal, or an exponential. The valid relational operators
               * for number fields are the equality operator (`=`), along with the less than/greater
               * than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
               * operator. You can prepend the `NOT` operator to an expression to negate it. * A
               * date field value must be written in `yyyy-mm-dd` form. Fields with date and time
               * use the RFC3339 time format. Leading zeros are required for one-digit months and
               * days. The valid relational operators for date fields are the equality operator
               * (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`).
               * Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
               * operator to an expression to negate it. * Multiple field query expressions can be
               * combined in one query by adding `AND` or `OR` operators between the expressions. If
               * a boolean operator appears within a quoted string, it is not treated as special,
               * it's just another part of the character string to be matched. You can prepend the
               * `NOT` operator to an expression to negate it. The fields available for filtering
               * are: - data_id - user_id. For example, `filter=user_id=\"user123\"`. - archived -
               * archive_time
               */
              public List setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Limit on the number of User data mappings to return in a single response.
               * If not specified, 100 is used. May not be larger than 1000.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Limit on the number of User data mappings to return in a single response. If not
             specified, 100 is used. May not be larger than 1000.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Limit on the number of User data mappings to return in a single response.
               * If not specified, 100 is used. May not be larger than 1000.
               */
              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. Token to retrieve the next page of results, or empty to get the first
               * page.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. Token to retrieve the next page of results, or empty to get the first page.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. Token to retrieve the next page of results, or empty to get the first
               * page.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }
            /**
             * Updates the specified User data mapping.
             *
             * Create a request for the method "userDataMappings.patch".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             *
             * @param name Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_id}/d
             *        atasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_
             *        id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.UserDataMapping}
             * @return the request
             */
            public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.UserDataMapping content) throws java.io.IOException {
              Patch result = new Patch(name, content);
              initialize(result);
              return result;
            }

            public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.UserDataMapping> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");

              /**
               * Updates the specified User data mapping.
               *
               * Create a request for the method "userDataMappings.patch".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
               * <p> {@link
               * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_id}/d
             *        atasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_
             *        id}`.
               * @param content the {@link com.google.api.services.healthcare.v1.model.UserDataMapping}
               * @since 1.13
               */
              protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.UserDataMapping content) {
                super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.UserDataMapping.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
              }

              @Override
              public Patch set$Xgafv(java.lang.String $Xgafv) {
                return (Patch) super.set$Xgafv($Xgafv);
              }

              @Override
              public Patch setAccessToken(java.lang.String accessToken) {
                return (Patch) super.setAccessToken(accessToken);
              }

              @Override
              public Patch setAlt(java.lang.String alt) {
                return (Patch) super.setAlt(alt);
              }

              @Override
              public Patch setCallback(java.lang.String callback) {
                return (Patch) super.setCallback(callback);
              }

              @Override
              public Patch setFields(java.lang.String fields) {
                return (Patch) super.setFields(fields);
              }

              @Override
              public Patch setKey(java.lang.String key) {
                return (Patch) super.setKey(key);
              }

              @Override
              public Patch setOauthToken(java.lang.String oauthToken) {
                return (Patch) super.setOauthToken(oauthToken);
              }

              @Override
              public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Patch) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Patch setQuotaUser(java.lang.String quotaUser) {
                return (Patch) super.setQuotaUser(quotaUser);
              }

              @Override
              public Patch setUploadType(java.lang.String uploadType) {
                return (Patch) super.setUploadType(uploadType);
              }

              @Override
              public Patch setUploadProtocol(java.lang.String uploadProtocol) {
                return (Patch) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Resource name of the User data mapping, of the form `projects/{project_id}/location
               * s/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMapp
               * ings/{user_data_mapping_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_id}/
             datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_id}`.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Resource name of the User data mapping, of the form `projects/{project_id}/location
               * s/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMapp
               * ings/{user_data_mapping_id}`.
               */
              public Patch setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/consentStores/[^/]+/userDataMappings/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Required. The update mask that applies to the resource. For the `FieldMask`
               * definition, see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `data_id`, `user_id` and
               * `resource_attributes` fields can be updated.
               */
              @com.google.api.client.util.Key
              private String updateMask;

              /** Required. The update mask that applies to the resource. For the `FieldMask` definition, see
             https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask. Only the
             `data_id`, `user_id` and `resource_attributes` fields can be updated.
               */
              public String getUpdateMask() {
                return updateMask;
              }

              /**
               * Required. The update mask that applies to the resource. For the `FieldMask`
               * definition, see https://developers.google.com/protocol-
               * buffers/docs/reference/google.protobuf#fieldmask. Only the `data_id`, `user_id` and
               * `resource_attributes` fields can be updated.
               */
              public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
              }

              @Override
              public Patch set(String parameterName, Object value) {
                return (Patch) super.set(parameterName, value);
              }
            }

          }
        }
        /**
         * An accessor for creating requests from the DicomStores collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
         *   {@code CloudHealthcare.DicomStores.List request = healthcare.dicomStores().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public DicomStores dicomStores() {
          return new DicomStores();
        }

        /**
         * The "dicomStores" collection of methods.
         */
        public class DicomStores {

          /**
           * Creates a new DICOM store within the parent dataset.
           *
           * Create a request for the method "dicomStores.create".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the dataset this DICOM store belongs to.
           * @param content the {@link com.google.api.services.healthcare.v1.model.DicomStore}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.DicomStore content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.DicomStore> {

            private static final String REST_PATH = "v1/{+parent}/dicomStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Creates a new DICOM store within the parent dataset.
             *
             * Create a request for the method "dicomStores.create".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the dataset this DICOM store belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.DicomStore}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.DicomStore content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.DicomStore.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the dataset this DICOM store belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the dataset this DICOM store belongs to.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the dataset this DICOM store belongs to. */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The ID of the DICOM store that is being created. Any string value up to 256
             * characters in length.
             */
            @com.google.api.client.util.Key
            private java.lang.String dicomStoreId;

            /** The ID of the DICOM store that is being created. Any string value up to 256 characters in length.
             */
            public java.lang.String getDicomStoreId() {
              return dicomStoreId;
            }

            /**
             * The ID of the DICOM store that is being created. Any string value up to 256
             * characters in length.
             */
            public Create setDicomStoreId(java.lang.String dicomStoreId) {
              this.dicomStoreId = dicomStoreId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * De-identifies data from the source store and writes it to the destination store. The metadata
           * field type is OperationMetadata. If the request is successful, the response field type is
           * DeidentifyDicomStoreSummary. If errors occur, error is set. The LRO result may still be
           * successful if de-identification fails for some DICOM instances. The output DICOM store will not
           * contain these failed resources. Failed resource totals are tracked in Operation.metadata. Error
           * details are also logged to Cloud Logging (see [Viewing error logs in Cloud
           * Logging](/healthcare/docs/how-tos/logging)).
           *
           * Create a request for the method "dicomStores.deidentify".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Deidentify#execute()} method to invoke the remote operation.
           *
           * @param sourceStore Source DICOM store resource name. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyDicomStoreRequest}
           * @return the request
           */
          public Deidentify deidentify(java.lang.String sourceStore, com.google.api.services.healthcare.v1.model.DeidentifyDicomStoreRequest content) throws java.io.IOException {
            Deidentify result = new Deidentify(sourceStore, content);
            initialize(result);
            return result;
          }

          public class Deidentify extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+sourceStore}:deidentify";

            private final java.util.regex.Pattern SOURCE_STORE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * De-identifies data from the source store and writes it to the destination store. The metadata
             * field type is OperationMetadata. If the request is successful, the response field type is
             * DeidentifyDicomStoreSummary. If errors occur, error is set. The LRO result may still be
             * successful if de-identification fails for some DICOM instances. The output DICOM store will not
             * contain these failed resources. Failed resource totals are tracked in Operation.metadata. Error
             * details are also logged to Cloud Logging (see [Viewing error logs in Cloud
             * Logging](/healthcare/docs/how-tos/logging)).
             *
             * Create a request for the method "dicomStores.deidentify".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Deidentify#execute()} method to invoke the remote
             * operation. <p> {@link
             * Deidentify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param sourceStore Source DICOM store resource name. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyDicomStoreRequest}
             * @since 1.13
             */
            protected Deidentify(java.lang.String sourceStore, com.google.api.services.healthcare.v1.model.DeidentifyDicomStoreRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.sourceStore = com.google.api.client.util.Preconditions.checkNotNull(sourceStore, "Required parameter sourceStore must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(SOURCE_STORE_PATTERN.matcher(sourceStore).matches(),
                    "Parameter sourceStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public Deidentify set$Xgafv(java.lang.String $Xgafv) {
              return (Deidentify) super.set$Xgafv($Xgafv);
            }

            @Override
            public Deidentify setAccessToken(java.lang.String accessToken) {
              return (Deidentify) super.setAccessToken(accessToken);
            }

            @Override
            public Deidentify setAlt(java.lang.String alt) {
              return (Deidentify) super.setAlt(alt);
            }

            @Override
            public Deidentify setCallback(java.lang.String callback) {
              return (Deidentify) super.setCallback(callback);
            }

            @Override
            public Deidentify setFields(java.lang.String fields) {
              return (Deidentify) super.setFields(fields);
            }

            @Override
            public Deidentify setKey(java.lang.String key) {
              return (Deidentify) super.setKey(key);
            }

            @Override
            public Deidentify setOauthToken(java.lang.String oauthToken) {
              return (Deidentify) super.setOauthToken(oauthToken);
            }

            @Override
            public Deidentify setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Deidentify) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Deidentify setQuotaUser(java.lang.String quotaUser) {
              return (Deidentify) super.setQuotaUser(quotaUser);
            }

            @Override
            public Deidentify setUploadType(java.lang.String uploadType) {
              return (Deidentify) super.setUploadType(uploadType);
            }

            @Override
            public Deidentify setUploadProtocol(java.lang.String uploadProtocol) {
              return (Deidentify) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Source DICOM store resource name. For example, `projects/{project_id}/locations/{loca
             * tion_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String sourceStore;

            /** Source DICOM store resource name. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getSourceStore() {
              return sourceStore;
            }

            /**
             * Source DICOM store resource name. For example, `projects/{project_id}/locations/{loca
             * tion_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public Deidentify setSourceStore(java.lang.String sourceStore) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(SOURCE_STORE_PATTERN.matcher(sourceStore).matches(),
                    "Parameter sourceStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.sourceStore = sourceStore;
              return this;
            }

            @Override
            public Deidentify set(String parameterName, Object value) {
              return (Deidentify) super.set(parameterName, value);
            }
          }
          /**
           * Deletes the specified DICOM store and removes all images that are contained within it.
           *
           * Create a request for the method "dicomStores.delete".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the DICOM store to delete.
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Deletes the specified DICOM store and removes all images that are contained within it.
             *
             * Create a request for the method "dicomStores.delete".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the DICOM store to delete.
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the DICOM store to delete. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the DICOM store to delete.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the DICOM store to delete. */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Exports data to the specified destination by copying it from the DICOM store. Errors are also
           * logged to Cloud Logging. For more information, see [Viewing error logs in Cloud
           * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata field type is
           * OperationMetadata.
           *
           * Create a request for the method "dicomStores.export".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Export#execute()} method to invoke the remote operation.
           *
           * @param name The DICOM store resource name from which to export the data. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ExportDicomDataRequest}
           * @return the request
           */
          public Export export(java.lang.String name, com.google.api.services.healthcare.v1.model.ExportDicomDataRequest content) throws java.io.IOException {
            Export result = new Export(name, content);
            initialize(result);
            return result;
          }

          public class Export extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:export";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Exports data to the specified destination by copying it from the DICOM store. Errors are also
             * logged to Cloud Logging. For more information, see [Viewing error logs in Cloud
             * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata field type is
             * OperationMetadata.
             *
             * Create a request for the method "dicomStores.export".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Export#execute()} method to invoke the remote operation.
             * <p> {@link
             * Export#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The DICOM store resource name from which to export the data. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ExportDicomDataRequest}
             * @since 1.13
             */
            protected Export(java.lang.String name, com.google.api.services.healthcare.v1.model.ExportDicomDataRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public Export set$Xgafv(java.lang.String $Xgafv) {
              return (Export) super.set$Xgafv($Xgafv);
            }

            @Override
            public Export setAccessToken(java.lang.String accessToken) {
              return (Export) super.setAccessToken(accessToken);
            }

            @Override
            public Export setAlt(java.lang.String alt) {
              return (Export) super.setAlt(alt);
            }

            @Override
            public Export setCallback(java.lang.String callback) {
              return (Export) super.setCallback(callback);
            }

            @Override
            public Export setFields(java.lang.String fields) {
              return (Export) super.setFields(fields);
            }

            @Override
            public Export setKey(java.lang.String key) {
              return (Export) super.setKey(key);
            }

            @Override
            public Export setOauthToken(java.lang.String oauthToken) {
              return (Export) super.setOauthToken(oauthToken);
            }

            @Override
            public Export setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Export) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Export setQuotaUser(java.lang.String quotaUser) {
              return (Export) super.setQuotaUser(quotaUser);
            }

            @Override
            public Export setUploadType(java.lang.String uploadType) {
              return (Export) super.setUploadType(uploadType);
            }

            @Override
            public Export setUploadProtocol(java.lang.String uploadProtocol) {
              return (Export) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The DICOM store resource name from which to export the data. For example, `projects/{
             * project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id
             * }`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The DICOM store resource name from which to export the data. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The DICOM store resource name from which to export the data. For example, `projects/{
             * project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id
             * }`.
             */
            public Export setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Export set(String parameterName, Object value) {
              return (Export) super.set(parameterName, value);
            }
          }
          /**
           * Gets the specified DICOM store.
           *
           * Create a request for the method "dicomStores.get".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the DICOM store to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.DicomStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Gets the specified DICOM store.
             *
             * Create a request for the method "dicomStores.get".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the DICOM store to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.DicomStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the DICOM store to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the DICOM store to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the DICOM store to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "dicomStores.getIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "dicomStores.getIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
           specifying an invalid value will be rejected. Requests for policies with any conditional bindings
           must specify version 3. Policies without any conditional bindings may specify any valid value or
           leave the field unset. To learn which resources support conditions in their IAM policies, see the
           [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Imports data into the DICOM store by copying it from the specified source. Errors are logged to
           * Cloud Logging. For more information, see [Viewing error logs in Cloud
           * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata field type is
           * OperationMetadata.
           *
           * Create a request for the method "dicomStores.import".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link CloudHealthcareImport#execute()} method to invoke the remote
           * operation.
           *
           * @param name The name of the DICOM store resource into which the data is imported. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ImportDicomDataRequest}
           * @return the request
           */
          public CloudHealthcareImport healthcareImport(java.lang.String name, com.google.api.services.healthcare.v1.model.ImportDicomDataRequest content) throws java.io.IOException {
            CloudHealthcareImport result = new CloudHealthcareImport(name, content);
            initialize(result);
            return result;
          }

          public class CloudHealthcareImport extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:import";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Imports data into the DICOM store by copying it from the specified source. Errors are logged to
             * Cloud Logging. For more information, see [Viewing error logs in Cloud
             * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata field type is
             * OperationMetadata.
             *
             * Create a request for the method "dicomStores.import".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link CloudHealthcareImport#execute()} method to invoke the
             * remote operation. <p> {@link CloudHealthcareImport#initialize(com.google.api.client.googleapis.
             * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
             * after invoking the constructor. </p>
             *
             * @param name The name of the DICOM store resource into which the data is imported. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ImportDicomDataRequest}
             * @since 1.13
             */
            protected CloudHealthcareImport(java.lang.String name, com.google.api.services.healthcare.v1.model.ImportDicomDataRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public CloudHealthcareImport set$Xgafv(java.lang.String $Xgafv) {
              return (CloudHealthcareImport) super.set$Xgafv($Xgafv);
            }

            @Override
            public CloudHealthcareImport setAccessToken(java.lang.String accessToken) {
              return (CloudHealthcareImport) super.setAccessToken(accessToken);
            }

            @Override
            public CloudHealthcareImport setAlt(java.lang.String alt) {
              return (CloudHealthcareImport) super.setAlt(alt);
            }

            @Override
            public CloudHealthcareImport setCallback(java.lang.String callback) {
              return (CloudHealthcareImport) super.setCallback(callback);
            }

            @Override
            public CloudHealthcareImport setFields(java.lang.String fields) {
              return (CloudHealthcareImport) super.setFields(fields);
            }

            @Override
            public CloudHealthcareImport setKey(java.lang.String key) {
              return (CloudHealthcareImport) super.setKey(key);
            }

            @Override
            public CloudHealthcareImport setOauthToken(java.lang.String oauthToken) {
              return (CloudHealthcareImport) super.setOauthToken(oauthToken);
            }

            @Override
            public CloudHealthcareImport setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (CloudHealthcareImport) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public CloudHealthcareImport setQuotaUser(java.lang.String quotaUser) {
              return (CloudHealthcareImport) super.setQuotaUser(quotaUser);
            }

            @Override
            public CloudHealthcareImport setUploadType(java.lang.String uploadType) {
              return (CloudHealthcareImport) super.setUploadType(uploadType);
            }

            @Override
            public CloudHealthcareImport setUploadProtocol(java.lang.String uploadProtocol) {
              return (CloudHealthcareImport) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the DICOM store resource into which the data is imported. For example, `p
             * rojects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom
             * _store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name of the DICOM store resource into which the data is imported. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name of the DICOM store resource into which the data is imported. For example, `p
             * rojects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom
             * _store_id}`.
             */
            public CloudHealthcareImport setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public CloudHealthcareImport set(String parameterName, Object value) {
              return (CloudHealthcareImport) super.set(parameterName, value);
            }
          }
          /**
           * Lists the DICOM stores in the given dataset.
           *
           * Create a request for the method "dicomStores.list".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Name of the dataset.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListDicomStoresResponse> {

            private static final String REST_PATH = "v1/{+parent}/dicomStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Lists the DICOM stores in the given dataset.
             *
             * Create a request for the method "dicomStores.list".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Name of the dataset.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListDicomStoresResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** Name of the dataset. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Name of the dataset.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Name of the dataset. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported. For example, `labels.key=value`.
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Restricts stores returned to those matching a filter. The following syntax is available: * A string
           field value can be written as text inside quotation marks, for example `"query text"`. The only
           valid relational operation for text fields is equality (`=`), where text is searched within the
           field, rather than having the field be equal to the text. For example, `"Comment = great"` returns
           messages with `great` in the comment field. * A number field value can be written as an integer, a
           decimal, or an exponential. The valid relational operators for number fields are the equality
           operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
           there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to
           negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use
           the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
           relational operators for date fields are the equality operator (`=`) , along with the less
           than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
           operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query
           expressions can be combined in one query by adding `AND` or `OR` operators between the expressions.
           If a boolean operator appears within a quoted string, it is not treated as special, it's just
           another part of the character string to be matched. You can prepend the `NOT` operator to an
           expression to negate it. Only filtering on labels is supported. For example, `labels.key=value`.
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported. For example, `labels.key=value`.
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Limit on the number of DICOM stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Limit on the number of DICOM stores to return in a single response. If not specified, 100 is used.
           May not be larger than 1000.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Limit on the number of DICOM stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** The next_page_token value returned from the previous List request, if any.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Updates the specified DICOM store.
           *
           * Create a request for the method "dicomStores.patch".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Resource name of the DICOM store, of the form
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.DicomStore}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.DicomStore content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.DicomStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Updates the specified DICOM store.
             *
             * Create a request for the method "dicomStores.patch".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Resource name of the DICOM store, of the form
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.DicomStore}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.DicomStore content) {
              super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.DicomStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Resource name of the DICOM store, of the form `projects/{project_id}/locations/{locat
             * ion_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Resource name of the DICOM store, of the form
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Resource name of the DICOM store, of the form `projects/{project_id}/locations/{locat
             * ion_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            @com.google.api.client.util.Key
            private String updateMask;

            /** The update mask applies to the resource. For the `FieldMask` definition, see
           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
             */
            public String getUpdateMask() {
              return updateMask;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            public Patch setUpdateMask(String updateMask) {
              this.updateMask = updateMask;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }
          /**
           * SearchForInstances returns a list of matching instances. See [Search Transaction]
           * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
           * the implementation of SearchForInstances, see [Search
           * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
           * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
           * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
           * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
           *
           * Create a request for the method "dicomStores.searchForInstances".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SearchForInstances#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
           *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
           * @return the request
           */
          public SearchForInstances searchForInstances(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
            SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
            initialize(result);
            return result;
          }

          public class SearchForInstances extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

            private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                java.util.regex.Pattern.compile("^instances$");

            /**
             * SearchForInstances returns a list of matching instances. See [Search Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
             * the implementation of SearchForInstances, see [Search
             * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
             * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
             * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
             *
             * Create a request for the method "dicomStores.searchForInstances".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SearchForInstances#execute()} method to invoke the remote
             * operation. <p> {@link SearchForInstances#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
           *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
             * @since 1.13
             */
            protected SearchForInstances(java.lang.String parent, java.lang.String dicomWebPath) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^instances$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public SearchForInstances set$Xgafv(java.lang.String $Xgafv) {
              return (SearchForInstances) super.set$Xgafv($Xgafv);
            }

            @Override
            public SearchForInstances setAccessToken(java.lang.String accessToken) {
              return (SearchForInstances) super.setAccessToken(accessToken);
            }

            @Override
            public SearchForInstances setAlt(java.lang.String alt) {
              return (SearchForInstances) super.setAlt(alt);
            }

            @Override
            public SearchForInstances setCallback(java.lang.String callback) {
              return (SearchForInstances) super.setCallback(callback);
            }

            @Override
            public SearchForInstances setFields(java.lang.String fields) {
              return (SearchForInstances) super.setFields(fields);
            }

            @Override
            public SearchForInstances setKey(java.lang.String key) {
              return (SearchForInstances) super.setKey(key);
            }

            @Override
            public SearchForInstances setOauthToken(java.lang.String oauthToken) {
              return (SearchForInstances) super.setOauthToken(oauthToken);
            }

            @Override
            public SearchForInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SearchForInstances) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SearchForInstances setQuotaUser(java.lang.String quotaUser) {
              return (SearchForInstances) super.setQuotaUser(quotaUser);
            }

            @Override
            public SearchForInstances setUploadType(java.lang.String uploadType) {
              return (SearchForInstances) super.setUploadType(uploadType);
            }

            @Override
            public SearchForInstances setUploadProtocol(java.lang.String uploadProtocol) {
              return (SearchForInstances) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the DICOM store that is being accessed. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public SearchForInstances setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
             * `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
             */
            @com.google.api.client.util.Key
            private java.lang.String dicomWebPath;

            /** The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
           `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
             */
            public java.lang.String getDicomWebPath() {
              return dicomWebPath;
            }

            /**
             * The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
             * `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
             */
            public SearchForInstances setDicomWebPath(java.lang.String dicomWebPath) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^instances$");
              }
              this.dicomWebPath = dicomWebPath;
              return this;
            }

            @Override
            public SearchForInstances set(String parameterName, Object value) {
              return (SearchForInstances) super.set(parameterName, value);
            }
          }
          /**
           * SearchForSeries returns a list of matching series. See [Search Transaction]
           * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
           * the implementation of SearchForSeries, see [Search
           * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
           * Healthcare API conformance statement. For samples that show how to call SearchForSeries, see
           * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
           * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
           *
           * Create a request for the method "dicomStores.searchForSeries".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SearchForSeries#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param dicomWebPath The path of the SearchForSeries DICOMweb request. For example, `series` or
           *        `studies/{study_uid}/series`.
           * @return the request
           */
          public SearchForSeries searchForSeries(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
            SearchForSeries result = new SearchForSeries(parent, dicomWebPath);
            initialize(result);
            return result;
          }

          public class SearchForSeries extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

            private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                java.util.regex.Pattern.compile("^series$");

            /**
             * SearchForSeries returns a list of matching series. See [Search Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
             * the implementation of SearchForSeries, see [Search
             * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call SearchForSeries, see
             * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
             * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
             *
             * Create a request for the method "dicomStores.searchForSeries".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SearchForSeries#execute()} method to invoke the remote
             * operation. <p> {@link SearchForSeries#initialize(com.google.api.client.googleapis.services.Abst
             * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param dicomWebPath The path of the SearchForSeries DICOMweb request. For example, `series` or
           *        `studies/{study_uid}/series`.
             * @since 1.13
             */
            protected SearchForSeries(java.lang.String parent, java.lang.String dicomWebPath) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^series$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public SearchForSeries set$Xgafv(java.lang.String $Xgafv) {
              return (SearchForSeries) super.set$Xgafv($Xgafv);
            }

            @Override
            public SearchForSeries setAccessToken(java.lang.String accessToken) {
              return (SearchForSeries) super.setAccessToken(accessToken);
            }

            @Override
            public SearchForSeries setAlt(java.lang.String alt) {
              return (SearchForSeries) super.setAlt(alt);
            }

            @Override
            public SearchForSeries setCallback(java.lang.String callback) {
              return (SearchForSeries) super.setCallback(callback);
            }

            @Override
            public SearchForSeries setFields(java.lang.String fields) {
              return (SearchForSeries) super.setFields(fields);
            }

            @Override
            public SearchForSeries setKey(java.lang.String key) {
              return (SearchForSeries) super.setKey(key);
            }

            @Override
            public SearchForSeries setOauthToken(java.lang.String oauthToken) {
              return (SearchForSeries) super.setOauthToken(oauthToken);
            }

            @Override
            public SearchForSeries setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SearchForSeries) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SearchForSeries setQuotaUser(java.lang.String quotaUser) {
              return (SearchForSeries) super.setQuotaUser(quotaUser);
            }

            @Override
            public SearchForSeries setUploadType(java.lang.String uploadType) {
              return (SearchForSeries) super.setUploadType(uploadType);
            }

            @Override
            public SearchForSeries setUploadProtocol(java.lang.String uploadProtocol) {
              return (SearchForSeries) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the DICOM store that is being accessed. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public SearchForSeries setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The path of the SearchForSeries DICOMweb request. For example, `series` or
             * `studies/{study_uid}/series`.
             */
            @com.google.api.client.util.Key
            private java.lang.String dicomWebPath;

            /** The path of the SearchForSeries DICOMweb request. For example, `series` or
           `studies/{study_uid}/series`.
             */
            public java.lang.String getDicomWebPath() {
              return dicomWebPath;
            }

            /**
             * The path of the SearchForSeries DICOMweb request. For example, `series` or
             * `studies/{study_uid}/series`.
             */
            public SearchForSeries setDicomWebPath(java.lang.String dicomWebPath) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^series$");
              }
              this.dicomWebPath = dicomWebPath;
              return this;
            }

            @Override
            public SearchForSeries set(String parameterName, Object value) {
              return (SearchForSeries) super.set(parameterName, value);
            }
          }
          /**
           * SearchForStudies returns a list of matching studies. See [Search Transaction]
           * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
           * the implementation of SearchForStudies, see [Search
           * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
           * Healthcare API conformance statement. For samples that show how to call SearchForStudies, see
           * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
           * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
           *
           * Create a request for the method "dicomStores.searchForStudies".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SearchForStudies#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param dicomWebPath The path of the SearchForStudies DICOMweb request. For example, `studies`.
           * @return the request
           */
          public SearchForStudies searchForStudies(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
            SearchForStudies result = new SearchForStudies(parent, dicomWebPath);
            initialize(result);
            return result;
          }

          public class SearchForStudies extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

            private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                java.util.regex.Pattern.compile("^studies$");

            /**
             * SearchForStudies returns a list of matching studies. See [Search Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
             * the implementation of SearchForStudies, see [Search
             * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call SearchForStudies, see
             * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
             * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
             *
             * Create a request for the method "dicomStores.searchForStudies".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SearchForStudies#execute()} method to invoke the remote
             * operation. <p> {@link SearchForStudies#initialize(com.google.api.client.googleapis.services.Abs
             * tractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param dicomWebPath The path of the SearchForStudies DICOMweb request. For example, `studies`.
             * @since 1.13
             */
            protected SearchForStudies(java.lang.String parent, java.lang.String dicomWebPath) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^studies$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public SearchForStudies set$Xgafv(java.lang.String $Xgafv) {
              return (SearchForStudies) super.set$Xgafv($Xgafv);
            }

            @Override
            public SearchForStudies setAccessToken(java.lang.String accessToken) {
              return (SearchForStudies) super.setAccessToken(accessToken);
            }

            @Override
            public SearchForStudies setAlt(java.lang.String alt) {
              return (SearchForStudies) super.setAlt(alt);
            }

            @Override
            public SearchForStudies setCallback(java.lang.String callback) {
              return (SearchForStudies) super.setCallback(callback);
            }

            @Override
            public SearchForStudies setFields(java.lang.String fields) {
              return (SearchForStudies) super.setFields(fields);
            }

            @Override
            public SearchForStudies setKey(java.lang.String key) {
              return (SearchForStudies) super.setKey(key);
            }

            @Override
            public SearchForStudies setOauthToken(java.lang.String oauthToken) {
              return (SearchForStudies) super.setOauthToken(oauthToken);
            }

            @Override
            public SearchForStudies setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SearchForStudies) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SearchForStudies setQuotaUser(java.lang.String quotaUser) {
              return (SearchForStudies) super.setQuotaUser(quotaUser);
            }

            @Override
            public SearchForStudies setUploadType(java.lang.String uploadType) {
              return (SearchForStudies) super.setUploadType(uploadType);
            }

            @Override
            public SearchForStudies setUploadProtocol(java.lang.String uploadProtocol) {
              return (SearchForStudies) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the DICOM store that is being accessed. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public SearchForStudies setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /** The path of the SearchForStudies DICOMweb request. For example, `studies`. */
            @com.google.api.client.util.Key
            private java.lang.String dicomWebPath;

            /** The path of the SearchForStudies DICOMweb request. For example, `studies`.
             */
            public java.lang.String getDicomWebPath() {
              return dicomWebPath;
            }

            /** The path of the SearchForStudies DICOMweb request. For example, `studies`. */
            public SearchForStudies setDicomWebPath(java.lang.String dicomWebPath) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^studies$");
              }
              this.dicomWebPath = dicomWebPath;
              return this;
            }

            @Override
            public SearchForStudies set(String parameterName, Object value) {
              return (SearchForStudies) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "dicomStores.setIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy. Can
             * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "dicomStores.setIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * StoreInstances stores DICOM instances associated with study instance unique identifiers (SUID).
           * See [Store Transaction]
           * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5). For details on
           * the implementation of StoreInstances, see [Store
           * transaction](https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the Cloud
           * Healthcare API conformance statement. For samples that show how to call StoreInstances, see
           * [Storing DICOM data](https://cloud.google.com/healthcare/docs/how-
           * tos/dicomweb#storing_dicom_data).
           *
           * Create a request for the method "dicomStores.storeInstances".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link StoreInstances#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
           * @param dicomWebPath The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that the
           *        `study_uid` is optional.
           * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
           * @return the request
           */
          public StoreInstances storeInstances(java.lang.String parent, java.lang.String dicomWebPath, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
            StoreInstances result = new StoreInstances(parent, dicomWebPath, content);
            initialize(result);
            return result;
          }

          public class StoreInstances extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

            private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                java.util.regex.Pattern.compile("^studies$");

            /**
             * StoreInstances stores DICOM instances associated with study instance unique identifiers (SUID).
             * See [Store Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5). For details on
             * the implementation of StoreInstances, see [Store
             * transaction](https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call StoreInstances, see
             * [Storing DICOM data](https://cloud.google.com/healthcare/docs/how-
             * tos/dicomweb#storing_dicom_data).
             *
             * Create a request for the method "dicomStores.storeInstances".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link StoreInstances#execute()} method to invoke the remote
             * operation. <p> {@link StoreInstances#initialize(com.google.api.client.googleapis.services.Abstr
             * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
           *        ore_id}`.
             * @param dicomWebPath The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that the
           *        `study_uid` is optional.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @since 1.13
             */
            protected StoreInstances(java.lang.String parent, java.lang.String dicomWebPath, com.google.api.services.healthcare.v1.model.HttpBody content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^studies$");
              }
            }

            @Override
            public StoreInstances set$Xgafv(java.lang.String $Xgafv) {
              return (StoreInstances) super.set$Xgafv($Xgafv);
            }

            @Override
            public StoreInstances setAccessToken(java.lang.String accessToken) {
              return (StoreInstances) super.setAccessToken(accessToken);
            }

            @Override
            public StoreInstances setAlt(java.lang.String alt) {
              return (StoreInstances) super.setAlt(alt);
            }

            @Override
            public StoreInstances setCallback(java.lang.String callback) {
              return (StoreInstances) super.setCallback(callback);
            }

            @Override
            public StoreInstances setFields(java.lang.String fields) {
              return (StoreInstances) super.setFields(fields);
            }

            @Override
            public StoreInstances setKey(java.lang.String key) {
              return (StoreInstances) super.setKey(key);
            }

            @Override
            public StoreInstances setOauthToken(java.lang.String oauthToken) {
              return (StoreInstances) super.setOauthToken(oauthToken);
            }

            @Override
            public StoreInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (StoreInstances) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public StoreInstances setQuotaUser(java.lang.String quotaUser) {
              return (StoreInstances) super.setQuotaUser(quotaUser);
            }

            @Override
            public StoreInstances setUploadType(java.lang.String uploadType) {
              return (StoreInstances) super.setUploadType(uploadType);
            }

            @Override
            public StoreInstances setUploadProtocol(java.lang.String uploadProtocol) {
              return (StoreInstances) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the DICOM store that is being accessed. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The name of the DICOM store that is being accessed. For example, `projects/{project_i
             * d}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
             */
            public StoreInstances setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The path of the StoreInstances DICOMweb request. For example,
             * `studies/[{study_uid}]`. Note that the `study_uid` is optional.
             */
            @com.google.api.client.util.Key
            private java.lang.String dicomWebPath;

            /** The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that
           the `study_uid` is optional.
             */
            public java.lang.String getDicomWebPath() {
              return dicomWebPath;
            }

            /**
             * The path of the StoreInstances DICOMweb request. For example,
             * `studies/[{study_uid}]`. Note that the `study_uid` is optional.
             */
            public StoreInstances setDicomWebPath(java.lang.String dicomWebPath) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                    "Parameter dicomWebPath must conform to the pattern " +
                    "^studies$");
              }
              this.dicomWebPath = dicomWebPath;
              return this;
            }

            @Override
            public StoreInstances set(String parameterName, Object value) {
              return (StoreInstances) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
           * designed to be used for building permission-aware UIs and command-line tools, not for
           * authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "dicomStores.testIamPermissions".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
             * operation is designed to be used for building permission-aware UIs and command-line tools, not
             * for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "dicomStores.testIamPermissions".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the Studies collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.Studies.List request = healthcare.studies().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public Studies studies() {
            return new Studies();
          }

          /**
           * The "studies" collection of methods.
           */
          public class Studies {

            /**
             * DeleteStudy deletes all instances within the given study. Delete requests are equivalent to the
             * GET requests specified in the Retrieve transaction. The method returns an Operation which will be
             * marked successful when the deletion is complete. Warning: Instances cannot be inserted into a
             * study that is being deleted by an operation until the operation completes. For samples that show
             * how to call DeleteStudy, see [Deleting a study, series, or
             * instance](https://cloud.google.com/healthcare/docs/how-
             * tos/dicomweb#deleting_a_study_series_or_instance).
             *
             * Create a request for the method "studies.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param parent
             * @param dicomWebPath The path of the DeleteStudy request. For example, `studies/{study_uid}`.
             * @return the request
             */
            public Delete delete(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
              Delete result = new Delete(parent, dicomWebPath);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+$");

              /**
               * DeleteStudy deletes all instances within the given study. Delete requests are equivalent to the
               * GET requests specified in the Retrieve transaction. The method returns an Operation which will
               * be marked successful when the deletion is complete. Warning: Instances cannot be inserted into
               * a study that is being deleted by an operation until the operation completes. For samples that
               * show how to call DeleteStudy, see [Deleting a study, series, or
               * instance](https://cloud.google.com/healthcare/docs/how-
               * tos/dicomweb#deleting_a_study_series_or_instance).
               *
               * Create a request for the method "studies.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent
               * @param dicomWebPath The path of the DeleteStudy request. For example, `studies/{study_uid}`.
               * @since 1.13
               */
              protected Delete(java.lang.String parent, java.lang.String dicomWebPath) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Operation.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              @com.google.api.client.util.Key
              private java.lang.String parent;

              /**

               */
              public java.lang.String getParent() {
                return parent;
              }

              public Delete setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /** The path of the DeleteStudy request. For example, `studies/{study_uid}`. */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the DeleteStudy request. For example, `studies/{study_uid}`.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /** The path of the DeleteStudy request. For example, `studies/{study_uid}`. */
              public Delete setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * RetrieveStudyMetadata returns instance associated with the given study presented as metadata with
             * the bulk data removed. See [RetrieveTransaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
             * the implementation of RetrieveStudyMetadata, see [Metadata
             * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call RetrieveStudyMetadata,
             * see [Retrieving metadata](https://cloud.google.com/healthcare/docs/how-
             * tos/dicomweb#retrieving_metadata).
             *
             * Create a request for the method "studies.retrieveMetadata".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
             * @param dicomWebPath The path of the RetrieveStudyMetadata DICOMweb request. For example, `studies/{study_uid}/metadata`.
             * @return the request
             */
            public RetrieveMetadata retrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
              RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
              initialize(result);
              return result;
            }

            public class RetrieveMetadata extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+/metadata$");

              /**
               * RetrieveStudyMetadata returns instance associated with the given study presented as metadata
               * with the bulk data removed. See [RetrieveTransaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
               * the implementation of RetrieveStudyMetadata, see [Metadata
               * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call RetrieveStudyMetadata,
               * see [Retrieving metadata](https://cloud.google.com/healthcare/docs/how-
               * tos/dicomweb#retrieving_metadata).
               *
               * Create a request for the method "studies.retrieveMetadata".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote
               * operation. <p> {@link RetrieveMetadata#initialize(com.google.api.client.googleapis.services.Abs
               * tractGoogleClientRequest)} must be called to initialize this instance immediately after
               * invoking the constructor. </p>
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
               * @param dicomWebPath The path of the RetrieveStudyMetadata DICOMweb request. For example, `studies/{study_uid}/metadata`.
               * @since 1.13
               */
              protected RetrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/metadata$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public RetrieveMetadata set$Xgafv(java.lang.String $Xgafv) {
                return (RetrieveMetadata) super.set$Xgafv($Xgafv);
              }

              @Override
              public RetrieveMetadata setAccessToken(java.lang.String accessToken) {
                return (RetrieveMetadata) super.setAccessToken(accessToken);
              }

              @Override
              public RetrieveMetadata setAlt(java.lang.String alt) {
                return (RetrieveMetadata) super.setAlt(alt);
              }

              @Override
              public RetrieveMetadata setCallback(java.lang.String callback) {
                return (RetrieveMetadata) super.setCallback(callback);
              }

              @Override
              public RetrieveMetadata setFields(java.lang.String fields) {
                return (RetrieveMetadata) super.setFields(fields);
              }

              @Override
              public RetrieveMetadata setKey(java.lang.String key) {
                return (RetrieveMetadata) super.setKey(key);
              }

              @Override
              public RetrieveMetadata setOauthToken(java.lang.String oauthToken) {
                return (RetrieveMetadata) super.setOauthToken(oauthToken);
              }

              @Override
              public RetrieveMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (RetrieveMetadata) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public RetrieveMetadata setQuotaUser(java.lang.String quotaUser) {
                return (RetrieveMetadata) super.setQuotaUser(quotaUser);
              }

              @Override
              public RetrieveMetadata setUploadType(java.lang.String uploadType) {
                return (RetrieveMetadata) super.setUploadType(uploadType);
              }

              @Override
              public RetrieveMetadata setUploadProtocol(java.lang.String uploadProtocol) {
                return (RetrieveMetadata) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the DICOM store that is being accessed. For example,
             `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public RetrieveMetadata setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The path of the RetrieveStudyMetadata DICOMweb request. For example,
               * `studies/{study_uid}/metadata`.
               */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the RetrieveStudyMetadata DICOMweb request. For example,
             `studies/{study_uid}/metadata`.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /**
               * The path of the RetrieveStudyMetadata DICOMweb request. For example,
               * `studies/{study_uid}/metadata`.
               */
              public RetrieveMetadata setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/metadata$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public RetrieveMetadata set(String parameterName, Object value) {
                return (RetrieveMetadata) super.set(parameterName, value);
              }
            }
            /**
             * RetrieveStudy returns all instances within the given study. See [RetrieveTransaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
             * the implementation of RetrieveStudy, see [DICOM study/series/instances](https://cloud.google.com/
             * healthcare/docs/dicom#dicom_studyseriesinstances) in the Cloud Healthcare API conformance
             * statement. For samples that show how to call RetrieveStudy, see [Retrieving DICOM
             * data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
             *
             * Create a request for the method "studies.retrieveStudy".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link RetrieveStudy#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
             * @param dicomWebPath The path of the RetrieveStudy DICOMweb request. For example, `studies/{study_uid}`.
             * @return the request
             */
            public RetrieveStudy retrieveStudy(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
              RetrieveStudy result = new RetrieveStudy(parent, dicomWebPath);
              initialize(result);
              return result;
            }

            public class RetrieveStudy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+$");

              /**
               * RetrieveStudy returns all instances within the given study. See [RetrieveTransaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
               * the implementation of RetrieveStudy, see [DICOM study/series/instances](https://cloud.google.co
               * m/healthcare/docs/dicom#dicom_studyseriesinstances) in the Cloud Healthcare API conformance
               * statement. For samples that show how to call RetrieveStudy, see [Retrieving DICOM
               * data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
               *
               * Create a request for the method "studies.retrieveStudy".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link RetrieveStudy#execute()} method to invoke the remote
               * operation. <p> {@link RetrieveStudy#initialize(com.google.api.client.googleapis.services.Abstra
               * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
               * @param dicomWebPath The path of the RetrieveStudy DICOMweb request. For example, `studies/{study_uid}`.
               * @since 1.13
               */
              protected RetrieveStudy(java.lang.String parent, java.lang.String dicomWebPath) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public RetrieveStudy set$Xgafv(java.lang.String $Xgafv) {
                return (RetrieveStudy) super.set$Xgafv($Xgafv);
              }

              @Override
              public RetrieveStudy setAccessToken(java.lang.String accessToken) {
                return (RetrieveStudy) super.setAccessToken(accessToken);
              }

              @Override
              public RetrieveStudy setAlt(java.lang.String alt) {
                return (RetrieveStudy) super.setAlt(alt);
              }

              @Override
              public RetrieveStudy setCallback(java.lang.String callback) {
                return (RetrieveStudy) super.setCallback(callback);
              }

              @Override
              public RetrieveStudy setFields(java.lang.String fields) {
                return (RetrieveStudy) super.setFields(fields);
              }

              @Override
              public RetrieveStudy setKey(java.lang.String key) {
                return (RetrieveStudy) super.setKey(key);
              }

              @Override
              public RetrieveStudy setOauthToken(java.lang.String oauthToken) {
                return (RetrieveStudy) super.setOauthToken(oauthToken);
              }

              @Override
              public RetrieveStudy setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (RetrieveStudy) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public RetrieveStudy setQuotaUser(java.lang.String quotaUser) {
                return (RetrieveStudy) super.setQuotaUser(quotaUser);
              }

              @Override
              public RetrieveStudy setUploadType(java.lang.String uploadType) {
                return (RetrieveStudy) super.setUploadType(uploadType);
              }

              @Override
              public RetrieveStudy setUploadProtocol(java.lang.String uploadProtocol) {
                return (RetrieveStudy) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the DICOM store that is being accessed. For example,
             `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public RetrieveStudy setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The path of the RetrieveStudy DICOMweb request. For example, `studies/{study_uid}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the RetrieveStudy DICOMweb request. For example, `studies/{study_uid}`.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /**
               * The path of the RetrieveStudy DICOMweb request. For example, `studies/{study_uid}`.
               */
              public RetrieveStudy setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public RetrieveStudy set(String parameterName, Object value) {
                return (RetrieveStudy) super.set(parameterName, value);
              }
            }
            /**
             * SearchForInstances returns a list of matching instances. See [Search Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
             * the implementation of SearchForInstances, see [Search
             * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
             * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
             * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
             *
             * Create a request for the method "studies.searchForInstances".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link SearchForInstances#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
             * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
             *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
             * @return the request
             */
            public SearchForInstances searchForInstances(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
              SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
              initialize(result);
              return result;
            }

            public class SearchForInstances extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+/instances$");

              /**
               * SearchForInstances returns a list of matching instances. See [Search Transaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
               * the implementation of SearchForInstances, see [Search
               * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
               * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
               * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
               *
               * Create a request for the method "studies.searchForInstances".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link SearchForInstances#execute()} method to invoke the remote
               * operation. <p> {@link SearchForInstances#initialize(com.google.api.client.googleapis.services.A
               * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
               * invoking the constructor. </p>
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
               * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
             *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
               * @since 1.13
               */
              protected SearchForInstances(java.lang.String parent, java.lang.String dicomWebPath) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/instances$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public SearchForInstances set$Xgafv(java.lang.String $Xgafv) {
                return (SearchForInstances) super.set$Xgafv($Xgafv);
              }

              @Override
              public SearchForInstances setAccessToken(java.lang.String accessToken) {
                return (SearchForInstances) super.setAccessToken(accessToken);
              }

              @Override
              public SearchForInstances setAlt(java.lang.String alt) {
                return (SearchForInstances) super.setAlt(alt);
              }

              @Override
              public SearchForInstances setCallback(java.lang.String callback) {
                return (SearchForInstances) super.setCallback(callback);
              }

              @Override
              public SearchForInstances setFields(java.lang.String fields) {
                return (SearchForInstances) super.setFields(fields);
              }

              @Override
              public SearchForInstances setKey(java.lang.String key) {
                return (SearchForInstances) super.setKey(key);
              }

              @Override
              public SearchForInstances setOauthToken(java.lang.String oauthToken) {
                return (SearchForInstances) super.setOauthToken(oauthToken);
              }

              @Override
              public SearchForInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (SearchForInstances) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public SearchForInstances setQuotaUser(java.lang.String quotaUser) {
                return (SearchForInstances) super.setQuotaUser(quotaUser);
              }

              @Override
              public SearchForInstances setUploadType(java.lang.String uploadType) {
                return (SearchForInstances) super.setUploadType(uploadType);
              }

              @Override
              public SearchForInstances setUploadProtocol(java.lang.String uploadProtocol) {
                return (SearchForInstances) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the DICOM store that is being accessed. For example,
             `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public SearchForInstances setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The path of the SearchForInstancesRequest DICOMweb request. For example,
               * `instances`, `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
               */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
             `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /**
               * The path of the SearchForInstancesRequest DICOMweb request. For example,
               * `instances`, `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
               */
              public SearchForInstances setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/instances$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public SearchForInstances set(String parameterName, Object value) {
                return (SearchForInstances) super.set(parameterName, value);
              }
            }
            /**
             * SearchForSeries returns a list of matching series. See [Search Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
             * the implementation of SearchForSeries, see [Search
             * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call SearchForSeries, see
             * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
             * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
             *
             * Create a request for the method "studies.searchForSeries".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link SearchForSeries#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
             * @param dicomWebPath The path of the SearchForSeries DICOMweb request. For example, `series` or
             *        `studies/{study_uid}/series`.
             * @return the request
             */
            public SearchForSeries searchForSeries(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
              SearchForSeries result = new SearchForSeries(parent, dicomWebPath);
              initialize(result);
              return result;
            }

            public class SearchForSeries extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+/series$");

              /**
               * SearchForSeries returns a list of matching series. See [Search Transaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
               * the implementation of SearchForSeries, see [Search
               * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call SearchForSeries, see
               * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
               * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
               *
               * Create a request for the method "studies.searchForSeries".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link SearchForSeries#execute()} method to invoke the remote
               * operation. <p> {@link SearchForSeries#initialize(com.google.api.client.googleapis.services.Abst
               * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
               * @param dicomWebPath The path of the SearchForSeries DICOMweb request. For example, `series` or
             *        `studies/{study_uid}/series`.
               * @since 1.13
               */
              protected SearchForSeries(java.lang.String parent, java.lang.String dicomWebPath) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/series$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public SearchForSeries set$Xgafv(java.lang.String $Xgafv) {
                return (SearchForSeries) super.set$Xgafv($Xgafv);
              }

              @Override
              public SearchForSeries setAccessToken(java.lang.String accessToken) {
                return (SearchForSeries) super.setAccessToken(accessToken);
              }

              @Override
              public SearchForSeries setAlt(java.lang.String alt) {
                return (SearchForSeries) super.setAlt(alt);
              }

              @Override
              public SearchForSeries setCallback(java.lang.String callback) {
                return (SearchForSeries) super.setCallback(callback);
              }

              @Override
              public SearchForSeries setFields(java.lang.String fields) {
                return (SearchForSeries) super.setFields(fields);
              }

              @Override
              public SearchForSeries setKey(java.lang.String key) {
                return (SearchForSeries) super.setKey(key);
              }

              @Override
              public SearchForSeries setOauthToken(java.lang.String oauthToken) {
                return (SearchForSeries) super.setOauthToken(oauthToken);
              }

              @Override
              public SearchForSeries setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (SearchForSeries) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public SearchForSeries setQuotaUser(java.lang.String quotaUser) {
                return (SearchForSeries) super.setQuotaUser(quotaUser);
              }

              @Override
              public SearchForSeries setUploadType(java.lang.String uploadType) {
                return (SearchForSeries) super.setUploadType(uploadType);
              }

              @Override
              public SearchForSeries setUploadProtocol(java.lang.String uploadProtocol) {
                return (SearchForSeries) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the DICOM store that is being accessed. For example,
             `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public SearchForSeries setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The path of the SearchForSeries DICOMweb request. For example, `series` or
               * `studies/{study_uid}/series`.
               */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the SearchForSeries DICOMweb request. For example, `series` or
             `studies/{study_uid}/series`.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /**
               * The path of the SearchForSeries DICOMweb request. For example, `series` or
               * `studies/{study_uid}/series`.
               */
              public SearchForSeries setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+/series$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public SearchForSeries set(String parameterName, Object value) {
                return (SearchForSeries) super.set(parameterName, value);
              }
            }
            /**
             * StoreInstances stores DICOM instances associated with study instance unique identifiers (SUID).
             * See [Store Transaction]
             * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5). For details on
             * the implementation of StoreInstances, see [Store
             * transaction](https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the Cloud
             * Healthcare API conformance statement. For samples that show how to call StoreInstances, see
             * [Storing DICOM data](https://cloud.google.com/healthcare/docs/how-
             * tos/dicomweb#storing_dicom_data).
             *
             * Create a request for the method "studies.storeInstances".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link StoreInstances#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
             * @param dicomWebPath The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that the
             *        `study_uid` is optional.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @return the request
             */
            public StoreInstances storeInstances(java.lang.String parent, java.lang.String dicomWebPath, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
              StoreInstances result = new StoreInstances(parent, dicomWebPath, content);
              initialize(result);
              return result;
            }

            public class StoreInstances extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

              private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                  java.util.regex.Pattern.compile("^studies/[^/]+$");

              /**
               * StoreInstances stores DICOM instances associated with study instance unique identifiers (SUID).
               * See [Store Transaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5). For details on
               * the implementation of StoreInstances, see [Store
               * transaction](https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call StoreInstances, see
               * [Storing DICOM data](https://cloud.google.com/healthcare/docs/how-
               * tos/dicomweb#storing_dicom_data).
               *
               * Create a request for the method "studies.storeInstances".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link StoreInstances#execute()} method to invoke the remote
               * operation. <p> {@link StoreInstances#initialize(com.google.api.client.googleapis.services.Abstr
               * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
             *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
             *        ore_id}`.
               * @param dicomWebPath The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that the
             *        `study_uid` is optional.
               * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
               * @since 1.13
               */
              protected StoreInstances(java.lang.String parent, java.lang.String dicomWebPath, com.google.api.services.healthcare.v1.model.HttpBody content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
              }

              @Override
              public StoreInstances set$Xgafv(java.lang.String $Xgafv) {
                return (StoreInstances) super.set$Xgafv($Xgafv);
              }

              @Override
              public StoreInstances setAccessToken(java.lang.String accessToken) {
                return (StoreInstances) super.setAccessToken(accessToken);
              }

              @Override
              public StoreInstances setAlt(java.lang.String alt) {
                return (StoreInstances) super.setAlt(alt);
              }

              @Override
              public StoreInstances setCallback(java.lang.String callback) {
                return (StoreInstances) super.setCallback(callback);
              }

              @Override
              public StoreInstances setFields(java.lang.String fields) {
                return (StoreInstances) super.setFields(fields);
              }

              @Override
              public StoreInstances setKey(java.lang.String key) {
                return (StoreInstances) super.setKey(key);
              }

              @Override
              public StoreInstances setOauthToken(java.lang.String oauthToken) {
                return (StoreInstances) super.setOauthToken(oauthToken);
              }

              @Override
              public StoreInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (StoreInstances) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public StoreInstances setQuotaUser(java.lang.String quotaUser) {
                return (StoreInstances) super.setQuotaUser(quotaUser);
              }

              @Override
              public StoreInstances setUploadType(java.lang.String uploadType) {
                return (StoreInstances) super.setUploadType(uploadType);
              }

              @Override
              public StoreInstances setUploadProtocol(java.lang.String uploadProtocol) {
                return (StoreInstances) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the DICOM store that is being accessed. For example,
             `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * The name of the DICOM store that is being accessed. For example, `projects/{project
               * _id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
               */
              public StoreInstances setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The path of the StoreInstances DICOMweb request. For example,
               * `studies/[{study_uid}]`. Note that the `study_uid` is optional.
               */
              @com.google.api.client.util.Key
              private java.lang.String dicomWebPath;

              /** The path of the StoreInstances DICOMweb request. For example, `studies/[{study_uid}]`. Note that
             the `study_uid` is optional.
               */
              public java.lang.String getDicomWebPath() {
                return dicomWebPath;
              }

              /**
               * The path of the StoreInstances DICOMweb request. For example,
               * `studies/[{study_uid}]`. Note that the `study_uid` is optional.
               */
              public StoreInstances setDicomWebPath(java.lang.String dicomWebPath) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                      "Parameter dicomWebPath must conform to the pattern " +
                      "^studies/[^/]+$");
                }
                this.dicomWebPath = dicomWebPath;
                return this;
              }

              @Override
              public StoreInstances set(String parameterName, Object value) {
                return (StoreInstances) super.set(parameterName, value);
              }
            }

            /**
             * An accessor for creating requests from the Series collection.
             *
             * <p>The typical use is:</p>
             * <pre>
             *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
             *   {@code CloudHealthcare.Series.List request = healthcare.series().list(parameters ...)}
             * </pre>
             *
             * @return the resource collection
             */
            public Series series() {
              return new Series();
            }

            /**
             * The "series" collection of methods.
             */
            public class Series {

              /**
               * DeleteSeries deletes all instances within the given study and series. Delete requests are
               * equivalent to the GET requests specified in the Retrieve transaction. The method returns an
               * Operation which will be marked successful when the deletion is complete. Warning: Instances
               * cannot be inserted into a series that is being deleted by an operation until the operation
               * completes. For samples that show how to call DeleteSeries, see [Deleting a study, series, or
               * instance](https://cloud.google.com/healthcare/docs/how-
               * tos/dicomweb#deleting_a_study_series_or_instance).
               *
               * Create a request for the method "series.delete".
               *
               * This request holds the parameters needed by the healthcare server.  After setting any optional
               * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
               * @param dicomWebPath The path of the DeleteSeries request. For example, `studies/{study_uid}/series/{series_uid}`.
               * @return the request
               */
              public Delete delete(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                Delete result = new Delete(parent, dicomWebPath);
                initialize(result);
                return result;
              }

              public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

                private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                private final java.util.regex.Pattern PARENT_PATTERN =
                    java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                    java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+$");

                /**
                 * DeleteSeries deletes all instances within the given study and series. Delete requests are
                 * equivalent to the GET requests specified in the Retrieve transaction. The method returns an
                 * Operation which will be marked successful when the deletion is complete. Warning: Instances
                 * cannot be inserted into a series that is being deleted by an operation until the operation
                 * completes. For samples that show how to call DeleteSeries, see [Deleting a study, series, or
                 * instance](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#deleting_a_study_series_or_instance).
                 *
                 * Create a request for the method "series.delete".
                 *
                 * This request holds the parameters needed by the the healthcare server.  After setting any
                 * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
                 * <p> {@link
                 * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
                 * be called to initialize this instance immediately after invoking the constructor. </p>
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
                 * @param dicomWebPath The path of the DeleteSeries request. For example, `studies/{study_uid}/series/{series_uid}`.
                 * @since 1.13
                 */
                protected Delete(java.lang.String parent, java.lang.String dicomWebPath) {
                  super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Operation.class);
                  this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+$");
                  }
                }

                @Override
                public Delete set$Xgafv(java.lang.String $Xgafv) {
                  return (Delete) super.set$Xgafv($Xgafv);
                }

                @Override
                public Delete setAccessToken(java.lang.String accessToken) {
                  return (Delete) super.setAccessToken(accessToken);
                }

                @Override
                public Delete setAlt(java.lang.String alt) {
                  return (Delete) super.setAlt(alt);
                }

                @Override
                public Delete setCallback(java.lang.String callback) {
                  return (Delete) super.setCallback(callback);
                }

                @Override
                public Delete setFields(java.lang.String fields) {
                  return (Delete) super.setFields(fields);
                }

                @Override
                public Delete setKey(java.lang.String key) {
                  return (Delete) super.setKey(key);
                }

                @Override
                public Delete setOauthToken(java.lang.String oauthToken) {
                  return (Delete) super.setOauthToken(oauthToken);
                }

                @Override
                public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                  return (Delete) super.setPrettyPrint(prettyPrint);
                }

                @Override
                public Delete setQuotaUser(java.lang.String quotaUser) {
                  return (Delete) super.setQuotaUser(quotaUser);
                }

                @Override
                public Delete setUploadType(java.lang.String uploadType) {
                  return (Delete) super.setUploadType(uploadType);
                }

                @Override
                public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                  return (Delete) super.setUploadProtocol(uploadProtocol);
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                @com.google.api.client.util.Key
                private java.lang.String parent;

                /** The name of the DICOM store that is being accessed. For example,
               `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                 */
                public java.lang.String getParent() {
                  return parent;
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                public Delete setParent(java.lang.String parent) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.parent = parent;
                  return this;
                }

                /**
                 * The path of the DeleteSeries request. For example,
                 * `studies/{study_uid}/series/{series_uid}`.
                 */
                @com.google.api.client.util.Key
                private java.lang.String dicomWebPath;

                /** The path of the DeleteSeries request. For example, `studies/{study_uid}/series/{series_uid}`.
                 */
                public java.lang.String getDicomWebPath() {
                  return dicomWebPath;
                }

                /**
                 * The path of the DeleteSeries request. For example,
                 * `studies/{study_uid}/series/{series_uid}`.
                 */
                public Delete setDicomWebPath(java.lang.String dicomWebPath) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+$");
                  }
                  this.dicomWebPath = dicomWebPath;
                  return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                  return (Delete) super.set(parameterName, value);
                }
              }
              /**
               * RetrieveSeriesMetadata returns instance associated with the given study and series, presented as
               * metadata with the bulk data removed. See [RetrieveTransaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
               * the implementation of RetrieveSeriesMetadata, see [Metadata
               * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call RetrieveSeriesMetadata,
               * see [Retrieving metadata](https://cloud.google.com/healthcare/docs/how-
               * tos/dicomweb#retrieving_metadata).
               *
               * Create a request for the method "series.retrieveMetadata".
               *
               * This request holds the parameters needed by the healthcare server.  After setting any optional
               * parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote operation.
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
               * @param dicomWebPath The path of the RetrieveSeriesMetadata DICOMweb request. For example,
               *        `studies/{study_uid}/series/{series_uid}/metadata`.
               * @return the request
               */
              public RetrieveMetadata retrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
                initialize(result);
                return result;
              }

              public class RetrieveMetadata extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                private final java.util.regex.Pattern PARENT_PATTERN =
                    java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                    java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/metadata$");

                /**
                 * RetrieveSeriesMetadata returns instance associated with the given study and series, presented
                 * as metadata with the bulk data removed. See [RetrieveTransaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                 * the implementation of RetrieveSeriesMetadata, see [Metadata
                 * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
                 * Healthcare API conformance statement. For samples that show how to call RetrieveSeriesMetadata,
                 * see [Retrieving metadata](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#retrieving_metadata).
                 *
                 * Create a request for the method "series.retrieveMetadata".
                 *
                 * This request holds the parameters needed by the the healthcare server.  After setting any
                 * optional parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote
                 * operation. <p> {@link RetrieveMetadata#initialize(com.google.api.client.googleapis.services.Abs
                 * tractGoogleClientRequest)} must be called to initialize this instance immediately after
                 * invoking the constructor. </p>
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
                 * @param dicomWebPath The path of the RetrieveSeriesMetadata DICOMweb request. For example,
               *        `studies/{study_uid}/series/{series_uid}/metadata`.
                 * @since 1.13
                 */
                protected RetrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) {
                  super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                  this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+/metadata$");
                  }
                }

                @Override
                public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                  return super.executeUsingHead();
                }

                @Override
                public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                  return super.buildHttpRequestUsingHead();
                }

                @Override
                public RetrieveMetadata set$Xgafv(java.lang.String $Xgafv) {
                  return (RetrieveMetadata) super.set$Xgafv($Xgafv);
                }

                @Override
                public RetrieveMetadata setAccessToken(java.lang.String accessToken) {
                  return (RetrieveMetadata) super.setAccessToken(accessToken);
                }

                @Override
                public RetrieveMetadata setAlt(java.lang.String alt) {
                  return (RetrieveMetadata) super.setAlt(alt);
                }

                @Override
                public RetrieveMetadata setCallback(java.lang.String callback) {
                  return (RetrieveMetadata) super.setCallback(callback);
                }

                @Override
                public RetrieveMetadata setFields(java.lang.String fields) {
                  return (RetrieveMetadata) super.setFields(fields);
                }

                @Override
                public RetrieveMetadata setKey(java.lang.String key) {
                  return (RetrieveMetadata) super.setKey(key);
                }

                @Override
                public RetrieveMetadata setOauthToken(java.lang.String oauthToken) {
                  return (RetrieveMetadata) super.setOauthToken(oauthToken);
                }

                @Override
                public RetrieveMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
                  return (RetrieveMetadata) super.setPrettyPrint(prettyPrint);
                }

                @Override
                public RetrieveMetadata setQuotaUser(java.lang.String quotaUser) {
                  return (RetrieveMetadata) super.setQuotaUser(quotaUser);
                }

                @Override
                public RetrieveMetadata setUploadType(java.lang.String uploadType) {
                  return (RetrieveMetadata) super.setUploadType(uploadType);
                }

                @Override
                public RetrieveMetadata setUploadProtocol(java.lang.String uploadProtocol) {
                  return (RetrieveMetadata) super.setUploadProtocol(uploadProtocol);
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                @com.google.api.client.util.Key
                private java.lang.String parent;

                /** The name of the DICOM store that is being accessed. For example,
               `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                 */
                public java.lang.String getParent() {
                  return parent;
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                public RetrieveMetadata setParent(java.lang.String parent) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.parent = parent;
                  return this;
                }

                /**
                 * The path of the RetrieveSeriesMetadata DICOMweb request. For example,
                 * `studies/{study_uid}/series/{series_uid}/metadata`.
                 */
                @com.google.api.client.util.Key
                private java.lang.String dicomWebPath;

                /** The path of the RetrieveSeriesMetadata DICOMweb request. For example,
               `studies/{study_uid}/series/{series_uid}/metadata`.
                 */
                public java.lang.String getDicomWebPath() {
                  return dicomWebPath;
                }

                /**
                 * The path of the RetrieveSeriesMetadata DICOMweb request. For example,
                 * `studies/{study_uid}/series/{series_uid}/metadata`.
                 */
                public RetrieveMetadata setDicomWebPath(java.lang.String dicomWebPath) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+/metadata$");
                  }
                  this.dicomWebPath = dicomWebPath;
                  return this;
                }

                @Override
                public RetrieveMetadata set(String parameterName, Object value) {
                  return (RetrieveMetadata) super.set(parameterName, value);
                }
              }
              /**
               * RetrieveSeries returns all instances within the given study and series. See [RetrieveTransaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
               * the implementation of RetrieveSeries, see [DICOM study/series/instances](https://cloud.google.com
               * /healthcare/docs/dicom#dicom_studyseriesinstances) in the Cloud Healthcare API conformance
               * statement. For samples that show how to call RetrieveSeries, see [Retrieving DICOM
               * data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
               *
               * Create a request for the method "series.retrieveSeries".
               *
               * This request holds the parameters needed by the healthcare server.  After setting any optional
               * parameters, call the {@link RetrieveSeries#execute()} method to invoke the remote operation.
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
               * @param dicomWebPath The path of the RetrieveSeries DICOMweb request. For example,
               *        `studies/{study_uid}/series/{series_uid}`.
               * @return the request
               */
              public RetrieveSeries retrieveSeries(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                RetrieveSeries result = new RetrieveSeries(parent, dicomWebPath);
                initialize(result);
                return result;
              }

              public class RetrieveSeries extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                private final java.util.regex.Pattern PARENT_PATTERN =
                    java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                    java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+$");

                /**
                 * RetrieveSeries returns all instances within the given study and series. See
                 * [RetrieveTransaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                 * the implementation of RetrieveSeries, see [DICOM study/series/instances](https://cloud.google.c
                 * om/healthcare/docs/dicom#dicom_studyseriesinstances) in the Cloud Healthcare API conformance
                 * statement. For samples that show how to call RetrieveSeries, see [Retrieving DICOM
                 * data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
                 *
                 * Create a request for the method "series.retrieveSeries".
                 *
                 * This request holds the parameters needed by the the healthcare server.  After setting any
                 * optional parameters, call the {@link RetrieveSeries#execute()} method to invoke the remote
                 * operation. <p> {@link RetrieveSeries#initialize(com.google.api.client.googleapis.services.Abstr
                 * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
                 * the constructor. </p>
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
                 * @param dicomWebPath The path of the RetrieveSeries DICOMweb request. For example,
               *        `studies/{study_uid}/series/{series_uid}`.
                 * @since 1.13
                 */
                protected RetrieveSeries(java.lang.String parent, java.lang.String dicomWebPath) {
                  super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                  this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+$");
                  }
                }

                @Override
                public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                  return super.executeUsingHead();
                }

                @Override
                public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                  return super.buildHttpRequestUsingHead();
                }

                @Override
                public RetrieveSeries set$Xgafv(java.lang.String $Xgafv) {
                  return (RetrieveSeries) super.set$Xgafv($Xgafv);
                }

                @Override
                public RetrieveSeries setAccessToken(java.lang.String accessToken) {
                  return (RetrieveSeries) super.setAccessToken(accessToken);
                }

                @Override
                public RetrieveSeries setAlt(java.lang.String alt) {
                  return (RetrieveSeries) super.setAlt(alt);
                }

                @Override
                public RetrieveSeries setCallback(java.lang.String callback) {
                  return (RetrieveSeries) super.setCallback(callback);
                }

                @Override
                public RetrieveSeries setFields(java.lang.String fields) {
                  return (RetrieveSeries) super.setFields(fields);
                }

                @Override
                public RetrieveSeries setKey(java.lang.String key) {
                  return (RetrieveSeries) super.setKey(key);
                }

                @Override
                public RetrieveSeries setOauthToken(java.lang.String oauthToken) {
                  return (RetrieveSeries) super.setOauthToken(oauthToken);
                }

                @Override
                public RetrieveSeries setPrettyPrint(java.lang.Boolean prettyPrint) {
                  return (RetrieveSeries) super.setPrettyPrint(prettyPrint);
                }

                @Override
                public RetrieveSeries setQuotaUser(java.lang.String quotaUser) {
                  return (RetrieveSeries) super.setQuotaUser(quotaUser);
                }

                @Override
                public RetrieveSeries setUploadType(java.lang.String uploadType) {
                  return (RetrieveSeries) super.setUploadType(uploadType);
                }

                @Override
                public RetrieveSeries setUploadProtocol(java.lang.String uploadProtocol) {
                  return (RetrieveSeries) super.setUploadProtocol(uploadProtocol);
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                @com.google.api.client.util.Key
                private java.lang.String parent;

                /** The name of the DICOM store that is being accessed. For example,
               `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                 */
                public java.lang.String getParent() {
                  return parent;
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                public RetrieveSeries setParent(java.lang.String parent) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.parent = parent;
                  return this;
                }

                /**
                 * The path of the RetrieveSeries DICOMweb request. For example,
                 * `studies/{study_uid}/series/{series_uid}`.
                 */
                @com.google.api.client.util.Key
                private java.lang.String dicomWebPath;

                /** The path of the RetrieveSeries DICOMweb request. For example,
               `studies/{study_uid}/series/{series_uid}`.
                 */
                public java.lang.String getDicomWebPath() {
                  return dicomWebPath;
                }

                /**
                 * The path of the RetrieveSeries DICOMweb request. For example,
                 * `studies/{study_uid}/series/{series_uid}`.
                 */
                public RetrieveSeries setDicomWebPath(java.lang.String dicomWebPath) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+$");
                  }
                  this.dicomWebPath = dicomWebPath;
                  return this;
                }

                @Override
                public RetrieveSeries set(String parameterName, Object value) {
                  return (RetrieveSeries) super.set(parameterName, value);
                }
              }
              /**
               * SearchForInstances returns a list of matching instances. See [Search Transaction]
               * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
               * the implementation of SearchForInstances, see [Search
               * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
               * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
               * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
               * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
               *
               * Create a request for the method "series.searchForInstances".
               *
               * This request holds the parameters needed by the healthcare server.  After setting any optional
               * parameters, call the {@link SearchForInstances#execute()} method to invoke the remote operation.
               *
               * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
               * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
               *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
               * @return the request
               */
              public SearchForInstances searchForInstances(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
                initialize(result);
                return result;
              }

              public class SearchForInstances extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                private final java.util.regex.Pattern PARENT_PATTERN =
                    java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                    java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances$");

                /**
                 * SearchForInstances returns a list of matching instances. See [Search Transaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6). For details on
                 * the implementation of SearchForInstances, see [Search
                 * transaction](https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the Cloud
                 * Healthcare API conformance statement. For samples that show how to call SearchForInstances, see
                 * [Searching for studies, series, instances, and frames](https://cloud.google.com/healthcare/docs
                 * /how-tos/dicomweb#searching_for_studies_series_instances_and_frames).
                 *
                 * Create a request for the method "series.searchForInstances".
                 *
                 * This request holds the parameters needed by the the healthcare server.  After setting any
                 * optional parameters, call the {@link SearchForInstances#execute()} method to invoke the remote
                 * operation. <p> {@link SearchForInstances#initialize(com.google.api.client.googleapis.services.A
                 * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
                 * invoking the constructor. </p>
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
               *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
               *        ore_id}`.
                 * @param dicomWebPath The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
               *        `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
                 * @since 1.13
                 */
                protected SearchForInstances(java.lang.String parent, java.lang.String dicomWebPath) {
                  super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                  this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+/instances$");
                  }
                }

                @Override
                public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                  return super.executeUsingHead();
                }

                @Override
                public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                  return super.buildHttpRequestUsingHead();
                }

                @Override
                public SearchForInstances set$Xgafv(java.lang.String $Xgafv) {
                  return (SearchForInstances) super.set$Xgafv($Xgafv);
                }

                @Override
                public SearchForInstances setAccessToken(java.lang.String accessToken) {
                  return (SearchForInstances) super.setAccessToken(accessToken);
                }

                @Override
                public SearchForInstances setAlt(java.lang.String alt) {
                  return (SearchForInstances) super.setAlt(alt);
                }

                @Override
                public SearchForInstances setCallback(java.lang.String callback) {
                  return (SearchForInstances) super.setCallback(callback);
                }

                @Override
                public SearchForInstances setFields(java.lang.String fields) {
                  return (SearchForInstances) super.setFields(fields);
                }

                @Override
                public SearchForInstances setKey(java.lang.String key) {
                  return (SearchForInstances) super.setKey(key);
                }

                @Override
                public SearchForInstances setOauthToken(java.lang.String oauthToken) {
                  return (SearchForInstances) super.setOauthToken(oauthToken);
                }

                @Override
                public SearchForInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
                  return (SearchForInstances) super.setPrettyPrint(prettyPrint);
                }

                @Override
                public SearchForInstances setQuotaUser(java.lang.String quotaUser) {
                  return (SearchForInstances) super.setQuotaUser(quotaUser);
                }

                @Override
                public SearchForInstances setUploadType(java.lang.String uploadType) {
                  return (SearchForInstances) super.setUploadType(uploadType);
                }

                @Override
                public SearchForInstances setUploadProtocol(java.lang.String uploadProtocol) {
                  return (SearchForInstances) super.setUploadProtocol(uploadProtocol);
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                @com.google.api.client.util.Key
                private java.lang.String parent;

                /** The name of the DICOM store that is being accessed. For example,
               `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                 */
                public java.lang.String getParent() {
                  return parent;
                }

                /**
                 * The name of the DICOM store that is being accessed. For example, `projects/{proje
                 * ct_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}
                 * `.
                 */
                public SearchForInstances setParent(java.lang.String parent) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                        "Parameter parent must conform to the pattern " +
                        "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                  }
                  this.parent = parent;
                  return this;
                }

                /**
                 * The path of the SearchForInstancesRequest DICOMweb request. For example,
                 * `instances`, `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
                 */
                @com.google.api.client.util.Key
                private java.lang.String dicomWebPath;

                /** The path of the SearchForInstancesRequest DICOMweb request. For example, `instances`,
               `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
                 */
                public java.lang.String getDicomWebPath() {
                  return dicomWebPath;
                }

                /**
                 * The path of the SearchForInstancesRequest DICOMweb request. For example,
                 * `instances`, `series/{series_uid}/instances`, or `studies/{study_uid}/instances`.
                 */
                public SearchForInstances setDicomWebPath(java.lang.String dicomWebPath) {
                  if (!getSuppressPatternChecks()) {
                    com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                        "Parameter dicomWebPath must conform to the pattern " +
                        "^studies/[^/]+/series/[^/]+/instances$");
                  }
                  this.dicomWebPath = dicomWebPath;
                  return this;
                }

                @Override
                public SearchForInstances set(String parameterName, Object value) {
                  return (SearchForInstances) super.set(parameterName, value);
                }
              }

              /**
               * An accessor for creating requests from the Instances collection.
               *
               * <p>The typical use is:</p>
               * <pre>
               *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
               *   {@code CloudHealthcare.Instances.List request = healthcare.instances().list(parameters ...)}
               * </pre>
               *
               * @return the resource collection
               */
              public Instances instances() {
                return new Instances();
              }

              /**
               * The "instances" collection of methods.
               */
              public class Instances {

                /**
                 * DeleteInstance deletes an instance associated with the given study, series, and SOP Instance UID.
                 * Delete requests are equivalent to the GET requests specified in the Retrieve transaction. Study
                 * and series search results can take a few seconds to be updated after an instance is deleted using
                 * DeleteInstance. For samples that show how to call DeleteInstance, see [Deleting a study, series,
                 * or instance](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#deleting_a_study_series_or_instance).
                 *
                 * Create a request for the method "instances.delete".
                 *
                 * This request holds the parameters needed by the healthcare server.  After setting any optional
                 * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                 * @param dicomWebPath The path of the DeleteInstance request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                 * @return the request
                 */
                public Delete delete(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                  Delete result = new Delete(parent, dicomWebPath);
                  initialize(result);
                  return result;
                }

                public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

                  private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                  private final java.util.regex.Pattern PARENT_PATTERN =
                      java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                  private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                      java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+$");

                  /**
                   * DeleteInstance deletes an instance associated with the given study, series, and SOP Instance
                   * UID. Delete requests are equivalent to the GET requests specified in the Retrieve transaction.
                   * Study and series search results can take a few seconds to be updated after an instance is
                   * deleted using DeleteInstance. For samples that show how to call DeleteInstance, see [Deleting a
                   * study, series, or instance](https://cloud.google.com/healthcare/docs/how-
                   * tos/dicomweb#deleting_a_study_series_or_instance).
                   *
                   * Create a request for the method "instances.delete".
                   *
                   * This request holds the parameters needed by the the healthcare server.  After setting any
                   * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
                   * <p> {@link
                   * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
                   * be called to initialize this instance immediately after invoking the constructor. </p>
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                   * @param dicomWebPath The path of the DeleteInstance request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   * @since 1.13
                   */
                  protected Delete(java.lang.String parent, java.lang.String dicomWebPath) {
                    super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                    this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                    }
                  }

                  @Override
                  public Delete set$Xgafv(java.lang.String $Xgafv) {
                    return (Delete) super.set$Xgafv($Xgafv);
                  }

                  @Override
                  public Delete setAccessToken(java.lang.String accessToken) {
                    return (Delete) super.setAccessToken(accessToken);
                  }

                  @Override
                  public Delete setAlt(java.lang.String alt) {
                    return (Delete) super.setAlt(alt);
                  }

                  @Override
                  public Delete setCallback(java.lang.String callback) {
                    return (Delete) super.setCallback(callback);
                  }

                  @Override
                  public Delete setFields(java.lang.String fields) {
                    return (Delete) super.setFields(fields);
                  }

                  @Override
                  public Delete setKey(java.lang.String key) {
                    return (Delete) super.setKey(key);
                  }

                  @Override
                  public Delete setOauthToken(java.lang.String oauthToken) {
                    return (Delete) super.setOauthToken(oauthToken);
                  }

                  @Override
                  public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                    return (Delete) super.setPrettyPrint(prettyPrint);
                  }

                  @Override
                  public Delete setQuotaUser(java.lang.String quotaUser) {
                    return (Delete) super.setQuotaUser(quotaUser);
                  }

                  @Override
                  public Delete setUploadType(java.lang.String uploadType) {
                    return (Delete) super.setUploadType(uploadType);
                  }

                  @Override
                  public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                    return (Delete) super.setUploadProtocol(uploadProtocol);
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String parent;

                  /** The name of the DICOM store that is being accessed. For example,
                 `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                   */
                  public java.lang.String getParent() {
                    return parent;
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  public Delete setParent(java.lang.String parent) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                  }

                  /**
                   * The path of the DeleteInstance request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String dicomWebPath;

                  /** The path of the DeleteInstance request. For example,
                 `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  public java.lang.String getDicomWebPath() {
                    return dicomWebPath;
                  }

                  /**
                   * The path of the DeleteInstance request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  public Delete setDicomWebPath(java.lang.String dicomWebPath) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                    }
                    this.dicomWebPath = dicomWebPath;
                    return this;
                  }

                  @Override
                  public Delete set(String parameterName, Object value) {
                    return (Delete) super.set(parameterName, value);
                  }
                }
                /**
                 * RetrieveInstance returns instance associated with the given study, series, and SOP Instance UID.
                 * See [RetrieveTransaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                 * the implementation of RetrieveInstance, see [DICOM study/series/instances](https://cloud.google.c
                 * om/healthcare/docs/dicom#dicom_studyseriesinstances) and [DICOM
                 * instances](https://cloud.google.com/healthcare/docs/dicom#dicom_instances) in the Cloud
                 * Healthcare API conformance statement. For samples that show how to call RetrieveInstance, see
                 * [Retrieving an instance](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#retrieving_an_instance).
                 *
                 * Create a request for the method "instances.retrieveInstance".
                 *
                 * This request holds the parameters needed by the healthcare server.  After setting any optional
                 * parameters, call the {@link RetrieveInstance#execute()} method to invoke the remote operation.
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                 * @param dicomWebPath The path of the RetrieveInstance DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                 * @return the request
                 */
                public RetrieveInstance retrieveInstance(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                  RetrieveInstance result = new RetrieveInstance(parent, dicomWebPath);
                  initialize(result);
                  return result;
                }

                public class RetrieveInstance extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                  private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                  private final java.util.regex.Pattern PARENT_PATTERN =
                      java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                  private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                      java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+$");

                  /**
                   * RetrieveInstance returns instance associated with the given study, series, and SOP Instance
                   * UID. See [RetrieveTransaction]
                   * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                   * the implementation of RetrieveInstance, see [DICOM study/series/instances](https://cloud.google
                   * .com/healthcare/docs/dicom#dicom_studyseriesinstances) and [DICOM
                   * instances](https://cloud.google.com/healthcare/docs/dicom#dicom_instances) in the Cloud
                   * Healthcare API conformance statement. For samples that show how to call RetrieveInstance, see
                   * [Retrieving an instance](https://cloud.google.com/healthcare/docs/how-
                   * tos/dicomweb#retrieving_an_instance).
                   *
                   * Create a request for the method "instances.retrieveInstance".
                   *
                   * This request holds the parameters needed by the the healthcare server.  After setting any
                   * optional parameters, call the {@link RetrieveInstance#execute()} method to invoke the remote
                   * operation. <p> {@link RetrieveInstance#initialize(com.google.api.client.googleapis.services.Abs
                   * tractGoogleClientRequest)} must be called to initialize this instance immediately after
                   * invoking the constructor. </p>
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                   * @param dicomWebPath The path of the RetrieveInstance DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   * @since 1.13
                   */
                  protected RetrieveInstance(java.lang.String parent, java.lang.String dicomWebPath) {
                    super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                    this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                    }
                  }

                  @Override
                  public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                    return super.executeUsingHead();
                  }

                  @Override
                  public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                    return super.buildHttpRequestUsingHead();
                  }

                  @Override
                  public RetrieveInstance set$Xgafv(java.lang.String $Xgafv) {
                    return (RetrieveInstance) super.set$Xgafv($Xgafv);
                  }

                  @Override
                  public RetrieveInstance setAccessToken(java.lang.String accessToken) {
                    return (RetrieveInstance) super.setAccessToken(accessToken);
                  }

                  @Override
                  public RetrieveInstance setAlt(java.lang.String alt) {
                    return (RetrieveInstance) super.setAlt(alt);
                  }

                  @Override
                  public RetrieveInstance setCallback(java.lang.String callback) {
                    return (RetrieveInstance) super.setCallback(callback);
                  }

                  @Override
                  public RetrieveInstance setFields(java.lang.String fields) {
                    return (RetrieveInstance) super.setFields(fields);
                  }

                  @Override
                  public RetrieveInstance setKey(java.lang.String key) {
                    return (RetrieveInstance) super.setKey(key);
                  }

                  @Override
                  public RetrieveInstance setOauthToken(java.lang.String oauthToken) {
                    return (RetrieveInstance) super.setOauthToken(oauthToken);
                  }

                  @Override
                  public RetrieveInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
                    return (RetrieveInstance) super.setPrettyPrint(prettyPrint);
                  }

                  @Override
                  public RetrieveInstance setQuotaUser(java.lang.String quotaUser) {
                    return (RetrieveInstance) super.setQuotaUser(quotaUser);
                  }

                  @Override
                  public RetrieveInstance setUploadType(java.lang.String uploadType) {
                    return (RetrieveInstance) super.setUploadType(uploadType);
                  }

                  @Override
                  public RetrieveInstance setUploadProtocol(java.lang.String uploadProtocol) {
                    return (RetrieveInstance) super.setUploadProtocol(uploadProtocol);
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String parent;

                  /** The name of the DICOM store that is being accessed. For example,
                 `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                   */
                  public java.lang.String getParent() {
                    return parent;
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  public RetrieveInstance setParent(java.lang.String parent) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                  }

                  /**
                   * The path of the RetrieveInstance DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String dicomWebPath;

                  /** The path of the RetrieveInstance DICOMweb request. For example,
                 `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  public java.lang.String getDicomWebPath() {
                    return dicomWebPath;
                  }

                  /**
                   * The path of the RetrieveInstance DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
                   */
                  public RetrieveInstance setDicomWebPath(java.lang.String dicomWebPath) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                    }
                    this.dicomWebPath = dicomWebPath;
                    return this;
                  }

                  @Override
                  public RetrieveInstance set(String parameterName, Object value) {
                    return (RetrieveInstance) super.set(parameterName, value);
                  }
                }
                /**
                 * RetrieveInstanceMetadata returns instance associated with the given study, series, and SOP
                 * Instance UID presented as metadata with the bulk data removed. See [RetrieveTransaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                 * the implementation of RetrieveInstanceMetadata, see [Metadata
                 * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
                 * Healthcare API conformance statement. For samples that show how to call RetrieveInstanceMetadata,
                 * see [Retrieving metadata](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#retrieving_metadata).
                 *
                 * Create a request for the method "instances.retrieveMetadata".
                 *
                 * This request holds the parameters needed by the healthcare server.  After setting any optional
                 * parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote operation.
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                 * @param dicomWebPath The path of the RetrieveInstanceMetadata DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`.
                 * @return the request
                 */
                public RetrieveMetadata retrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                  RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
                  initialize(result);
                  return result;
                }

                public class RetrieveMetadata extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                  private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                  private final java.util.regex.Pattern PARENT_PATTERN =
                      java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                  private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                      java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");

                  /**
                   * RetrieveInstanceMetadata returns instance associated with the given study, series, and SOP
                   * Instance UID presented as metadata with the bulk data removed. See [RetrieveTransaction]
                   * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                   * the implementation of RetrieveInstanceMetadata, see [Metadata
                   * resources](https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the Cloud
                   * Healthcare API conformance statement. For samples that show how to call
                   * RetrieveInstanceMetadata, see [Retrieving metadata](https://cloud.google.com/healthcare/docs
                   * /how-tos/dicomweb#retrieving_metadata).
                   *
                   * Create a request for the method "instances.retrieveMetadata".
                   *
                   * This request holds the parameters needed by the the healthcare server.  After setting any
                   * optional parameters, call the {@link RetrieveMetadata#execute()} method to invoke the remote
                   * operation. <p> {@link RetrieveMetadata#initialize(com.google.api.client.googleapis.services.Abs
                   * tractGoogleClientRequest)} must be called to initialize this instance immediately after
                   * invoking the constructor. </p>
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                   * @param dicomWebPath The path of the RetrieveInstanceMetadata DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`.
                   * @since 1.13
                   */
                  protected RetrieveMetadata(java.lang.String parent, java.lang.String dicomWebPath) {
                    super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                    this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");
                    }
                  }

                  @Override
                  public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                    return super.executeUsingHead();
                  }

                  @Override
                  public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                    return super.buildHttpRequestUsingHead();
                  }

                  @Override
                  public RetrieveMetadata set$Xgafv(java.lang.String $Xgafv) {
                    return (RetrieveMetadata) super.set$Xgafv($Xgafv);
                  }

                  @Override
                  public RetrieveMetadata setAccessToken(java.lang.String accessToken) {
                    return (RetrieveMetadata) super.setAccessToken(accessToken);
                  }

                  @Override
                  public RetrieveMetadata setAlt(java.lang.String alt) {
                    return (RetrieveMetadata) super.setAlt(alt);
                  }

                  @Override
                  public RetrieveMetadata setCallback(java.lang.String callback) {
                    return (RetrieveMetadata) super.setCallback(callback);
                  }

                  @Override
                  public RetrieveMetadata setFields(java.lang.String fields) {
                    return (RetrieveMetadata) super.setFields(fields);
                  }

                  @Override
                  public RetrieveMetadata setKey(java.lang.String key) {
                    return (RetrieveMetadata) super.setKey(key);
                  }

                  @Override
                  public RetrieveMetadata setOauthToken(java.lang.String oauthToken) {
                    return (RetrieveMetadata) super.setOauthToken(oauthToken);
                  }

                  @Override
                  public RetrieveMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
                    return (RetrieveMetadata) super.setPrettyPrint(prettyPrint);
                  }

                  @Override
                  public RetrieveMetadata setQuotaUser(java.lang.String quotaUser) {
                    return (RetrieveMetadata) super.setQuotaUser(quotaUser);
                  }

                  @Override
                  public RetrieveMetadata setUploadType(java.lang.String uploadType) {
                    return (RetrieveMetadata) super.setUploadType(uploadType);
                  }

                  @Override
                  public RetrieveMetadata setUploadProtocol(java.lang.String uploadProtocol) {
                    return (RetrieveMetadata) super.setUploadProtocol(uploadProtocol);
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String parent;

                  /** The name of the DICOM store that is being accessed. For example,
                 `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                   */
                  public java.lang.String getParent() {
                    return parent;
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  public RetrieveMetadata setParent(java.lang.String parent) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                  }

                  /**
                   * The path of the RetrieveInstanceMetadata DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String dicomWebPath;

                  /** The path of the RetrieveInstanceMetadata DICOMweb request. For example,
                 `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`.
                   */
                  public java.lang.String getDicomWebPath() {
                    return dicomWebPath;
                  }

                  /**
                   * The path of the RetrieveInstanceMetadata DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`.
                   */
                  public RetrieveMetadata setDicomWebPath(java.lang.String dicomWebPath) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");
                    }
                    this.dicomWebPath = dicomWebPath;
                    return this;
                  }

                  @Override
                  public RetrieveMetadata set(String parameterName, Object value) {
                    return (RetrieveMetadata) super.set(parameterName, value);
                  }
                }
                /**
                 * RetrieveRenderedInstance returns instance associated with the given study, series, and SOP
                 * Instance UID in an acceptable Rendered Media Type. See [RetrieveTransaction]
                 * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                 * the implementation of RetrieveRenderedInstance, see [Rendered
                 * resources](https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the Cloud
                 * Healthcare API conformance statement. For samples that show how to call RetrieveRenderedInstance,
                 * see [Retrieving consumer image formats](https://cloud.google.com/healthcare/docs/how-
                 * tos/dicomweb#retrieving_consumer_image_formats).
                 *
                 * Create a request for the method "instances.retrieveRendered".
                 *
                 * This request holds the parameters needed by the healthcare server.  After setting any optional
                 * parameters, call the {@link RetrieveRendered#execute()} method to invoke the remote operation.
                 *
                 * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                 * @param dicomWebPath The path of the RetrieveRenderedInstance DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`.
                 * @return the request
                 */
                public RetrieveRendered retrieveRendered(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                  RetrieveRendered result = new RetrieveRendered(parent, dicomWebPath);
                  initialize(result);
                  return result;
                }

                public class RetrieveRendered extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                  private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                  private final java.util.regex.Pattern PARENT_PATTERN =
                      java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                  private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                      java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");

                  /**
                   * RetrieveRenderedInstance returns instance associated with the given study, series, and SOP
                   * Instance UID in an acceptable Rendered Media Type. See [RetrieveTransaction]
                   * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                   * the implementation of RetrieveRenderedInstance, see [Rendered
                   * resources](https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the Cloud
                   * Healthcare API conformance statement. For samples that show how to call
                   * RetrieveRenderedInstance, see [Retrieving consumer image
                   * formats](https://cloud.google.com/healthcare/docs/how-
                   * tos/dicomweb#retrieving_consumer_image_formats).
                   *
                   * Create a request for the method "instances.retrieveRendered".
                   *
                   * This request holds the parameters needed by the the healthcare server.  After setting any
                   * optional parameters, call the {@link RetrieveRendered#execute()} method to invoke the remote
                   * operation. <p> {@link RetrieveRendered#initialize(com.google.api.client.googleapis.services.Abs
                   * tractGoogleClientRequest)} must be called to initialize this instance immediately after
                   * invoking the constructor. </p>
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                 *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                 *        ore_id}`.
                   * @param dicomWebPath The path of the RetrieveRenderedInstance DICOMweb request. For example,
                 *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`.
                   * @since 1.13
                   */
                  protected RetrieveRendered(java.lang.String parent, java.lang.String dicomWebPath) {
                    super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                    this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");
                    }
                  }

                  @Override
                  public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                    return super.executeUsingHead();
                  }

                  @Override
                  public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                    return super.buildHttpRequestUsingHead();
                  }

                  @Override
                  public RetrieveRendered set$Xgafv(java.lang.String $Xgafv) {
                    return (RetrieveRendered) super.set$Xgafv($Xgafv);
                  }

                  @Override
                  public RetrieveRendered setAccessToken(java.lang.String accessToken) {
                    return (RetrieveRendered) super.setAccessToken(accessToken);
                  }

                  @Override
                  public RetrieveRendered setAlt(java.lang.String alt) {
                    return (RetrieveRendered) super.setAlt(alt);
                  }

                  @Override
                  public RetrieveRendered setCallback(java.lang.String callback) {
                    return (RetrieveRendered) super.setCallback(callback);
                  }

                  @Override
                  public RetrieveRendered setFields(java.lang.String fields) {
                    return (RetrieveRendered) super.setFields(fields);
                  }

                  @Override
                  public RetrieveRendered setKey(java.lang.String key) {
                    return (RetrieveRendered) super.setKey(key);
                  }

                  @Override
                  public RetrieveRendered setOauthToken(java.lang.String oauthToken) {
                    return (RetrieveRendered) super.setOauthToken(oauthToken);
                  }

                  @Override
                  public RetrieveRendered setPrettyPrint(java.lang.Boolean prettyPrint) {
                    return (RetrieveRendered) super.setPrettyPrint(prettyPrint);
                  }

                  @Override
                  public RetrieveRendered setQuotaUser(java.lang.String quotaUser) {
                    return (RetrieveRendered) super.setQuotaUser(quotaUser);
                  }

                  @Override
                  public RetrieveRendered setUploadType(java.lang.String uploadType) {
                    return (RetrieveRendered) super.setUploadType(uploadType);
                  }

                  @Override
                  public RetrieveRendered setUploadProtocol(java.lang.String uploadProtocol) {
                    return (RetrieveRendered) super.setUploadProtocol(uploadProtocol);
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String parent;

                  /** The name of the DICOM store that is being accessed. For example,
                 `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                   */
                  public java.lang.String getParent() {
                    return parent;
                  }

                  /**
                   * The name of the DICOM store that is being accessed. For example, `projects/{pro
                   * ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store
                   * _id}`.
                   */
                  public RetrieveRendered setParent(java.lang.String parent) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                          "Parameter parent must conform to the pattern " +
                          "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                  }

                  /**
                   * The path of the RetrieveRenderedInstance DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`.
                   */
                  @com.google.api.client.util.Key
                  private java.lang.String dicomWebPath;

                  /** The path of the RetrieveRenderedInstance DICOMweb request. For example,
                 `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`.
                   */
                  public java.lang.String getDicomWebPath() {
                    return dicomWebPath;
                  }

                  /**
                   * The path of the RetrieveRenderedInstance DICOMweb request. For example,
                   * `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`.
                   */
                  public RetrieveRendered setDicomWebPath(java.lang.String dicomWebPath) {
                    if (!getSuppressPatternChecks()) {
                      com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                          "Parameter dicomWebPath must conform to the pattern " +
                          "^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");
                    }
                    this.dicomWebPath = dicomWebPath;
                    return this;
                  }

                  @Override
                  public RetrieveRendered set(String parameterName, Object value) {
                    return (RetrieveRendered) super.set(parameterName, value);
                  }
                }

                /**
                 * An accessor for creating requests from the Frames collection.
                 *
                 * <p>The typical use is:</p>
                 * <pre>
                 *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
                 *   {@code CloudHealthcare.Frames.List request = healthcare.frames().list(parameters ...)}
                 * </pre>
                 *
                 * @return the resource collection
                 */
                public Frames frames() {
                  return new Frames();
                }

                /**
                 * The "frames" collection of methods.
                 */
                public class Frames {

                  /**
                   * RetrieveFrames returns instances associated with the given study, series, SOP Instance UID and
                   * frame numbers. See [RetrieveTransaction]
                   * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4}. For details on
                   * the implementation of RetrieveFrames, see [DICOM
                   * frames](https://cloud.google.com/healthcare/docs/dicom#dicom_frames) in the Cloud Healthcare API
                   * conformance statement. For samples that show how to call RetrieveFrames, see [Retrieving DICOM
                   * data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
                   *
                   * Create a request for the method "frames.retrieveFrames".
                   *
                   * This request holds the parameters needed by the healthcare server.  After setting any optional
                   * parameters, call the {@link RetrieveFrames#execute()} method to invoke the remote operation.
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                   *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                   *        ore_id}`.
                   * @param dicomWebPath The path of the RetrieveFrames DICOMweb request. For example,
                   *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}`.
                   * @return the request
                   */
                  public RetrieveFrames retrieveFrames(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                    RetrieveFrames result = new RetrieveFrames(parent, dicomWebPath);
                    initialize(result);
                    return result;
                  }

                  public class RetrieveFrames extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                    private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                    private final java.util.regex.Pattern PARENT_PATTERN =
                        java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                    private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                        java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");

                    /**
                     * RetrieveFrames returns instances associated with the given study, series, SOP Instance UID and
                     * frame numbers. See [RetrieveTransaction]
                     * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4}. For details on
                     * the implementation of RetrieveFrames, see [DICOM
                     * frames](https://cloud.google.com/healthcare/docs/dicom#dicom_frames) in the Cloud Healthcare
                     * API conformance statement. For samples that show how to call RetrieveFrames, see [Retrieving
                     * DICOM data](https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieving_dicom_data).
                     *
                     * Create a request for the method "frames.retrieveFrames".
                     *
                     * This request holds the parameters needed by the the healthcare server.  After setting any
                     * optional parameters, call the {@link RetrieveFrames#execute()} method to invoke the remote
                     * operation. <p> {@link RetrieveFrames#initialize(com.google.api.client.googleapis.services.Abstr
                     * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
                     * the constructor. </p>
                     *
                     * @param parent The name of the DICOM store that is being accessed. For example,
                   *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                   *        ore_id}`.
                     * @param dicomWebPath The path of the RetrieveFrames DICOMweb request. For example,
                   *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}`.
                     * @since 1.13
                     */
                    protected RetrieveFrames(java.lang.String parent, java.lang.String dicomWebPath) {
                      super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                      this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                            "Parameter parent must conform to the pattern " +
                            "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                      }
                      this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                            "Parameter dicomWebPath must conform to the pattern " +
                            "^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");
                      }
                    }

                    @Override
                    public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                      return super.executeUsingHead();
                    }

                    @Override
                    public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                      return super.buildHttpRequestUsingHead();
                    }

                    @Override
                    public RetrieveFrames set$Xgafv(java.lang.String $Xgafv) {
                      return (RetrieveFrames) super.set$Xgafv($Xgafv);
                    }

                    @Override
                    public RetrieveFrames setAccessToken(java.lang.String accessToken) {
                      return (RetrieveFrames) super.setAccessToken(accessToken);
                    }

                    @Override
                    public RetrieveFrames setAlt(java.lang.String alt) {
                      return (RetrieveFrames) super.setAlt(alt);
                    }

                    @Override
                    public RetrieveFrames setCallback(java.lang.String callback) {
                      return (RetrieveFrames) super.setCallback(callback);
                    }

                    @Override
                    public RetrieveFrames setFields(java.lang.String fields) {
                      return (RetrieveFrames) super.setFields(fields);
                    }

                    @Override
                    public RetrieveFrames setKey(java.lang.String key) {
                      return (RetrieveFrames) super.setKey(key);
                    }

                    @Override
                    public RetrieveFrames setOauthToken(java.lang.String oauthToken) {
                      return (RetrieveFrames) super.setOauthToken(oauthToken);
                    }

                    @Override
                    public RetrieveFrames setPrettyPrint(java.lang.Boolean prettyPrint) {
                      return (RetrieveFrames) super.setPrettyPrint(prettyPrint);
                    }

                    @Override
                    public RetrieveFrames setQuotaUser(java.lang.String quotaUser) {
                      return (RetrieveFrames) super.setQuotaUser(quotaUser);
                    }

                    @Override
                    public RetrieveFrames setUploadType(java.lang.String uploadType) {
                      return (RetrieveFrames) super.setUploadType(uploadType);
                    }

                    @Override
                    public RetrieveFrames setUploadProtocol(java.lang.String uploadProtocol) {
                      return (RetrieveFrames) super.setUploadProtocol(uploadProtocol);
                    }

                    /**
                     * The name of the DICOM store that is being accessed. For example, `projects/{p
                     * roject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_s
                     * tore_id}`.
                     */
                    @com.google.api.client.util.Key
                    private java.lang.String parent;

                    /** The name of the DICOM store that is being accessed. For example,
                   `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                     */
                    public java.lang.String getParent() {
                      return parent;
                    }

                    /**
                     * The name of the DICOM store that is being accessed. For example, `projects/{p
                     * roject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_s
                     * tore_id}`.
                     */
                    public RetrieveFrames setParent(java.lang.String parent) {
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                            "Parameter parent must conform to the pattern " +
                            "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                      }
                      this.parent = parent;
                      return this;
                    }

                    /**
                     * The path of the RetrieveFrames DICOMweb request. For example, `studies/{study
                     * _uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}`.
                     */
                    @com.google.api.client.util.Key
                    private java.lang.String dicomWebPath;

                    /** The path of the RetrieveFrames DICOMweb request. For example,
                   `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}`.
                     */
                    public java.lang.String getDicomWebPath() {
                      return dicomWebPath;
                    }

                    /**
                     * The path of the RetrieveFrames DICOMweb request. For example, `studies/{study
                     * _uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}`.
                     */
                    public RetrieveFrames setDicomWebPath(java.lang.String dicomWebPath) {
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                            "Parameter dicomWebPath must conform to the pattern " +
                            "^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");
                      }
                      this.dicomWebPath = dicomWebPath;
                      return this;
                    }

                    @Override
                    public RetrieveFrames set(String parameterName, Object value) {
                      return (RetrieveFrames) super.set(parameterName, value);
                    }
                  }
                  /**
                   * RetrieveRenderedFrames returns instances associated with the given study, series, SOP Instance
                   * UID and frame numbers in an acceptable Rendered Media Type. See [RetrieveTransaction]
                   * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                   * the implementation of RetrieveRenderedFrames, see [Rendered
                   * resources](https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the Cloud
                   * Healthcare API conformance statement. For samples that show how to call RetrieveRenderedFrames,
                   * see [Retrieving consumer image formats](https://cloud.google.com/healthcare/docs/how-
                   * tos/dicomweb#retrieving_consumer_image_formats).
                   *
                   * Create a request for the method "frames.retrieveRendered".
                   *
                   * This request holds the parameters needed by the healthcare server.  After setting any optional
                   * parameters, call the {@link RetrieveRendered#execute()} method to invoke the remote operation.
                   *
                   * @param parent The name of the DICOM store that is being accessed. For example,
                   *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                   *        ore_id}`.
                   * @param dicomWebPath The path of the RetrieveRenderedFrames DICOMweb request. For example,
                   *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}/rend
                   *        ered`.
                   * @return the request
                   */
                  public RetrieveRendered retrieveRendered(java.lang.String parent, java.lang.String dicomWebPath) throws java.io.IOException {
                    RetrieveRendered result = new RetrieveRendered(parent, dicomWebPath);
                    initialize(result);
                    return result;
                  }

                  public class RetrieveRendered extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

                    private static final String REST_PATH = "v1/{+parent}/dicomWeb/{+dicomWebPath}";

                    private final java.util.regex.Pattern PARENT_PATTERN =
                        java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");

                    private final java.util.regex.Pattern DICOM_WEB_PATH_PATTERN =
                        java.util.regex.Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");

                    /**
                     * RetrieveRenderedFrames returns instances associated with the given study, series, SOP Instance
                     * UID and frame numbers in an acceptable Rendered Media Type. See [RetrieveTransaction]
                     * (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4). For details on
                     * the implementation of RetrieveRenderedFrames, see [Rendered
                     * resources](https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the Cloud
                     * Healthcare API conformance statement. For samples that show how to call RetrieveRenderedFrames,
                     * see [Retrieving consumer image formats](https://cloud.google.com/healthcare/docs/how-
                     * tos/dicomweb#retrieving_consumer_image_formats).
                     *
                     * Create a request for the method "frames.retrieveRendered".
                     *
                     * This request holds the parameters needed by the the healthcare server.  After setting any
                     * optional parameters, call the {@link RetrieveRendered#execute()} method to invoke the remote
                     * operation. <p> {@link RetrieveRendered#initialize(com.google.api.client.googleapis.services.Abs
                     * tractGoogleClientRequest)} must be called to initialize this instance immediately after
                     * invoking the constructor. </p>
                     *
                     * @param parent The name of the DICOM store that is being accessed. For example,
                   *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_st
                   *        ore_id}`.
                     * @param dicomWebPath The path of the RetrieveRenderedFrames DICOMweb request. For example,
                   *        `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}/rend
                   *        ered`.
                     * @since 1.13
                     */
                    protected RetrieveRendered(java.lang.String parent, java.lang.String dicomWebPath) {
                      super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                      this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                            "Parameter parent must conform to the pattern " +
                            "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                      }
                      this.dicomWebPath = com.google.api.client.util.Preconditions.checkNotNull(dicomWebPath, "Required parameter dicomWebPath must be specified.");
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                            "Parameter dicomWebPath must conform to the pattern " +
                            "^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");
                      }
                    }

                    @Override
                    public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                      return super.executeUsingHead();
                    }

                    @Override
                    public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                      return super.buildHttpRequestUsingHead();
                    }

                    @Override
                    public RetrieveRendered set$Xgafv(java.lang.String $Xgafv) {
                      return (RetrieveRendered) super.set$Xgafv($Xgafv);
                    }

                    @Override
                    public RetrieveRendered setAccessToken(java.lang.String accessToken) {
                      return (RetrieveRendered) super.setAccessToken(accessToken);
                    }

                    @Override
                    public RetrieveRendered setAlt(java.lang.String alt) {
                      return (RetrieveRendered) super.setAlt(alt);
                    }

                    @Override
                    public RetrieveRendered setCallback(java.lang.String callback) {
                      return (RetrieveRendered) super.setCallback(callback);
                    }

                    @Override
                    public RetrieveRendered setFields(java.lang.String fields) {
                      return (RetrieveRendered) super.setFields(fields);
                    }

                    @Override
                    public RetrieveRendered setKey(java.lang.String key) {
                      return (RetrieveRendered) super.setKey(key);
                    }

                    @Override
                    public RetrieveRendered setOauthToken(java.lang.String oauthToken) {
                      return (RetrieveRendered) super.setOauthToken(oauthToken);
                    }

                    @Override
                    public RetrieveRendered setPrettyPrint(java.lang.Boolean prettyPrint) {
                      return (RetrieveRendered) super.setPrettyPrint(prettyPrint);
                    }

                    @Override
                    public RetrieveRendered setQuotaUser(java.lang.String quotaUser) {
                      return (RetrieveRendered) super.setQuotaUser(quotaUser);
                    }

                    @Override
                    public RetrieveRendered setUploadType(java.lang.String uploadType) {
                      return (RetrieveRendered) super.setUploadType(uploadType);
                    }

                    @Override
                    public RetrieveRendered setUploadProtocol(java.lang.String uploadProtocol) {
                      return (RetrieveRendered) super.setUploadProtocol(uploadProtocol);
                    }

                    /**
                     * The name of the DICOM store that is being accessed. For example, `projects/{p
                     * roject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_s
                     * tore_id}`.
                     */
                    @com.google.api.client.util.Key
                    private java.lang.String parent;

                    /** The name of the DICOM store that is being accessed. For example,
                   `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
                     */
                    public java.lang.String getParent() {
                      return parent;
                    }

                    /**
                     * The name of the DICOM store that is being accessed. For example, `projects/{p
                     * roject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_s
                     * tore_id}`.
                     */
                    public RetrieveRendered setParent(java.lang.String parent) {
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                            "Parameter parent must conform to the pattern " +
                            "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                      }
                      this.parent = parent;
                      return this;
                    }

                    /**
                     * The path of the RetrieveRenderedFrames DICOMweb request. For example, `studie
                     * s/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list
                     * }/rendered`.
                     */
                    @com.google.api.client.util.Key
                    private java.lang.String dicomWebPath;

                    /** The path of the RetrieveRenderedFrames DICOMweb request. For example,
                   `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list}/rendered`.
                     */
                    public java.lang.String getDicomWebPath() {
                      return dicomWebPath;
                    }

                    /**
                     * The path of the RetrieveRenderedFrames DICOMweb request. For example, `studie
                     * s/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{frame_list
                     * }/rendered`.
                     */
                    public RetrieveRendered setDicomWebPath(java.lang.String dicomWebPath) {
                      if (!getSuppressPatternChecks()) {
                        com.google.api.client.util.Preconditions.checkArgument(DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(),
                            "Parameter dicomWebPath must conform to the pattern " +
                            "^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");
                      }
                      this.dicomWebPath = dicomWebPath;
                      return this;
                    }

                    @Override
                    public RetrieveRendered set(String parameterName, Object value) {
                      return (RetrieveRendered) super.set(parameterName, value);
                    }
                  }

                }
              }
            }
          }
        }
        /**
         * An accessor for creating requests from the FhirStores collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
         *   {@code CloudHealthcare.FhirStores.List request = healthcare.fhirStores().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public FhirStores fhirStores() {
          return new FhirStores();
        }

        /**
         * The "fhirStores" collection of methods.
         */
        public class FhirStores {

          /**
           * Creates a new FHIR store within the parent dataset.
           *
           * Create a request for the method "fhirStores.create".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the dataset this FHIR store belongs to.
           * @param content the {@link com.google.api.services.healthcare.v1.model.FhirStore}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.FhirStore content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.FhirStore> {

            private static final String REST_PATH = "v1/{+parent}/fhirStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Creates a new FHIR store within the parent dataset.
             *
             * Create a request for the method "fhirStores.create".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the dataset this FHIR store belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.FhirStore}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.FhirStore content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.FhirStore.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the dataset this FHIR store belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the dataset this FHIR store belongs to.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the dataset this FHIR store belongs to. */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The ID of the FHIR store that is being created. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String fhirStoreId;

            /** The ID of the FHIR store that is being created. The string must match the following regex:
           `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            public java.lang.String getFhirStoreId() {
              return fhirStoreId;
            }

            /**
             * The ID of the FHIR store that is being created. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            public Create setFhirStoreId(java.lang.String fhirStoreId) {
              this.fhirStoreId = fhirStoreId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * De-identifies data from the source store and writes it to the destination store. The metadata
           * field type is OperationMetadata. If the request is successful, the response field type is
           * DeidentifyFhirStoreSummary. If errors occur, error is set. Error details are also logged to Cloud
           * Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-
           * tos/logging)).
           *
           * Create a request for the method "fhirStores.deidentify".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Deidentify#execute()} method to invoke the remote operation.
           *
           * @param sourceStore Source FHIR store resource name. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest}
           * @return the request
           */
          public Deidentify deidentify(java.lang.String sourceStore, com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest content) throws java.io.IOException {
            Deidentify result = new Deidentify(sourceStore, content);
            initialize(result);
            return result;
          }

          public class Deidentify extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+sourceStore}:deidentify";

            private final java.util.regex.Pattern SOURCE_STORE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * De-identifies data from the source store and writes it to the destination store. The metadata
             * field type is OperationMetadata. If the request is successful, the response field type is
             * DeidentifyFhirStoreSummary. If errors occur, error is set. Error details are also logged to
             * Cloud Logging (see [Viewing error logs in Cloud
             * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
             *
             * Create a request for the method "fhirStores.deidentify".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Deidentify#execute()} method to invoke the remote
             * operation. <p> {@link
             * Deidentify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param sourceStore Source FHIR store resource name. For example,
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest}
             * @since 1.13
             */
            protected Deidentify(java.lang.String sourceStore, com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.sourceStore = com.google.api.client.util.Preconditions.checkNotNull(sourceStore, "Required parameter sourceStore must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(SOURCE_STORE_PATTERN.matcher(sourceStore).matches(),
                    "Parameter sourceStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public Deidentify set$Xgafv(java.lang.String $Xgafv) {
              return (Deidentify) super.set$Xgafv($Xgafv);
            }

            @Override
            public Deidentify setAccessToken(java.lang.String accessToken) {
              return (Deidentify) super.setAccessToken(accessToken);
            }

            @Override
            public Deidentify setAlt(java.lang.String alt) {
              return (Deidentify) super.setAlt(alt);
            }

            @Override
            public Deidentify setCallback(java.lang.String callback) {
              return (Deidentify) super.setCallback(callback);
            }

            @Override
            public Deidentify setFields(java.lang.String fields) {
              return (Deidentify) super.setFields(fields);
            }

            @Override
            public Deidentify setKey(java.lang.String key) {
              return (Deidentify) super.setKey(key);
            }

            @Override
            public Deidentify setOauthToken(java.lang.String oauthToken) {
              return (Deidentify) super.setOauthToken(oauthToken);
            }

            @Override
            public Deidentify setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Deidentify) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Deidentify setQuotaUser(java.lang.String quotaUser) {
              return (Deidentify) super.setQuotaUser(quotaUser);
            }

            @Override
            public Deidentify setUploadType(java.lang.String uploadType) {
              return (Deidentify) super.setUploadType(uploadType);
            }

            @Override
            public Deidentify setUploadProtocol(java.lang.String uploadProtocol) {
              return (Deidentify) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Source FHIR store resource name. For example, `projects/{project_id}/locations/{locat
             * ion_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String sourceStore;

            /** Source FHIR store resource name. For example,
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public java.lang.String getSourceStore() {
              return sourceStore;
            }

            /**
             * Source FHIR store resource name. For example, `projects/{project_id}/locations/{locat
             * ion_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public Deidentify setSourceStore(java.lang.String sourceStore) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(SOURCE_STORE_PATTERN.matcher(sourceStore).matches(),
                    "Parameter sourceStore must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.sourceStore = sourceStore;
              return this;
            }

            @Override
            public Deidentify set(String parameterName, Object value) {
              return (Deidentify) super.set(parameterName, value);
            }
          }
          /**
           * Deletes the specified FHIR store and removes all resources within it.
           *
           * Create a request for the method "fhirStores.delete".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the FHIR store to delete.
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Deletes the specified FHIR store and removes all resources within it.
             *
             * Create a request for the method "fhirStores.delete".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the FHIR store to delete.
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the FHIR store to delete. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the FHIR store to delete.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the FHIR store to delete. */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Export resources from the FHIR store to the specified destination. This method returns an
           * Operation that can be used to track the status of the export by calling GetOperation. Immediate
           * fatal errors appear in the error field, errors are also logged to Cloud Logging (see [Viewing
           * error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
           * Otherwise, when the operation finishes, a detailed response of type ExportResourcesResponse is
           * returned in the response field. The metadata field type for this operation is OperationMetadata.
           *
           * Create a request for the method "fhirStores.export".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Export#execute()} method to invoke the remote operation.
           *
           * @param name The name of the FHIR store to export resource from, in the format of
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ExportResourcesRequest}
           * @return the request
           */
          public Export export(java.lang.String name, com.google.api.services.healthcare.v1.model.ExportResourcesRequest content) throws java.io.IOException {
            Export result = new Export(name, content);
            initialize(result);
            return result;
          }

          public class Export extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:export";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Export resources from the FHIR store to the specified destination. This method returns an
             * Operation that can be used to track the status of the export by calling GetOperation. Immediate
             * fatal errors appear in the error field, errors are also logged to Cloud Logging (see [Viewing
             * error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
             * Otherwise, when the operation finishes, a detailed response of type ExportResourcesResponse is
             * returned in the response field. The metadata field type for this operation is
             * OperationMetadata.
             *
             * Create a request for the method "fhirStores.export".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Export#execute()} method to invoke the remote operation.
             * <p> {@link
             * Export#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name of the FHIR store to export resource from, in the format of
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ExportResourcesRequest}
             * @since 1.13
             */
            protected Export(java.lang.String name, com.google.api.services.healthcare.v1.model.ExportResourcesRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public Export set$Xgafv(java.lang.String $Xgafv) {
              return (Export) super.set$Xgafv($Xgafv);
            }

            @Override
            public Export setAccessToken(java.lang.String accessToken) {
              return (Export) super.setAccessToken(accessToken);
            }

            @Override
            public Export setAlt(java.lang.String alt) {
              return (Export) super.setAlt(alt);
            }

            @Override
            public Export setCallback(java.lang.String callback) {
              return (Export) super.setCallback(callback);
            }

            @Override
            public Export setFields(java.lang.String fields) {
              return (Export) super.setFields(fields);
            }

            @Override
            public Export setKey(java.lang.String key) {
              return (Export) super.setKey(key);
            }

            @Override
            public Export setOauthToken(java.lang.String oauthToken) {
              return (Export) super.setOauthToken(oauthToken);
            }

            @Override
            public Export setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Export) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Export setQuotaUser(java.lang.String quotaUser) {
              return (Export) super.setQuotaUser(quotaUser);
            }

            @Override
            public Export setUploadType(java.lang.String uploadType) {
              return (Export) super.setUploadType(uploadType);
            }

            @Override
            public Export setUploadProtocol(java.lang.String uploadProtocol) {
              return (Export) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the FHIR store to export resource from, in the format of `projects/{proje
             * ct_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name of the FHIR store to export resource from, in the format of
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name of the FHIR store to export resource from, in the format of `projects/{proje
             * ct_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public Export setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Export set(String parameterName, Object value) {
              return (Export) super.set(parameterName, value);
            }
          }
          /**
           * Gets the configuration of the specified FHIR store.
           *
           * Create a request for the method "fhirStores.get".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the FHIR store to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.FhirStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Gets the configuration of the specified FHIR store.
             *
             * Create a request for the method "fhirStores.get".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the FHIR store to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.FhirStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the FHIR store to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the FHIR store to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the FHIR store to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "fhirStores.getIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "fhirStores.getIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
           specifying an invalid value will be rejected. Requests for policies with any conditional bindings
           must specify version 3. Policies without any conditional bindings may specify any valid value or
           leave the field unset. To learn which resources support conditions in their IAM policies, see the
           [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Imports resources to the FHIR store by loading data from the specified sources. This method is
           * optimized to load large quantities of data using import semantics that ignore some FHIR store
           * configuration options and are not suitable for all use cases. It is primarily intended to load
           * data into an empty FHIR store that is not being used by other clients. In cases where this method
           * is not appropriate, consider using ExecuteBundle to load data. Every resource in the input must
           * contain a client-supplied ID. Each resource is stored using the supplied ID regardless of the
           * enable_update_create setting on the FHIR store. It is strongly advised not to include or encode
           * any sensitive data such as patient identifiers in client-specified resource IDs. Those IDs are
           * part of the FHIR resource path recorded in Cloud Audit Logs and Cloud Pub/Sub notifications.
           * Those IDs can also be contained in reference fields within other resources. The import process
           * does not enforce referential integrity, regardless of the disable_referential_integrity setting
           * on the FHIR store. This allows the import of resources with arbitrary interdependencies without
           * considering grouping or ordering, but if the input data contains invalid references or if some
           * resources fail to be imported, the FHIR store might be left in a state that violates referential
           * integrity. The import process does not trigger Pub/Sub notification or BigQuery streaming update,
           * regardless of how those are configured on the FHIR store. If a resource with the specified ID
           * already exists, the most recent version of the resource is overwritten without creating a new
           * historical version, regardless of the disable_resource_versioning setting on the FHIR store. If
           * transient failures occur during the import, it's possible that successfully imported resources
           * will be overwritten more than once. The import operation is idempotent unless the input data
           * contains multiple valid resources with the same ID but different contents. In that case, after
           * the import completes, the store contains exactly one resource with that ID but there is no
           * ordering guarantee on which version of the contents it will have. The operation result counters
           * do not count duplicate IDs as an error and count one success for each resource in the input,
           * which might result in a success count larger than the number of resources in the FHIR store. This
           * often occurs when importing data organized in bundles produced by Patient-everything where each
           * bundle contains its own copy of a resource such as Practitioner that might be referred to by many
           * patients. If some resources fail to import, for example due to parsing errors, successfully
           * imported resources are not rolled back. The location and format of the input data is specified by
           * the parameters in ImportResourcesRequest. Note that if no format is specified, this method
           * assumes the `BUNDLE` format. When using the `BUNDLE` format this method ignores the `Bundle.type`
           * field, except that `history` bundles are rejected, and does not apply any of the bundle
           * processing semantics for batch or transaction bundles. Unlike in ExecuteBundle, transaction
           * bundles are not executed as a single transaction and bundle-internal references are not
           * rewritten. The bundle is treated as a collection of resources to be written as provided in
           * `Bundle.entry.resource`, ignoring `Bundle.entry.request`. As an example, this allows the import
           * of `searchset` bundles produced by a FHIR search or Patient-everything operation. This method
           * returns an Operation that can be used to track the status of the import by calling GetOperation.
           * Immediate fatal errors appear in the error field, errors are also logged to Cloud Logging (see
           * [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
           * Otherwise, when the operation finishes, a detailed response of type ImportResourcesResponse is
           * returned in the response field. The metadata field type for this operation is OperationMetadata.
           *
           * Create a request for the method "fhirStores.import".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link CloudHealthcareImport#execute()} method to invoke the remote
           * operation.
           *
           * @param name The name of the FHIR store to import FHIR resources to, in the format of
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.ImportResourcesRequest}
           * @return the request
           */
          public CloudHealthcareImport healthcareImport(java.lang.String name, com.google.api.services.healthcare.v1.model.ImportResourcesRequest content) throws java.io.IOException {
            CloudHealthcareImport result = new CloudHealthcareImport(name, content);
            initialize(result);
            return result;
          }

          public class CloudHealthcareImport extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:import";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Imports resources to the FHIR store by loading data from the specified sources. This method is
             * optimized to load large quantities of data using import semantics that ignore some FHIR store
             * configuration options and are not suitable for all use cases. It is primarily intended to load
             * data into an empty FHIR store that is not being used by other clients. In cases where this
             * method is not appropriate, consider using ExecuteBundle to load data. Every resource in the
             * input must contain a client-supplied ID. Each resource is stored using the supplied ID
             * regardless of the enable_update_create setting on the FHIR store. It is strongly advised not to
             * include or encode any sensitive data such as patient identifiers in client-specified resource
             * IDs. Those IDs are part of the FHIR resource path recorded in Cloud Audit Logs and Cloud
             * Pub/Sub notifications. Those IDs can also be contained in reference fields within other
             * resources. The import process does not enforce referential integrity, regardless of the
             * disable_referential_integrity setting on the FHIR store. This allows the import of resources
             * with arbitrary interdependencies without considering grouping or ordering, but if the input
             * data contains invalid references or if some resources fail to be imported, the FHIR store might
             * be left in a state that violates referential integrity. The import process does not trigger
             * Pub/Sub notification or BigQuery streaming update, regardless of how those are configured on
             * the FHIR store. If a resource with the specified ID already exists, the most recent version of
             * the resource is overwritten without creating a new historical version, regardless of the
             * disable_resource_versioning setting on the FHIR store. If transient failures occur during the
             * import, it's possible that successfully imported resources will be overwritten more than once.
             * The import operation is idempotent unless the input data contains multiple valid resources with
             * the same ID but different contents. In that case, after the import completes, the store
             * contains exactly one resource with that ID but there is no ordering guarantee on which version
             * of the contents it will have. The operation result counters do not count duplicate IDs as an
             * error and count one success for each resource in the input, which might result in a success
             * count larger than the number of resources in the FHIR store. This often occurs when importing
             * data organized in bundles produced by Patient-everything where each bundle contains its own
             * copy of a resource such as Practitioner that might be referred to by many patients. If some
             * resources fail to import, for example due to parsing errors, successfully imported resources
             * are not rolled back. The location and format of the input data is specified by the parameters
             * in ImportResourcesRequest. Note that if no format is specified, this method assumes the
             * `BUNDLE` format. When using the `BUNDLE` format this method ignores the `Bundle.type` field,
             * except that `history` bundles are rejected, and does not apply any of the bundle processing
             * semantics for batch or transaction bundles. Unlike in ExecuteBundle, transaction bundles are
             * not executed as a single transaction and bundle-internal references are not rewritten. The
             * bundle is treated as a collection of resources to be written as provided in
             * `Bundle.entry.resource`, ignoring `Bundle.entry.request`. As an example, this allows the import
             * of `searchset` bundles produced by a FHIR search or Patient-everything operation. This method
             * returns an Operation that can be used to track the status of the import by calling
             * GetOperation. Immediate fatal errors appear in the error field, errors are also logged to Cloud
             * Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs
             * /how-tos/logging)). Otherwise, when the operation finishes, a detailed response of type
             * ImportResourcesResponse is returned in the response field. The metadata field type for this
             * operation is OperationMetadata.
             *
             * Create a request for the method "fhirStores.import".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link CloudHealthcareImport#execute()} method to invoke the
             * remote operation. <p> {@link CloudHealthcareImport#initialize(com.google.api.client.googleapis.
             * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
             * after invoking the constructor. </p>
             *
             * @param name The name of the FHIR store to import FHIR resources to, in the format of
           *        `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_stor
           *        e_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.ImportResourcesRequest}
             * @since 1.13
             */
            protected CloudHealthcareImport(java.lang.String name, com.google.api.services.healthcare.v1.model.ImportResourcesRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public CloudHealthcareImport set$Xgafv(java.lang.String $Xgafv) {
              return (CloudHealthcareImport) super.set$Xgafv($Xgafv);
            }

            @Override
            public CloudHealthcareImport setAccessToken(java.lang.String accessToken) {
              return (CloudHealthcareImport) super.setAccessToken(accessToken);
            }

            @Override
            public CloudHealthcareImport setAlt(java.lang.String alt) {
              return (CloudHealthcareImport) super.setAlt(alt);
            }

            @Override
            public CloudHealthcareImport setCallback(java.lang.String callback) {
              return (CloudHealthcareImport) super.setCallback(callback);
            }

            @Override
            public CloudHealthcareImport setFields(java.lang.String fields) {
              return (CloudHealthcareImport) super.setFields(fields);
            }

            @Override
            public CloudHealthcareImport setKey(java.lang.String key) {
              return (CloudHealthcareImport) super.setKey(key);
            }

            @Override
            public CloudHealthcareImport setOauthToken(java.lang.String oauthToken) {
              return (CloudHealthcareImport) super.setOauthToken(oauthToken);
            }

            @Override
            public CloudHealthcareImport setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (CloudHealthcareImport) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public CloudHealthcareImport setQuotaUser(java.lang.String quotaUser) {
              return (CloudHealthcareImport) super.setQuotaUser(quotaUser);
            }

            @Override
            public CloudHealthcareImport setUploadType(java.lang.String uploadType) {
              return (CloudHealthcareImport) super.setUploadType(uploadType);
            }

            @Override
            public CloudHealthcareImport setUploadProtocol(java.lang.String uploadProtocol) {
              return (CloudHealthcareImport) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name of the FHIR store to import FHIR resources to, in the format of `projects/{p
             * roject_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name of the FHIR store to import FHIR resources to, in the format of
           `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name of the FHIR store to import FHIR resources to, in the format of `projects/{p
             * roject_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public CloudHealthcareImport setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public CloudHealthcareImport set(String parameterName, Object value) {
              return (CloudHealthcareImport) super.set(parameterName, value);
            }
          }
          /**
           * Lists the FHIR stores in the given dataset.
           *
           * Create a request for the method "fhirStores.list".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Name of the dataset.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListFhirStoresResponse> {

            private static final String REST_PATH = "v1/{+parent}/fhirStores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Lists the FHIR stores in the given dataset.
             *
             * Create a request for the method "fhirStores.list".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Name of the dataset.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListFhirStoresResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** Name of the dataset. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Name of the dataset.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Name of the dataset. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported, for example `labels.key=value`.
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Restricts stores returned to those matching a filter. The following syntax is available: * A string
           field value can be written as text inside quotation marks, for example `"query text"`. The only
           valid relational operation for text fields is equality (`=`), where text is searched within the
           field, rather than having the field be equal to the text. For example, `"Comment = great"` returns
           messages with `great` in the comment field. * A number field value can be written as an integer, a
           decimal, or an exponential. The valid relational operators for number fields are the equality
           operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
           there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to
           negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use
           the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
           relational operators for date fields are the equality operator (`=`) , along with the less
           than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
           operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query
           expressions can be combined in one query by adding `AND` or `OR` operators between the expressions.
           If a boolean operator appears within a quoted string, it is not treated as special, it's just
           another part of the character string to be matched. You can prepend the `NOT` operator to an
           expression to negate it. Only filtering on labels is supported, for example `labels.key=value`.
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported, for example `labels.key=value`.
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Limit on the number of FHIR stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Limit on the number of FHIR stores to return in a single response. If not specified, 100 is used.
           May not be larger than 1000.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Limit on the number of FHIR stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** The next_page_token value returned from the previous List request, if any.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Updates the configuration of the specified FHIR store.
           *
           * Create a request for the method "fhirStores.patch".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Output only. Resource name of the FHIR store, of the form
           *        `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.FhirStore}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.FhirStore content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.FhirStore> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Updates the configuration of the specified FHIR store.
             *
             * Create a request for the method "fhirStores.patch".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Output only. Resource name of the FHIR store, of the form
           *        `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.FhirStore}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.FhirStore content) {
              super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.FhirStore.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Output only. Resource name of the FHIR store, of the form
             * `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Output only. Resource name of the FHIR store, of the form
           `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Output only. Resource name of the FHIR store, of the form
             * `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            @com.google.api.client.util.Key
            private String updateMask;

            /** The update mask applies to the resource. For the `FieldMask` definition, see
           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
             */
            public String getUpdateMask() {
              return updateMask;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            public Patch setUpdateMask(String updateMask) {
              this.updateMask = updateMask;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "fhirStores.setIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy. Can
             * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "fhirStores.setIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
           * designed to be used for building permission-aware UIs and command-line tools, not for
           * authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "fhirStores.testIamPermissions".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
             * operation is designed to be used for building permission-aware UIs and command-line tools, not
             * for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "fhirStores.testIamPermissions".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the Fhir collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.Fhir.List request = healthcare.fhir().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public Fhir fhir() {
            return new Fhir();
          }

          /**
           * The "fhir" collection of methods.
           */
          public class Fhir {

            /**
             * Retrieves a Patient resource and resources related to that patient. Implements the FHIR extended
             * operation Patient-everything ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/patient-
             * operations.html#everything), [STU3](http://hl7.org/implement/standards/fhir/STU3/patient-
             * operations.html#everything), [R4](http://hl7.org/implement/standards/fhir/R4/patient-
             * operations.html#everything)). On success, the response body contains a JSON-encoded
             * representation of a `Bundle` resource of type `searchset`, containing the results of the
             * operation. Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource
             * describing the reason for the error. If the request cannot be mapped to a valid API method on a
             * FHIR store, a generic GCP error might be returned instead. The resources in scope for the
             * response are: * The patient resource itself. * All the resources directly referenced by the
             * patient resource. * Resources directly referencing the patient resource that meet the inclusion
             * criteria. The inclusion criteria are based on the membership rules in the patient compartment
             * definition ([DSTU2](http://hl7.org/fhir/DSTU2/compartment-patient.html),
             * [STU3](http://www.hl7.org/fhir/stu3/compartmentdefinition-patient.html),
             * [R4](http://hl7.org/fhir/R4/compartmentdefinition-patient.html)), which details the eligible
             * resource types and referencing search parameters. For samples that show how to call `Patient-
             * everything`, see [Getting all patient compartment resources](/healthcare/docs/how-tos/fhir-
             * resources#getting_all_patient_compartment_resources).
             *
             * Create a request for the method "fhir.Patient-everything".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link PatientEverything#execute()} method to invoke the remote operation.
             *
             * @param name Name of the `Patient` resource for which the information is required.
             * @return the request
             */
            public PatientEverything patientEverything(java.lang.String name) throws java.io.IOException {
              PatientEverything result = new PatientEverything(name);
              initialize(result);
              return result;
            }

            public class PatientEverything extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}/$everything";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");

              /**
               * Retrieves a Patient resource and resources related to that patient. Implements the FHIR
               * extended operation Patient-everything ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2
               * /patient-operations.html#everything), [STU3](http://hl7.org/implement/standards/fhir/STU3
               * /patient-operations.html#everything), [R4](http://hl7.org/implement/standards/fhir/R4/patient-
               * operations.html#everything)). On success, the response body contains a JSON-encoded
               * representation of a `Bundle` resource of type `searchset`, containing the results of the
               * operation. Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome`
               * resource describing the reason for the error. If the request cannot be mapped to a valid API
               * method on a FHIR store, a generic GCP error might be returned instead. The resources in scope
               * for the response are: * The patient resource itself. * All the resources directly referenced by
               * the patient resource. * Resources directly referencing the patient resource that meet the
               * inclusion criteria. The inclusion criteria are based on the membership rules in the patient
               * compartment definition ([DSTU2](http://hl7.org/fhir/DSTU2/compartment-patient.html),
               * [STU3](http://www.hl7.org/fhir/stu3/compartmentdefinition-patient.html),
               * [R4](http://hl7.org/fhir/R4/compartmentdefinition-patient.html)), which details the eligible
               * resource types and referencing search parameters. For samples that show how to call `Patient-
               * everything`, see [Getting all patient compartment resources](/healthcare/docs/how-tos/fhir-
               * resources#getting_all_patient_compartment_resources).
               *
               * Create a request for the method "fhir.Patient-everything".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link PatientEverything#execute()} method to invoke the remote
               * operation. <p> {@link PatientEverything#initialize(com.google.api.client.googleapis.services.Ab
               * stractGoogleClientRequest)} must be called to initialize this instance immediately after
               * invoking the constructor. </p>
               *
               * @param name Name of the `Patient` resource for which the information is required.
               * @since 1.13
               */
              protected PatientEverything(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public PatientEverything set$Xgafv(java.lang.String $Xgafv) {
                return (PatientEverything) super.set$Xgafv($Xgafv);
              }

              @Override
              public PatientEverything setAccessToken(java.lang.String accessToken) {
                return (PatientEverything) super.setAccessToken(accessToken);
              }

              @Override
              public PatientEverything setAlt(java.lang.String alt) {
                return (PatientEverything) super.setAlt(alt);
              }

              @Override
              public PatientEverything setCallback(java.lang.String callback) {
                return (PatientEverything) super.setCallback(callback);
              }

              @Override
              public PatientEverything setFields(java.lang.String fields) {
                return (PatientEverything) super.setFields(fields);
              }

              @Override
              public PatientEverything setKey(java.lang.String key) {
                return (PatientEverything) super.setKey(key);
              }

              @Override
              public PatientEverything setOauthToken(java.lang.String oauthToken) {
                return (PatientEverything) super.setOauthToken(oauthToken);
              }

              @Override
              public PatientEverything setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (PatientEverything) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public PatientEverything setQuotaUser(java.lang.String quotaUser) {
                return (PatientEverything) super.setQuotaUser(quotaUser);
              }

              @Override
              public PatientEverything setUploadType(java.lang.String uploadType) {
                return (PatientEverything) super.setUploadType(uploadType);
              }

              @Override
              public PatientEverything setUploadProtocol(java.lang.String uploadProtocol) {
                return (PatientEverything) super.setUploadProtocol(uploadProtocol);
              }

              /** Name of the `Patient` resource for which the information is required. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Name of the `Patient` resource for which the information is required.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Name of the `Patient` resource for which the information is required. */
              public PatientEverything setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Maximum number of resources in a page. If not specified, 100 is used. May not be
               * larger than 1000.
               */
              @com.google.api.client.util.Key("_count")
              private java.lang.Integer count;

              /** Maximum number of resources in a page. If not specified, 100 is used. May not be larger than 1000.
               */
              public java.lang.Integer getCount() {
                return count;
              }

              /**
               * Maximum number of resources in a page. If not specified, 100 is used. May not be
               * larger than 1000.
               */
              public PatientEverything setCount(java.lang.Integer count) {
                this.count = count;
                return this;
              }

              /**
               * Used to retrieve the next or previous page of results when using pagination. Set
               * `_page_token` to the value of _page_token set in next or previous page links' url.
               * Next and previous page are returned in the response bundle's links field, where
               * `link.relation` is "previous" or "next". Omit `_page_token` if no previous request
               * has been made.
               */
              @com.google.api.client.util.Key("_page_token")
              private java.lang.String pageToken;

              /** Used to retrieve the next or previous page of results when using pagination. Set `_page_token` to
             the value of _page_token set in next or previous page links' url. Next and previous page are
             returned in the response bundle's links field, where `link.relation` is "previous" or "next". Omit
             `_page_token` if no previous request has been made.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Used to retrieve the next or previous page of results when using pagination. Set
               * `_page_token` to the value of _page_token set in next or previous page links' url.
               * Next and previous page are returned in the response bundle's links field, where
               * `link.relation` is "previous" or "next". Omit `_page_token` if no previous request
               * has been made.
               */
              public PatientEverything setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              /**
               * If provided, only resources updated after this time are returned. The time uses the
               * format YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
               * or `2017-01-01T00:00:00Z`. The time must be specified to the second and include a
               * time zone.
               */
              @com.google.api.client.util.Key("_since")
              private java.lang.String since;

              /** If provided, only resources updated after this time are returned. The time uses the format YYYY-MM-
             DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00` or `2017-01-01T00:00:00Z`. The
             time must be specified to the second and include a time zone.
               */
              public java.lang.String getSince() {
                return since;
              }

              /**
               * If provided, only resources updated after this time are returned. The time uses the
               * format YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
               * or `2017-01-01T00:00:00Z`. The time must be specified to the second and include a
               * time zone.
               */
              public PatientEverything setSince(java.lang.String since) {
                this.since = since;
                return this;
              }

              /**
               * String of comma-delimited FHIR resource types. If provided, only resources of the
               * specified resource type(s) are returned.
               */
              @com.google.api.client.util.Key("_type")
              private java.lang.String type;

              /** String of comma-delimited FHIR resource types. If provided, only resources of the specified
             resource type(s) are returned.
               */
              public java.lang.String getType() {
                return type;
              }

              /**
               * String of comma-delimited FHIR resource types. If provided, only resources of the
               * specified resource type(s) are returned.
               */
              public PatientEverything setType(java.lang.String type) {
                this.type = type;
                return this;
              }

              /**
               * The response includes records prior to the end date. If no end date is provided,
               * all records subsequent to the start date are in scope.
               */
              @com.google.api.client.util.Key
              private java.lang.String end;

              /** The response includes records prior to the end date. If no end date is provided, all records
             subsequent to the start date are in scope.
               */
              public java.lang.String getEnd() {
                return end;
              }

              /**
               * The response includes records prior to the end date. If no end date is provided,
               * all records subsequent to the start date are in scope.
               */
              public PatientEverything setEnd(java.lang.String end) {
                this.end = end;
                return this;
              }

              /**
               * The response includes records subsequent to the start date. If no start date is
               * provided, all records prior to the end date are in scope.
               */
              @com.google.api.client.util.Key
              private java.lang.String start;

              /** The response includes records subsequent to the start date. If no start date is provided, all
             records prior to the end date are in scope.
               */
              public java.lang.String getStart() {
                return start;
              }

              /**
               * The response includes records subsequent to the start date. If no start date is
               * provided, all records prior to the end date are in scope.
               */
              public PatientEverything setStart(java.lang.String start) {
                this.start = start;
                return this;
              }

              @Override
              public PatientEverything set(String parameterName, Object value) {
                return (PatientEverything) super.set(parameterName, value);
              }
            }
            /**
             * Deletes all the historical versions of a resource (excluding the current version) from the FHIR
             * store. To remove all versions of a resource, first delete the current version and then call this
             * method. This is not a FHIR standard operation. For samples that show how to call `Resource-
             * purge`, see [Deleting historical versions of a FHIR resource](/healthcare/docs/how-tos/fhir-
             * resources#deleting_historical_versions_of_a_fhir_resource).
             *
             * Create a request for the method "fhir.Resource-purge".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link ResourcePurge#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to purge.
             * @return the request
             */
            public ResourcePurge resourcePurge(java.lang.String name) throws java.io.IOException {
              ResourcePurge result = new ResourcePurge(name);
              initialize(result);
              return result;
            }

            public class ResourcePurge extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}/$purge";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Deletes all the historical versions of a resource (excluding the current version) from the FHIR
               * store. To remove all versions of a resource, first delete the current version and then call
               * this method. This is not a FHIR standard operation. For samples that show how to call
               * `Resource-purge`, see [Deleting historical versions of a FHIR resource](/healthcare/docs/how-
               * tos/fhir-resources#deleting_historical_versions_of_a_fhir_resource).
               *
               * Create a request for the method "fhir.Resource-purge".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link ResourcePurge#execute()} method to invoke the remote
               * operation. <p> {@link ResourcePurge#initialize(com.google.api.client.googleapis.services.Abstra
               * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param name The name of the resource to purge.
               * @since 1.13
               */
              protected ResourcePurge(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public ResourcePurge set$Xgafv(java.lang.String $Xgafv) {
                return (ResourcePurge) super.set$Xgafv($Xgafv);
              }

              @Override
              public ResourcePurge setAccessToken(java.lang.String accessToken) {
                return (ResourcePurge) super.setAccessToken(accessToken);
              }

              @Override
              public ResourcePurge setAlt(java.lang.String alt) {
                return (ResourcePurge) super.setAlt(alt);
              }

              @Override
              public ResourcePurge setCallback(java.lang.String callback) {
                return (ResourcePurge) super.setCallback(callback);
              }

              @Override
              public ResourcePurge setFields(java.lang.String fields) {
                return (ResourcePurge) super.setFields(fields);
              }

              @Override
              public ResourcePurge setKey(java.lang.String key) {
                return (ResourcePurge) super.setKey(key);
              }

              @Override
              public ResourcePurge setOauthToken(java.lang.String oauthToken) {
                return (ResourcePurge) super.setOauthToken(oauthToken);
              }

              @Override
              public ResourcePurge setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (ResourcePurge) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public ResourcePurge setQuotaUser(java.lang.String quotaUser) {
                return (ResourcePurge) super.setQuotaUser(quotaUser);
              }

              @Override
              public ResourcePurge setUploadType(java.lang.String uploadType) {
                return (ResourcePurge) super.setUploadType(uploadType);
              }

              @Override
              public ResourcePurge setUploadProtocol(java.lang.String uploadProtocol) {
                return (ResourcePurge) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to purge. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to purge.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to purge. */
              public ResourcePurge setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public ResourcePurge set(String parameterName, Object value) {
                return (ResourcePurge) super.set(parameterName, value);
              }
            }
            /**
             * Gets the FHIR capability statement
             * ([STU3](http://hl7.org/implement/standards/fhir/STU3/capabilitystatement.html),
             * [R4](http://hl7.org/implement/standards/fhir/R4/capabilitystatement.html)), or the [conformance
             * statement](http://hl7.org/implement/standards/fhir/DSTU2/conformance.html) in the DSTU2 case for
             * the store, which contains a description of functionality supported by the server. Implements the
             * FHIR standard capabilities interaction
             * ([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#capabilities),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#capabilities)), or the [conformance
             * interaction](http://hl7.org/implement/standards/fhir/DSTU2/http.html#conformance) in the DSTU2
             * case. On success, the response body contains a JSON-encoded representation of a
             * `CapabilityStatement` resource.
             *
             * Create a request for the method "fhir.capabilities".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Capabilities#execute()} method to invoke the remote operation.
             *
             * @param name Name of the FHIR store to retrieve the capabilities for.
             * @return the request
             */
            public Capabilities capabilities(java.lang.String name) throws java.io.IOException {
              Capabilities result = new Capabilities(name);
              initialize(result);
              return result;
            }

            public class Capabilities extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}/fhir/metadata";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

              /**
               * Gets the FHIR capability statement
               * ([STU3](http://hl7.org/implement/standards/fhir/STU3/capabilitystatement.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/capabilitystatement.html)), or the [conformance
               * statement](http://hl7.org/implement/standards/fhir/DSTU2/conformance.html) in the DSTU2 case
               * for the store, which contains a description of functionality supported by the server.
               * Implements the FHIR standard capabilities interaction
               * ([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#capabilities),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#capabilities)), or the [conformance
               * interaction](http://hl7.org/implement/standards/fhir/DSTU2/http.html#conformance) in the DSTU2
               * case. On success, the response body contains a JSON-encoded representation of a
               * `CapabilityStatement` resource.
               *
               * Create a request for the method "fhir.capabilities".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Capabilities#execute()} method to invoke the remote
               * operation. <p> {@link
               * Capabilities#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Name of the FHIR store to retrieve the capabilities for.
               * @since 1.13
               */
              protected Capabilities(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Capabilities set$Xgafv(java.lang.String $Xgafv) {
                return (Capabilities) super.set$Xgafv($Xgafv);
              }

              @Override
              public Capabilities setAccessToken(java.lang.String accessToken) {
                return (Capabilities) super.setAccessToken(accessToken);
              }

              @Override
              public Capabilities setAlt(java.lang.String alt) {
                return (Capabilities) super.setAlt(alt);
              }

              @Override
              public Capabilities setCallback(java.lang.String callback) {
                return (Capabilities) super.setCallback(callback);
              }

              @Override
              public Capabilities setFields(java.lang.String fields) {
                return (Capabilities) super.setFields(fields);
              }

              @Override
              public Capabilities setKey(java.lang.String key) {
                return (Capabilities) super.setKey(key);
              }

              @Override
              public Capabilities setOauthToken(java.lang.String oauthToken) {
                return (Capabilities) super.setOauthToken(oauthToken);
              }

              @Override
              public Capabilities setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Capabilities) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Capabilities setQuotaUser(java.lang.String quotaUser) {
                return (Capabilities) super.setQuotaUser(quotaUser);
              }

              @Override
              public Capabilities setUploadType(java.lang.String uploadType) {
                return (Capabilities) super.setUploadType(uploadType);
              }

              @Override
              public Capabilities setUploadProtocol(java.lang.String uploadProtocol) {
                return (Capabilities) super.setUploadProtocol(uploadProtocol);
              }

              /** Name of the FHIR store to retrieve the capabilities for. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Name of the FHIR store to retrieve the capabilities for.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Name of the FHIR store to retrieve the capabilities for. */
              public Capabilities setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Capabilities set(String parameterName, Object value) {
                return (Capabilities) super.set(parameterName, value);
              }
            }
            /**
             * Creates a FHIR resource. Implements the FHIR standard create interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#create),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#create),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#create)), which creates a new resource
             * with a server-assigned resource ID. The request body must contain a JSON-encoded FHIR resource,
             * and the request headers must contain `Content-Type: application/fhir+json`. On success, the
             * response body contains a JSON-encoded representation of the resource as it was created on the
             * server, including the server-assigned resource ID and version ID. Errors generated by the FHIR
             * store contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If
             * the request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
             * returned instead. For samples that show how to call `create`, see [Creating a FHIR
             * resource](/healthcare/docs/how-tos/fhir-resources#creating_a_fhir_resource).
             *
             * Create a request for the method "fhir.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the FHIR store this resource belongs to.
             * @param type The FHIR resource type to create, such as Patient or Observation. For a complete list, see the FHIR
             *        Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             *        [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             *        [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)). Must match the
             *        resource type in the provided content.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @return the request
             */
            public Create create(java.lang.String parent, java.lang.String type, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
              Create result = new Create(parent, type, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/fhir/{+type}";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

              private final java.util.regex.Pattern TYPE_PATTERN =
                  java.util.regex.Pattern.compile("^[^/]+$");

              /**
               * Creates a FHIR resource. Implements the FHIR standard create interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#create),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#create),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#create)), which creates a new
               * resource with a server-assigned resource ID. The request body must contain a JSON-encoded FHIR
               * resource, and the request headers must contain `Content-Type: application/fhir+json`. On
               * success, the response body contains a JSON-encoded representation of the resource as it was
               * created on the server, including the server-assigned resource ID and version ID. Errors
               * generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource describing the
               * reason for the error. If the request cannot be mapped to a valid API method on a FHIR store, a
               * generic GCP error might be returned instead. For samples that show how to call `create`, see
               * [Creating a FHIR resource](/healthcare/docs/how-tos/fhir-resources#creating_a_fhir_resource).
               *
               * Create a request for the method "fhir.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent The name of the FHIR store this resource belongs to.
               * @param type The FHIR resource type to create, such as Patient or Observation. For a complete list, see the FHIR
             *        Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             *        [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             *        [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)). Must match the
             *        resource type in the provided content.
               * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
               * @since 1.13
               */
              protected Create(java.lang.String parent, java.lang.String type, com.google.api.services.healthcare.v1.model.HttpBody content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(TYPE_PATTERN.matcher(type).matches(),
                      "Parameter type must conform to the pattern " +
                      "^[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the FHIR store this resource belongs to. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the FHIR store this resource belongs to.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** The name of the FHIR store this resource belongs to. */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The FHIR resource type to create, such as Patient or Observation. For a complete
               * list, see the FHIR Resource Index
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)). Must match the
               * resource type in the provided content.
               */
              @com.google.api.client.util.Key
              private java.lang.String type;

              /** The FHIR resource type to create, such as Patient or Observation. For a complete list, see the FHIR
             Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)). Must match the resource type
             in the provided content.
               */
              public java.lang.String getType() {
                return type;
              }

              /**
               * The FHIR resource type to create, such as Patient or Observation. For a complete
               * list, see the FHIR Resource Index
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)). Must match the
               * resource type in the provided content.
               */
              public Create setType(java.lang.String type) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(TYPE_PATTERN.matcher(type).matches(),
                      "Parameter type must conform to the pattern " +
                      "^[^/]+$");
                }
                this.type = type;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes a FHIR resource. Implements the FHIR standard delete interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#delete),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#delete),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#delete)). Note: Unless resource
             * versioning is disabled by setting the disable_resource_versioning flag on the FHIR store, the
             * deleted resources will be moved to a history repository that can still be retrieved through vread
             * and related methods, unless they are removed by the purge method. For samples that show how to
             * call `delete`, see [Deleting a FHIR resource](/healthcare/docs/how-tos/fhir-
             * resources#deleting_a_fhir_resource).
             *
             * Create a request for the method "fhir.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to delete.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Deletes a FHIR resource. Implements the FHIR standard delete interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#delete),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#delete),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#delete)). Note: Unless resource
               * versioning is disabled by setting the disable_resource_versioning flag on the FHIR store, the
               * deleted resources will be moved to a history repository that can still be retrieved through
               * vread and related methods, unless they are removed by the purge method. For samples that show
               * how to call `delete`, see [Deleting a FHIR resource](/healthcare/docs/how-tos/fhir-
               * resources#deleting_a_fhir_resource).
               *
               * Create a request for the method "fhir.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource to delete.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to delete. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to delete.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to delete. */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Executes all the requests in the given Bundle. Implements the FHIR standard batch/transaction
             * interaction ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#transaction),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#transaction),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#transaction)). Supports all
             * interactions within a bundle, except search. This method accepts Bundles of type `batch` and
             * `transaction`, processing them according to the batch processing rules
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.1),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.1),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#brules)) and transaction processing
             * rules ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.2),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.2),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#trules)). The request body must contain
             * a JSON-encoded FHIR `Bundle` resource, and the request headers must contain `Content-Type:
             * application/fhir+json`. For a batch bundle or a successful transaction the response body will
             * contain a JSON-encoded representation of a `Bundle` resource of type `batch-response` or
             * `transaction-response` containing one entry for each entry in the request, with the outcome of
             * processing the entry. In the case of an error for a transaction bundle, the response body will
             * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
             * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
             * returned instead. For samples that show how to call `executeBundle`, see [Managing FHIR resources
             * using FHIR bundles](/healthcare/docs/how-tos/fhir-bundles).
             *
             * Create a request for the method "fhir.executeBundle".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link ExecuteBundle#execute()} method to invoke the remote operation.
             *
             * @param parent Name of the FHIR store in which this bundle will be executed.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @return the request
             */
            public ExecuteBundle executeBundle(java.lang.String parent, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
              ExecuteBundle result = new ExecuteBundle(parent, content);
              initialize(result);
              return result;
            }

            public class ExecuteBundle extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/fhir";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

              /**
               * Executes all the requests in the given Bundle. Implements the FHIR standard batch/transaction
               * interaction ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#transaction),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#transaction),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#transaction)). Supports all
               * interactions within a bundle, except search. This method accepts Bundles of type `batch` and
               * `transaction`, processing them according to the batch processing rules
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.1),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.1),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#brules)) and transaction processing
               * rules ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#2.1.0.16.2),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#2.21.0.17.2),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#trules)). The request body must
               * contain a JSON-encoded FHIR `Bundle` resource, and the request headers must contain `Content-
               * Type: application/fhir+json`. For a batch bundle or a successful transaction the response body
               * will contain a JSON-encoded representation of a `Bundle` resource of type `batch-response` or
               * `transaction-response` containing one entry for each entry in the request, with the outcome of
               * processing the entry. In the case of an error for a transaction bundle, the response body will
               * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
               * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
               * returned instead. For samples that show how to call `executeBundle`, see [Managing FHIR
               * resources using FHIR bundles](/healthcare/docs/how-tos/fhir-bundles).
               *
               * Create a request for the method "fhir.executeBundle".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link ExecuteBundle#execute()} method to invoke the remote
               * operation. <p> {@link ExecuteBundle#initialize(com.google.api.client.googleapis.services.Abstra
               * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param parent Name of the FHIR store in which this bundle will be executed.
               * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
               * @since 1.13
               */
              protected ExecuteBundle(java.lang.String parent, com.google.api.services.healthcare.v1.model.HttpBody content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
              }

              @Override
              public ExecuteBundle set$Xgafv(java.lang.String $Xgafv) {
                return (ExecuteBundle) super.set$Xgafv($Xgafv);
              }

              @Override
              public ExecuteBundle setAccessToken(java.lang.String accessToken) {
                return (ExecuteBundle) super.setAccessToken(accessToken);
              }

              @Override
              public ExecuteBundle setAlt(java.lang.String alt) {
                return (ExecuteBundle) super.setAlt(alt);
              }

              @Override
              public ExecuteBundle setCallback(java.lang.String callback) {
                return (ExecuteBundle) super.setCallback(callback);
              }

              @Override
              public ExecuteBundle setFields(java.lang.String fields) {
                return (ExecuteBundle) super.setFields(fields);
              }

              @Override
              public ExecuteBundle setKey(java.lang.String key) {
                return (ExecuteBundle) super.setKey(key);
              }

              @Override
              public ExecuteBundle setOauthToken(java.lang.String oauthToken) {
                return (ExecuteBundle) super.setOauthToken(oauthToken);
              }

              @Override
              public ExecuteBundle setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (ExecuteBundle) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public ExecuteBundle setQuotaUser(java.lang.String quotaUser) {
                return (ExecuteBundle) super.setQuotaUser(quotaUser);
              }

              @Override
              public ExecuteBundle setUploadType(java.lang.String uploadType) {
                return (ExecuteBundle) super.setUploadType(uploadType);
              }

              @Override
              public ExecuteBundle setUploadProtocol(java.lang.String uploadProtocol) {
                return (ExecuteBundle) super.setUploadProtocol(uploadProtocol);
              }

              /** Name of the FHIR store in which this bundle will be executed. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Name of the FHIR store in which this bundle will be executed.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Name of the FHIR store in which this bundle will be executed. */
              public ExecuteBundle setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public ExecuteBundle set(String parameterName, Object value) {
                return (ExecuteBundle) super.set(parameterName, value);
              }
            }
            /**
             * Lists all the versions of a resource (including the current version and deleted versions) from
             * the FHIR store. Implements the per-resource form of the FHIR standard history interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#history),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#history),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#history)). On success, the response
             * body contains a JSON-encoded representation of a `Bundle` resource of type `history`, containing
             * the version history sorted from most recent to oldest versions. Errors generated by the FHIR
             * store contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If
             * the request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
             * returned instead. For samples that show how to call `history`, see [Listing FHIR resource
             * versions](/healthcare/docs/how-tos/fhir-resources#listing_fhir_resource_versions).
             *
             * Create a request for the method "fhir.history".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link History#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to retrieve.
             * @return the request
             */
            public History history(java.lang.String name) throws java.io.IOException {
              History result = new History(name);
              initialize(result);
              return result;
            }

            public class History extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}/_history";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Lists all the versions of a resource (including the current version and deleted versions) from
               * the FHIR store. Implements the per-resource form of the FHIR standard history interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#history),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#history),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#history)). On success, the response
               * body contains a JSON-encoded representation of a `Bundle` resource of type `history`,
               * containing the version history sorted from most recent to oldest versions. Errors generated by
               * the FHIR store contain a JSON-encoded `OperationOutcome` resource describing the reason for the
               * error. If the request cannot be mapped to a valid API method on a FHIR store, a generic GCP
               * error might be returned instead. For samples that show how to call `history`, see [Listing FHIR
               * resource versions](/healthcare/docs/how-tos/fhir-resources#listing_fhir_resource_versions).
               *
               * Create a request for the method "fhir.history".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link History#execute()} method to invoke the remote operation.
               * <p> {@link
               * History#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource to retrieve.
               * @since 1.13
               */
              protected History(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public History set$Xgafv(java.lang.String $Xgafv) {
                return (History) super.set$Xgafv($Xgafv);
              }

              @Override
              public History setAccessToken(java.lang.String accessToken) {
                return (History) super.setAccessToken(accessToken);
              }

              @Override
              public History setAlt(java.lang.String alt) {
                return (History) super.setAlt(alt);
              }

              @Override
              public History setCallback(java.lang.String callback) {
                return (History) super.setCallback(callback);
              }

              @Override
              public History setFields(java.lang.String fields) {
                return (History) super.setFields(fields);
              }

              @Override
              public History setKey(java.lang.String key) {
                return (History) super.setKey(key);
              }

              @Override
              public History setOauthToken(java.lang.String oauthToken) {
                return (History) super.setOauthToken(oauthToken);
              }

              @Override
              public History setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (History) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public History setQuotaUser(java.lang.String quotaUser) {
                return (History) super.setQuotaUser(quotaUser);
              }

              @Override
              public History setUploadType(java.lang.String uploadType) {
                return (History) super.setUploadType(uploadType);
              }

              @Override
              public History setUploadProtocol(java.lang.String uploadProtocol) {
                return (History) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to retrieve.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to retrieve. */
              public History setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /**
               * Only include resource versions that were current at some point during the time
               * period specified in the date time value. The date parameter format is yyyy-mm-
               * ddThh:mm:ss[Z|(+|-)hh:mm] Clients may specify any of the following: * An entire
               * year: `_at=2019` * An entire month: `_at=2019-01` * A specific day:
               * `_at=2019-01-20` * A specific second: `_at=2018-12-31T23:59:58Z`
               */
              @com.google.api.client.util.Key("_at")
              private java.lang.String at;

              /** Only include resource versions that were current at some point during the time period specified in
             the date time value. The date parameter format is yyyy-mm-ddThh:mm:ss[Z|(+|-)hh:mm] Clients may
             specify any of the following: * An entire year: `_at=2019` * An entire month: `_at=2019-01` * A
             specific day: `_at=2019-01-20` * A specific second: `_at=2018-12-31T23:59:58Z`
               */
              public java.lang.String getAt() {
                return at;
              }

              /**
               * Only include resource versions that were current at some point during the time
               * period specified in the date time value. The date parameter format is yyyy-mm-
               * ddThh:mm:ss[Z|(+|-)hh:mm] Clients may specify any of the following: * An entire
               * year: `_at=2019` * An entire month: `_at=2019-01` * A specific day:
               * `_at=2019-01-20` * A specific second: `_at=2018-12-31T23:59:58Z`
               */
              public History setAt(java.lang.String at) {
                this.at = at;
                return this;
              }

              /**
               * The maximum number of search results on a page. If not specified, 100 is used. May
               * not be larger than 1000.
               */
              @com.google.api.client.util.Key("_count")
              private java.lang.Integer count;

              /** The maximum number of search results on a page. If not specified, 100 is used. May not be larger
             than 1000.
               */
              public java.lang.Integer getCount() {
                return count;
              }

              /**
               * The maximum number of search results on a page. If not specified, 100 is used. May
               * not be larger than 1000.
               */
              public History setCount(java.lang.Integer count) {
                this.count = count;
                return this;
              }

              /**
               * Used to retrieve the first, previous, next, or last page of resource versions when
               * using pagination. Value should be set to the value of `_page_token` set in next or
               * previous page links' URLs. Next and previous page are returned in the response
               * bundle's links field, where `link.relation` is "previous" or "next". Omit
               * `_page_token` if no previous request has been made.
               */
              @com.google.api.client.util.Key("_page_token")
              private java.lang.String pageToken;

              /** Used to retrieve the first, previous, next, or last page of resource versions when using
             pagination. Value should be set to the value of `_page_token` set in next or previous page links'
             URLs. Next and previous page are returned in the response bundle's links field, where
             `link.relation` is "previous" or "next". Omit `_page_token` if no previous request has been made.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Used to retrieve the first, previous, next, or last page of resource versions when
               * using pagination. Value should be set to the value of `_page_token` set in next or
               * previous page links' URLs. Next and previous page are returned in the response
               * bundle's links field, where `link.relation` is "previous" or "next". Omit
               * `_page_token` if no previous request has been made.
               */
              public History setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              /**
               * Only include resource versions that were created at or after the given instant in
               * time. The instant in time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz (for
               * example 2015-02-07T13:28:17.239+02:00 or 2017-01-01T00:00:00Z). The time must be
               * specified to the second and include a time zone.
               */
              @com.google.api.client.util.Key("_since")
              private java.lang.String since;

              /** Only include resource versions that were created at or after the given instant in time. The instant
             in time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz (for example 2015-02-07T13:28:17.239+02:00 or
             2017-01-01T00:00:00Z). The time must be specified to the second and include a time zone.
               */
              public java.lang.String getSince() {
                return since;
              }

              /**
               * Only include resource versions that were created at or after the given instant in
               * time. The instant in time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz (for
               * example 2015-02-07T13:28:17.239+02:00 or 2017-01-01T00:00:00Z). The time must be
               * specified to the second and include a time zone.
               */
              public History setSince(java.lang.String since) {
                this.since = since;
                return this;
              }

              @Override
              public History set(String parameterName, Object value) {
                return (History) super.set(parameterName, value);
              }
            }
            /**
             * Updates part of an existing resource by applying the operations specified in a [JSON
             * Patch](http://jsonpatch.com/) document. Implements the FHIR standard patch interaction
             * ([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#patch),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#patch)). DSTU2 doesn't define a patch
             * method, but the server supports it in the same way it supports STU3. The request body must
             * contain a JSON Patch document, and the request headers must contain `Content-Type: application
             * /json-patch+json`. On success, the response body contains a JSON-encoded representation of the
             * updated resource, including the server-assigned version ID. Errors generated by the FHIR store
             * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
             * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
             * returned instead. For samples that show how to call `patch`, see [Patching a FHIR
             * resource](/healthcare/docs/how-tos/fhir-resources#patching_a_fhir_resource).
             *
             * Create a request for the method "fhir.patch".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to update.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @return the request
             */
            public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
              Patch result = new Patch(name, content);
              initialize(result);
              return result;
            }

            public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Updates part of an existing resource by applying the operations specified in a [JSON
               * Patch](http://jsonpatch.com/) document. Implements the FHIR standard patch interaction
               * ([STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#patch),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#patch)). DSTU2 doesn't define a patch
               * method, but the server supports it in the same way it supports STU3. The request body must
               * contain a JSON Patch document, and the request headers must contain `Content-Type: application
               * /json-patch+json`. On success, the response body contains a JSON-encoded representation of the
               * updated resource, including the server-assigned version ID. Errors generated by the FHIR store
               * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
               * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
               * returned instead. For samples that show how to call `patch`, see [Patching a FHIR
               * resource](/healthcare/docs/how-tos/fhir-resources#patching_a_fhir_resource).
               *
               * Create a request for the method "fhir.patch".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
               * <p> {@link
               * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource to update.
               * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
               * @since 1.13
               */
              protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.HttpBody content) {
                super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public Patch set$Xgafv(java.lang.String $Xgafv) {
                return (Patch) super.set$Xgafv($Xgafv);
              }

              @Override
              public Patch setAccessToken(java.lang.String accessToken) {
                return (Patch) super.setAccessToken(accessToken);
              }

              @Override
              public Patch setAlt(java.lang.String alt) {
                return (Patch) super.setAlt(alt);
              }

              @Override
              public Patch setCallback(java.lang.String callback) {
                return (Patch) super.setCallback(callback);
              }

              @Override
              public Patch setFields(java.lang.String fields) {
                return (Patch) super.setFields(fields);
              }

              @Override
              public Patch setKey(java.lang.String key) {
                return (Patch) super.setKey(key);
              }

              @Override
              public Patch setOauthToken(java.lang.String oauthToken) {
                return (Patch) super.setOauthToken(oauthToken);
              }

              @Override
              public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Patch) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Patch setQuotaUser(java.lang.String quotaUser) {
                return (Patch) super.setQuotaUser(quotaUser);
              }

              @Override
              public Patch setUploadType(java.lang.String uploadType) {
                return (Patch) super.setUploadType(uploadType);
              }

              @Override
              public Patch setUploadProtocol(java.lang.String uploadProtocol) {
                return (Patch) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to update. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to update.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to update. */
              public Patch setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Patch set(String parameterName, Object value) {
                return (Patch) super.set(parameterName, value);
              }
            }
            /**
             * Gets the contents of a FHIR resource. Implements the FHIR standard read interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#read),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#read),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#read)). Also supports the FHIR standard
             * conditional read interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#cread),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#cread),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#cread)) specified by supplying an `If-
             * Modified-Since` header with a date/time value or an `If-None-Match` header with an ETag value. On
             * success, the response body contains a JSON-encoded representation of the resource. Errors
             * generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource describing the
             * reason for the error. If the request cannot be mapped to a valid API method on a FHIR store, a
             * generic GCP error might be returned instead. For samples that show how to call `read`, see
             * [Getting a FHIR resource](/healthcare/docs/how-tos/fhir-resources#getting_a_fhir_resource).
             *
             * Create a request for the method "fhir.read".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Read#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to retrieve.
             * @return the request
             */
            public Read read(java.lang.String name) throws java.io.IOException {
              Read result = new Read(name);
              initialize(result);
              return result;
            }

            public class Read extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Gets the contents of a FHIR resource. Implements the FHIR standard read interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#read),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#read),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#read)). Also supports the FHIR
               * standard conditional read interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#cread),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#cread),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#cread)) specified by supplying an
               * `If-Modified-Since` header with a date/time value or an `If-None-Match` header with an ETag
               * value. On success, the response body contains a JSON-encoded representation of the resource.
               * Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource
               * describing the reason for the error. If the request cannot be mapped to a valid API method on a
               * FHIR store, a generic GCP error might be returned instead. For samples that show how to call
               * `read`, see [Getting a FHIR resource](/healthcare/docs/how-tos/fhir-
               * resources#getting_a_fhir_resource).
               *
               * Create a request for the method "fhir.read".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Read#execute()} method to invoke the remote operation. <p>
               * {@link Read#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource to retrieve.
               * @since 1.13
               */
              protected Read(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Read set$Xgafv(java.lang.String $Xgafv) {
                return (Read) super.set$Xgafv($Xgafv);
              }

              @Override
              public Read setAccessToken(java.lang.String accessToken) {
                return (Read) super.setAccessToken(accessToken);
              }

              @Override
              public Read setAlt(java.lang.String alt) {
                return (Read) super.setAlt(alt);
              }

              @Override
              public Read setCallback(java.lang.String callback) {
                return (Read) super.setCallback(callback);
              }

              @Override
              public Read setFields(java.lang.String fields) {
                return (Read) super.setFields(fields);
              }

              @Override
              public Read setKey(java.lang.String key) {
                return (Read) super.setKey(key);
              }

              @Override
              public Read setOauthToken(java.lang.String oauthToken) {
                return (Read) super.setOauthToken(oauthToken);
              }

              @Override
              public Read setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Read) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Read setQuotaUser(java.lang.String quotaUser) {
                return (Read) super.setQuotaUser(quotaUser);
              }

              @Override
              public Read setUploadType(java.lang.String uploadType) {
                return (Read) super.setUploadType(uploadType);
              }

              @Override
              public Read setUploadProtocol(java.lang.String uploadProtocol) {
                return (Read) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to retrieve.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to retrieve. */
              public Read setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Read set(String parameterName, Object value) {
                return (Read) super.set(parameterName, value);
              }
            }
            /**
             * Searches for resources in the given FHIR store according to criteria specified as query
             * parameters. Implements the FHIR standard search interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#search),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#search),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#search)) using the search semantics
             * described in the FHIR Search specification
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/search.html),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/search.html),
             * [R4](http://hl7.org/implement/standards/fhir/R4/search.html)). Supports four methods of search
             * defined by the specification: * `GET [base]?[parameters]` to search across all resources. * `GET
             * [base]/[type]?[parameters]` to search resources of a specified type. * `POST
             * [base]/_search?[parameters]` as an alternate form having the same semantics as the `GET` method
             * across all resources. * `POST [base]/[type]/_search?[parameters]` as an alternate form having the
             * same semantics as the `GET` method for the specified type. The `GET` and `POST` methods do not
             * support compartment searches. The `POST` method does not support `application/x-www-form-
             * urlencoded` search parameters. On success, the response body contains a JSON-encoded
             * representation of a `Bundle` resource of type `searchset`, containing the results of the search.
             * Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource describing
             * the reason for the error. If the request cannot be mapped to a valid API method on a FHIR store,
             * a generic GCP error might be returned instead. The server's capability statement, retrieved
             * through capabilities, indicates what search parameters are supported on each FHIR resource. A
             * list of all search parameters defined by the specification can be found in the FHIR Search
             * Parameter Registry ([STU3](http://hl7.org/implement/standards/fhir/STU3/searchparameter-
             * registry.html), [R4](http://hl7.org/implement/standards/fhir/R4/searchparameter-registry.html)).
             * FHIR search parameters for DSTU2 can be found on each resource's definition page. Supported
             * search modifiers: `:missing`, `:exact`, `:contains`, `:text`, `:in`, `:not-in`, `:above`,
             * `:below`, `:[type]`, `:not`, and `:recurse`. Supported search result parameters: `_sort`,
             * `_count`, `_include`, `_revinclude`, `_summary=text`, `_summary=data`, and `_elements`. The
             * maximum number of search results returned defaults to 100, which can be overridden by the
             * `_count` parameter up to a maximum limit of 1000. If there are additional results, the returned
             * `Bundle` contains a link of `relation` "next", which has a `_page_token` parameter for an opaque
             * pagination token that can be used to retrieve the next page. Resources with a total size larger
             * than 5MB or a field count larger than 50,000 might not be fully searchable as the server might
             * trim its generated search index in those cases. Note: FHIR resources are indexed asynchronously,
             * so there might be a slight delay between the time a resource is created or changes and when the
             * change is reflected in search results. For samples and detailed information, see [Searching for
             * FHIR resources](/healthcare/docs/how-tos/fhir-search) and [Advanced FHIR search
             * features](/healthcare/docs/how-tos/fhir-advanced-search).
             *
             * Create a request for the method "fhir.search".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Search#execute()} method to invoke the remote operation.
             *
             * @param parent Name of the FHIR store to retrieve resources from.
             * @param content the {@link com.google.api.services.healthcare.v1.model.SearchResourcesRequest}
             * @return the request
             */
            public Search search(java.lang.String parent, com.google.api.services.healthcare.v1.model.SearchResourcesRequest content) throws java.io.IOException {
              Search result = new Search(parent, content);
              initialize(result);
              return result;
            }

            public class Search extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/fhir/_search";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

              /**
               * Searches for resources in the given FHIR store according to criteria specified as query
               * parameters. Implements the FHIR standard search interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#search),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#search),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#search)) using the search semantics
               * described in the FHIR Search specification
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/search.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/search.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/search.html)). Supports four methods of search
               * defined by the specification: * `GET [base]?[parameters]` to search across all resources. *
               * `GET [base]/[type]?[parameters]` to search resources of a specified type. * `POST
               * [base]/_search?[parameters]` as an alternate form having the same semantics as the `GET` method
               * across all resources. * `POST [base]/[type]/_search?[parameters]` as an alternate form having
               * the same semantics as the `GET` method for the specified type. The `GET` and `POST` methods do
               * not support compartment searches. The `POST` method does not support `application/x-www-form-
               * urlencoded` search parameters. On success, the response body contains a JSON-encoded
               * representation of a `Bundle` resource of type `searchset`, containing the results of the
               * search. Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource
               * describing the reason for the error. If the request cannot be mapped to a valid API method on a
               * FHIR store, a generic GCP error might be returned instead. The server's capability statement,
               * retrieved through capabilities, indicates what search parameters are supported on each FHIR
               * resource. A list of all search parameters defined by the specification can be found in the FHIR
               * Search Parameter Registry ([STU3](http://hl7.org/implement/standards/fhir/STU3/searchparameter-
               * registry.html), [R4](http://hl7.org/implement/standards/fhir/R4/searchparameter-
               * registry.html)). FHIR search parameters for DSTU2 can be found on each resource's definition
               * page. Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`, `:in`, `:not-in`,
               * `:above`, `:below`, `:[type]`, `:not`, and `:recurse`. Supported search result parameters:
               * `_sort`, `_count`, `_include`, `_revinclude`, `_summary=text`, `_summary=data`, and
               * `_elements`. The maximum number of search results returned defaults to 100, which can be
               * overridden by the `_count` parameter up to a maximum limit of 1000. If there are additional
               * results, the returned `Bundle` contains a link of `relation` "next", which has a `_page_token`
               * parameter for an opaque pagination token that can be used to retrieve the next page. Resources
               * with a total size larger than 5MB or a field count larger than 50,000 might not be fully
               * searchable as the server might trim its generated search index in those cases. Note: FHIR
               * resources are indexed asynchronously, so there might be a slight delay between the time a
               * resource is created or changes and when the change is reflected in search results. For samples
               * and detailed information, see [Searching for FHIR resources](/healthcare/docs/how-tos/fhir-
               * search) and [Advanced FHIR search features](/healthcare/docs/how-tos/fhir-advanced-search).
               *
               * Create a request for the method "fhir.search".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
               * <p> {@link
               * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Name of the FHIR store to retrieve resources from.
               * @param content the {@link com.google.api.services.healthcare.v1.model.SearchResourcesRequest}
               * @since 1.13
               */
              protected Search(java.lang.String parent, com.google.api.services.healthcare.v1.model.SearchResourcesRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
              }

              @Override
              public Search set$Xgafv(java.lang.String $Xgafv) {
                return (Search) super.set$Xgafv($Xgafv);
              }

              @Override
              public Search setAccessToken(java.lang.String accessToken) {
                return (Search) super.setAccessToken(accessToken);
              }

              @Override
              public Search setAlt(java.lang.String alt) {
                return (Search) super.setAlt(alt);
              }

              @Override
              public Search setCallback(java.lang.String callback) {
                return (Search) super.setCallback(callback);
              }

              @Override
              public Search setFields(java.lang.String fields) {
                return (Search) super.setFields(fields);
              }

              @Override
              public Search setKey(java.lang.String key) {
                return (Search) super.setKey(key);
              }

              @Override
              public Search setOauthToken(java.lang.String oauthToken) {
                return (Search) super.setOauthToken(oauthToken);
              }

              @Override
              public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Search) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Search setQuotaUser(java.lang.String quotaUser) {
                return (Search) super.setQuotaUser(quotaUser);
              }

              @Override
              public Search setUploadType(java.lang.String uploadType) {
                return (Search) super.setUploadType(uploadType);
              }

              @Override
              public Search setUploadProtocol(java.lang.String uploadProtocol) {
                return (Search) super.setUploadProtocol(uploadProtocol);
              }

              /** Name of the FHIR store to retrieve resources from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Name of the FHIR store to retrieve resources from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Name of the FHIR store to retrieve resources from. */
              public Search setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Search set(String parameterName, Object value) {
                return (Search) super.set(parameterName, value);
              }
            }
            /**
             * Searches for resources in the given FHIR store according to criteria specified as query
             * parameters. Implements the FHIR standard search interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#search),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#search),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#search)) using the search semantics
             * described in the FHIR Search specification
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/search.html),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/search.html),
             * [R4](http://hl7.org/implement/standards/fhir/R4/search.html)). Supports four methods of search
             * defined by the specification: * `GET [base]?[parameters]` to search across all resources. * `GET
             * [base]/[type]?[parameters]` to search resources of a specified type. * `POST
             * [base]/_search?[parameters]` as an alternate form having the same semantics as the `GET` method
             * across all resources. * `POST [base]/[type]/_search?[parameters]` as an alternate form having the
             * same semantics as the `GET` method for the specified type. The `GET` and `POST` methods do not
             * support compartment searches. The `POST` method does not support `application/x-www-form-
             * urlencoded` search parameters. On success, the response body contains a JSON-encoded
             * representation of a `Bundle` resource of type `searchset`, containing the results of the search.
             * Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource describing
             * the reason for the error. If the request cannot be mapped to a valid API method on a FHIR store,
             * a generic GCP error might be returned instead. The server's capability statement, retrieved
             * through capabilities, indicates what search parameters are supported on each FHIR resource. A
             * list of all search parameters defined by the specification can be found in the FHIR Search
             * Parameter Registry ([STU3](http://hl7.org/implement/standards/fhir/STU3/searchparameter-
             * registry.html), [R4](http://hl7.org/implement/standards/fhir/R4/searchparameter-registry.html)).
             * FHIR search parameters for DSTU2 can be found on each resource's definition page. Supported
             * search modifiers: `:missing`, `:exact`, `:contains`, `:text`, `:in`, `:not-in`, `:above`,
             * `:below`, `:[type]`, `:not`, and `:recurse`. Supported search result parameters: `_sort`,
             * `_count`, `_include`, `_revinclude`, `_summary=text`, `_summary=data`, and `_elements`. The
             * maximum number of search results returned defaults to 100, which can be overridden by the
             * `_count` parameter up to a maximum limit of 1000. If there are additional results, the returned
             * `Bundle` contains a link of `relation` "next", which has a `_page_token` parameter for an opaque
             * pagination token that can be used to retrieve the next page. Resources with a total size larger
             * than 5MB or a field count larger than 50,000 might not be fully searchable as the server might
             * trim its generated search index in those cases. Note: FHIR resources are indexed asynchronously,
             * so there might be a slight delay between the time a resource is created or changes and when the
             * change is reflected in search results. For samples and detailed information, see [Searching for
             * FHIR resources](/healthcare/docs/how-tos/fhir-search) and [Advanced FHIR search
             * features](/healthcare/docs/how-tos/fhir-advanced-search).
             *
             * Create a request for the method "fhir.search-type".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link SearchType#execute()} method to invoke the remote operation.
             *
             * @param parent Name of the FHIR store to retrieve resources from.
             * @param resourceType The FHIR resource type to search, such as Patient or Observation. For a complete list, see the FHIR
             *        Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             *        [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             *        [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
             * @param content the {@link com.google.api.services.healthcare.v1.model.SearchResourcesRequest}
             * @return the request
             */
            public SearchType searchType(java.lang.String parent, java.lang.String resourceType, com.google.api.services.healthcare.v1.model.SearchResourcesRequest content) throws java.io.IOException {
              SearchType result = new SearchType(parent, resourceType, content);
              initialize(result);
              return result;
            }

            public class SearchType extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+parent}/fhir/{resourceType}/_search";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");

              /**
               * Searches for resources in the given FHIR store according to criteria specified as query
               * parameters. Implements the FHIR standard search interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#search),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#search),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#search)) using the search semantics
               * described in the FHIR Search specification
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/search.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/search.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/search.html)). Supports four methods of search
               * defined by the specification: * `GET [base]?[parameters]` to search across all resources. *
               * `GET [base]/[type]?[parameters]` to search resources of a specified type. * `POST
               * [base]/_search?[parameters]` as an alternate form having the same semantics as the `GET` method
               * across all resources. * `POST [base]/[type]/_search?[parameters]` as an alternate form having
               * the same semantics as the `GET` method for the specified type. The `GET` and `POST` methods do
               * not support compartment searches. The `POST` method does not support `application/x-www-form-
               * urlencoded` search parameters. On success, the response body contains a JSON-encoded
               * representation of a `Bundle` resource of type `searchset`, containing the results of the
               * search. Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome` resource
               * describing the reason for the error. If the request cannot be mapped to a valid API method on a
               * FHIR store, a generic GCP error might be returned instead. The server's capability statement,
               * retrieved through capabilities, indicates what search parameters are supported on each FHIR
               * resource. A list of all search parameters defined by the specification can be found in the FHIR
               * Search Parameter Registry ([STU3](http://hl7.org/implement/standards/fhir/STU3/searchparameter-
               * registry.html), [R4](http://hl7.org/implement/standards/fhir/R4/searchparameter-
               * registry.html)). FHIR search parameters for DSTU2 can be found on each resource's definition
               * page. Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`, `:in`, `:not-in`,
               * `:above`, `:below`, `:[type]`, `:not`, and `:recurse`. Supported search result parameters:
               * `_sort`, `_count`, `_include`, `_revinclude`, `_summary=text`, `_summary=data`, and
               * `_elements`. The maximum number of search results returned defaults to 100, which can be
               * overridden by the `_count` parameter up to a maximum limit of 1000. If there are additional
               * results, the returned `Bundle` contains a link of `relation` "next", which has a `_page_token`
               * parameter for an opaque pagination token that can be used to retrieve the next page. Resources
               * with a total size larger than 5MB or a field count larger than 50,000 might not be fully
               * searchable as the server might trim its generated search index in those cases. Note: FHIR
               * resources are indexed asynchronously, so there might be a slight delay between the time a
               * resource is created or changes and when the change is reflected in search results. For samples
               * and detailed information, see [Searching for FHIR resources](/healthcare/docs/how-tos/fhir-
               * search) and [Advanced FHIR search features](/healthcare/docs/how-tos/fhir-advanced-search).
               *
               * Create a request for the method "fhir.search-type".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link SearchType#execute()} method to invoke the remote
               * operation. <p> {@link
               * SearchType#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Name of the FHIR store to retrieve resources from.
               * @param resourceType The FHIR resource type to search, such as Patient or Observation. For a complete list, see the FHIR
             *        Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             *        [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             *        [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
               * @param content the {@link com.google.api.services.healthcare.v1.model.SearchResourcesRequest}
               * @since 1.13
               */
              protected SearchType(java.lang.String parent, java.lang.String resourceType, com.google.api.services.healthcare.v1.model.SearchResourcesRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.resourceType = com.google.api.client.util.Preconditions.checkNotNull(resourceType, "Required parameter resourceType must be specified.");
              }

              @Override
              public SearchType set$Xgafv(java.lang.String $Xgafv) {
                return (SearchType) super.set$Xgafv($Xgafv);
              }

              @Override
              public SearchType setAccessToken(java.lang.String accessToken) {
                return (SearchType) super.setAccessToken(accessToken);
              }

              @Override
              public SearchType setAlt(java.lang.String alt) {
                return (SearchType) super.setAlt(alt);
              }

              @Override
              public SearchType setCallback(java.lang.String callback) {
                return (SearchType) super.setCallback(callback);
              }

              @Override
              public SearchType setFields(java.lang.String fields) {
                return (SearchType) super.setFields(fields);
              }

              @Override
              public SearchType setKey(java.lang.String key) {
                return (SearchType) super.setKey(key);
              }

              @Override
              public SearchType setOauthToken(java.lang.String oauthToken) {
                return (SearchType) super.setOauthToken(oauthToken);
              }

              @Override
              public SearchType setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (SearchType) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public SearchType setQuotaUser(java.lang.String quotaUser) {
                return (SearchType) super.setQuotaUser(quotaUser);
              }

              @Override
              public SearchType setUploadType(java.lang.String uploadType) {
                return (SearchType) super.setUploadType(uploadType);
              }

              @Override
              public SearchType setUploadProtocol(java.lang.String uploadProtocol) {
                return (SearchType) super.setUploadProtocol(uploadProtocol);
              }

              /** Name of the FHIR store to retrieve resources from. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Name of the FHIR store to retrieve resources from.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** Name of the FHIR store to retrieve resources from. */
              public SearchType setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * The FHIR resource type to search, such as Patient or Observation. For a complete
               * list, see the FHIR Resource Index
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
               */
              @com.google.api.client.util.Key
              private java.lang.String resourceType;

              /** The FHIR resource type to search, such as Patient or Observation. For a complete list, see the FHIR
             Resource Index ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
             [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
             [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
               */
              public java.lang.String getResourceType() {
                return resourceType;
              }

              /**
               * The FHIR resource type to search, such as Patient or Observation. For a complete
               * list, see the FHIR Resource Index
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
               * [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
               */
              public SearchType setResourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
              }

              @Override
              public SearchType set(String parameterName, Object value) {
                return (SearchType) super.set(parameterName, value);
              }
            }
            /**
             * Updates the entire contents of a resource. Implements the FHIR standard update interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#update),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#update),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#update)). If the specified resource
             * does not exist and the FHIR store has enable_update_create set, creates the resource with the
             * client-specified ID. It is strongly advised not to include or encode any sensitive data such as
             * patient identifiers in client-specified resource IDs. Those IDs are part of the FHIR resource
             * path recorded in Cloud Audit Logs and Pub/Sub notifications. Those IDs can also be contained in
             * reference fields within other resources. The request body must contain a JSON-encoded FHIR
             * resource, and the request headers must contain `Content-Type: application/fhir+json`. The
             * resource must contain an `id` element having an identical value to the ID in the REST path of the
             * request. On success, the response body contains a JSON-encoded representation of the updated
             * resource, including the server-assigned version ID. Errors generated by the FHIR store contain a
             * JSON-encoded `OperationOutcome` resource describing the reason for the error. If the request
             * cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be returned
             * instead. For samples that show how to call `update`, see [Updating a FHIR
             * resource](/healthcare/docs/how-tos/fhir-resources#updating_a_fhir_resource).
             *
             * Create a request for the method "fhir.update".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Update#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource to update.
             * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
             * @return the request
             */
            public Update update(java.lang.String name, com.google.api.services.healthcare.v1.model.HttpBody content) throws java.io.IOException {
              Update result = new Update(name, content);
              initialize(result);
              return result;
            }

            public class Update extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");

              /**
               * Updates the entire contents of a resource. Implements the FHIR standard update interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#update),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#update),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#update)). If the specified resource
               * does not exist and the FHIR store has enable_update_create set, creates the resource with the
               * client-specified ID. It is strongly advised not to include or encode any sensitive data such as
               * patient identifiers in client-specified resource IDs. Those IDs are part of the FHIR resource
               * path recorded in Cloud Audit Logs and Pub/Sub notifications. Those IDs can also be contained in
               * reference fields within other resources. The request body must contain a JSON-encoded FHIR
               * resource, and the request headers must contain `Content-Type: application/fhir+json`. The
               * resource must contain an `id` element having an identical value to the ID in the REST path of
               * the request. On success, the response body contains a JSON-encoded representation of the
               * updated resource, including the server-assigned version ID. Errors generated by the FHIR store
               * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
               * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
               * returned instead. For samples that show how to call `update`, see [Updating a FHIR
               * resource](/healthcare/docs/how-tos/fhir-resources#updating_a_fhir_resource).
               *
               * Create a request for the method "fhir.update".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
               * <p> {@link
               * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource to update.
               * @param content the {@link com.google.api.services.healthcare.v1.model.HttpBody}
               * @since 1.13
               */
              protected Update(java.lang.String name, com.google.api.services.healthcare.v1.model.HttpBody content) {
                super(CloudHealthcare.this, "PUT", REST_PATH, content, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
              }

              @Override
              public Update set$Xgafv(java.lang.String $Xgafv) {
                return (Update) super.set$Xgafv($Xgafv);
              }

              @Override
              public Update setAccessToken(java.lang.String accessToken) {
                return (Update) super.setAccessToken(accessToken);
              }

              @Override
              public Update setAlt(java.lang.String alt) {
                return (Update) super.setAlt(alt);
              }

              @Override
              public Update setCallback(java.lang.String callback) {
                return (Update) super.setCallback(callback);
              }

              @Override
              public Update setFields(java.lang.String fields) {
                return (Update) super.setFields(fields);
              }

              @Override
              public Update setKey(java.lang.String key) {
                return (Update) super.setKey(key);
              }

              @Override
              public Update setOauthToken(java.lang.String oauthToken) {
                return (Update) super.setOauthToken(oauthToken);
              }

              @Override
              public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Update) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Update setQuotaUser(java.lang.String quotaUser) {
                return (Update) super.setQuotaUser(quotaUser);
              }

              @Override
              public Update setUploadType(java.lang.String uploadType) {
                return (Update) super.setUploadType(uploadType);
              }

              @Override
              public Update setUploadProtocol(java.lang.String uploadProtocol) {
                return (Update) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource to update. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource to update.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource to update. */
              public Update setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Update set(String parameterName, Object value) {
                return (Update) super.set(parameterName, value);
              }
            }
            /**
             * Gets the contents of a version (current or historical) of a FHIR resource by version ID.
             * Implements the FHIR standard vread interaction
             * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#vread),
             * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#vread),
             * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#vread)). On success, the response body
             * contains a JSON-encoded representation of the resource. Errors generated by the FHIR store
             * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
             * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
             * returned instead. For samples that show how to call `vread`, see [Retrieving a FHIR resource
             * version](/healthcare/docs/how-tos/fhir-resources#retrieving_a_fhir_resource_version).
             *
             * Create a request for the method "fhir.vread".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Vread#execute()} method to invoke the remote operation.
             *
             * @param name The name of the resource version to retrieve.
             * @return the request
             */
            public Vread vread(java.lang.String name) throws java.io.IOException {
              Vread result = new Vread(name);
              initialize(result);
              return result;
            }

            public class Vread extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.HttpBody> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");

              /**
               * Gets the contents of a version (current or historical) of a FHIR resource by version ID.
               * Implements the FHIR standard vread interaction
               * ([DSTU2](http://hl7.org/implement/standards/fhir/DSTU2/http.html#vread),
               * [STU3](http://hl7.org/implement/standards/fhir/STU3/http.html#vread),
               * [R4](http://hl7.org/implement/standards/fhir/R4/http.html#vread)). On success, the response
               * body contains a JSON-encoded representation of the resource. Errors generated by the FHIR store
               * contain a JSON-encoded `OperationOutcome` resource describing the reason for the error. If the
               * request cannot be mapped to a valid API method on a FHIR store, a generic GCP error might be
               * returned instead. For samples that show how to call `vread`, see [Retrieving a FHIR resource
               * version](/healthcare/docs/how-tos/fhir-resources#retrieving_a_fhir_resource_version).
               *
               * Create a request for the method "fhir.vread".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Vread#execute()} method to invoke the remote operation.
               * <p> {@link
               * Vread#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the resource version to retrieve.
               * @since 1.13
               */
              protected Vread(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.HttpBody.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Vread set$Xgafv(java.lang.String $Xgafv) {
                return (Vread) super.set$Xgafv($Xgafv);
              }

              @Override
              public Vread setAccessToken(java.lang.String accessToken) {
                return (Vread) super.setAccessToken(accessToken);
              }

              @Override
              public Vread setAlt(java.lang.String alt) {
                return (Vread) super.setAlt(alt);
              }

              @Override
              public Vread setCallback(java.lang.String callback) {
                return (Vread) super.setCallback(callback);
              }

              @Override
              public Vread setFields(java.lang.String fields) {
                return (Vread) super.setFields(fields);
              }

              @Override
              public Vread setKey(java.lang.String key) {
                return (Vread) super.setKey(key);
              }

              @Override
              public Vread setOauthToken(java.lang.String oauthToken) {
                return (Vread) super.setOauthToken(oauthToken);
              }

              @Override
              public Vread setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Vread) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Vread setQuotaUser(java.lang.String quotaUser) {
                return (Vread) super.setQuotaUser(quotaUser);
              }

              @Override
              public Vread setUploadType(java.lang.String uploadType) {
                return (Vread) super.setUploadType(uploadType);
              }

              @Override
              public Vread setUploadProtocol(java.lang.String uploadProtocol) {
                return (Vread) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the resource version to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the resource version to retrieve.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the resource version to retrieve. */
              public Vread setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Vread set(String parameterName, Object value) {
                return (Vread) super.set(parameterName, value);
              }
            }

          }
        }
        /**
         * An accessor for creating requests from the Hl7V2Stores collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
         *   {@code CloudHealthcare.Hl7V2Stores.List request = healthcare.hl7V2Stores().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Hl7V2Stores hl7V2Stores() {
          return new Hl7V2Stores();
        }

        /**
         * The "hl7V2Stores" collection of methods.
         */
        public class Hl7V2Stores {

          /**
           * Creates a new HL7v2 store within the parent dataset.
           *
           * Create a request for the method "hl7V2Stores.create".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the dataset this HL7v2 store belongs to.
           * @param content the {@link com.google.api.services.healthcare.v1.model.Hl7V2Store}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Hl7V2Store content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Hl7V2Store> {

            private static final String REST_PATH = "v1/{+parent}/hl7V2Stores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Creates a new HL7v2 store within the parent dataset.
             *
             * Create a request for the method "hl7V2Stores.create".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the dataset this HL7v2 store belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.Hl7V2Store}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.Hl7V2Store content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Hl7V2Store.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the dataset this HL7v2 store belongs to. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the dataset this HL7v2 store belongs to.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the dataset this HL7v2 store belongs to. */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * The ID of the HL7v2 store that is being created. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String hl7V2StoreId;

            /** The ID of the HL7v2 store that is being created. The string must match the following regex:
           `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            public java.lang.String getHl7V2StoreId() {
              return hl7V2StoreId;
            }

            /**
             * The ID of the HL7v2 store that is being created. The string must match the following
             * regex: `[\p{L}\p{N}_\-\.]{1,256}`.
             */
            public Create setHl7V2StoreId(java.lang.String hl7V2StoreId) {
              this.hl7V2StoreId = hl7V2StoreId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Deletes the specified HL7v2 store and removes all messages that it contains.
           *
           * Create a request for the method "hl7V2Stores.delete".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the HL7v2 store to delete.
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Deletes the specified HL7v2 store and removes all messages that it contains.
             *
             * Create a request for the method "hl7V2Stores.delete".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the HL7v2 store to delete.
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the HL7v2 store to delete. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the HL7v2 store to delete.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the HL7v2 store to delete. */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Gets the specified HL7v2 store.
           *
           * Create a request for the method "hl7V2Stores.get".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the HL7v2 store to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Hl7V2Store> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Gets the specified HL7v2 store.
             *
             * Create a request for the method "hl7V2Stores.get".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the HL7v2 store to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Hl7V2Store.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the HL7v2 store to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the HL7v2 store to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the HL7v2 store to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "hl7V2Stores.getIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "hl7V2Stores.getIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
           specifying an invalid value will be rejected. Requests for policies with any conditional bindings
           must specify version 3. Policies without any conditional bindings may specify any valid value or
           leave the field unset. To learn which resources support conditions in their IAM policies, see the
           [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
             * Requests specifying an invalid value will be rejected. Requests for policies with any
             * conditional bindings must specify version 3. Policies without any conditional
             * bindings may specify any valid value or leave the field unset. To learn which
             * resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Lists the HL7v2 stores in the given dataset.
           *
           * Create a request for the method "hl7V2Stores.list".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Name of the dataset.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.ListHl7V2StoresResponse> {

            private static final String REST_PATH = "v1/{+parent}/hl7V2Stores";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");

            /**
             * Lists the HL7v2 stores in the given dataset.
             *
             * Create a request for the method "hl7V2Stores.list".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Name of the dataset.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.ListHl7V2StoresResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** Name of the dataset. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Name of the dataset.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** Name of the dataset. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported. For example, `labels.key=value`.
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Restricts stores returned to those matching a filter. The following syntax is available: * A string
           field value can be written as text inside quotation marks, for example `"query text"`. The only
           valid relational operation for text fields is equality (`=`), where text is searched within the
           field, rather than having the field be equal to the text. For example, `"Comment = great"` returns
           messages with `great` in the comment field. * A number field value can be written as an integer, a
           decimal, or an exponential. The valid relational operators for number fields are the equality
           operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
           there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to
           negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use
           the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
           relational operators for date fields are the equality operator (`=`) , along with the less
           than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
           operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query
           expressions can be combined in one query by adding `AND` or `OR` operators between the expressions.
           If a boolean operator appears within a quoted string, it is not treated as special, it's just
           another part of the character string to be matched. You can prepend the `NOT` operator to an
           expression to negate it. Only filtering on labels is supported. For example, `labels.key=value`.
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Restricts stores returned to those matching a filter. The following syntax is
             * available: * A string field value can be written as text inside quotation marks, for
             * example `"query text"`. The only valid relational operation for text fields is
             * equality (`=`), where text is searched within the field, rather than having the field
             * be equal to the text. For example, `"Comment = great"` returns messages with `great`
             * in the comment field. * A number field value can be written as an integer, a decimal,
             * or an exponential. The valid relational operators for number fields are the equality
             * operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`,
             * `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT`
             * operator to an expression to negate it. * A date field value must be written in
             * `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading
             * zeros are required for one-digit months and days. The valid relational operators for
             * date fields are the equality operator (`=`) , along with the less than/greater than
             * operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator.
             * You can prepend the `NOT` operator to an expression to negate it. * Multiple field
             * query expressions can be combined in one query by adding `AND` or `OR` operators
             * between the expressions. If a boolean operator appears within a quoted string, it is
             * not treated as special, it's just another part of the character string to be matched.
             * You can prepend the `NOT` operator to an expression to negate it. Only filtering on
             * labels is supported. For example, `labels.key=value`.
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Limit on the number of HL7v2 stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Limit on the number of HL7v2 stores to return in a single response. If not specified, 100 is used.
           May not be larger than 1000.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Limit on the number of HL7v2 stores to return in a single response. If not specified,
             * 100 is used. May not be larger than 1000.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** The next_page_token value returned from the previous List request, if any.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** The next_page_token value returned from the previous List request, if any. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Updates the HL7v2 store.
           *
           * Create a request for the method "hl7V2Stores.patch".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Resource name of the HL7v2 store, of the form
           *        `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
           * @param content the {@link com.google.api.services.healthcare.v1.model.Hl7V2Store}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Hl7V2Store content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Hl7V2Store> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Updates the HL7v2 store.
             *
             * Create a request for the method "hl7V2Stores.patch".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Resource name of the HL7v2 store, of the form
           *        `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
             * @param content the {@link com.google.api.services.healthcare.v1.model.Hl7V2Store}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.healthcare.v1.model.Hl7V2Store content) {
              super(CloudHealthcare.this, "PATCH", REST_PATH, content, com.google.api.services.healthcare.v1.model.Hl7V2Store.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Resource name of the HL7v2 store, of the form
             * `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Resource name of the HL7v2 store, of the form
           `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Resource name of the HL7v2 store, of the form
             * `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            @com.google.api.client.util.Key
            private String updateMask;

            /** The update mask applies to the resource. For the `FieldMask` definition, see
           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
             */
            public String getUpdateMask() {
              return updateMask;
            }

            /**
             * The update mask applies to the resource. For the `FieldMask` definition, see
             * https://developers.google.com/protocol-
             * buffers/docs/reference/google.protobuf#fieldmask
             */
            public Patch setUpdateMask(String updateMask) {
              this.updateMask = updateMask;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "hl7V2Stores.setIamPolicy".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy. Can
             * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "hl7V2Stores.setIamPolicy".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.healthcare.v1.model.SetIamPolicyRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
           * designed to be used for building permission-aware UIs and command-line tools, not for
           * authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "hl7V2Stores.testIamPermissions".
           *
           * This request holds the parameters needed by the healthcare server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
             * operation is designed to be used for building permission-aware UIs and command-line tools, not
             * for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "hl7V2Stores.testIamPermissions".
             *
             * This request holds the parameters needed by the the healthcare server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.healthcare.v1.model.TestIamPermissionsRequest content) {
              super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the Messages collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudHealthcare healthcare = new CloudHealthcare(...);}
           *   {@code CloudHealthcare.Messages.List request = healthcare.messages().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public Messages messages() {
            return new Messages();
          }

          /**
           * The "messages" collection of methods.
           */
          public class Messages {

            /**
             * Parses and stores an HL7v2 message. This method triggers an asynchronous notification to any
             * Pub/Sub topic configured in Hl7V2Store.Hl7V2NotificationConfig, if the filtering matches the
             * message. If an MLLP adapter is configured to listen to a Pub/Sub topic, the adapter transmits the
             * message when a notification is received.
             *
             * Create a request for the method "messages.create".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent The name of the dataset this message belongs to.
             * @param content the {@link com.google.api.services.healthcare.v1.model.CreateMessageRequest}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.healthcare.v1.model.CreateMessageRequest content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Message> {

              private static final String REST_PATH = "v1/{+parent}/messages";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");

              /**
               * Parses and stores an HL7v2 message. This method triggers an asynchronous notification to any
               * Pub/Sub topic configured in Hl7V2Store.Hl7V2NotificationConfig, if the filtering matches the
               * message. If an MLLP adapter is configured to listen to a Pub/Sub topic, the adapter transmits
               * the message when a notification is received.
               *
               * Create a request for the method "messages.create".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent The name of the dataset this message belongs to.
               * @param content the {@link com.google.api.services.healthcare.v1.model.CreateMessageRequest}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.healthcare.v1.model.CreateMessageRequest content) {
                super(CloudHealthcare.this, "POST", REST_PATH, content, com.google.api.services.healthcare.v1.model.Message.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the dataset this message belongs to. */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** The name of the dataset this message belongs to.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /** The name of the dataset this message belongs to. */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Deletes an HL7v2 message.
             *
             * Create a request for the method "messages.delete".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             *
             * @param name The resource name of the HL7v2 message to delete.
             * @return the request
             */
            public Delete delete(java.lang.String name) throws java.io.IOException {
              Delete result = new Delete(name);
              initialize(result);
              return result;
            }

            public class Delete extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Empty> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");

              /**
               * Deletes an HL7v2 message.
               *
               * Create a request for the method "messages.delete".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
               * <p> {@link
               * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The resource name of the HL7v2 message to delete.
               * @since 1.13
               */
              protected Delete(java.lang.String name) {
                super(CloudHealthcare.this, "DELETE", REST_PATH, null, com.google.api.services.healthcare.v1.model.Empty.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                }
              }

              @Override
              public Delete set$Xgafv(java.lang.String $Xgafv) {
                return (Delete) super.set$Xgafv($Xgafv);
              }

              @Override
              public Delete setAccessToken(java.lang.String accessToken) {
                return (Delete) super.setAccessToken(accessToken);
              }

              @Override
              public Delete setAlt(java.lang.String alt) {
                return (Delete) super.setAlt(alt);
              }

              @Override
              public Delete setCallback(java.lang.String callback) {
                return (Delete) super.setCallback(callback);
              }

              @Override
              public Delete setFields(java.lang.String fields) {
                return (Delete) super.setFields(fields);
              }

              @Override
              public Delete setKey(java.lang.String key) {
                return (Delete) super.setKey(key);
              }

              @Override
              public Delete setOauthToken(java.lang.String oauthToken) {
                return (Delete) super.setOauthToken(oauthToken);
              }

              @Override
              public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Delete) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Delete setQuotaUser(java.lang.String quotaUser) {
                return (Delete) super.setQuotaUser(quotaUser);
              }

              @Override
              public Delete setUploadType(java.lang.String uploadType) {
                return (Delete) super.setUploadType(uploadType);
              }

              @Override
              public Delete setUploadProtocol(java.lang.String uploadProtocol) {
                return (Delete) super.setUploadProtocol(uploadProtocol);
              }

              /** The resource name of the HL7v2 message to delete. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The resource name of the HL7v2 message to delete.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The resource name of the HL7v2 message to delete. */
              public Delete setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Delete set(String parameterName, Object value) {
                return (Delete) super.set(parameterName, value);
              }
            }
            /**
             * Gets an HL7v2 message.
             *
             * Create a request for the method "messages.get".
             *
             * This request holds the parameters needed by the healthcare server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name The resource name of the HL7v2 message to retrieve.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudHealthcareRequest<com.google.api.services.healthcare.v1.model.Message> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");

              /**
               * Gets an HL7v2 message.
               *
               * Create a request for the method "messages.get".
               *
               * This request holds the parameters needed by the the healthcare server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The resource name of the HL7v2 message to retrieve.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudHealthcare.this, "GET", REST_PATH, null, com.google.api.services.healthcare.v1.model.Message.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** The resource name of the HL7v2 message to retrieve. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The resource name of the HL7v2 message to retrieve.
       