/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * The candidate entities that an entity mention could link to.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Entity extends com.google.api.client.json.GenericJson {

  /**
   * entity_id is a first class field entity_id uniquely identifies this concept and its meta-
   * vocabulary. For example, "UMLS/C0000970".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entityId;

  /**
   * preferred_term is the preferred term for this concept. For example, "Acetaminophen". For ad hoc
   * entities formed by normalization, this is the most popular unnormalized string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String preferredTerm;

  /**
   * Vocabulary codes are first-class fields and differentiated from the concept unique identifier
   * (entity_id). vocabulary_codes contains the representation of this concept in particular
   * vocabularies, such as ICD-10, SNOMED-CT and RxNORM. These are prefixed by the name of the
   * vocabulary, followed by the unique code within that vocabulary. For example,
   * "RXNORM/A10334543".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> vocabularyCodes;

  /**
   * entity_id is a first class field entity_id uniquely identifies this concept and its meta-
   * vocabulary. For example, "UMLS/C0000970".
   * @return value or {@code null} for none
   */
  public java.lang.String getEntityId() {
    return entityId;
  }

  /**
   * entity_id is a first class field entity_id uniquely identifies this concept and its meta-
   * vocabulary. For example, "UMLS/C0000970".
   * @param entityId entityId or {@code null} for none
   */
  public Entity setEntityId(java.lang.String entityId) {
    this.entityId = entityId;
    return this;
  }

  /**
   * preferred_term is the preferred term for this concept. For example, "Acetaminophen". For ad hoc
   * entities formed by normalization, this is the most popular unnormalized string.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreferredTerm() {
    return preferredTerm;
  }

  /**
   * preferred_term is the preferred term for this concept. For example, "Acetaminophen". For ad hoc
   * entities formed by normalization, this is the most popular unnormalized string.
   * @param preferredTerm preferredTerm or {@code null} for none
   */
  public Entity setPreferredTerm(java.lang.String preferredTerm) {
    this.preferredTerm = preferredTerm;
    return this;
  }

  /**
   * Vocabulary codes are first-class fields and differentiated from the concept unique identifier
   * (entity_id). vocabulary_codes contains the representation of this concept in particular
   * vocabularies, such as ICD-10, SNOMED-CT and RxNORM. These are prefixed by the name of the
   * vocabulary, followed by the unique code within that vocabulary. For example,
   * "RXNORM/A10334543".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getVocabularyCodes() {
    return vocabularyCodes;
  }

  /**
   * Vocabulary codes are first-class fields and differentiated from the concept unique identifier
   * (entity_id). vocabulary_codes contains the representation of this concept in particular
   * vocabularies, such as ICD-10, SNOMED-CT and RxNORM. These are prefixed by the name of the
   * vocabulary, followed by the unique code within that vocabulary. For example,
   * "RXNORM/A10334543".
   * @param vocabularyCodes vocabularyCodes or {@code null} for none
   */
  public Entity setVocabularyCodes(java.util.List<java.lang.String> vocabularyCodes) {
    this.vocabularyCodes = vocabularyCodes;
    return this;
  }

  @Override
  public Entity set(String fieldName, Object value) {
    return (Entity) super.set(fieldName, value);
  }

  @Override
  public Entity clone() {
    return (Entity) super.clone();
  }

}
