/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * A (sub) field of a type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Field extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of times this field can be repeated. 0 or -1 means unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxOccurs;

  /**
   * The minimum number of times this field must be present/repeated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minOccurs;

  /**
   * The name of the field. For example, "PID-1" or just "1".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually
   * refers to table "0296".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String table;

  /**
   * The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The maximum number of times this field can be repeated. 0 or -1 means unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxOccurs() {
    return maxOccurs;
  }

  /**
   * The maximum number of times this field can be repeated. 0 or -1 means unbounded.
   * @param maxOccurs maxOccurs or {@code null} for none
   */
  public Field setMaxOccurs(java.lang.Integer maxOccurs) {
    this.maxOccurs = maxOccurs;
    return this;
  }

  /**
   * The minimum number of times this field must be present/repeated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinOccurs() {
    return minOccurs;
  }

  /**
   * The minimum number of times this field must be present/repeated.
   * @param minOccurs minOccurs or {@code null} for none
   */
  public Field setMinOccurs(java.lang.Integer minOccurs) {
    this.minOccurs = minOccurs;
    return this;
  }

  /**
   * The name of the field. For example, "PID-1" or just "1".
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the field. For example, "PID-1" or just "1".
   * @param name name or {@code null} for none
   */
  public Field setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually
   * refers to table "0296".
   * @return value or {@code null} for none
   */
  public java.lang.String getTable() {
    return table;
  }

  /**
   * The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually
   * refers to table "0296".
   * @param table table or {@code null} for none
   */
  public Field setTable(java.lang.String table) {
    this.table = table;
    return this;
  }

  /**
   * The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
   * @param type type or {@code null} for none
   */
  public Field setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Field set(String fieldName, Object value) {
    return (Field) super.set(fieldName, value);
  }

  @Override
  public Field clone() {
    return (Field) super.clone();
  }

}
