/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Request to import resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImportResourcesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The content structure in the source location. If not specified, the server treats the input
   * source files as BUNDLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentStructure;

  /**
   * Cloud Storage source data location and import configuration. The Healthcare Service Agent
   * account requires the `roles/storage.objectAdmin` role on the Cloud Storage location. Each Cloud
   * Storage object should be a text file that contains the format specified in ContentStructure.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleCloudHealthcareV1FhirGcsSource gcsSource;

  /**
   * The content structure in the source location. If not specified, the server treats the input
   * source files as BUNDLE.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentStructure() {
    return contentStructure;
  }

  /**
   * The content structure in the source location. If not specified, the server treats the input
   * source files as BUNDLE.
   * @param contentStructure contentStructure or {@code null} for none
   */
  public ImportResourcesRequest setContentStructure(java.lang.String contentStructure) {
    this.contentStructure = contentStructure;
    return this;
  }

  /**
   * Cloud Storage source data location and import configuration. The Healthcare Service Agent
   * account requires the `roles/storage.objectAdmin` role on the Cloud Storage location. Each Cloud
   * Storage object should be a text file that contains the format specified in ContentStructure.
   * @return value or {@code null} for none
   */
  public GoogleCloudHealthcareV1FhirGcsSource getGcsSource() {
    return gcsSource;
  }

  /**
   * Cloud Storage source data location and import configuration. The Healthcare Service Agent
   * account requires the `roles/storage.objectAdmin` role on the Cloud Storage location. Each Cloud
   * Storage object should be a text file that contains the format specified in ContentStructure.
   * @param gcsSource gcsSource or {@code null} for none
   */
  public ImportResourcesRequest setGcsSource(GoogleCloudHealthcareV1FhirGcsSource gcsSource) {
    this.gcsSource = gcsSource;
    return this;
  }

  @Override
  public ImportResourcesRequest set(String fieldName, Object value) {
    return (ImportResourcesRequest) super.set(fieldName, value);
  }

  @Override
  public ImportResourcesRequest clone() {
    return (ImportResourcesRequest) super.clone();
  }

}
