/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * A transformation to apply to text that is identified as a specific info_type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InfoTypeTransformation extends com.google.api.client.json.GenericJson {

  /**
   * Config for character mask.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CharacterMaskConfig characterMaskConfig;

  /**
   * Config for crypto hash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CryptoHashConfig cryptoHashConfig;

  /**
   * Config for date shift.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateShiftConfig dateShiftConfig;

  /**
   * InfoTypes to apply this transformation to. If this is not specified, the transformation applies
   * to any info_type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> infoTypes;

  /**
   * Config for text redaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RedactConfig redactConfig;

  /**
   * Config for replace with InfoType.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceWithInfoTypeConfig replaceWithInfoTypeConfig;

  /**
   * Config for character mask.
   * @return value or {@code null} for none
   */
  public CharacterMaskConfig getCharacterMaskConfig() {
    return characterMaskConfig;
  }

  /**
   * Config for character mask.
   * @param characterMaskConfig characterMaskConfig or {@code null} for none
   */
  public InfoTypeTransformation setCharacterMaskConfig(CharacterMaskConfig characterMaskConfig) {
    this.characterMaskConfig = characterMaskConfig;
    return this;
  }

  /**
   * Config for crypto hash.
   * @return value or {@code null} for none
   */
  public CryptoHashConfig getCryptoHashConfig() {
    return cryptoHashConfig;
  }

  /**
   * Config for crypto hash.
   * @param cryptoHashConfig cryptoHashConfig or {@code null} for none
   */
  public InfoTypeTransformation setCryptoHashConfig(CryptoHashConfig cryptoHashConfig) {
    this.cryptoHashConfig = cryptoHashConfig;
    return this;
  }

  /**
   * Config for date shift.
   * @return value or {@code null} for none
   */
  public DateShiftConfig getDateShiftConfig() {
    return dateShiftConfig;
  }

  /**
   * Config for date shift.
   * @param dateShiftConfig dateShiftConfig or {@code null} for none
   */
  public InfoTypeTransformation setDateShiftConfig(DateShiftConfig dateShiftConfig) {
    this.dateShiftConfig = dateShiftConfig;
    return this;
  }

  /**
   * InfoTypes to apply this transformation to. If this is not specified, the transformation applies
   * to any info_type.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInfoTypes() {
    return infoTypes;
  }

  /**
   * InfoTypes to apply this transformation to. If this is not specified, the transformation applies
   * to any info_type.
   * @param infoTypes infoTypes or {@code null} for none
   */
  public InfoTypeTransformation setInfoTypes(java.util.List<java.lang.String> infoTypes) {
    this.infoTypes = infoTypes;
    return this;
  }

  /**
   * Config for text redaction.
   * @return value or {@code null} for none
   */
  public RedactConfig getRedactConfig() {
    return redactConfig;
  }

  /**
   * Config for text redaction.
   * @param redactConfig redactConfig or {@code null} for none
   */
  public InfoTypeTransformation setRedactConfig(RedactConfig redactConfig) {
    this.redactConfig = redactConfig;
    return this;
  }

  /**
   * Config for replace with InfoType.
   * @return value or {@code null} for none
   */
  public ReplaceWithInfoTypeConfig getReplaceWithInfoTypeConfig() {
    return replaceWithInfoTypeConfig;
  }

  /**
   * Config for replace with InfoType.
   * @param replaceWithInfoTypeConfig replaceWithInfoTypeConfig or {@code null} for none
   */
  public InfoTypeTransformation setReplaceWithInfoTypeConfig(ReplaceWithInfoTypeConfig replaceWithInfoTypeConfig) {
    this.replaceWithInfoTypeConfig = replaceWithInfoTypeConfig;
    return this;
  }

  @Override
  public InfoTypeTransformation set(String fieldName, Object value) {
    return (InfoTypeTransformation) super.set(fieldName, value);
  }

  @Override
  public InfoTypeTransformation clone() {
    return (InfoTypeTransformation) super.clone();
  }

}
