/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * EntityMentions can be linked to multiple entities using a LinkedEntity message lets us add other
 * fields, e.g. confidence.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LinkedEntity extends com.google.api.client.json.GenericJson {

  /**
   * entity_id is a concept unique identifier. These are prefixed by a string that identifies the
   * entity coding system, followed by the unique identifier within that system. For example,
   * "UMLS/C0000970". This also supports ad hoc entities, which are formed by normalizing entity
   * mention content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entityId;

  /**
   * entity_id is a concept unique identifier. These are prefixed by a string that identifies the
   * entity coding system, followed by the unique identifier within that system. For example,
   * "UMLS/C0000970". This also supports ad hoc entities, which are formed by normalizing entity
   * mention content.
   * @return value or {@code null} for none
   */
  public java.lang.String getEntityId() {
    return entityId;
  }

  /**
   * entity_id is a concept unique identifier. These are prefixed by a string that identifies the
   * entity coding system, followed by the unique identifier within that system. For example,
   * "UMLS/C0000970". This also supports ad hoc entities, which are formed by normalizing entity
   * mention content.
   * @param entityId entityId or {@code null} for none
   */
  public LinkedEntity setEntityId(java.lang.String entityId) {
    this.entityId = entityId;
    return this;
  }

  @Override
  public LinkedEntity set(String fieldName, Object value) {
    return (LinkedEntity) super.set(fieldName, value);
  }

  @Override
  public LinkedEntity clone() {
    return (LinkedEntity) super.clone();
  }

}
