/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * An HL7v2 Segment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchemaSegment extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of times this segment can be present in this group. 0 or -1 means unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxOccurs;

  /**
   * The minimum number of times this segment can be present in this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minOccurs;

  /**
   * The Segment type. For example, "PID".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The maximum number of times this segment can be present in this group. 0 or -1 means unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxOccurs() {
    return maxOccurs;
  }

  /**
   * The maximum number of times this segment can be present in this group. 0 or -1 means unbounded.
   * @param maxOccurs maxOccurs or {@code null} for none
   */
  public SchemaSegment setMaxOccurs(java.lang.Integer maxOccurs) {
    this.maxOccurs = maxOccurs;
    return this;
  }

  /**
   * The minimum number of times this segment can be present in this group.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinOccurs() {
    return minOccurs;
  }

  /**
   * The minimum number of times this segment can be present in this group.
   * @param minOccurs minOccurs or {@code null} for none
   */
  public SchemaSegment setMinOccurs(java.lang.Integer minOccurs) {
    this.minOccurs = minOccurs;
    return this;
  }

  /**
   * The Segment type. For example, "PID".
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The Segment type. For example, "PID".
   * @param type type or {@code null} for none
   */
  public SchemaSegment setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SchemaSegment set(String fieldName, Object value) {
    return (SchemaSegment) super.set(fieldName, value);
  }

  @Override
  public SchemaSegment clone() {
    return (SchemaSegment) super.clone();
  }

}
