/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * A span of text in the provided document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextSpan extends com.google.api.client.json.GenericJson {

  /**
   * The unicode codepoint index of the beginning of this span.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer beginOffset;

  /**
   * The original text contained in this span.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The unicode codepoint index of the beginning of this span.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBeginOffset() {
    return beginOffset;
  }

  /**
   * The unicode codepoint index of the beginning of this span.
   * @param beginOffset beginOffset or {@code null} for none
   */
  public TextSpan setBeginOffset(java.lang.Integer beginOffset) {
    this.beginOffset = beginOffset;
    return this;
  }

  /**
   * The original text contained in this span.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The original text contained in this span.
   * @param content content or {@code null} for none
   */
  public TextSpan setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  @Override
  public TextSpan set(String fieldName, Object value) {
    return (TextSpan) super.set(fieldName, value);
  }

  @Override
  public TextSpan clone() {
    return (TextSpan) super.clone();
  }

}
