/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * DicomStoreMetrics contains metrics describing a DICOM store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DicomStoreMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Total blob storage bytes for all instances in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long blobStorageSizeBytes;

  /**
   * Number of instances in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long instanceCount;

  /**
   * Resource name of the DICOM store, of the form `projects/{project_id}/locations/{location_id}/da
   * tasets/{dataset_id}/dicomStores/{dicom_store_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Number of series in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long seriesCount;

  /**
   * Total structured storage bytes for all instances in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long structuredStorageSizeBytes;

  /**
   * Number of studies in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long studyCount;

  /**
   * Total blob storage bytes for all instances in the store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBlobStorageSizeBytes() {
    return blobStorageSizeBytes;
  }

  /**
   * Total blob storage bytes for all instances in the store.
   * @param blobStorageSizeBytes blobStorageSizeBytes or {@code null} for none
   */
  public DicomStoreMetrics setBlobStorageSizeBytes(java.lang.Long blobStorageSizeBytes) {
    this.blobStorageSizeBytes = blobStorageSizeBytes;
    return this;
  }

  /**
   * Number of instances in the store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInstanceCount() {
    return instanceCount;
  }

  /**
   * Number of instances in the store.
   * @param instanceCount instanceCount or {@code null} for none
   */
  public DicomStoreMetrics setInstanceCount(java.lang.Long instanceCount) {
    this.instanceCount = instanceCount;
    return this;
  }

  /**
   * Resource name of the DICOM store, of the form `projects/{project_id}/locations/{location_id}/da
   * tasets/{dataset_id}/dicomStores/{dicom_store_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the DICOM store, of the form `projects/{project_id}/locations/{location_id}/da
   * tasets/{dataset_id}/dicomStores/{dicom_store_id}`.
   * @param name name or {@code null} for none
   */
  public DicomStoreMetrics setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Number of series in the store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSeriesCount() {
    return seriesCount;
  }

  /**
   * Number of series in the store.
   * @param seriesCount seriesCount or {@code null} for none
   */
  public DicomStoreMetrics setSeriesCount(java.lang.Long seriesCount) {
    this.seriesCount = seriesCount;
    return this;
  }

  /**
   * Total structured storage bytes for all instances in the store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStructuredStorageSizeBytes() {
    return structuredStorageSizeBytes;
  }

  /**
   * Total structured storage bytes for all instances in the store.
   * @param structuredStorageSizeBytes structuredStorageSizeBytes or {@code null} for none
   */
  public DicomStoreMetrics setStructuredStorageSizeBytes(java.lang.Long structuredStorageSizeBytes) {
    this.structuredStorageSizeBytes = structuredStorageSizeBytes;
    return this;
  }

  /**
   * Number of studies in the store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStudyCount() {
    return studyCount;
  }

  /**
   * Number of studies in the store.
   * @param studyCount studyCount or {@code null} for none
   */
  public DicomStoreMetrics setStudyCount(java.lang.Long studyCount) {
    this.studyCount = studyCount;
    return this;
  }

  @Override
  public DicomStoreMetrics set(String fieldName, Object value) {
    return (DicomStoreMetrics) super.set(fieldName, value);
  }

  @Override
  public DicomStoreMetrics clone() {
    return (DicomStoreMetrics) super.clone();
  }

}
