/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Defines directed relationship from one entity mention to another.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EntityMentionRelationship extends com.google.api.client.json.GenericJson {

  /**
   * The model's confidence in this annotation. A number between 0 and 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double confidence;

  /**
   * object_id is the id of the object entity mention.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * subject_id is the id of the subject entity mention.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subjectId;

  /**
   * The model's confidence in this annotation. A number between 0 and 1.
   * @return value or {@code null} for none
   */
  public java.lang.Double getConfidence() {
    return confidence;
  }

  /**
   * The model's confidence in this annotation. A number between 0 and 1.
   * @param confidence confidence or {@code null} for none
   */
  public EntityMentionRelationship setConfidence(java.lang.Double confidence) {
    this.confidence = confidence;
    return this;
  }

  /**
   * object_id is the id of the object entity mention.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * object_id is the id of the object entity mention.
   * @param objectId objectId or {@code null} for none
   */
  public EntityMentionRelationship setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * subject_id is the id of the subject entity mention.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubjectId() {
    return subjectId;
  }

  /**
   * subject_id is the id of the subject entity mention.
   * @param subjectId subjectId or {@code null} for none
   */
  public EntityMentionRelationship setSubjectId(java.lang.String subjectId) {
    this.subjectId = subjectId;
    return this;
  }

  @Override
  public EntityMentionRelationship set(String fieldName, Object value) {
    return (EntityMentionRelationship) super.set(fieldName, value);
  }

  @Override
  public EntityMentionRelationship clone() {
    return (EntityMentionRelationship) super.clone();
  }

}
